/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.api.role.RoleMembership;
import org.kuali.kfs.kim.api.role.RoleService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionCapitalAssetSystem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.dataaccess.RequisitionDao;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.service.PostalCodeValidationService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.vnd.businessobject.VendorCommodityCode;
import org.kuali.kfs.vnd.businessobject.VendorContract;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class RequisitionServiceImpl
implements RequisitionService {
    private static final Logger LOG = LogManager.getLogger();
    protected BusinessObjectService businessObjectService;
    protected CapitalAssetManagementModuleService capitalAssetManagementModuleService;
    protected DateTimeService dateTimeService;
    protected DocumentService documentService;
    protected KualiRuleService ruleService;
    protected ConfigurationService kualiConfigurationService;
    protected ParameterService parameterService;
    protected PersonService personService;
    protected PostalCodeValidationService postalCodeValidationService;
    protected PurapService purapService;
    protected RequisitionDao requisitionDao;
    protected UniversityDateService universityDateService;
    protected VendorService vendorService;
    protected RoleService roleService;

    @Override
    public PurchasingCapitalAssetItem createCamsItem(PurchasingDocument purDoc, PurApItem purapItem) {
        RequisitionCapitalAssetItem camsItem = new RequisitionCapitalAssetItem();
        camsItem.setItemIdentifier(purapItem.getItemIdentifier());
        if (purDoc.getCapitalAssetSystemTypeCode().equals("IND")) {
            RequisitionCapitalAssetSystem resultSystem = new RequisitionCapitalAssetSystem();
            camsItem.setPurchasingCapitalAssetSystem(resultSystem);
        }
        camsItem.setPurchasingDocument(purDoc);
        return camsItem;
    }

    @Override
    public CapitalAssetSystem createCapitalAssetSystem() {
        return new RequisitionCapitalAssetSystem();
    }

    @Override
    public RequisitionDocument getRequisitionById(Integer id) {
        String documentNumber = this.requisitionDao.getDocumentNumberForRequisitionId(id);
        if (ObjectUtils.isNotNull((Object)documentNumber)) {
            return (RequisitionDocument)this.documentService.getByDocumentHeaderId(documentNumber);
        }
        return null;
    }

    @Override
    public boolean isAutomaticPurchaseOrderAllowed(RequisitionDocument requisition) {
        LOG.debug("isAutomaticPurchaseOrderAllowed() started");
        Object note = this.checkAutomaticPurchaseOrderRules(requisition);
        if (StringUtils.isNotEmpty((CharSequence)note)) {
            note = "ORDER ROUTED TO PURCHASING FOR PROCESSING: " + (String)note;
            try {
                Note apoNote = this.documentService.createNoteFromDocument((Document)requisition, (String)note);
                requisition.addNote(apoNote);
                this.documentService.saveDocumentNotes((Document)requisition);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create a note on this document. " + e);
            }
            LOG.debug("isAutomaticPurchaseOrderAllowed() return false; {}", note);
            return false;
        }
        LOG.debug("isAutomaticPurchaseOrderAllowed() You made it!  Your REQ can become an APO; return true.");
        return true;
    }

    protected String checkAutomaticPurchaseOrderRules(RequisitionDocument requisition) {
        Person initiator;
        VendorContract b2bContract;
        String requisitionSource = requisition.getRequisitionSourceCode();
        KualiDecimal reqTotal = requisition.getTotalDollarAmount();
        KualiDecimal apoLimit = this.purapService.getApoLimit(requisition.getVendorContractGeneratedIdentifier(), requisition.getChartOfAccountsCode(), requisition.getOrganizationCode());
        requisition.setOrganizationAutomaticPurchaseOrderLimit(apoLimit);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = requisition::getPurapDocumentIdentifier;
        supplierArray[1] = () -> apoLimit;
        supplierArray[2] = () -> reqTotal;
        LOG.debug("isAPO() reqId = {}; apoLimit = {}; reqTotal = {}", supplierArray);
        if (apoLimit == null) {
            return "APO limit is empty.";
        }
        if (reqTotal.compareTo((AbstractKualiDecimal)apoLimit) == 1) {
            return "Requisition total is greater than the APO limit.";
        }
        if (reqTotal.compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) <= 0) {
            return "Requisition total is not greater than zero.";
        }
        Supplier[] supplierArray2 = new Supplier[2];
        supplierArray2[0] = requisition::getVendorHeaderGeneratedIdentifier;
        supplierArray2[1] = requisition::getVendorDetailAssignedIdentifier;
        LOG.debug("isAPO() vendor #{}-{}", supplierArray2);
        if (requisition.getVendorHeaderGeneratedIdentifier() == null || requisition.getVendorDetailAssignedIdentifier() == null) {
            return "Vendor was not selected from the vendor database.";
        }
        VendorDetail vendorDetail = this.vendorService.getVendorDetail(requisition.getVendorHeaderGeneratedIdentifier(), requisition.getVendorDetailAssignedIdentifier());
        if (vendorDetail == null) {
            return "Error retrieving vendor from the database.";
        }
        if (StringUtils.isBlank((CharSequence)requisition.getVendorLine1Address()) || StringUtils.isBlank((CharSequence)requisition.getVendorCityName()) || StringUtils.isBlank((CharSequence)requisition.getVendorCountryCode())) {
            return "Requisition does not have all of the vendor address fields that are required for Purchase Order.";
        }
        requisition.setVendorRestrictedIndicator(vendorDetail.getVendorRestrictedIndicator());
        if (requisition.getVendorRestrictedIndicator() != null && requisition.getVendorRestrictedIndicator().booleanValue()) {
            return "Selected vendor is marked as restricted.";
        }
        if (vendorDetail.isVendorDebarred()) {
            return "Selected vendor is marked as a debarred vendor";
        }
        requisition.setVendorDetail(vendorDetail);
        if (!"B2B".equals(requisitionSource) && ObjectUtils.isNull((Object)requisition.getVendorContractGeneratedIdentifier()) && (b2bContract = this.vendorService.getVendorB2BContract(vendorDetail, (initiator = this.personService.getPerson(requisition.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId())).getCampusCode())) != null) {
            return "Standard requisition with no contract selected but a B2B contract exists for the selected vendor.";
        }
        if (StringUtils.isNotBlank((CharSequence)requisition.getVendorContractName()) && this.vendorService.isVendorContractExpired((Document)requisition, requisition.getVendorContractGeneratedIdentifier(), vendorDetail)) {
            return "Contracted Vendor used where the contract end date is expired.";
        }
        if (StringUtils.isBlank((CharSequence)requisition.getVendorLine1Address()) || StringUtils.isBlank((CharSequence)requisition.getVendorCityName()) || StringUtils.isBlank((CharSequence)requisition.getVendorCountryCode()) || !this.postalCodeValidationService.validateAddress(requisition.getVendorCountryCode(), requisition.getVendorStateCode(), requisition.getVendorPostalCode(), "", "")) {
            return "Requisition does not contain a complete vendor address";
        }
        String purchaseOrderRequiresCommodityCode = this.parameterService.getParameterValueAsString(PurchaseOrderDocument.class, "ITEMS_REQUIRE_COMMODITY_CODE_IND");
        boolean commodityCodeRequired = "Y".equals(purchaseOrderRequiresCommodityCode);
        for (Object anItem : requisition.getItems()) {
            List vendorCommodityCodes;
            String commodityCodesReason;
            RequisitionItem item = (RequisitionItem)anItem;
            if (item.isItemRestrictedIndicator()) {
                return "Requisition contains an item that is marked as restricted.";
            }
            if (item.getItemType().isLineItemIndicator() && StringUtils.isNotBlank((CharSequence)(commodityCodesReason = this.checkAPORulesPerItemForCommodityCodes(item, vendorCommodityCodes = commodityCodeRequired ? requisition.getVendorDetail().getVendorCommodities() : null, commodityCodeRequired)))) {
                return commodityCodesReason;
            }
            if (("ORDS".equals(item.getItemType().getItemTypeCode()) || "TRDI".equals(item.getItemType().getItemTypeCode())) && item.getItemUnitPrice() != null && BigDecimal.ZERO.compareTo(item.getItemUnitPrice()) != 0) {
                return "Requisition contains a " + item.getItemType().getItemTypeDescription() + " item, so it does not qualify as an APO.";
            }
            if ("B2B".equals(requisitionSource)) continue;
            for (PurApAccountingLine accountingLine : item.getSourceAccountingLines()) {
                if (!this.capitalAssetManagementModuleService.doesAccountingLineFailAutomaticPurchaseOrderRules((AccountingLine)accountingLine)) continue;
                return "Requisition contains accounting line with capital object level";
            }
        }
        if (this.capitalAssetManagementModuleService.doesDocumentFailAutomaticPurchaseOrderRules((AccountingDocument)requisition)) {
            return "Requisition contains capital asset items.";
        }
        if (StringUtils.isNotEmpty((CharSequence)requisition.getRecurringPaymentTypeCode())) {
            return "Payment type is marked as recurring.";
        }
        if (requisition.getPurchaseOrderTotalLimit() != null && KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)requisition.getPurchaseOrderTotalLimit()) != 0) {
            LOG.debug("isAPO() po total limit is not null and not equal to zero; return false.");
            return "The 'PO not to exceed' amount has been entered.";
        }
        if (StringUtils.isNotEmpty((CharSequence)requisition.getAlternate1VendorName()) || StringUtils.isNotEmpty((CharSequence)requisition.getAlternate2VendorName()) || StringUtils.isNotEmpty((CharSequence)requisition.getAlternate3VendorName()) || StringUtils.isNotEmpty((CharSequence)requisition.getAlternate4VendorName()) || StringUtils.isNotEmpty((CharSequence)requisition.getAlternate5VendorName())) {
            LOG.debug("isAPO() alternate vendor name exists; return false.");
            return "Requisition contains additional suggested vendor names.";
        }
        if (requisition.isPostingYearNext() && !this.purapService.isTodayWithinApoAllowedRange()) {
            return "Requisition is set to encumber next fiscal year and approval is not within APO allowed date range.";
        }
        return "";
    }

    protected String checkAPORulesPerItemForCommodityCodes(RequisitionItem purItem, List<VendorCommodityCode> vendorCommodityCodes, boolean commodityCodeRequired) {
        if (purItem.getCommodityCode() == null && commodityCodeRequired) {
            for (VendorCommodityCode vcc : vendorCommodityCodes) {
                if (!vcc.isCommodityDefaultIndicator()) continue;
                purItem.setCommodityCode(vcc.getCommodityCode());
                purItem.setPurchasingCommodityCode(vcc.getPurchasingCommodityCode());
            }
        }
        if (purItem.getCommodityCode() == null) {
            if (commodityCodeRequired) {
                return "There are missing commodity code(s).";
            }
        } else {
            if (!purItem.getCommodityCode().isActive()) {
                return "Requisition contains inactive commodity codes.";
            }
            if (purItem.getCommodityCode().isRestrictedItemsIndicator()) {
                return "Requisition contains an item with a restricted commodity code.";
            }
        }
        return "";
    }

    @Override
    public List<RequisitionDocument> getRequisitionsAwaitingContractManagerAssignment() {
        return this.requisitionDao.getDocumentsAwaitingContractManagerAssignment();
    }

    @Deprecated
    protected List<String> getDocumentsNumbersAwaitingContractManagerAssignment() {
        return this.requisitionDao.getDocumentNumbersAwaitingContractManagerAssignment();
    }

    @Override
    public int getCountOfRequisitionsAwaitingContractManagerAssignment() {
        List<RequisitionDocument> unassignedRequisitions = this.getRequisitionsAwaitingContractManagerAssignment();
        if (ObjectUtils.isNotNull(unassignedRequisitions)) {
            return unassignedRequisitions.size();
        }
        return 0;
    }

    @Override
    public List<RoleMembership> getContentReviewers(String org, String chart) {
        String roleId = this.roleService.getRoleIdByNamespaceCodeAndName("KFS-PURAP", "Content Reviewer");
        HashMap<String, String> qualification = new HashMap<String, String>(2);
        qualification.put("organizationCode", org);
        qualification.put("chartOfAccountsCode", chart);
        List members = this.roleService.getRoleMembers(Arrays.asList(roleId), qualification);
        return members;
    }

    public void setBusinessObjectService(BusinessObjectService boService) {
        this.businessObjectService = boService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setRequisitionDao(RequisitionDao requisitionDao) {
        this.requisitionDao = requisitionDao;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public void setRuleService(KualiRuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setCapitalAssetManagementModuleService(CapitalAssetManagementModuleService capitalAssetManagementModuleService) {
        this.capitalAssetManagementModuleService = capitalAssetManagementModuleService;
    }

    public void setPostalCodeValidationService(PostalCodeValidationService postalCodeValidationService) {
        this.postalCodeValidationService = postalCodeValidationService;
    }

    public void setRoleService(RoleService serv) {
        this.roleService = serv;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

