/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Date;
import java.util.List;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.batch.ScrubberStep;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PaymentRequestExpiredAccountWarningValidation
extends GenericValidation {
    private PurApItem itemForValidation;
    private DateTimeService dateTimeService;
    private ParameterService parameterService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        List<PurApAccountingLine> accountingLines = this.itemForValidation.getSourceAccountingLines();
        for (PurApAccountingLine accountingLine : accountingLines) {
            if (!accountingLine.getAccount().isExpired() || accountingLine.getAccountExpiredOverride()) continue;
            Date current = this.dateTimeService.getCurrentDate();
            java.sql.Date accountExpirationDate = accountingLine.getAccount().getAccountExpirationDate();
            String expirationExtensionDays = this.parameterService.getParameterValueAsString(ScrubberStep.class, "CG_ACCOUNT_EXPIRATION_EXTENSION_DAYS");
            int expirationExtensionDaysInt = 90;
            if (expirationExtensionDays.trim().length() > 0) {
                expirationExtensionDaysInt = new Integer(expirationExtensionDays);
            }
            if (accountingLine.getAccount().isForContractsAndGrants() && this.dateTimeService.dateDiff((Date)accountExpirationDate, current, false) >= expirationExtensionDaysInt) continue;
            KNSGlobalVariables.getMessageList().add("error.gl.AccountExpired", new String[0]);
            valid = false;
            break;
        }
        return valid;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public PurApItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(PurApItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

