/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PaymentRequestReviewValidation
extends GenericValidation {
    private static final Logger LOG = LogManager.getLogger();
    private PaymentRequestItem itemForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        PaymentRequestDocument paymentRequest = (PaymentRequestDocument)event.getDocument();
        String identifier = this.itemForValidation.getItemIdentifierString();
        LOG.debug("validatePaymentRequestReview() The {} is getting the total percent field set to {}", (Object)identifier, (Object)BigDecimal.ZERO);
        if (this.itemForValidation.getTotalAmount() != null && this.itemForValidation.getTotalAmount().isNonZero() && this.itemForValidation.getItemType().isLineItemIndicator() && (this.itemForValidation.getItemType().isAmountBasedGeneralLedgerIndicator() && (this.itemForValidation.getPoOutstandingAmount() == null || this.itemForValidation.getPoOutstandingAmount().isZero()) || this.itemForValidation.getItemType().isQuantityBasedGeneralLedgerIndicator() && (this.itemForValidation.getPoOutstandingQuantity() == null || this.itemForValidation.getPoOutstandingQuantity().isZero()))) {
            if (this.itemForValidation.getItemType().isAmountBasedGeneralLedgerIndicator()) {
                String error = "Payment Request " + paymentRequest.getPurapDocumentIdentifier() + ", " + identifier + " has total amount '" + this.itemForValidation.getTotalAmount() + "' but outstanding encumbered amount " + this.itemForValidation.getPoOutstandingAmount();
                LOG.error("validatePaymentRequestReview() {}", (Object)error);
            } else {
                String error = "Payment Request " + paymentRequest.getPurapDocumentIdentifier() + ", " + identifier + " has quantity '" + this.itemForValidation.getItemQuantity() + "' but outstanding encumbered quantity " + this.itemForValidation.getPoOutstandingQuantity();
                LOG.error("validatePaymentRequestReview() {}", (Object)error);
            }
        } else {
            String error = "Payment Request " + paymentRequest.getPurapDocumentIdentifier() + ", " + identifier + " has total amount '" + this.itemForValidation.getTotalAmount() + "'";
            if (this.itemForValidation.getItemType().isLineItemIndicator()) {
                error = this.itemForValidation.getItemType().isAmountBasedGeneralLedgerIndicator() ? error + " with outstanding encumbered amount " + this.itemForValidation.getPoOutstandingAmount() : error + " with outstanding encumbered quantity " + this.itemForValidation.getPoOutstandingQuantity();
            }
            LOG.info("validatePaymentRequestReview() {}", (Object)error);
        }
        return true;
    }

    public PaymentRequestItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(PaymentRequestItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }
}

