/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingAccountsPayablesItemPreCalculateValidations
extends GenericValidation {
    private PurApItem item;

    public boolean validate(AttributedDocumentEvent event) {
        return this.checkTotalPercentOrTotalAmountsEqual(this.item);
    }

    public boolean checkTotalPercentOrTotalAmountsEqual(PurApItem item) {
        boolean validPercent = this.validateTotalPercent(item, false);
        if (validPercent) {
            return true;
        }
        boolean validAmount = this.validateTotalAmount(item, false);
        if (validAmount) {
            return true;
        }
        KualiDecimal desiredAmount = item.getTotalAmount() == null ? new KualiDecimal(0) : item.getTotalAmount();
        GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.percent.or.total.invalid", new String[]{item.getItemIdentifierString(), desiredAmount.toString()});
        return false;
    }

    public boolean validateTotalPercent(PurApItem item, boolean writeErrorMessage) {
        boolean valid = true;
        if (item.getSourceAccountingLines().size() == 0) {
            return valid;
        }
        BigDecimal totalPercent = BigDecimal.ZERO;
        BigDecimal desiredPercent = new BigDecimal("100");
        for (PurApAccountingLine account : item.getSourceAccountingLines()) {
            if (account.getAccountLinePercent() != null) {
                totalPercent = totalPercent.add(account.getAccountLinePercent());
                continue;
            }
            totalPercent = totalPercent.add(BigDecimal.ZERO);
        }
        if (desiredPercent.compareTo(totalPercent) != 0) {
            if (writeErrorMessage) {
                GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.total", new String[]{item.getItemIdentifierString()});
            }
            valid = false;
        }
        return valid;
    }

    public boolean validateTotalAmount(PurApItem item, boolean writeErrorMessage) {
        if (item.getSourceAccountingLines().size() == 0) {
            return true;
        }
        if (item.getItemQuantity() == null || item.getItemUnitPrice() == null || item.getTotalAmount().compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) == 0) {
            return true;
        }
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        KualiDecimal desiredAmount = item.getTotalAmount() == null ? new KualiDecimal(0) : item.getTotalAmount();
        for (PurApAccountingLine account : item.getSourceAccountingLines()) {
            if (account.getAmount() != null) {
                totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)account.getAmount());
                continue;
            }
            totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)KualiDecimal.ZERO);
        }
        if (desiredAmount.compareTo((AbstractKualiDecimal)totalAmount) != 0) {
            if (writeErrorMessage) {
                GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.total.amount", new String[]{item.getItemIdentifierString(), desiredAmount.toString()});
            }
            return false;
        }
        return true;
    }

    public void setItem(PurApItem item) {
        this.item = item;
    }
}

