/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.integration.purap.ExternalPurApItem;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableNewIndividualItemValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingBelowTheLineItemNoUnitCostValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingItemDescriptionValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingItemQuantityValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingItemUnitPriceValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingUnitOfMeasureValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.vnd.businessobject.CommodityCode;

public class PurchasingNewIndividualItemValidation
extends PurchasingAccountsPayableNewIndividualItemValidation {
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    private BusinessObjectService businessObjectService;
    private CapitalAssetManagementModuleService capitalAssetManagementModuleService;
    private PurchasingUnitOfMeasureValidation unitOfMeasureValidation;
    private PurchasingItemUnitPriceValidation itemUnitPriceValidation;
    private PurchasingItemDescriptionValidation itemDescriptionValidation;
    private PurchasingItemQuantityValidation itemQuantityValidation;
    private PurchasingBelowTheLineItemNoUnitCostValidation belowTheLineItemNoUnitCostValidation;

    @Override
    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = super.validate(event);
        String recurringPaymentTypeCode = ((PurchasingDocument)event.getDocument()).getRecurringPaymentTypeCode();
        if (!this.getItemForValidation().getItemType().isAdditionalChargeIndicator()) {
            valid &= this.capitalAssetManagementModuleService.validateItemCapitalAssetWithErrors(recurringPaymentTypeCode, (ExternalPurApItem)this.getItemForValidation(), false);
        }
        this.unitOfMeasureValidation.setItemForValidation(this.getItemForValidation());
        valid &= this.unitOfMeasureValidation.validate(event);
        if (this.getItemForValidation().getItemType().isLineItemIndicator()) {
            this.itemUnitPriceValidation.setItemForValidation(this.getItemForValidation());
            valid &= this.itemUnitPriceValidation.validate(event);
            this.itemDescriptionValidation.setItemForValidation(this.getItemForValidation());
            valid &= this.itemDescriptionValidation.validate(event);
            this.itemQuantityValidation.setItemForValidation(this.getItemForValidation());
            valid &= this.itemQuantityValidation.validate(event);
            valid &= this.validateCommodityCodes(this.getItemForValidation(), this.commodityCodeIsRequired());
        } else {
            this.belowTheLineItemNoUnitCostValidation.setItemForValidation(this.getItemForValidation());
            valid &= this.belowTheLineItemNoUnitCostValidation.validate(event);
        }
        return valid;
    }

    protected boolean commodityCodeIsRequired() {
        return false;
    }

    protected boolean validateCommodityCodes(PurApItem item, boolean commodityCodeRequired) {
        boolean valid = true;
        String identifierString = item.getItemIdentifierString();
        PurchasingItemBase purItem = (PurchasingItemBase)item;
        String errorPrefix = "document.item[" + (item.getItemLineNumber() - 1) + "].purchasingCommodityCode";
        if (commodityCodeRequired && StringUtils.isBlank((CharSequence)purItem.getPurchasingCommodityCode())) {
            valid = false;
            String attributeLabel = this.businessObjectDictionaryService.getBusinessObjectEntry(CommodityCode.class.getName()).getAttributeDefinition("purchasingCommodityCode").getLabel();
            GlobalVariables.getMessageMap().putError(errorPrefix, "error.required", new String[]{attributeLabel + " in " + identifierString});
        } else if (StringUtils.isNotBlank((CharSequence)purItem.getPurchasingCommodityCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("purchasingCommodityCode", purItem.getPurchasingCommodityCode());
            if (this.businessObjectService.countMatching(CommodityCode.class, fieldValues) != 1) {
                valid = false;
                GlobalVariables.getMessageMap().putError(errorPrefix, "error.commodity.code.invalid", new String[]{" in " + identifierString});
            } else {
                valid = this.validateThatCommodityCodeIsActive(item);
            }
        }
        return valid;
    }

    protected boolean validateThatCommodityCodeIsActive(PurApItem item) {
        item.refreshReferenceObject("commodityCode");
        if (!((PurchasingItemBase)item).getCommodityCode().isActive()) {
            String errorPrefix = "document.item[" + (item.getItemLineNumber() - 1) + "].purchasingCommodityCode";
            GlobalVariables.getMessageMap().putError(errorPrefix, "error.commodity.code.inactive", new String[]{" in " + item.getItemIdentifierString()});
            return false;
        }
        return true;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected CapitalAssetManagementModuleService getCapitalAssetManagementModuleService() {
        return this.capitalAssetManagementModuleService;
    }

    public void setCapitalAssetManagementModuleService(CapitalAssetManagementModuleService capitalAssetManagementModuleService) {
        this.capitalAssetManagementModuleService = capitalAssetManagementModuleService;
    }

    protected PurchasingUnitOfMeasureValidation getUnitOfMeasureValidation() {
        return this.unitOfMeasureValidation;
    }

    public void setUnitOfMeasureValidation(PurchasingUnitOfMeasureValidation unitOfMeasureValidation) {
        this.unitOfMeasureValidation = unitOfMeasureValidation;
    }

    protected PurchasingItemUnitPriceValidation getItemUnitPriceValidation() {
        return this.itemUnitPriceValidation;
    }

    public void setItemUnitPriceValidation(PurchasingItemUnitPriceValidation itemUnitPriceValidation) {
        this.itemUnitPriceValidation = itemUnitPriceValidation;
    }

    protected PurchasingItemDescriptionValidation getItemDescriptionValidation() {
        return this.itemDescriptionValidation;
    }

    public void setItemDescriptionValidation(PurchasingItemDescriptionValidation itemDescriptionValidation) {
        this.itemDescriptionValidation = itemDescriptionValidation;
    }

    protected PurchasingItemQuantityValidation getItemQuantityValidation() {
        return this.itemQuantityValidation;
    }

    public void setItemQuantityValidation(PurchasingItemQuantityValidation itemQuantityValidation) {
        this.itemQuantityValidation = itemQuantityValidation;
    }

    protected PurchasingBelowTheLineItemNoUnitCostValidation getBelowTheLineItemNoUnitCostValidation() {
        return this.belowTheLineItemNoUnitCostValidation;
    }

    public void setBelowTheLineItemNoUnitCostValidation(PurchasingBelowTheLineItemNoUnitCostValidation belowTheLineItemNoUnitCostValidation) {
        this.belowTheLineItemNoUnitCostValidation = belowTheLineItemNoUnitCostValidation;
    }
}

