/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.datadictionary.validation.fieldlevel.EmailAddressValidationPattern;
import org.kuali.kfs.kns.datadictionary.validation.fieldlevel.PhoneNumberValidationPattern;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingProcessRequestorPhoneAndEmailAddressValidation
extends GenericValidation {
    public boolean validate(AttributedDocumentEvent event) {
        String emailAddress;
        PurchasingDocument purDocument = (PurchasingDocument)event.getDocument();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.clearErrorPath();
        errorMap.addToErrorPath("document.requestor*,document.institution*,document.purchaseOrderTransmissionMethodCode,document.purchaseOrderCostSourceCode,document.purchaseOrderTotalLimit");
        boolean valid = true;
        String phoneNumber = purDocument.getRequestorPersonPhoneNumber();
        if (StringUtils.isNotBlank((CharSequence)phoneNumber) && !this.validatePhoneNumber(phoneNumber)) {
            valid = false;
            errorMap.putError("requestorPersonPhoneNumber", "errors.invalid.requestorPhoneNumber", new String[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)(emailAddress = purDocument.getRequestorPersonEmailAddress())) && !this.validateEmailAddress(emailAddress)) {
            valid = false;
            errorMap.putError("requestorPersonEmailAddress", "errors.invalid.requestorEmailAddress", new String[0]);
        }
        errorMap.clearErrorPath();
        return valid;
    }

    protected boolean validatePhoneNumber(String phoneNumber) {
        PhoneNumberValidationPattern phonePattern = new PhoneNumberValidationPattern();
        return phonePattern.matches(phoneNumber);
    }

    protected boolean validateEmailAddress(String emailAddress) {
        EmailAddressValidationPattern emailAddressPattern = new EmailAddressValidationPattern();
        return emailAddressPattern.matches(emailAddress);
    }
}

