/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Set;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentPresentationController;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingNewIndividualItemValidation;

public class RequisitionNewIndividualItemValidation
extends PurchasingNewIndividualItemValidation {
    private DocumentDictionaryService documentDictionaryService;

    @Override
    protected boolean commodityCodeIsRequired() {
        boolean enableCommodityCode = this.parameterService.getParameterValueAsBoolean("KFS-PURAP", "Document", "ENABLE_COMMODITY_CODE_IND");
        if (!enableCommodityCode) {
            return false;
        }
        Boolean itemsRequireCommodityCode = this.parameterService.getParameterValueAsBoolean(RequisitionDocument.class, "ITEMS_REQUIRE_COMMODITY_CODE_IND");
        if (!itemsRequireCommodityCode.booleanValue()) {
            return false;
        }
        return this.userCanEditDocument();
    }

    private boolean userCanEditDocument() {
        Object accountingDocument = this.getItemForValidation().getPurapDocument();
        TransactionalDocumentPresentationController presentationController = (TransactionalDocumentPresentationController)this.documentDictionaryService.getDocumentPresentationController(accountingDocument);
        TransactionalDocumentAuthorizer documentAuthorizer = (TransactionalDocumentAuthorizer)this.documentDictionaryService.getDocumentAuthorizer(accountingDocument);
        Person person = GlobalVariables.getUserSession().getPerson();
        Set presentationControllerEditModes = presentationController.getEditModes(accountingDocument);
        Set editModes = documentAuthorizer.getEditModes(accountingDocument, person, presentationControllerEditModes);
        Set presentationControllerDocumentActions = presentationController.getDocumentActions(accountingDocument);
        Set documentActions = documentAuthorizer.getDocumentActions(accountingDocument, person, presentationControllerDocumentActions);
        return documentActions.contains("canEdit") && !editModes.contains("restrictFullEntry");
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }
}

