/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.ContractManagerAssignmentDetail;
import org.kuali.kfs.module.purap.document.ContractManagerAssignmentDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentActionBase;

public class ContractManagerAssignmentAction
extends FinancialSystemTransactionalDocumentActionBase {
    private static final Logger LOG = LogManager.getLogger();

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) {
        super.createDocument(kualiDocumentFormBase);
        ContractManagerAssignmentDocument acmDocument = (ContractManagerAssignmentDocument)kualiDocumentFormBase.getDocument();
        acmDocument.getDocumentHeader().setDocumentDescription("Contract Manager Assigned");
        acmDocument.populateDocumentWithRequisitions();
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) {
        super.loadDocument(kualiDocumentFormBase);
        ContractManagerAssignmentDocument document = (ContractManagerAssignmentDocument)kualiDocumentFormBase.getDocument();
        HashMap<String, ContractManagerAssignmentDetail> documentHeaderIdsAndDetails = new HashMap<String, ContractManagerAssignmentDetail>();
        for (ContractManagerAssignmentDetail detail : document.getContractManagerAssignmentDetails()) {
            documentHeaderIdsAndDetails.put(detail.getRequisition().getDocumentNumber(), detail);
        }
        ArrayList documentHeaderIds = new ArrayList(documentHeaderIdsAndDetails.keySet());
        List requisitionDocumentsFromDocService = new ArrayList();
        if (documentHeaderIds.size() > 0) {
            requisitionDocumentsFromDocService = ((DocumentService)SpringContext.getBean(DocumentService.class)).getDocumentsByListOfDocumentHeaderIds(RequisitionDocument.class, documentHeaderIds);
        }
        for (Document req : requisitionDocumentsFromDocService) {
            ContractManagerAssignmentDetail detail = (ContractManagerAssignmentDetail)((Object)documentHeaderIdsAndDetails.get(req.getDocumentNumber()));
            detail.getRequisition().setDocumentHeader(req.getDocumentHeader());
        }
    }

    protected void populateAdHocActionRequestCodes(KualiDocumentFormBase formBase) {
        Document document = formBase.getDocument();
        DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
        HashMap<String, String> adHocActionRequestCodes = new HashMap<String, String>();
        if (documentAuthorizer.canSendAdHocRequests(document, "F", GlobalVariables.getUserSession().getPerson())) {
            adHocActionRequestCodes.put("F", "FYI");
        }
        if ((document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved() || document.getDocumentHeader().getWorkflowDocument().isEnroute()) && documentAuthorizer.canSendAdHocRequests(document, "K", GlobalVariables.getUserSession().getPerson())) {
            adHocActionRequestCodes.put("K", "ACKNOWLEDGE");
        }
        formBase.setAdHocActionRequestCodes(adHocActionRequestCodes);
    }
}

