/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.form.BlankFormFile;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderQuoteList;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderQuoteListVendor;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderSensitiveData;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorStipulation;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignment;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderRetransmitDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderSplitDocument;
import org.kuali.kfs.module.purap.document.service.FaxService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.PurchasingService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedAddVendorToQuoteEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedAssignSensitiveDataEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedSplitPurchaseOrderEvent;
import org.kuali.kfs.module.purap.document.web.struts.PurchaseOrderForm;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingAccountsPayableFormBase;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingActionBase;
import org.kuali.kfs.module.purap.service.SensitiveDataService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;

public class PurchaseOrderAction
extends PurchasingActionBase {
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String newStipulation;
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument document = (PurchaseOrderDocument)poForm.getDocument();
        BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        if (request.getParameter("document.alternateVendorHeaderGeneratedIdentifier") != null && request.getParameter("document.alternateVendorDetailAssignedIdentifier") != null) {
            Integer alternateVendorDetailAssignedId = document.getAlternateVendorDetailAssignedIdentifier();
            Integer alternateVendorHeaderGeneratedId = document.getAlternateVendorHeaderGeneratedIdentifier();
            Object refreshVendorDetail = new VendorDetail();
            refreshVendorDetail.setVendorDetailAssignedIdentifier(alternateVendorDetailAssignedId);
            refreshVendorDetail.setVendorHeaderGeneratedIdentifier(alternateVendorHeaderGeneratedId);
            refreshVendorDetail = (VendorDetail)businessObjectService.retrieve((PersistableBusinessObject)refreshVendorDetail);
            document.templateAlternateVendor((VendorDetail)refreshVendorDetail);
        }
        if (request.getParameter("document.purchaseOrderQuoteListIdentifier") != null) {
            Integer poQuoteListIdentifier = document.getPurchaseOrderQuoteListIdentifier();
            PurchaseOrderQuoteList poQuoteList = new PurchaseOrderQuoteList();
            poQuoteList.setPurchaseOrderQuoteListIdentifier(poQuoteListIdentifier);
            poQuoteList = (PurchaseOrderQuoteList)businessObjectService.retrieve((PersistableBusinessObject)poQuoteList);
            if (poQuoteList.isActive()) {
                for (PurchaseOrderQuoteListVendor poQuoteListVendor : poQuoteList.getQuoteListVendors()) {
                    VendorDetail newVendor;
                    if (!poQuoteListVendor.isActive() || !(newVendor = poQuoteListVendor.getVendorDetail()).isActiveIndicator() || newVendor.isVendorDebarred()) continue;
                    PurchaseOrderVendorQuote newPOVendorQuote = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).populateQuoteWithVendor(newVendor.getVendorHeaderGeneratedIdentifier(), newVendor.getVendorDetailAssignedIdentifier(), document.getDocumentNumber());
                    document.getPurchaseOrderVendorQuotes().add(newPOVendorQuote);
                }
            }
        }
        String newVendorHeaderGeneratedIdentifier = request.getParameter("newPurchaseOrderVendorQuote.vendorHeaderGeneratedIdentifier");
        String newVendorDetailAssignedIdentifier = request.getParameter("newPurchaseOrderVendorQuote.vendorDetailAssignedIdentifier");
        if (newVendorHeaderGeneratedIdentifier != null && newVendorDetailAssignedIdentifier != null) {
            PurchaseOrderVendorQuote newPOVendorQuote = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).populateQuoteWithVendor(new Integer(newVendorHeaderGeneratedIdentifier), new Integer(newVendorDetailAssignedIdentifier), document.getDocumentNumber());
            poForm.setNewPurchaseOrderVendorQuote(newPOVendorQuote);
        }
        if (StringUtils.isNotEmpty((CharSequence)(newStipulation = request.getParameter("document.vendorStipulationDescription")))) {
            poForm.getNewPurchaseOrderVendorStipulationLine().setVendorStipulationDescription(newStipulation);
        }
        return super.refresh(mapping, form, request, response);
    }

    public ActionForward inactivateItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchaseOrderDocument purDocument = (PurchaseOrderDocument)purchasingForm.getDocument();
        List items = purDocument.getItems();
        PurchaseOrderItem item = (PurchaseOrderItem)items.get(this.getSelectedLine(request));
        item.setItemActiveIndicator(false);
        return mapping.findForward("basic");
    }

    protected ActionForward askQuestionsAndPerformDocumentAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionType, String confirmType, String documentType, String notePrefix, String messageType, String operation) throws Exception {
        LOG.debug("askQuestionsAndPerformDocumentAction started.");
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)kualiDocumentFormBase.getDocument();
        String question = request.getParameter("questionIndex");
        String reason = request.getParameter("reason");
        ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        if (ObjectUtils.isNull((Object)question)) {
            String message;
            if (documentType.equals("POSP")) {
                message = kualiConfiguration.getPropertyValueAsString("purchaseOrder.split.question.text");
            } else {
                String key = kualiConfiguration.getPropertyValueAsString("purchaseOrder.question.text");
                message = StringUtils.replace((String)key, (String)"{0}", (String)operation);
            }
            return this.performQuestionWithInput(mapping, form, request, response, questionType, message, "confirmationQuestion", questionType, "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if (question.equals(questionType) && buttonClicked.equals("1")) {
            return this.returnToPreviousPage(mapping, kualiDocumentFormBase);
        }
        if (question.equals(confirmType) && buttonClicked.equals("0")) {
            return mapping.findForward("portal");
        }
        String introNoteMessage = notePrefix + " ";
        String noteText = introNoteMessage + reason;
        int noteTextLength = noteText.length();
        int noteTextMaxLength = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(Note.class, "noteText");
        if (StringUtils.isBlank((CharSequence)reason) || noteTextLength > noteTextMaxLength) {
            int reasonLimit = noteTextMaxLength - noteTextLength;
            if (ObjectUtils.isNull((Object)reason)) {
                reason = "";
            }
            String key = kualiConfiguration.getPropertyValueAsString("purchaseOrder.question.text");
            String message = StringUtils.replace((String)key, (String)"{0}", (String)operation);
            return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, questionType, message, "confirmationQuestion", questionType, "", reason, "error.purchaseOrder.reasonRequired", "reason", Integer.toString(reasonLimit));
        }
        ActionForward returnActionForward = null;
        if (!po.isPendingActionIndicator()) {
            if (documentType.equals("POSP")) {
                po.setPendingSplit(true);
                ((PurchaseOrderForm)kualiDocumentFormBase).setSplitNoteText(noteText);
                returnActionForward = mapping.findForward("basic");
            } else {
                String newStatus = null;
                if (documentType.equals("POA")) {
                    newStatus = "Pending Amendment";
                    po = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).createAndSavePotentialChangeDocument(kualiDocumentFormBase.getDocument().getDocumentNumber(), documentType, newStatus);
                    returnActionForward = mapping.findForward("basic");
                } else {
                    switch (documentType) {
                        case "POC": {
                            newStatus = "Pending Close";
                            break;
                        }
                        case "POR": {
                            newStatus = "Pending Reopen";
                            break;
                        }
                        case "POV": {
                            newStatus = "Pending Void";
                            break;
                        }
                        case "POPH": {
                            newStatus = "Pending Payment Hold";
                            break;
                        }
                        case "PORH": {
                            newStatus = "Pending Remove Hold";
                            break;
                        }
                        case "PORT": {
                            newStatus = "Pending Retransmit";
                            break;
                        }
                    }
                    po = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).createAndRoutePotentialChangeDocument(kualiDocumentFormBase.getDocument().getDocumentNumber(), documentType, kualiDocumentFormBase.getAnnotation(), this.combineAdHocRecipients(kualiDocumentFormBase), newStatus);
                }
                if (!GlobalVariables.getMessageMap().hasNoErrors()) {
                    throw new ValidationException("errors occurred during new PO creation");
                }
                String previousDocumentId = kualiDocumentFormBase.getDocId();
                kualiDocumentFormBase.setDocument((Document)po);
                kualiDocumentFormBase.setDocId(po.getDocumentNumber());
                kualiDocumentFormBase.setDocTypeName(po.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
                Note newNote = new Note();
                if (documentType.equals("POA")) {
                    noteText = noteText + " (Previous Document Id is " + previousDocumentId + ")";
                }
                newNote.setNoteText(noteText);
                newNote.setNoteTypeCode(KFSConstants.NoteTypeEnum.BUSINESS_OBJECT_NOTE_TYPE.getCode());
                kualiDocumentFormBase.setNewNote(newNote);
                kualiDocumentFormBase.setAttachmentFile((FormFile)new BlankFormFile());
                this.insertBONote(mapping, (ActionForm)kualiDocumentFormBase, request, response);
                PurchaseOrderDocument oldestPurchaseOrder = (PurchaseOrderDocument)kualiDocumentFormBase.getDocument();
                List newNotes = this.getNoteService().getByRemoteObjectId(oldestPurchaseOrder.getObjectId());
                oldestPurchaseOrder.setNotes(newNotes);
            }
            if (StringUtils.isNotEmpty((CharSequence)messageType)) {
                KNSGlobalVariables.getMessageList().add(messageType, new String[0]);
            }
        }
        if (ObjectUtils.isNotNull(returnActionForward)) {
            return returnActionForward;
        }
        return this.performQuestionWithoutInput(mapping, form, request, response, confirmType, kualiConfiguration.getPropertyValueAsString(messageType), "singleConfirmationQuestion", questionType, "");
    }

    public ActionForward closePo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("ClosePO started.");
        String operation = "Close ";
        PurchaseOrderDocument po = ((PurchaseOrderForm)form).getPurchaseOrderDocument();
        if (po.canClosePOForTradeIn()) {
            return this.askQuestionsAndPerformDocumentAction(mapping, form, request, response, "POClose", "POCloseConfirm", "POC", "Note entered while closing a Purchase Order :", "purchaseOrder.route.message.close.text", operation);
        }
        return mapping.findForward("basic");
    }

    public ActionForward paymentHoldPo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("PaymentHoldPO started.");
        String operation = "Hold Payment ";
        return this.askQuestionsAndPerformDocumentAction(mapping, form, request, response, "POPaymentHold", "POPaymentHoldConfirm", "POPH", "Note entered while putting a Purchase Order on payment hold :", "purchaseOrder.route.message.payment.hold.text", operation);
    }

    public ActionForward removeHoldPo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("RemoveHoldPO started.");
        String operation = "Remove Payment Hold ";
        return this.askQuestionsAndPerformDocumentAction(mapping, form, request, response, "PORemoveHold", "PORemoveHoldConfirm", "PORH", "Note entered while removing a Purchase Order from payment hold :", "purchaseOrder.route.message.remove.hold.text", operation);
    }

    public ActionForward reopenPo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("Reopen PO started");
        String operation = "Reopen ";
        return this.askQuestionsAndPerformDocumentAction(mapping, form, request, response, "ReopenPO", "ConfirmReopen", "POR", "Note entered while reopening a Purchase Order : ", "purchaseOrder.route.message.reopen.text", operation);
    }

    public ActionForward amendPo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("Amend PO started");
        String operation = "Amend ";
        return this.askQuestionsAndPerformDocumentAction(mapping, form, request, response, "AmendmentPO", "ConfirmAmendment", "POA", "Note entered while amending a Purchase Order : ", null, operation);
    }

    public ActionForward voidPo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("Void PO started");
        String operation = "Void ";
        return this.askQuestionsAndPerformDocumentAction(mapping, form, request, response, "POVoid", "POVoidConfirm", "POV", "Note entered while voiding a Purchase Order :", "purchaseOrder.route.message.void.text", operation);
    }

    public ActionForward splitPo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("Split PO started");
        String operation = "Split ";
        return this.askQuestionsAndPerformDocumentAction(mapping, form, request, response, "POSplit", "POSplitConfirm", "POSP", "Note entered while splitting this Purchase Order : ", "purchaseOrder.route.message.split.text", operation);
    }

    public ActionForward continuePurchaseOrderSplit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("Continue Purchase Order Split started");
        PurchaseOrderForm purchaseOrderForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument poToSplit = (PurchaseOrderDocument)purchaseOrderForm.getDocument();
        boolean copyNotes = poToSplit.isCopyingNotesWhenSplitting();
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedSplitPurchaseOrderEvent((Document)poToSplit));
        if (!rulePassed) {
            poToSplit.setPendingSplit(true);
        } else {
            HashMap<String, List<PurchaseOrderItem>> categorizedItems = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).categorizeItemsForSplit(poToSplit.getItems());
            List<PurchaseOrderItem> movingPOItems = categorizedItems.get("movingPOItems");
            List<PurchaseOrderItem> remainingPOItems = categorizedItems.get("remainingPOItems");
            poToSplit = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(poToSplit.getPurapDocumentIdentifier());
            poToSplit.setItems(remainingPOItems);
            poToSplit.renumberItems(0);
            ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetItems(poToSplit);
            ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetSystem(poToSplit);
            String noteText = purchaseOrderForm.getSplitNoteText();
            try {
                Note splitNote = ((DocumentService)SpringContext.getBean(DocumentService.class)).createNoteFromDocument((Document)poToSplit, noteText);
                poToSplit.addNote(splitNote);
                ((NoteService)SpringContext.getBean(NoteService.class)).save(splitNote);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)poToSplit);
            PurchaseOrderSplitDocument splitPO = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).createAndSavePurchaseOrderSplitDocument(movingPOItems, poToSplit, copyNotes, noteText);
            splitPO.setAccountsPayablePurchasingDocumentLinkIdentifier(poToSplit.getAccountsPayablePurchasingDocumentLinkIdentifier());
            purchaseOrderForm.setDocument((Document)splitPO);
            purchaseOrderForm.setDocId(splitPO.getDocumentNumber());
            purchaseOrderForm.setDocTypeName(splitPO.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            this.loadDocument((KualiDocumentFormBase)purchaseOrderForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward cancelPurchaseOrderSplit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("Cancel Purchase Order Split started");
        PurchaseOrderForm purchaseOrderForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)purchaseOrderForm.getDocument();
        po = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getPurchaseOrderByDocumentNumber(po.getDocumentNumber());
        po.setPendingSplit(false);
        po.setCopyingNotesWhenSplitting(false);
        purchaseOrderForm.setDocument((Document)po);
        this.reload(mapping, (ActionForm)purchaseOrderForm, request, response);
        return mapping.findForward("basic");
    }

    public ActionForward assignSensitiveData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("Assign Sensitive Data started");
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)poForm.getDocument();
        Integer poId = po.getPurapDocumentIdentifier();
        SensitiveDataService sdService = (SensitiveDataService)SpringContext.getBean(SensitiveDataService.class);
        po.setAssigningSensitiveData(true);
        poForm.setSensitiveDataAssignmentReason("");
        poForm.setNewSensitiveDataLine(new SensitiveData());
        SensitiveDataAssignment sda = sdService.getLastSensitiveDataAssignment(poId);
        poForm.setLastSensitiveDataAssignment(sda);
        List<SensitiveData> posds = sdService.getSensitiveDatasAssignedByPoId(poId);
        poForm.setSensitiveDatasAssigned(posds);
        return mapping.findForward("basic");
    }

    public ActionForward submitSensitiveData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("Submit Sensitive Data started");
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)poForm.getDocument();
        Integer poId = po.getPurapDocumentIdentifier();
        List<SensitiveData> sds = poForm.getSensitiveDatasAssigned();
        String sdaReason = poForm.getSensitiveDataAssignmentReason();
        SensitiveDataService sdService = (SensitiveDataService)SpringContext.getBean(SensitiveDataService.class);
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedAssignSensitiveDataEvent("", (Document)po, sdaReason, sds));
        if (!rulePassed) {
            return mapping.findForward("basic");
        }
        SensitiveDataAssignment sda = new SensitiveDataAssignment(poId, poForm.getSensitiveDataAssignmentReason(), GlobalVariables.getUserSession().getPerson().getPrincipalName(), poForm.getSensitiveDatasAssigned());
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)sda);
        sdService.deletePurchaseOrderSensitiveDatas(poId);
        ArrayList<PurchaseOrderSensitiveData> posds = new ArrayList<PurchaseOrderSensitiveData>();
        for (SensitiveData sd : sds) {
            posds.add(new PurchaseOrderSensitiveData(poId, po.getRequisitionIdentifier(), sd.getSensitiveDataCode()));
        }
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save(posds);
        ((PurapService)SpringContext.getBean(PurapService.class)).saveRoutingDataForRelatedDocuments(po.getAccountsPayablePurchasingDocumentLinkIdentifier());
        po.setAssigningSensitiveData(false);
        ParameterService parmService = (ParameterService)SpringContext.getBean(ParameterService.class);
        if (parmService.parameterExists(PurchaseOrderDocument.class, "SENSITIVE_DATA_NOTE_IND").booleanValue() && parmService.getParameterValueAsBoolean(PurchaseOrderDocument.class, "SENSITIVE_DATA_NOTE_IND").booleanValue()) {
            Note newNote = new Note();
            String introNoteMessage = "Sensitive Data: ";
            String reason = sda.getSensitiveDataAssignmentReasonText();
            String noteText = introNoteMessage + " " + reason;
            newNote.setNoteText(noteText);
            newNote.setNoteTypeCode(KFSConstants.NoteTypeEnum.BUSINESS_OBJECT_NOTE_TYPE.getCode());
            poForm.setNewNote(newNote);
            poForm.setAttachmentFile((FormFile)new BlankFormFile());
            this.insertBONote(mapping, (ActionForm)poForm, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward cancelSensitiveData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("Cancel Sensitive Data started");
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)poForm.getDocument();
        po.setAssigningSensitiveData(false);
        List<SensitiveData> sds = ((SensitiveDataService)SpringContext.getBean(SensitiveDataService.class)).getSensitiveDatasAssignedByPoId(po.getPurapDocumentIdentifier());
        poForm.setSensitiveDatasAssigned(sds);
        return mapping.findForward("basic");
    }

    public ActionForward addSensitiveData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("Add Sensitive Data started");
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        SensitiveDataService sdService = (SensitiveDataService)SpringContext.getBean(SensitiveDataService.class);
        SensitiveData newsd = poForm.getNewSensitiveDataLine();
        newsd = sdService.getSensitiveDataByCode(newsd.getSensitiveDataCode());
        List<SensitiveData> sds = poForm.getSensitiveDatasAssigned();
        sds.add(newsd);
        poForm.setNewSensitiveDataLine(new SensitiveData());
        return mapping.findForward("basic");
    }

    public ActionForward deleteSensitiveData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("Delete Sensitive Data started");
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        List<SensitiveData> sds = poForm.getSensitiveDatasAssigned();
        sds.remove(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    protected ActionForward returnToPreviousPage(ActionMapping mapping, KualiDocumentFormBase kualiDocumentFormBase) {
        return mapping.findForward("basic");
    }

    public ActionForward firstTransmitPrintPo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).performPurchaseOrderFirstTransmitViaPrinting(poForm.getPurchaseOrderDocument());
        poForm.setPurchaseOrderPrintRequested(true);
        return mapping.findForward("basic");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generatePOOutput(HttpServletRequest request, HttpServletResponse response, String poDocId, ByteArrayOutputStream baosPDF) throws IOException {
        try {
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).performPrintPurchaseOrderPDFOnly(poDocId, baosPDF);
            String sbFilename = this.buildFileName("PURAP_PO_", poDocId);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baosPDF, (String)sbFilename);
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
    }

    protected String getUrlForPrintPO(String basePath, String docId, String methodToCall) {
        return basePath + "/purapPurchaseOrder.do?methodToCall=" + methodToCall + "&docId=" + docId + "&command=displayDocSearchView";
    }

    public ActionForward printPurchaseOrderPDFOnly(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        poForm.setPurchaseOrderPrintRequested(false);
        String poDocId = poForm.getDocId();
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        this.generatePOOutput(request, response, poDocId, baosPDF);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward printPoQuote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)kualiDocumentFormBase.getDocument();
        PurchaseOrderVendorQuote poVendorQuote = po.getPurchaseOrderVendorQuotes().get(this.getSelectedLine(request));
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        poVendorQuote.setTransmitPrintDisplayed(false);
        try {
            String sbFilename = this.buildFileName("PURAP_PO_QUOTE_", "" + po.getPurapDocumentIdentifier());
            boolean success = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).printPurchaseOrderQuotePDF(po, poVendorQuote, baosPDF);
            if (!success) {
                poVendorQuote.setTransmitPrintDisplayed(true);
                poVendorQuote.setPdfDisplayedToUserOnce(false);
                if (baosPDF != null) {
                    baosPDF.reset();
                }
                ActionForward actionForward = mapping.findForward("basic");
                return actionForward;
            }
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baosPDF, (String)sbFilename);
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward printPoQuoteList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String poDocId = ((PurchaseOrderForm)form).getDocId();
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)kualiDocumentFormBase.getDocument();
        ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)po);
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        try {
            String sbFilename = this.buildFileName("PURAP_PO_QUOTE_LIST_", poDocId);
            boolean success = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).printPurchaseOrderQuoteRequestsListPDF(poDocId, baosPDF);
            if (!success) {
                if (baosPDF != null) {
                    baosPDF.reset();
                }
                ActionForward actionForward = mapping.findForward("portal");
                return actionForward;
            }
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baosPDF, (String)sbFilename);
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
        return null;
    }

    public ActionForward transmitPurchaseOrderQuote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)kualiDocumentFormBase.getDocument();
        PurchaseOrderVendorQuote vendorQuote = po.getPurchaseOrderVendorQuotes().get(this.getSelectedLine(request));
        if ("PRINT".equals(vendorQuote.getPurchaseOrderQuoteTransmitTypeCode())) {
            vendorQuote.setPurchaseOrderQuoteTransmitTimestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
            vendorQuote.setTransmitPrintDisplayed(true);
            vendorQuote.setPdfDisplayedToUserOnce(false);
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)po);
        } else if ("FAX".equals(vendorQuote.getPurchaseOrderQuoteTransmitTypeCode())) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            FaxService faxService = (FaxService)SpringContext.getBean(FaxService.class);
            faxService.faxPurchaseOrderQuotePdf(po, vendorQuote);
            if (GlobalVariables.getMessageMap().getNumberOfPropertiesWithErrors() == 0) {
                vendorQuote.setPurchaseOrderQuoteTransmitTimestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
                ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)po);
            }
        } else {
            GlobalVariables.getMessageMap().putError("purchaseOrderVendorQuotes", "error.purchaseOrder.quote.transmit.type.not.selected", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward selectAllForRetransmit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)kualiDocumentFormBase.getDocument();
        List items = po.getItems();
        for (PurchaseOrderItem item : items) {
            item.setItemSelectedForRetransmitIndicator(true);
        }
        return this.returnToPreviousPage(mapping, kualiDocumentFormBase);
    }

    public ActionForward deselectAllForRetransmit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)kualiDocumentFormBase.getDocument();
        List items = po.getItems();
        for (PurchaseOrderItem item : items) {
            item.setItemSelectedForRetransmitIndicator(false);
        }
        return this.returnToPreviousPage(mapping, kualiDocumentFormBase);
    }

    public ActionForward retransmitPo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)kualiDocumentFormBase.getDocument();
        if (po.isPendingActionIndicator()) {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "error.invoice.purchaseOrder.isPending", new String[0]);
        } else {
            po = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).createAndRoutePotentialChangeDocument(kualiDocumentFormBase.getDocument().getDocumentNumber(), "PORT", kualiDocumentFormBase.getAnnotation(), this.combineAdHocRecipients(kualiDocumentFormBase), "Pending Retransmit");
            ((PurchaseOrderRetransmitDocument)po).setShouldDisplayRetransmitTab(true);
        }
        kualiDocumentFormBase.setDocument((Document)po);
        return this.returnToPreviousPage(mapping, kualiDocumentFormBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward printingPreviewPo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String poDocId = ((PurchaseOrderForm)form).getDocId();
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        try {
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).performPurchaseOrderPreviewPrinting(poDocId, baosPDF);
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
        this.generatePOOutput(request, response, poDocId, baosPDF);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward printingRetransmitPo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)kualiDocumentFormBase.getDocument();
        String documentNumber = po.getDocumentNumber();
        StringBuilder itemIndexesBuffer = this.createSelectedItemIndexes(po.getItems());
        if (itemIndexesBuffer.length() > 0) {
            itemIndexesBuffer.deleteCharAt(itemIndexesBuffer.lastIndexOf(","));
        }
        if (itemIndexesBuffer.length() == 0) {
            GlobalVariables.getMessageMap().putError("document.items", "error.purchaseOrder.retransmit.select", new String[0]);
            return this.returnToPreviousPage(mapping, kualiDocumentFormBase);
        }
        String retransmitHeader = request.getParameter("retransmitHeader");
        po.setRetransmitHeader(retransmitHeader);
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        try {
            String sbFilename = this.buildFileName("PURAP_PO_", "" + po.getPurapDocumentIdentifier());
            PurchaseOrderDocument poDoc = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getPurchaseOrderByDocumentNumber(documentNumber);
            this.setItemSelectedForRetransmitIndicatorFromPOInForm(itemIndexesBuffer.toString(), poDoc.getItems());
            poDoc.setRetransmitHeader(retransmitHeader);
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).retransmitPurchaseOrderPDF(poDoc, baosPDF);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baosPDF, (String)sbFilename);
        }
        catch (ValidationException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((PurchaseOrderDocument)po).getDocumentNumber();
            LOG.warn("Caught ValidationException while trying to retransmit PO with doc id {}", supplierArray);
            ActionForward actionForward = mapping.findForward("error");
            return actionForward;
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
        return null;
    }

    protected String buildFileName(String filename, String purapDocumentIdentifier) {
        return filename + purapDocumentIdentifier + "_" + System.currentTimeMillis() + ".pdf";
    }

    protected StringBuilder createSelectedItemIndexes(List<PurchaseOrderItem> items) {
        StringBuilder itemIndexesBuilder = new StringBuilder();
        int i = 0;
        for (PurchaseOrderItem item : items) {
            if (item.isItemSelectedForRetransmitIndicator()) {
                itemIndexesBuilder.append(i);
                itemIndexesBuilder.append(',');
            }
            ++i;
        }
        return itemIndexesBuilder;
    }

    protected void setItemSelectedForRetransmitIndicatorFromPOInForm(String selectedItemIndexes, List itemsFromDB) {
        StringTokenizer tok = new StringTokenizer(selectedItemIndexes, ",");
        while (tok.hasMoreTokens()) {
            int i = Integer.parseInt(tok.nextToken());
            ((PurchaseOrderItem)itemsFromDB.get(i)).setItemSelectedForRetransmitIndicator(true);
        }
    }

    protected void checkForPOWarnings(PurchaseOrderDocument po, ActionMessages messages) {
        if (!po.isPurchaseOrderCurrentIndicator() && !po.getDocumentHeader().getWorkflowDocument().isEnroute()) {
            KNSGlobalVariables.getMessageList().add("warning.purchaseOrder.notCurrent", new String[0]);
        }
        if (!po.isPurchaseOrderCurrentIndicator() && po.getDocumentHeader().getWorkflowDocument().isEnroute()) {
            KNSGlobalVariables.getMessageList().add("warning.purchaseOrder.pendingAction.notCurrent", new String[0]);
        }
        if (po.isPendingActionIndicator()) {
            KNSGlobalVariables.getMessageList().add("warning.purchaseOrder.pendingAction", new String[0]);
        }
        if (!po.isPurchaseOrderCurrentIndicator()) {
            ActionMessage noteMessage = new ActionMessage("warning.purchaseOrder.allNotes");
            messages.add("noteWarning", noteMessage);
        }
    }

    public ActionForward addStipulation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument document = (PurchaseOrderDocument)poForm.getDocument();
        if (StringUtils.isBlank((CharSequence)poForm.getNewPurchaseOrderVendorStipulationLine().getVendorStipulationDescription())) {
            String errorPrefix = "newPurchaseOrderVendorStipulationLine.vendorStipulationDescription";
            GlobalVariables.getMessageMap().putError(errorPrefix, "error.purchaseOrder.stipulationDescriptionEmpty", new String[0]);
        } else {
            PurchaseOrderVendorStipulation newStipulation = poForm.getAndResetNewPurchaseOrderVendorStipulationLine();
            document.getPurchaseOrderVendorStipulations().add(newStipulation);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteStipulation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument document = (PurchaseOrderDocument)poForm.getDocument();
        document.getPurchaseOrderVendorStipulations().remove(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.docHandler(mapping, form, request, response);
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument po = (PurchaseOrderDocument)poForm.getDocument();
        ActionMessages messages = new ActionMessages();
        this.checkForPOWarnings(po, messages);
        this.saveMessages(request, messages);
        return forward;
    }

    public ActionForward initiateQuote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument document = (PurchaseOrderDocument)poForm.getDocument();
        if (!"In Process".equals(document.getApplicationDocumentStatus())) {
            GlobalVariables.getMessageMap().putError("purchaseOrderVendorQuotes", "error.purchaseOrder.quote.notInProcess", new String[0]);
            return mapping.findForward("basic");
        }
        Calendar currentCalendar = dateTimeService.getCurrentCalendar();
        Date currentSqlDate = new Date(currentCalendar.getTimeInMillis());
        document.setPurchaseOrderQuoteInitializationDate(currentSqlDate);
        document.updateAndSaveAppDocStatus("Out for Quote");
        document.setStatusChange("Out for Quote");
        Calendar expCalendar = (Calendar)currentCalendar.clone();
        expCalendar.add(5, 10);
        Date expDate = new Date(expCalendar.getTimeInMillis());
        document.setPurchaseOrderQuoteDueDate(expDate);
        document.getPurchaseOrderVendorQuotes().clear();
        ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)document);
        return mapping.findForward("basic");
    }

    public ActionForward addVendor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument document = (PurchaseOrderDocument)poForm.getDocument();
        PurchaseOrderVendorQuote vendorQuote = poForm.getNewPurchaseOrderVendorQuote();
        String errorPrefix = "newPurchaseOrderVendorQuote";
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedAddVendorToQuoteEvent(errorPrefix, (Document)document, vendorQuote));
        if (rulePassed) {
            poForm.getNewPurchaseOrderVendorQuote().setDocumentNumber(document.getDocumentNumber());
            document.getPurchaseOrderVendorQuotes().add(vendorQuote);
            poForm.setNewPurchaseOrderVendorQuote(new PurchaseOrderVendorQuote());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteVendor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument document = (PurchaseOrderDocument)poForm.getDocument();
        document.getPurchaseOrderVendorQuotes().remove(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward completeQuote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument document = (PurchaseOrderDocument)poForm.getDocument();
        boolean dictionaryValid = true;
        for (PurchaseOrderVendorQuote poQuote : document.getPurchaseOrderVendorQuotes()) {
            if (poQuote.getPurchaseOrderQuoteStatusCode() == null) {
                GlobalVariables.getMessageMap().putError("purchaseOrderVendorQuotes", "error.purchaseOrder.quote.status.not.selected", new String[0]);
                return mapping.findForward("basic");
            }
            dictionaryValid &= ((DictionaryValidationService)SpringContext.getBean(DictionaryValidationService.class)).isBusinessObjectValid((BusinessObject)poQuote, "purchaseOrderVendorQuotes");
        }
        if (!dictionaryValid) {
            return mapping.findForward("basic");
        }
        if (poForm.getAwardedVendorNumber() == null) {
            GlobalVariables.getMessageMap().putError("purchaseOrderVendorQuotes", "error.transmit.purchaseOrder.noVendorAwarded", new String[0]);
            return mapping.findForward("basic");
        }
        PurchaseOrderVendorQuote awardedQuote = document.getPurchaseOrderVendorQuote(poForm.getAwardedVendorNumber().intValue());
        if (awardedQuote.getPurchaseOrderQuoteStatusCode() == null) {
            GlobalVariables.getMessageMap().putError("purchaseOrderVendorQuotes", "error.transmit.purchaseOrder.notTransmitted", new String[0]);
            return mapping.findForward("basic");
        }
        VendorDetail awardedVendor = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDetail(awardedQuote.getVendorHeaderGeneratedIdentifier(), awardedQuote.getVendorDetailAssignedIdentifier());
        if (!awardedVendor.getVendorHeader().getVendorTypeCode().equals("PO")) {
            GlobalVariables.getMessageMap().putError("purchaseOrderVendorQuotes", "error.purchaseOrder.quote.award.nonPO", new String[0]);
            return mapping.findForward("basic");
        }
        StringBuffer awardedVendorInfo = new StringBuffer(((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("purchaseOrder.route.message.confirm.award.text"));
        int awardNbr = 0;
        for (PurchaseOrderVendorQuote poQuote : document.getPurchaseOrderVendorQuotes()) {
            awardedVendorInfo.append(++awardNbr).append(". ").append("Vendor Name: ");
            awardedVendorInfo.append(poQuote.getVendorName()).append("[br]");
            awardedVendorInfo.append("Awarded Date: ");
            if (poQuote.getPurchaseOrderQuoteAwardTimestamp() == null) {
                if (awardedQuote.getVendorNumber().equals(poQuote.getVendorNumber())) {
                    awardedVendorInfo.append(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate().toString());
                }
            } else {
                awardedVendorInfo.append(poQuote.getPurchaseOrderQuoteAwardTimestamp().toString());
            }
            awardedVendorInfo.append("[br]");
            awardedVendorInfo.append("Quote Status: ");
            if (poQuote.getPurchaseOrderQuoteStatusCode() != null) {
                poQuote.refreshReferenceObject("purchaseOrderQuoteStatus");
                awardedVendorInfo.append(poQuote.getPurchaseOrderQuoteStatus().getStatusDescription());
            } else {
                awardedVendorInfo.append("N/A");
            }
            awardedVendorInfo.append("[br]");
            awardedVendorInfo.append("Rank: ");
            if (poQuote.getPurchaseOrderQuoteRankNumber() != null) {
                awardedVendorInfo.append(poQuote.getPurchaseOrderQuoteRankNumber());
            } else {
                awardedVendorInfo.append("N/A");
            }
            awardedVendorInfo.append("[br][br]");
        }
        String question = request.getParameter("questionIndex");
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, "POConfirmAward", awardedVendorInfo.toString(), "confirmationQuestion", "completeQuote", "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if ("POConfirmAward".equals(question) && "0".equals(buttonClicked)) {
            awardedQuote.setPurchaseOrderQuoteAwardTimestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
            Date currentSqlDate = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
            document.setPurchaseOrderQuoteAwardedDate(currentSqlDate);
            document.setVendorName(awardedQuote.getVendorName());
            document.setVendorNumber(awardedQuote.getVendorNumber());
            Integer headID = awardedQuote.getVendorHeaderGeneratedIdentifier();
            Integer detailID = awardedQuote.getVendorDetailAssignedIdentifier();
            document.setVendorHeaderGeneratedIdentifier(headID);
            document.setVendorDetailAssignedIdentifier(detailID);
            String campusCode = document.getDeliveryCampusCode();
            VendorAddress pova = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDefaultAddress(headID, detailID, "PO", campusCode);
            if (pova != null) {
                document.setVendorLine1Address(pova.getVendorLine1Address());
                document.setVendorLine2Address(pova.getVendorLine2Address());
                document.setVendorCityName(pova.getVendorCityName());
                document.setVendorStateCode(pova.getVendorStateCode());
                document.setVendorPostalCode(pova.getVendorZipCode());
                document.setVendorCountryCode(pova.getVendorCountryCode());
                document.setVendorFaxNumber(pova.getVendorFaxNumber());
            }
            document.updateAndSaveAppDocStatus("In Process");
            document.setStatusChange("In Process");
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)document);
            if (pova == null) {
                document.setVendorLine1Address("");
                document.setVendorLine2Address("");
                document.setVendorCityName("");
                document.setVendorStateCode("");
                document.setVendorPostalCode("");
                document.setVendorCountryCode("");
                document.setVendorFaxNumber("");
                document.setStatusChange("In Process");
                GlobalVariables.getMessageMap().putError("document.vendorAddress", "error.inactive.vendoraddress", new String[0]);
                return mapping.findForward("basic");
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward cancelQuote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument document = (PurchaseOrderDocument)poForm.getDocument();
        for (PurchaseOrderVendorQuote quotedVendors : document.getPurchaseOrderVendorQuotes()) {
            if (quotedVendors.getPurchaseOrderQuoteTransmitTimestamp() == null) continue;
            GlobalVariables.getMessageMap().putError("purchaseOrderVendorQuotes", "error.transmit.purchaseOrder.already.transmitted", new String[0]);
            return mapping.findForward("basic");
        }
        String message = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("purchaseOrder.route.message.confirm.cancel.quote.text");
        String question = request.getParameter("questionIndex");
        if (question == null) {
            return this.performQuestionWithInput(mapping, form, request, response, "POCancelQuote", message, "confirmationQuestion", "cancelQuote", "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if ("POCancelQuote".equals(question) && "0".equals(buttonClicked)) {
            String reason = request.getParameter("reason");
            if (StringUtils.isEmpty((CharSequence)reason)) {
                return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, "POCancelQuote", message, "confirmationQuestion", "cancelQuote", "", "", "error.purchaseOrder.reasonRequired", "reason", "250");
            }
            document.getPurchaseOrderVendorQuotes().clear();
            Note cancelNote = new Note();
            cancelNote.setAuthorUniversalIdentifier(GlobalVariables.getUserSession().getPerson().getPrincipalId());
            String reasonPrefix = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("purchaseOrder.route.message.cancel.note.text");
            cancelNote.setNoteText(reasonPrefix + reason);
            cancelNote.setNoteTypeCode(document.getNoteType().getCode());
            cancelNote.setNotePostedTimestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
            document.addNote(cancelNote);
            document.updateAndSaveAppDocStatus("In Process");
            document.setStatusChange(null);
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)document);
        }
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        String operation = "CANCEL";
        ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        String questionText = kualiConfiguration.getPropertyValueAsString("purchaseOrder.question.text");
        questionText = StringUtils.replace((String)questionText, (String)"{0}", (String)operation);
        String reason = request.getParameter("reason");
        if (question == null) {
            return this.performQuestionWithInput(mapping, form, request, response, "DocCancel", kualiConfiguration.getPropertyValueAsString("document.question.cancel.text"), "confirmationQuestion", "cancel", "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if ("DocCancel".equals(question) && "1".equals(buttonClicked)) {
            return mapping.findForward("basic");
        }
        reason = reason == null ? "" : reason;
        int cancelNoteTextLength = reason.length();
        int noteTextMaxLength = this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText");
        if (StringUtils.isBlank((CharSequence)reason) || cancelNoteTextLength > noteTextMaxLength) {
            int reasonLimit = noteTextMaxLength - cancelNoteTextLength;
            return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, "DocCancel", questionText, "confirmationQuestion", "cancel", "", reason, "error.document.disapprove.reasonRequired", "reason", Integer.toString(reasonLimit));
        }
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        Document document = kualiDocumentFormBase.getDocument();
        Note cancelNote = new Note();
        cancelNote.setAuthorUniversalIdentifier(GlobalVariables.getUserSession().getPerson().getPrincipalId());
        String reasonPrefix = this.getKualiConfigurationService().getPropertyValueAsString("purchaseOrder.route.message.cancel.note.prefix.text");
        cancelNote.setNoteText(reasonPrefix + reason);
        cancelNote.setNoteTypeCode(document.getNoteType().getCode());
        cancelNote.setNotePostedTimestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
        document.addNote(cancelNote);
        ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation(document);
        ((DocumentService)SpringContext.getBean(DocumentService.class)).cancelDocument(kualiDocumentFormBase.getDocument(), kualiDocumentFormBase.getAnnotation());
        return this.returnToSender(request, mapping, kualiDocumentFormBase);
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WorkflowDocument workflowDocument;
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument po = poForm.getPurchaseOrderDocument();
        if (StringUtils.isNotBlank((CharSequence)po.getApplicationDocumentStatus()) && StringUtils.isNotBlank((CharSequence)po.getStatusChange()) && !StringUtils.equals((CharSequence)po.getApplicationDocumentStatus(), (CharSequence)po.getStatusChange()) && (ObjectUtils.isNull((Object)(workflowDocument = po.getDocumentHeader().getWorkflowDocument())) || workflowDocument.isInitiated() || workflowDocument.isSaved())) {
            return this.askSaveQuestions(mapping, form, request, response, "manualStatusChangeQuestion");
        }
        return super.save(mapping, form, request, response);
    }

    protected ActionForward askSaveQuestions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionType) {
        String noteText;
        ActionForward forward;
        KualiDocumentFormBase kualiDocumentFormBase;
        block15: {
            kualiDocumentFormBase = (KualiDocumentFormBase)form;
            PurchaseOrderDocument po = (PurchaseOrderDocument)kualiDocumentFormBase.getDocument();
            String question = request.getParameter("questionIndex");
            String reason = request.getParameter("reason");
            ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
            forward = mapping.findForward("basic");
            String notePrefix = "";
            if (StringUtils.equals((CharSequence)questionType, (CharSequence)"manualStatusChangeQuestion") && ObjectUtils.isNull((Object)question)) {
                String message = kualiConfiguration.getPropertyValueAsString("purchaseOrder.question.manual.status.change");
                try {
                    return this.performQuestionWithInput(mapping, form, request, response, questionType, message, "confirmationQuestion", questionType, "");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if (question.equals(questionType) && buttonClicked.equals("1")) {
                return forward;
            }
            if (StringUtils.equals((CharSequence)questionType, (CharSequence)"manualStatusChangeQuestion")) {
                HashMap<String, String> manuallyChangeableStatuses = new HashMap<String, String>();
                manuallyChangeableStatuses.put("In Process", "In Process");
                manuallyChangeableStatuses.put("Waiting for Vendor", "Waiting for Vendor");
                manuallyChangeableStatuses.put("Waiting for Department", "Waiting for Department");
                String key = kualiConfiguration.getPropertyValueAsString("purchaseOrder.manual.status.change.note.prefix");
                String oldStatus = (String)manuallyChangeableStatuses.get(po.getApplicationDocumentStatus());
                String newStatus = (String)manuallyChangeableStatuses.get(po.getStatusChange());
                key = StringUtils.replace((String)key, (String)"{0}", (String)(StringUtils.isBlank((CharSequence)oldStatus) ? " " : oldStatus));
                notePrefix = StringUtils.replace((String)key, (String)"{1}", (String)(StringUtils.isBlank((CharSequence)newStatus) ? " " : newStatus));
            }
            noteText = notePrefix + " " + reason;
            int noteTextLength = noteText.length();
            int noteTextMaxLength = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(Note.class, "noteText");
            if (StringUtils.isBlank((CharSequence)reason) || noteTextLength > noteTextMaxLength) {
                int reasonLimit = noteTextMaxLength - noteTextLength;
                if (ObjectUtils.isNull((Object)reason)) {
                    reason = "";
                }
                try {
                    if (StringUtils.equals((CharSequence)questionType, (CharSequence)"manualStatusChangeQuestion")) {
                        return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, questionType, kualiConfiguration.getPropertyValueAsString("purchaseOrder.question.manual.status.change"), "confirmationQuestion", questionType, "", reason, "error.purchaseOrder.reasonRequired", "reason", Integer.toString(reasonLimit));
                    }
                    break block15;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (StringUtils.equals((CharSequence)questionType, (CharSequence)"manualStatusChangeQuestion")) {
                this.executeManualStatusChange(po);
                try {
                    forward = super.save(mapping, form, request, response);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Note newNote = new Note();
        newNote.setNoteText(noteText);
        newNote.setNoteTypeCode(KFSConstants.NoteTypeEnum.BUSINESS_OBJECT_NOTE_TYPE.getCode());
        kualiDocumentFormBase.setNewNote(newNote);
        try {
            this.insertBONote(mapping, (ActionForm)kualiDocumentFormBase, request, response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return forward;
    }

    protected void executeManualStatusChange(PurchaseOrderDocument po) {
        try {
            po.updateAndSaveAppDocStatus(po.getStatusChange());
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)po);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) {
        super.loadDocument(kualiDocumentFormBase);
        PurchaseOrderForm poForm = (PurchaseOrderForm)kualiDocumentFormBase;
        PurchaseOrderDocument po = (PurchaseOrderDocument)poForm.getDocument();
        po.setInternalPurchasingLimit(((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getInternalPurchasingDollarLimit(po));
    }

    public ActionForward addAsset(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument document = (PurchaseOrderDocument)poForm.getDocument();
        return mapping.findForward("basic");
    }

    public ActionForward removeAlternateVendor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument document = (PurchaseOrderDocument)poForm.getDocument();
        document.setAlternateVendorDetailAssignedIdentifier(null);
        document.setAlternateVendorHeaderGeneratedIdentifier(null);
        document.setAlternateVendorName(null);
        document.setAlternateVendorNumber(null);
        return mapping.findForward("basic");
    }

    public ActionForward createReceivingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchaseOrderForm poForm = (PurchaseOrderForm)form;
        PurchaseOrderDocument document = (PurchaseOrderDocument)poForm.getDocument();
        String basePath = PurchaseOrderAction.getApplicationBaseUrl();
        String methodToCallDocHandler = "docHandler";
        String methodToCallReceivingLine = "initiate";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", methodToCallDocHandler);
        parameters.put("command", methodToCallReceivingLine);
        parameters.put("docTypeName", "RCVL");
        parameters.put("purchaseOrderId", document.getPurapDocumentIdentifier().toString());
        String receivingUrl = UrlFactory.parameterizeUrl((String)(basePath + "/purapLineItemReceiving.do"), parameters);
        return new ActionForward(receivingUrl, true);
    }

    public ActionForward resendPoCxml(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchaseOrderDocument po = (PurchaseOrderDocument)((PurchaseOrderForm)form).getDocument();
        ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).retransmitB2BPurchaseOrder(po);
        return mapping.findForward("basic");
    }
}

