/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableItemBase;
import org.kuali.kfs.module.purap.businessobject.CreditMemoAccount;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccount;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.kfs.module.purap.util.ExpiredOrClosedAccountEntry;
import org.kuali.kfs.sys.context.SpringContext;

public class CreditMemoItem
extends AccountsPayableItemBase {
    private KualiDecimal poInvoicedTotalQuantity;
    private BigDecimal poUnitPrice;
    private KualiDecimal poTotalAmount;
    private KualiDecimal preqInvoicedTotalQuantity;
    private BigDecimal preqUnitPrice;
    private KualiDecimal preqTotalAmount;

    public CreditMemoItem() {
    }

    public CreditMemoItem(VendorCreditMemoDocument cmDocument, PurchaseOrderItem poItem) {
        this(cmDocument, poItem, new HashMap<String, ExpiredOrClosedAccountEntry>());
    }

    public CreditMemoItem(VendorCreditMemoDocument cmDocument, PurchaseOrderItem poItem, HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList) {
        this.setPurapDocumentIdentifier(cmDocument.getPurapDocumentIdentifier());
        this.setPurapDocument(cmDocument);
        this.setItemLineNumber(poItem.getItemLineNumber());
        this.setPoInvoicedTotalQuantity(poItem.getItemInvoicedTotalQuantity());
        this.setPoUnitPrice(poItem.getItemUnitPrice());
        this.setPoTotalAmount(poItem.getItemInvoicedTotalAmount());
        this.setItemTypeCode(poItem.getItemTypeCode());
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax(cmDocument);
        if (ObjectUtils.isNotNull((Object)((Object)this.getItemType())) && this.getItemType().isAmountBasedGeneralLedgerIndicator()) {
            this.setItemUnitPrice(null);
        } else {
            this.setItemUnitPrice(poItem.getItemUnitPrice());
        }
        this.setItemCatalogNumber(poItem.getItemCatalogNumber());
        this.setItemDescription(poItem.getItemDescription());
        if (this.getPoInvoicedTotalQuantity() == null) {
            this.setPoInvoicedTotalQuantity(KualiDecimal.ZERO);
        }
        if (this.getPoUnitPrice() == null) {
            this.setPoUnitPrice(BigDecimal.ZERO);
        }
        if (this.getPoTotalAmount() == null) {
            this.setPoTotalAmount(KualiDecimal.ZERO);
        }
        for (PurApAccountingLine purApAccountingLine : poItem.getSourceAccountingLines()) {
            PurchaseOrderAccount account = (PurchaseOrderAccount)purApAccountingLine;
            ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).processExpiredOrClosedAccount(account, expiredOrClosedAccountList);
            this.getSourceAccountingLines().add(new CreditMemoAccount(account));
        }
    }

    public CreditMemoItem(VendorCreditMemoDocument cmDocument, PaymentRequestItem preqItem, PurchaseOrderItem poItem, HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList) {
        this.setPurapDocumentIdentifier(cmDocument.getPurapDocumentIdentifier());
        this.setItemLineNumber(preqItem.getItemLineNumber());
        this.setPurapDocument(cmDocument);
        if (poItem.getItemInvoicedTotalQuantity() != null && preqItem.getItemQuantity() != null && poItem.getItemInvoicedTotalQuantity().isLessThan((AbstractKualiDecimal)preqItem.getItemQuantity())) {
            this.setPreqInvoicedTotalQuantity(poItem.getItemInvoicedTotalQuantity());
            this.setPreqTotalAmount(poItem.getItemInvoicedTotalAmount());
        } else {
            this.setPreqInvoicedTotalQuantity(preqItem.getItemQuantity());
            this.setPreqTotalAmount(preqItem.getTotalAmount());
        }
        this.setPreqUnitPrice(preqItem.getItemUnitPrice());
        this.setItemTypeCode(preqItem.getItemTypeCode());
        if (ObjectUtils.isNotNull((Object)((Object)this.getItemType())) && this.getItemType().isAmountBasedGeneralLedgerIndicator()) {
            this.setItemUnitPrice(null);
        } else {
            this.setItemUnitPrice(preqItem.getItemUnitPrice());
        }
        this.setItemCatalogNumber(preqItem.getItemCatalogNumber());
        this.setItemDescription(preqItem.getItemDescription());
        this.setCapitalAssetTransactionTypeCode(preqItem.getCapitalAssetTransactionTypeCode());
        if (this.getPreqInvoicedTotalQuantity() == null) {
            this.setPreqInvoicedTotalQuantity(KualiDecimal.ZERO);
        }
        if (this.getPreqUnitPrice() == null) {
            this.setPreqUnitPrice(BigDecimal.ZERO);
        }
        if (this.getPreqTotalAmount() == null) {
            this.setPreqTotalAmount(KualiDecimal.ZERO);
        }
        for (PurApAccountingLine purApAccountingLine : preqItem.getSourceAccountingLines()) {
            PaymentRequestAccount account = (PaymentRequestAccount)purApAccountingLine;
            ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).processExpiredOrClosedAccount(account, expiredOrClosedAccountList);
            this.getSourceAccountingLines().add(new CreditMemoAccount(account));
        }
    }

    @Override
    public Class<CreditMemoAccount> getAccountingLineClass() {
        return CreditMemoAccount.class;
    }

    public KualiDecimal getPoTotalAmount() {
        return this.poTotalAmount;
    }

    public void setPoTotalAmount(KualiDecimal poTotalAmount) {
        this.poTotalAmount = poTotalAmount;
    }

    public KualiDecimal getPoInvoicedTotalQuantity() {
        return this.poInvoicedTotalQuantity;
    }

    public void setPoInvoicedTotalQuantity(KualiDecimal poInvoicedTotalQuantity) {
        this.poInvoicedTotalQuantity = poInvoicedTotalQuantity;
    }

    public BigDecimal getPoUnitPrice() {
        return this.poUnitPrice;
    }

    public void setPoUnitPrice(BigDecimal poUnitPrice) {
        this.poUnitPrice = poUnitPrice;
    }

    public KualiDecimal getPreqTotalAmount() {
        return this.preqTotalAmount;
    }

    public void setPreqTotalAmount(KualiDecimal preqTotalAmount) {
        this.preqTotalAmount = preqTotalAmount;
    }

    public KualiDecimal getPreqInvoicedTotalQuantity() {
        return this.preqInvoicedTotalQuantity;
    }

    public void setPreqInvoicedTotalQuantity(KualiDecimal preqInvoicedTotalQuantity) {
        this.preqInvoicedTotalQuantity = preqInvoicedTotalQuantity;
    }

    public BigDecimal getPreqUnitPrice() {
        return this.preqUnitPrice;
    }

    public void setPreqUnitPrice(BigDecimal preqUnitPrice) {
        this.preqUnitPrice = preqUnitPrice;
    }

    @Override
    public Class getUseTaxClass() {
        return CreditMemoItemUseTax.class;
    }

    @Override
    public PurchaseOrderItem getPurchaseOrderItem() {
        PurchaseOrderItem poi = null;
        if (ObjectUtils.isNotNull((Object)this.getPurapDocumentIdentifier()) && ObjectUtils.isNull((Object)this.getVendorCreditMemo())) {
            this.refreshReferenceObject("purapDocument");
        }
        if (ObjectUtils.isNotNull((Object)this.getVendorCreditMemo())) {
            PurchaseOrderDocument purchaseOrderDocument = null;
            Integer purchaseOrderDocumentId = this.getVendorCreditMemo().getPurchaseOrderIdentifier();
            if (this.getVendorCreditMemo().isSourceDocumentPaymentRequest() && ObjectUtils.isNull((Object)purchaseOrderDocumentId)) {
                PaymentRequestDocument paymentRequestDocument = ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).getPaymentRequestById(this.getVendorCreditMemo().getPaymentRequestIdentifier());
                purchaseOrderDocumentId = paymentRequestDocument.getPurchaseOrderIdentifier();
            }
            if (ObjectUtils.isNotNull((Object)purchaseOrderDocumentId)) {
                purchaseOrderDocument = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(purchaseOrderDocumentId);
            }
            if (ObjectUtils.isNotNull(purchaseOrderDocument)) {
                if (this.getItemType().isLineItemIndicator()) {
                    List items = purchaseOrderDocument.getItems();
                    poi = (PurchaseOrderItem)items.get(this.getItemLineNumber() - 1);
                } else {
                    poi = (PurchaseOrderItem)((PurapService)SpringContext.getBean(PurapService.class)).getBelowTheLineByType(purchaseOrderDocument, this.getItemType());
                }
            }
        } else {
            throw new PurError("Credit Memo Object in Purchase Order item line number " + this.getItemLineNumber() + "or itemType " + this.getItemTypeCode() + " is null");
        }
        return poi;
    }

    public VendorCreditMemoDocument getVendorCreditMemo() {
        return (VendorCreditMemoDocument)super.getPurapDocument();
    }
}

