/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.jaxb.Comments;
import org.kuali.kfs.module.purap.businessobject.jaxb.Contact;
import org.kuali.kfs.module.purap.businessobject.jaxb.Distribution;
import org.kuali.kfs.module.purap.businessobject.jaxb.Extrinsic;
import org.kuali.kfs.module.purap.businessobject.jaxb.GrossAmount;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailDiscount;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailItemReference;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailLineShipping;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailLineSpecialHandling;
import org.kuali.kfs.module.purap.businessobject.jaxb.NetAmount;
import org.kuali.kfs.module.purap.businessobject.jaxb.SubtotalAmount;
import org.kuali.kfs.module.purap.businessobject.jaxb.Tax;
import org.kuali.kfs.module.purap.businessobject.jaxb.UnitPrice;
import org.kuali.kfs.module.purap.util.cxml.CxmlExtrinsic;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"unitOfMeasure", "unitPrice", "invoiceDetailItemReference", "subtotalAmount", "tax", "invoiceDetailLineSpecialHandling", "invoiceDetailLineShipping", "grossAmount", "invoiceDetailDiscount", "netAmount", "distribution", "comments", "extrinsic"})
@XmlRootElement(name="InvoiceDetailItem", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
public class InvoiceDetailItem {
    @XmlElement(name="UnitOfMeasure", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", required=true)
    protected String unitOfMeasure;
    @XmlElement(name="UnitPrice", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", required=true)
    protected UnitPrice unitPrice;
    @XmlElement(name="InvoiceDetailItemReference", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", required=true)
    protected InvoiceDetailItemReference invoiceDetailItemReference;
    @XmlElement(name="SubtotalAmount", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected SubtotalAmount subtotalAmount;
    @XmlElement(name="Tax", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected Tax tax;
    @XmlElement(name="InvoiceDetailLineSpecialHandling", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected InvoiceDetailLineSpecialHandling invoiceDetailLineSpecialHandling;
    @XmlElement(name="InvoiceDetailLineShipping", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected InvoiceDetailLineShipping invoiceDetailLineShipping;
    @XmlElement(name="GrossAmount", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected GrossAmount grossAmount;
    @XmlElement(name="InvoiceDetailDiscount", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected InvoiceDetailDiscount invoiceDetailDiscount;
    @XmlElement(name="NetAmount", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected NetAmount netAmount;
    @XmlElement(name="Distribution", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected List<Distribution> distribution;
    @XmlElement(name="Comments", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected Comments comments;
    @XmlElement(name="Extrinsic", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected List<Extrinsic> extrinsic;
    @XmlAttribute(name="invoiceLineNumber", required=true)
    @XmlSchemaType(name="unsignedByte")
    protected short invoiceLineNumber;
    @XmlAttribute(name="quantity", required=true)
    protected BigDecimal quantity;

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public UnitPrice getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(UnitPrice unitPrice) {
        this.unitPrice = unitPrice;
    }

    public InvoiceDetailItemReference getInvoiceDetailItemReference() {
        return this.invoiceDetailItemReference;
    }

    public void setInvoiceDetailItemReference(InvoiceDetailItemReference invoiceDetailItemReference) {
        this.invoiceDetailItemReference = invoiceDetailItemReference;
    }

    public SubtotalAmount getSubtotalAmount() {
        return this.subtotalAmount;
    }

    public void setSubtotalAmount(SubtotalAmount subtotalAmount) {
        this.subtotalAmount = subtotalAmount;
    }

    public Tax getTax() {
        return this.tax;
    }

    public void setTax(Tax tax) {
        this.tax = tax;
    }

    public InvoiceDetailLineSpecialHandling getInvoiceDetailLineSpecialHandling() {
        return this.invoiceDetailLineSpecialHandling;
    }

    public void setInvoiceDetailLineSpecialHandling(InvoiceDetailLineSpecialHandling invoiceDetailLineSpecialHandling) {
        this.invoiceDetailLineSpecialHandling = invoiceDetailLineSpecialHandling;
    }

    public InvoiceDetailLineShipping getInvoiceDetailLineShipping() {
        return this.invoiceDetailLineShipping;
    }

    public void setInvoiceDetailLineShipping(InvoiceDetailLineShipping invoiceDetailLineShipping) {
        this.invoiceDetailLineShipping = invoiceDetailLineShipping;
    }

    public GrossAmount getGrossAmount() {
        return this.grossAmount;
    }

    public void setGrossAmount(GrossAmount grossAmount) {
        this.grossAmount = grossAmount;
    }

    public InvoiceDetailDiscount getInvoiceDetailDiscount() {
        return this.invoiceDetailDiscount;
    }

    public void setInvoiceDetailDiscount(InvoiceDetailDiscount invoiceDetailDiscount) {
        this.invoiceDetailDiscount = invoiceDetailDiscount;
    }

    public NetAmount getNetAmount() {
        return this.netAmount;
    }

    public void setNetAmount(NetAmount netAmount) {
        this.netAmount = netAmount;
    }

    public List<Distribution> getDistribution() {
        if (this.distribution == null) {
            this.distribution = new ArrayList<Distribution>();
        }
        return this.distribution;
    }

    public Comments getComments() {
        return this.comments;
    }

    public void setComments(Comments comments) {
        this.comments = comments;
    }

    public List<Extrinsic> getExtrinsic() {
        if (this.extrinsic == null) {
            this.extrinsic = new ArrayList<Extrinsic>();
        }
        return this.extrinsic;
    }

    public short getInvoiceLineNumber() {
        return this.invoiceLineNumber;
    }

    public void setInvoiceLineNumber(short invoiceLineNumber) {
        this.invoiceLineNumber = invoiceLineNumber;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    ElectronicInvoiceItem toElectronicInvoiceItem() {
        ElectronicInvoiceItem item = new ElectronicInvoiceItem();
        item.setInvoiceLineNumber(String.valueOf(this.invoiceLineNumber));
        item.setQuantity(this.quantity.toPlainString());
        item.setUnitOfMeasure(this.unitOfMeasure);
        item.setUnitPrice(this.unitPrice.getMoney().getValue());
        item.setUnitPriceCurrency(this.unitPrice.getMoney().getCurrency());
        if (this.invoiceDetailDiscount != null) {
            item.setInvoiceLineDiscountAmount(this.invoiceDetailDiscount.getMoney().getValue());
            item.setInvoiceLineDiscountAmountCurrency(this.invoiceDetailDiscount.getMoney().getCurrency());
            item.setInvoiceLineDiscountPercentageRate(this.invoiceDetailDiscount.getPercentageRate().toPlainString());
        }
        if (this.invoiceDetailLineShipping != null) {
            item.setInvoiceLineShippingAmount(this.invoiceDetailLineShipping.getMoney().getValue());
            item.setInvoiceLineShippingAmountCurrency(this.invoiceDetailLineShipping.getMoney().getCurrency());
            if (this.invoiceDetailLineShipping.getInvoiceDetailShipping() != null) {
                item.setShippingDateString(this.invoiceDetailLineShipping.getInvoiceDetailShipping().getShippingDate());
                if (CollectionUtils.isNotEmpty(this.invoiceDetailLineShipping.getInvoiceDetailShipping().getContact())) {
                    item.setInvoiceShippingContacts(this.invoiceDetailLineShipping.getInvoiceDetailShipping().getContact().stream().map(Contact::toElectronicInvoiceContact).collect(Collectors.toList()));
                }
            }
        }
        if (this.grossAmount != null) {
            item.setInvoiceLineGrossAmount(this.grossAmount.getMoney().getValue());
            item.setInvoiceLineGrossAmountCurrency(this.grossAmount.getMoney().getCurrency());
        }
        if (this.netAmount != null) {
            item.setInvoiceLineNetAmount(this.netAmount.getMoney().getValue());
            item.setInvoiceLineNetAmountCurrency(this.netAmount.getMoney().getCurrency());
        }
        if (this.invoiceDetailLineSpecialHandling != null) {
            item.setInvoiceLineSpecialHandlingAmount(this.invoiceDetailLineSpecialHandling.getMoney().getValue());
            item.setInvoiceLineSpecialHandlingAmountCurrency(this.invoiceDetailLineSpecialHandling.getMoney().getCurrency());
        }
        if (this.subtotalAmount != null) {
            item.setSubTotalAmount(this.subtotalAmount.getMoney().getValue());
            item.setSubTotalAmountCurrency(this.subtotalAmount.getMoney().getCurrency());
        }
        if (this.tax != null) {
            item.setTaxAmount(this.tax.getMoney().getValue());
            item.setTaxAmountCurrency(this.tax.getMoney().getCurrency());
            item.setTaxDescription(this.tax.getDescription().getValue());
        }
        if (this.invoiceDetailItemReference != null) {
            if (this.invoiceDetailItemReference.getCountry() != null) {
                item.setReferenceCountryName(this.invoiceDetailItemReference.getCountry().getValue());
                item.setReferenceCountryCode(this.invoiceDetailItemReference.getCountry().getIsoCountryCode());
            }
            item.setReferenceDescription(this.invoiceDetailItemReference.getDescription().getValue());
            item.setReferenceItemIDSupplierPartAuxID(this.invoiceDetailItemReference.getItemID().getSupplierPartAuxiliaryID());
            item.setReferenceItemIDSupplierPartID(this.invoiceDetailItemReference.getItemID().getSupplierPartID());
            item.setReferenceLineNumber(String.valueOf(this.invoiceDetailItemReference.getLineNumber()));
            if (this.invoiceDetailItemReference.getManufacturerName() != null) {
                item.setReferenceManufacturerName(this.invoiceDetailItemReference.getManufacturerName().getValue());
            }
            item.setReferenceManufacturerPartID(this.invoiceDetailItemReference.getManufacturerPartID());
            item.setReferenceSerialNumber(this.invoiceDetailItemReference.getSerialNumber());
            item.setReferenceSerialNumbers(this.invoiceDetailItemReference.getSerialNumbers());
        }
        if (this.comments != null) {
            item.addComments(this.comments.getValue());
        }
        if (CollectionUtils.isNotEmpty(this.extrinsic)) {
            item.setExtrinsic(this.extrinsic.stream().map(ex -> new CxmlExtrinsic(ex.getName(), ex.getValue())).collect(Collectors.toList()));
        }
        return item;
    }
}

