/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.integration.purap.ItemCapitalAsset;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.BillingAddress;
import org.kuali.kfs.module.purap.businessobject.CapitalAssetSystemState;
import org.kuali.kfs.module.purap.businessobject.CapitalAssetSystemType;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetSystemBase;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.module.purap.businessobject.RequisitionCapitalAssetLocation;
import org.kuali.kfs.module.purap.document.PurchaseOrderAmendmentDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocumentBase;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.PurchasingService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedAddPurchasingAccountsPayableItemEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedAddPurchasingCapitalAssetLocationEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedAddPurchasingItemCapitalAssetEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedCommodityCodesForDistributionEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedImportPurchasingAccountsPayableItemEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedUpdateCamsViewPurapEvent;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingAccountsPayableActionBase;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingAccountsPayableFormBase;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingFormBase;
import org.kuali.kfs.module.purap.document.web.struts.RequisitionForm;
import org.kuali.kfs.module.purap.exception.ItemParserException;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.util.ItemParser;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.Building;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.businessobject.VendorContract;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.kfs.vnd.service.PhoneNumberService;

public class PurchasingActionBase
extends PurchasingAccountsPayableActionBase {
    private static final Logger LOG = LogManager.getLogger();

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase baseForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument document = (PurchasingDocument)baseForm.getDocument();
        String refreshCaller = baseForm.getRefreshCaller();
        BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        PhoneNumberService phoneNumberService = (PhoneNumberService)SpringContext.getBean(PhoneNumberService.class);
        document.setInstitutionContactPhoneNumber(phoneNumberService.formatNumberIfPossible(document.getInstitutionContactPhoneNumber()));
        document.setRequestorPersonPhoneNumber(phoneNumberService.formatNumberIfPossible(document.getRequestorPersonPhoneNumber()));
        document.setDeliveryToPhoneNumber(phoneNumberService.formatNumberIfPossible(document.getDeliveryToPhoneNumber()));
        if (StringUtils.equals((CharSequence)refreshCaller, (CharSequence)"kimPersonLookupable")) {
            Integer deliveryToNameMaxLength = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(document.getClass(), "deliveryToName");
            if (StringUtils.isNotEmpty((CharSequence)document.getDeliveryToName()) && ObjectUtils.isNotNull((Object)deliveryToNameMaxLength) && document.getDeliveryToName().length() > deliveryToNameMaxLength) {
                document.setDeliveryToName(document.getDeliveryToName().substring(0, deliveryToNameMaxLength));
                GlobalVariables.getMessageMap().clearErrorPath();
                GlobalVariables.getMessageMap().addToErrorPath("document.delivery*");
                GlobalVariables.getMessageMap().putWarning("deliveryToName", "warning.delivery.to.name.truncated", new String[0]);
                GlobalVariables.getMessageMap().removeFromErrorPath("document.delivery*");
            }
            Integer requestorNameMaxLength = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(document.getClass(), "requestorPersonName");
            if (StringUtils.isNotEmpty((CharSequence)document.getRequestorPersonName()) && ObjectUtils.isNotNull((Object)requestorNameMaxLength) && document.getRequestorPersonName().length() > requestorNameMaxLength) {
                document.setRequestorPersonName(document.getRequestorPersonName().substring(0, requestorNameMaxLength));
                GlobalVariables.getMessageMap().clearErrorPath();
                GlobalVariables.getMessageMap().addToErrorPath("document.requestor*,document.institution*,document.purchaseOrderTransmissionMethodCode,document.purchaseOrderCostSourceCode,document.purchaseOrderTotalLimit");
                GlobalVariables.getMessageMap().putWarning("requestorPersonName", "warning.requestor.name.truncated", new String[0]);
                GlobalVariables.getMessageMap().removeFromErrorPath("document.requestor*,document.institution*,document.purchaseOrderTransmissionMethodCode,document.purchaseOrderCostSourceCode,document.purchaseOrderTotalLimit");
            }
        }
        if (StringUtils.equals((CharSequence)refreshCaller, (CharSequence)"vendorLookupable") && document.getVendorDetailAssignedIdentifier() != null && document.getVendorHeaderGeneratedIdentifier() != null) {
            document.setVendorContractGeneratedIdentifier(null);
            document.refreshReferenceObject("vendorContract");
            document.refreshReferenceObject("vendorDetail");
            document.templateVendorDetail(document.getVendorDetail());
            VendorAddress defaultAddress = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDefaultAddress((Collection)document.getVendorDetail().getVendorAddresses(), document.getVendorDetail().getVendorHeader().getVendorType().getAddressType().getVendorAddressTypeCode(), document.getDeliveryCampusCode());
            if (defaultAddress == null) {
                GlobalVariables.getMessageMap().putError("document.vendorAddress", "error.inactive.vendoraddress", new String[0]);
            }
            document.templateVendorAddress(defaultAddress);
        }
        if (StringUtils.equals((CharSequence)refreshCaller, (CharSequence)"vendorContractLookupable") && StringUtils.isNotEmpty((CharSequence)request.getParameter("document.vendorContractGeneratedIdentifier"))) {
            VendorContract refreshVendorContract = new VendorContract();
            refreshVendorContract.setVendorContractGeneratedIdentifier(document.getVendorContractGeneratedIdentifier());
            refreshVendorContract = (VendorContract)businessObjectService.retrieve((PersistableBusinessObject)refreshVendorContract);
            document.setVendorHeaderGeneratedIdentifier(refreshVendorContract.getVendorHeaderGeneratedIdentifier());
            document.setVendorDetailAssignedIdentifier(refreshVendorContract.getVendorDetailAssignedIdentifier());
            document.refreshReferenceObject("vendorDetail");
            document.templateVendorDetail(document.getVendorDetail());
            document.templateVendorContract(refreshVendorContract);
            VendorAddress defaultAddress = ((VendorService)SpringContext.getBean(VendorService.class)).getVendorDefaultAddress((Collection)document.getVendorDetail().getVendorAddresses(), document.getVendorDetail().getVendorHeader().getVendorType().getAddressType().getVendorAddressTypeCode(), "");
            if (defaultAddress == null) {
                GlobalVariables.getMessageMap().putError("document.vendorAddress", "error.inactive.vendoraddress", new String[0]);
            }
            document.templateVendorAddress(defaultAddress);
            if (document instanceof PurchaseOrderDocument) {
                PurchaseOrderDocument poDoc = (PurchaseOrderDocument)document;
                KualiDecimal limit = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getInternalPurchasingDollarLimit(poDoc);
                poDoc.setInternalPurchasingLimit(limit);
            }
        }
        if (StringUtils.equals((CharSequence)refreshCaller, (CharSequence)"vendorAddressLookupable") && StringUtils.isNotEmpty((CharSequence)request.getParameter("document.vendorAddressGeneratedIdentifier"))) {
            VendorAddress refreshVendorAddress = new VendorAddress();
            refreshVendorAddress.setVendorAddressGeneratedIdentifier(document.getVendorAddressGeneratedIdentifier());
            refreshVendorAddress = (VendorAddress)businessObjectService.retrieve((PersistableBusinessObject)refreshVendorAddress);
            document.templateVendorAddress(refreshVendorAddress);
        }
        if (StringUtils.equals((CharSequence)refreshCaller, (CharSequence)"kualiLookupable")) {
            if (request.getParameter("document.deliveryCampusCode") != null) {
                BillingAddress billingAddress = new BillingAddress();
                billingAddress.setBillingCampusCode(document.getDeliveryCampusCode());
                Map keys = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)billingAddress);
                billingAddress = (BillingAddress)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BillingAddress.class, keys);
                document.templateBillingAddress(billingAddress);
                if (request.getParameter("document.deliveryBuildingName") == null) {
                    this.clearDeliveryBuildingInfo(document, true);
                } else {
                    document.setDeliveryBuildingOtherIndicator(false);
                    document.setDeliveryBuildingRoomNumber("");
                    document.setDeliveryBuildingLine2Address("");
                }
            } else if (request.getParameter("document.chartOfAccountsCode") != null) {
                document.loadReceivingAddress();
            } else {
                String buildingCodeParam = this.findBuildingCodeFromCapitalAssetBuildingLookup(request);
                if (StringUtils.isNotEmpty((CharSequence)buildingCodeParam)) {
                    PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
                    this.updateCapitalAssetLocation(request, purchasingForm, document, buildingCodeParam);
                }
            }
        }
        return super.refresh(mapping, form, request, response);
    }

    protected void updateAssetBuildingLocations(PurchasingFormBase purchasingForm, HttpServletRequest request, PurchasingDocument document) {
        List<String> buildingCodeParams = this.findAllBuildingCodesFromCapitalAssetBuildingLookup(request);
        for (String buildingCodeParam : buildingCodeParams) {
            this.updateCapitalAssetLocation(request, purchasingForm, document, buildingCodeParam);
        }
    }

    protected void updateCapitalAssetLocation(HttpServletRequest request, PurchasingFormBase purchasingForm, PurchasingDocument document, String buildingCodeParam) {
        String buildingCode = request.getParameterValues(buildingCodeParam)[0];
        String campusCodeParam = buildingCodeParam.replace("buildingCode", "campusCode");
        String campusCode = request.getParameterValues(campusCodeParam)[0];
        Building locationBuilding = this.findBuilding(buildingCode, campusCode);
        CapitalAssetLocation location = null;
        boolean isNewLine = StringUtils.containsIgnoreCase((CharSequence)buildingCodeParam, (CharSequence)"newPurchasingCapitalAssetLocationLine");
        if (isNewLine) {
            if (document.getCapitalAssetSystemType().getCapitalAssetSystemTypeCode().equals("IND")) {
                String locationCapitalAssetItemNumber = this.getCaptialAssetItemNumberFromParameter(buildingCodeParam);
                PurchasingCapitalAssetItem capitalAssetItem = document.getPurchasingCapitalAssetItems().get(Integer.parseInt(locationCapitalAssetItemNumber));
                location = capitalAssetItem.getPurchasingCapitalAssetSystem().getNewPurchasingCapitalAssetLocationLine();
            } else {
                location = purchasingForm.getNewPurchasingCapitalAssetLocationLine();
            }
        } else if (StringUtils.containsIgnoreCase((CharSequence)buildingCodeParam, (CharSequence)"purchasingCapitalAssetLocationLine")) {
            String locationCapitalAssetLocationNumber = this.getCaptialAssetLocationNumberFromParameter(buildingCodeParam);
            if (document.getCapitalAssetSystemType().getCapitalAssetSystemTypeCode().equals("IND")) {
                String locationCapitalAssetItemNumber = this.getCaptialAssetItemNumberFromParameter(buildingCodeParam);
                PurchasingCapitalAssetItem capitalAssetItem = document.getPurchasingCapitalAssetItems().get(Integer.parseInt(locationCapitalAssetItemNumber));
                location = (CapitalAssetLocation)capitalAssetItem.getPurchasingCapitalAssetSystem().getCapitalAssetLocations().get(Integer.parseInt(locationCapitalAssetLocationNumber));
            }
        } else if (StringUtils.containsIgnoreCase((CharSequence)buildingCodeParam, (CharSequence)"purchasingCapitalAssetSystem")) {
            String locationCapitalAssetLocationNumber = this.getCaptialAssetLocationNumberFromParameter(buildingCodeParam);
            if (document.getCapitalAssetSystemType().getCapitalAssetSystemTypeCode().equals("IND")) {
                String locationCapitalAssetItemNumber = this.getCaptialAssetItemNumberFromParameter(buildingCodeParam);
                PurchasingCapitalAssetItem capitalAssetItem = document.getPurchasingCapitalAssetItems().get(Integer.parseInt(locationCapitalAssetItemNumber));
                location = (CapitalAssetLocation)capitalAssetItem.getPurchasingCapitalAssetSystem().getCapitalAssetLocations().get(Integer.parseInt(locationCapitalAssetLocationNumber));
            } else {
                CapitalAssetSystem capitalAssetSystem = document.getPurchasingCapitalAssetSystems().get(0);
                location = (CapitalAssetLocation)capitalAssetSystem.getCapitalAssetLocations().get(Integer.parseInt(locationCapitalAssetLocationNumber));
            }
        }
        if (location != null) {
            location.templateBuilding(locationBuilding);
        }
        if (!(locationBuilding != null || isNewLine && buildingCode.isEmpty())) {
            GlobalVariables.getMessageMap().putError(buildingCodeParam, "error.capitalAsset.location.building.code.invalid", new String[0]);
        }
    }

    protected String getCaptialAssetLocationNumberFromParameter(String parameterKey) {
        int beginIndex = parameterKey.lastIndexOf("[") + 1;
        int endIndex = parameterKey.lastIndexOf("]");
        return parameterKey.substring(beginIndex, endIndex);
    }

    protected String getCaptialAssetItemNumberFromParameter(String parameterKey) {
        int beginIndex = parameterKey.indexOf("[") + 1;
        int endIndex = parameterKey.indexOf("]");
        return parameterKey.substring(beginIndex, endIndex);
    }

    protected void updateDeliveryBuilding(HttpServletRequest request, PurchasingDocument document) {
        String campusCode;
        String buildingCode = request.getParameter("document.deliveryBuildingCode");
        Building deliveryBuilding = this.findBuilding(buildingCode, campusCode = request.getParameter("document.deliveryCampusCode"));
        if (deliveryBuilding != null) {
            document.setDeliveryBuildingName(deliveryBuilding.getBuildingName());
            document.setDeliveryBuildingLine1Address(deliveryBuilding.getBuildingStreetAddress());
            document.setDeliveryBuildingLine2Address("");
            document.setDeliveryBuildingRoomNumber("");
            document.setDeliveryCityName(deliveryBuilding.getBuildingAddressCityName());
            document.setDeliveryStateCode(deliveryBuilding.getBuildingAddressStateCode());
            document.setDeliveryPostalCode(deliveryBuilding.getBuildingAddressZipCode());
            document.setDeliveryCountryCode(deliveryBuilding.getBuildingAddressCountryCode());
        } else {
            this.clearDeliveryBuildingInfo(document, false);
            GlobalVariables.getMessageMap().putError("document.deliveryBuildingCode", "error.delivery.building.code.invalid", new String[0]);
        }
    }

    private void clearDeliveryBuildingInfo(PurchasingDocument document, boolean clearBuildingCode) {
        if (clearBuildingCode) {
            document.setDeliveryBuildingCode("");
        }
        document.setDeliveryBuildingName("");
        document.setDeliveryBuildingLine1Address("");
        document.setDeliveryBuildingLine2Address("");
        document.setDeliveryBuildingRoomNumber("");
        document.setDeliveryCityName("");
        document.setDeliveryStateCode("");
        document.setDeliveryPostalCode("");
        document.setDeliveryCountryCode("");
    }

    private Building findBuilding(String buildingCode, String campusCode) {
        Building building = new Building();
        building.setCampusCode(campusCode);
        building.setBuildingCode(buildingCode.toUpperCase(Locale.US));
        Map keys = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)building);
        building = (Building)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(Building.class, keys);
        return building;
    }

    public ActionForward useOtherDeliveryBuilding(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase baseForm = (PurchasingFormBase)form;
        PurchasingDocument document = (PurchasingDocument)baseForm.getDocument();
        document.setDeliveryBuildingOtherIndicator(true);
        this.clearDeliveryBuildingInfo(document, true);
        return mapping.findForward("basic");
    }

    public ActionForward useOffCampusAssetLocationBuildingByDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase baseForm = (PurchasingFormBase)form;
        PurchasingDocument document = (PurchasingDocument)baseForm.getDocument();
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        String systemIndex = StringUtils.substringBetween((String)fullParameter, (String)"(((", (String)")))");
        String assetLocationIndex = StringUtils.substringBetween((String)fullParameter, (String)"((#", (String)"#))");
        CapitalAssetSystem system = document.getPurchasingCapitalAssetSystems().get(Integer.parseInt(systemIndex));
        if ("new".equals(assetLocationIndex)) {
            this.useOffCampusAssetLocationBuilding(baseForm.getNewPurchasingCapitalAssetLocationLine());
        } else {
            this.useOffCampusAssetLocationBuilding((CapitalAssetLocation)system.getCapitalAssetLocations().get(Integer.parseInt(assetLocationIndex)));
        }
        return mapping.findForward("basic");
    }

    public ActionForward useOffCampusAssetLocationBuildingByItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase baseForm = (PurchasingFormBase)form;
        PurchasingDocument document = (PurchasingDocument)baseForm.getDocument();
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        String assetItemIndex = StringUtils.substringBetween((String)fullParameter, (String)"(((", (String)")))");
        String assetLocationIndex = StringUtils.substringBetween((String)fullParameter, (String)"((#", (String)"#))");
        PurchasingCapitalAssetItem assetItem = document.getPurchasingCapitalAssetItems().get(Integer.parseInt(assetItemIndex));
        CapitalAssetSystem system = assetItem.getPurchasingCapitalAssetSystem();
        if ("new".equals(assetLocationIndex)) {
            this.useOffCampusAssetLocationBuilding(system.getNewPurchasingCapitalAssetLocationLine());
        } else {
            this.useOffCampusAssetLocationBuilding((CapitalAssetLocation)system.getCapitalAssetLocations().get(Integer.parseInt(assetLocationIndex)));
        }
        return mapping.findForward("basic");
    }

    protected void useOffCampusAssetLocationBuilding(CapitalAssetLocation location) {
        if (location != null) {
            location.setOffCampusIndicator(true);
            location.setBuildingCode("");
            location.setCapitalAssetLine1Address("");
            location.setCapitalAssetCityName("");
            location.setCapitalAssetStateCode("");
            location.setCapitalAssetPostalCode("");
            location.setCapitalAssetCountryCode("");
            location.setBuildingRoomNumber("");
        }
    }

    public ActionForward addItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurApItem item = purchasingForm.getNewPurchasingItemLine();
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", (Document)purDocument, item));
        if (rulePassed) {
            item = purchasingForm.getAndResetNewPurchasingItemLine();
            purDocument.addItem(item);
        }
        return mapping.findForward("basic");
    }

    public ActionForward importItems(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.info("Importing item lines");
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        String documentNumber = purDocument.getDocumentNumber();
        FormFile itemFile = purchasingForm.getItemImportFile();
        Class itemClass = purDocument.getItemClass();
        String errorPath = "document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*";
        ItemParser itemParser = purDocument.getItemParser();
        int itemLinePosition = purDocument.getItemLinePosition();
        try {
            List<PurApItem> importedItems = itemParser.importItems(itemFile, itemClass, documentNumber);
            boolean allPassed = true;
            int itemLineNumber = 0;
            for (PurApItem item : importedItems) {
                item.setItemLineNumber(++itemLineNumber);
                allPassed &= ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedImportPurchasingAccountsPayableItemEvent("", (Document)purDocument, item));
                item.setItemLineNumber(itemLineNumber + itemLinePosition);
            }
            if (allPassed) {
                this.updateBOReferenceforNewItems(importedItems, (PurchasingDocumentBase)purDocument);
                purDocument.getItems().addAll(itemLinePosition, importedItems);
            }
        }
        catch (ItemParserException e) {
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", e.getErrorKey(), e.getErrorParameters());
        }
        return mapping.findForward("basic");
    }

    protected void updateBOReferenceforNewItems(List<PurApItem> importedItems, PurchasingDocumentBase purDocument) {
        for (PurApItem item : importedItems) {
            item.setPurapDocument(purDocument);
            if (purDocument.getPurapDocumentIdentifier() != null) {
                item.setPurapDocumentIdentifier(purDocument.getPurapDocumentIdentifier());
            }
            for (PurApAccountingLine account : item.getSourceAccountingLines()) {
                account.setPurapItem(item);
                if (item.getItemIdentifier() == null) continue;
                account.setItemIdentifier(item.getItemIdentifier());
            }
        }
    }

    public ActionForward deleteItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean rulePassed;
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        purDocument.deleteItem(this.getSelectedLine(request));
        if (StringUtils.isNotBlank((CharSequence)purDocument.getCapitalAssetSystemTypeCode()) && (rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedUpdateCamsViewPurapEvent((Document)purDocument)))) {
            ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetItems(purDocument);
        }
        return mapping.findForward("basic");
    }

    public ActionForward upItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        int line = this.getSelectedLine(request);
        purDocument.itemSwap(line, line - 1);
        return mapping.findForward("basic");
    }

    public ActionForward downItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        int line = this.getSelectedLine(request);
        purDocument.itemSwap(line, line + 1);
        return mapping.findForward("basic");
    }

    public ActionForward setupAccountDistribution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        purchasingForm.setHideDistributeAccounts(false);
        return mapping.findForward("basic");
    }

    public ActionForward removeAccounts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        if (question == null) {
            String questionText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("question.document.purap.removeAccounts");
            return this.performQuestionWithoutInput(mapping, form, request, response, "RemoveAccounts", questionText, "confirmationQuestion", "route", "0");
        }
        if ("0".equals(buttonClicked)) {
            for (PurApItem item : ((PurchasingAccountsPayableDocument)purchasingForm.getDocument()).getItems()) {
                item.getSourceAccountingLines().clear();
            }
            KNSGlobalVariables.getMessageList().add("message.document.purap.accountsRemoved", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward clearItemsCommodityCodes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        if (question == null) {
            String questionText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("question.document.pur.clearCommodityCodes");
            return this.performQuestionWithoutInput(mapping, form, request, response, "ClearCommodityCodes", questionText, "confirmationQuestion", "route", "0");
        }
        if ("0".equals(buttonClicked)) {
            for (PurApItem item : ((PurchasingAccountsPayableDocument)purchasingForm.getDocument()).getItems()) {
                PurchasingItemBase purItem = (PurchasingItemBase)item;
                purItem.setPurchasingCommodityCode(null);
                purItem.setCommodityCode(null);
            }
            KNSGlobalVariables.getMessageList().add("message.document.pur.commodityCodesCleared", new String[0]);
        }
        return mapping.findForward("basic");
    }

    protected boolean validateDistributeAccounts(Document document, List<PurApAccountingLine> distributionSourceAccountingLines) {
        boolean rulePassed = true;
        int i = 0;
        for (PurApAccountingLine accountingLine : distributionSourceAccountingLines) {
            String errorPrefix = "distributionSourceAccountingLines[" + Integer.toString(i) + "]";
            rulePassed &= ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AddAccountingLineEvent(errorPrefix, document, (AccountingLine)accountingLine));
            ++i;
        }
        return rulePassed;
    }

    public ActionForward doDistribution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        boolean needToDistributeCommodityCode = false;
        if (StringUtils.isNotBlank((CharSequence)purchasingForm.getDistributePurchasingCommodityCode())) {
            needToDistributeCommodityCode = true;
        }
        boolean needToDistributeAccount = false;
        List<PurApAccountingLine> distributionsourceAccountingLines = purchasingForm.getAccountDistributionsourceAccountingLines();
        if (distributionsourceAccountingLines.size() > 0) {
            needToDistributeAccount = true;
        }
        if (needToDistributeAccount || needToDistributeCommodityCode) {
            PurchasingAccountsPayableDocumentBase purApDocument = (PurchasingAccountsPayableDocumentBase)purchasingForm.getDocument();
            boolean institutionNeedsDistributeAccountValidation = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "VALIDATE_ACCOUNT_DISTRIBUTION_IND");
            boolean foundAccountDistributionError = false;
            boolean foundCommodityCodeDistributionError = false;
            boolean performedAccountDistribution = false;
            boolean performedCommodityCodeDistribution = false;
            if (!"P".equalsIgnoreCase(purApDocument.getAccountDistributionMethod()) && institutionNeedsDistributeAccountValidation && needToDistributeAccount && purchasingForm.getTotalPercentageOfAccountDistributionsourceAccountingLines().compareTo(new BigDecimal(100)) != 0) {
                GlobalVariables.getMessageMap().putError("accountDistributionnewSourceLine", "error.distribute.accounts.not.100.percent", new String[0]);
                foundAccountDistributionError = true;
            }
            if (institutionNeedsDistributeAccountValidation && needToDistributeAccount && !this.validateDistributeAccounts(purchasingForm.getDocument(), distributionsourceAccountingLines)) {
                foundAccountDistributionError = true;
            }
            for (PurApItem item : ((PurchasingAccountsPayableDocument)purchasingForm.getDocument()).getItems()) {
                boolean itemOnExcludeList;
                boolean itemIsActive = true;
                if (item instanceof PurchaseOrderItem) {
                    itemIsActive = ((PurchaseOrderItem)item).isItemActiveIndicator();
                }
                if (needToDistributeCommodityCode) {
                    if (item.getItemType().isLineItemIndicator() && StringUtils.isBlank((CharSequence)((PurchasingItemBase)item).getPurchasingCommodityCode()) && itemIsActive) {
                        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedCommodityCodesForDistributionEvent("", purchasingForm.getDocument(), purchasingForm.getDistributePurchasingCommodityCode()));
                        if (rulePassed) {
                            ((PurchasingItemBase)item).setPurchasingCommodityCode(purchasingForm.getDistributePurchasingCommodityCode());
                            performedCommodityCodeDistribution = true;
                        } else {
                            foundCommodityCodeDistributionError = true;
                        }
                    } else if (item.getItemType().isLineItemIndicator() && StringUtils.isNotBlank((CharSequence)((PurchasingItemBase)item).getPurchasingCommodityCode()) && itemIsActive) {
                        foundCommodityCodeDistributionError = true;
                    }
                }
                if (!needToDistributeAccount || foundAccountDistributionError) continue;
                BigDecimal zero = new BigDecimal(0);
                boolean unitCostNotZeroForBelowLineItems = item.getItemType().isLineItemIndicator() || item.getItemUnitPrice() != null && zero.compareTo(item.getItemUnitPrice()) < 0;
                Document document = ((PurchasingFormBase)form).getDocument();
                Class clazz = document instanceof PurchaseOrderAmendmentDocument ? PurchaseOrderDocument.class : document.getClass();
                ArrayList typesNotAllowingEdit = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(clazz, "ITEM_TYPES_RESTRICTING_ACCOUNT_EDIT"));
                boolean bl = itemOnExcludeList = typesNotAllowingEdit != null && typesNotAllowingEdit.contains(item.getItemTypeCode());
                if (item.getSourceAccountingLines().size() != 0 || !unitCostNotZeroForBelowLineItems || itemOnExcludeList || !itemIsActive) continue;
                for (PurApAccountingLine purApAccountingLine : distributionsourceAccountingLines) {
                    item.getSourceAccountingLines().add((PurApAccountingLine)((Object)ObjectUtils.deepCopy((Serializable)((Object)purApAccountingLine))));
                }
                performedAccountDistribution = true;
            }
            if (needToDistributeCommodityCode && performedCommodityCodeDistribution && !foundCommodityCodeDistributionError || needToDistributeAccount && performedAccountDistribution && !foundAccountDistributionError) {
                if (needToDistributeCommodityCode && !foundCommodityCodeDistributionError && performedCommodityCodeDistribution) {
                    KNSGlobalVariables.getMessageList().add("message.document.pur.commodityCodeDistributed", new String[0]);
                    purchasingForm.setDistributePurchasingCommodityCode(null);
                }
                if (needToDistributeAccount && !foundAccountDistributionError && performedAccountDistribution) {
                    KNSGlobalVariables.getMessageList().add("message.document.purap.accountsDistributed", new String[0]);
                    distributionsourceAccountingLines.clear();
                }
                purchasingForm.setHideDistributeAccounts(true);
            }
            if (needToDistributeAccount && !performedAccountDistribution && foundAccountDistributionError) {
                GlobalVariables.getMessageMap().putError("accountDistributionnewSourceLine", "error.document.purap.noItemsToDistributeTo", new String[]{"account numbers"});
            }
            if (needToDistributeCommodityCode && !performedCommodityCodeDistribution && foundCommodityCodeDistributionError) {
                GlobalVariables.getMessageMap().putError("distributePurchasingCommodityCode", "error.document.purap.noItemsToDistributeTo", new String[]{"commodity codes"});
            }
        } else {
            GlobalVariables.getMessageMap().putError("accountDistributionnewSourceLine", "error.document.purap.noAccountsToDistribute", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward cancelAccountDistribution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        purchasingForm.setHideDistributeAccounts(true);
        return mapping.findForward("basic");
    }

    @Override
    public boolean processCustomInsertAccountingLine(PurchasingAccountsPayableFormBase purapForm, HttpServletRequest request) {
        boolean success = false;
        PurchasingFormBase purchasingForm = (PurchasingFormBase)purapForm;
        int itemIndex = this.getSelectedLine(request);
        boolean institutionNeedsDistributeAccountValidation = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "VALIDATE_ACCOUNT_DISTRIBUTION_IND");
        if (itemIndex == -2 && !institutionNeedsDistributeAccountValidation) {
            PurApAccountingLine line = purchasingForm.getAccountDistributionnewSourceLine();
            purchasingForm.addAccountDistributionsourceAccountingLine(line);
            success = true;
        }
        return success;
    }

    @Override
    public ActionForward deleteSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        String[] indexes = this.getSelectedLineForAccounts(request);
        int itemIndex = Integer.parseInt(indexes[0]);
        int accountIndex = Integer.parseInt(indexes[1]);
        if (itemIndex == -2) {
            purchasingForm.getAccountDistributionsourceAccountingLines().remove(accountIndex);
        } else {
            PurApItem item = ((PurchasingAccountsPayableDocument)purchasingForm.getDocument()).getItem(itemIndex);
            item.getSourceAccountingLines().remove(accountIndex);
        }
        return mapping.findForward("basic");
    }

    @Override
    protected SourceAccountingLine customAccountRetrieval(int accountIndex, PurchasingAccountsPayableFormBase purchasingAccountsPayableForm) {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)purchasingAccountsPayableForm;
        SourceAccountingLine line = (SourceAccountingLine)ObjectUtils.deepCopy((Serializable)((Serializable)((Object)purchasingForm.getAccountDistributionsourceAccountingLines().get(accountIndex))));
        return line;
    }

    public ActionForward selectSystemType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocumentBase document = (PurchasingDocumentBase)purchasingForm.getDocument();
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        if (question == null) {
            String questionText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("question.document.pur.systemTypeSwitching");
            return this.performQuestionWithoutInput(mapping, form, request, response, "SystemSwitchingQuestion", questionText, "confirmationQuestion", "route", "0");
        }
        if ("0".equals(buttonClicked)) {
            document.refreshReferenceObject("capitalAssetSystemType");
            KNSGlobalVariables.getMessageList().add("message.document.pur.systemTypeSwitched", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addItemCapitalAssetByDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        ItemCapitalAsset asset = purDocument.getPurchasingCapitalAssetItems().get(0).getNewPurchasingItemCapitalAssetLine();
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedAddPurchasingItemCapitalAssetEvent("", (Document)purDocument, asset));
        if (rulePassed) {
            CapitalAssetSystem system = purDocument.getPurchasingCapitalAssetSystems().get(this.getSelectedLine(request));
            asset = purDocument.getPurchasingCapitalAssetItems().get(0).getAndResetNewPurchasingItemCapitalAssetLine();
            asset.setCapitalAssetSystemIdentifier(system.getCapitalAssetSystemIdentifier());
            if (this.capitalAssetSystemHasAssetItem(system, asset)) {
                GlobalVariables.getMessageMap().putError("document.purchasingCapitalAsset*,newPurchasingItemCapitalAssetLine*,newPurchasingCapitalAssetLocationLine*,document.capitalAssetSystemStateCode", "error.capitalAsset.duplicate.asset", new String[0]);
            } else {
                system.getItemCapitalAssets().add(asset);
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward addItemCapitalAssetByItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        PurchasingCapitalAssetItem assetItem = purDocument.getPurchasingCapitalAssetItems().get(this.getSelectedLine(request));
        ItemCapitalAsset asset = assetItem.getNewPurchasingItemCapitalAssetLine();
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedAddPurchasingItemCapitalAssetEvent("", (Document)purDocument, asset));
        if (rulePassed) {
            CapitalAssetSystem system = assetItem.getPurchasingCapitalAssetSystem();
            asset = assetItem.getAndResetNewPurchasingItemCapitalAssetLine();
            asset.setCapitalAssetSystemIdentifier(system.getCapitalAssetSystemIdentifier());
            if (this.capitalAssetSystemHasAssetItem(system, asset)) {
                GlobalVariables.getMessageMap().putError("document.purchasingCapitalAsset*,newPurchasingItemCapitalAssetLine*,newPurchasingCapitalAssetLocationLine*,document.capitalAssetSystemStateCode", "error.capitalAsset.duplicate.asset", new String[0]);
            } else {
                system.getItemCapitalAssets().add(asset);
            }
        }
        return mapping.findForward("basic");
    }

    private boolean capitalAssetSystemHasAssetItem(CapitalAssetSystem system, ItemCapitalAsset asset) {
        return system.getItemCapitalAssets().stream().map(ItemCapitalAsset::getCapitalAssetNumber).collect(Collectors.toList()).contains(asset.getCapitalAssetNumber());
    }

    public ActionForward deleteItemCapitalAssetByDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        String systemIndex = StringUtils.substringBetween((String)fullParameter, (String)"(((", (String)")))");
        String assetIndex = StringUtils.substringBetween((String)fullParameter, (String)"((#", (String)"#))");
        PurchasingCapitalAssetSystemBase system = (PurchasingCapitalAssetSystemBase)purDocument.getPurchasingCapitalAssetSystems().get(Integer.parseInt(systemIndex));
        system.getItemCapitalAssets().remove(Integer.parseInt(assetIndex));
        return mapping.findForward("basic");
    }

    public ActionForward deleteItemCapitalAssetByItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        PurchasingCapitalAssetItem assetItem = purDocument.getPurchasingCapitalAssetItems().get(this.getSelectedLine(request));
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        String assetIndex = StringUtils.substringBetween((String)fullParameter, (String)"((#", (String)"#))");
        PurchasingCapitalAssetSystemBase system = (PurchasingCapitalAssetSystemBase)assetItem.getPurchasingCapitalAssetSystem();
        system.getItemCapitalAssets().remove(Integer.parseInt(assetIndex));
        return mapping.findForward("basic");
    }

    public ActionForward addCapitalAssetLocationByDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        CapitalAssetLocation location = purchasingForm.getAndResetNewPurchasingCapitalAssetLocationLine();
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedAddPurchasingCapitalAssetLocationEvent("", (Document)purDocument, location));
        boolean bl = rulePassed = rulePassed && ((PurchasingService)SpringContext.getBean(PurchasingService.class)).checkCapitalAssetLocation(location);
        if (rulePassed) {
            CapitalAssetSystem system = purDocument.getPurchasingCapitalAssetSystems().get(this.getSelectedLine(request));
            location.setCapitalAssetSystemIdentifier(system.getCapitalAssetSystemIdentifier());
            system.getCapitalAssetLocations().add(location);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addCapitalAssetLocationByItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        CapitalAssetLocation location = purDocument.getPurchasingCapitalAssetItems().get(this.getSelectedLine(request)).getPurchasingCapitalAssetSystem().getNewPurchasingCapitalAssetLocationLine();
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedAddPurchasingCapitalAssetLocationEvent("", (Document)purDocument, location));
        if (rulePassed) {
            PurchasingCapitalAssetItem assetItem = purDocument.getPurchasingCapitalAssetItems().get(this.getSelectedLine(request));
            CapitalAssetSystem system = assetItem.getPurchasingCapitalAssetSystem();
            location.setCapitalAssetSystemIdentifier(system.getCapitalAssetSystemIdentifier());
            system.getCapitalAssetLocations().add(location);
            purDocument.getPurchasingCapitalAssetItems().get(this.getSelectedLine(request)).getPurchasingCapitalAssetSystem().resetNewPurchasingCapitalAssetLocationLine();
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteCapitalAssetLocationByDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        String systemIndex = StringUtils.substringBetween((String)fullParameter, (String)"(((", (String)")))");
        String locationIndex = StringUtils.substringBetween((String)fullParameter, (String)"((#", (String)"#))");
        CapitalAssetSystem system = purDocument.getPurchasingCapitalAssetSystems().get(Integer.parseInt(systemIndex));
        system.getCapitalAssetLocations().remove(Integer.parseInt(locationIndex));
        return mapping.findForward("basic");
    }

    public ActionForward deleteCapitalAssetLocationByItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurchasingDocument purDocument = (PurchasingDocument)purchasingForm.getDocument();
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        String assetItemIndex = StringUtils.substringBetween((String)fullParameter, (String)"(((", (String)")))");
        String locationIndex = StringUtils.substringBetween((String)fullParameter, (String)"((#", (String)"#))");
        PurchasingCapitalAssetItem assetItem = purDocument.getPurchasingCapitalAssetItems().get(Integer.parseInt(assetItemIndex));
        CapitalAssetSystem system = assetItem.getPurchasingCapitalAssetSystem();
        RequisitionCapitalAssetLocation capitalAssetLocation = (RequisitionCapitalAssetLocation)((Object)system.getCapitalAssetLocations().remove(Integer.parseInt(locationIndex)));
        this.getBusinessObjectService().delete((PersistableBusinessObject)capitalAssetLocation);
        return mapping.findForward("basic");
    }

    public ActionForward setupCAMSSystem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument document = (PurchasingDocument)purchasingForm.getDocument();
        ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetSystem(document);
        return mapping.findForward("basic");
    }

    public ActionForward selectSystem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument document = (PurchasingDocument)purchasingForm.getDocument();
        String errorPath = "document.purchasingCapitalAsset*,newPurchasingItemCapitalAssetLine*,newPurchasingCapitalAssetLocationLine*,document.capitalAssetSystemStateCode";
        if (StringUtils.isEmpty((CharSequence)document.getCapitalAssetSystemTypeCode())) {
            GlobalVariables.getMessageMap().putError("document.purchasingCapitalAsset*,newPurchasingItemCapitalAssetLine*,newPurchasingCapitalAssetLocationLine*,document.capitalAssetSystemStateCode", "error.custom", new String[]{"Capital Asset System Type and Capital Asset System State are both required to proceed"});
        } else if (StringUtils.isEmpty((CharSequence)document.getCapitalAssetSystemStateCode())) {
            GlobalVariables.getMessageMap().putError("document.purchasingCapitalAsset*,newPurchasingItemCapitalAssetLine*,newPurchasingCapitalAssetLocationLine*,document.capitalAssetSystemStateCode", "error.custom", new String[]{"Capital Asset System Type and Capital Asset System State are both required to proceed"});
        } else {
            document.refreshReferenceObject("capitalAssetSystemType");
            document.refreshReferenceObject("capitalAssetSystemState");
            if (PurchasingActionBase.validateCapitalAssetSystemStateAllowed(document.getCapitalAssetSystemType(), document.getCapitalAssetSystemState())) {
                ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetSystem(document);
                ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetItems(document);
                if (!document.getPurchasingCapitalAssetItems().isEmpty()) {
                    this.saveDocumentNoValidationUsingClearErrorMap(document);
                } else {
                    GlobalVariables.getMessageMap().putError("document.purchasingCapitalAsset*,newPurchasingItemCapitalAssetLine*,newPurchasingCapitalAssetLocationLine*,document.capitalAssetSystemStateCode", "error.custom", new String[]{"No items were found that met the requirements for Capital Asset data collection"});
                }
                this.saveDocumentNoValidationUsingClearErrorMap(document);
            } else {
                document.setCapitalAssetSystemStateCode(null);
                document.setCapitalAssetSystemState(null);
            }
        }
        return mapping.findForward("basic");
    }

    protected static boolean validateCapitalAssetSystemStateAllowed(CapitalAssetSystemType capitalAssetSystemType, CapitalAssetSystemState capitalAssetSystemState) {
        List<String> allowedCodes = Arrays.asList(capitalAssetSystemType.getAllowedCapitalAssetSystemStateCodes().split(";"));
        if (!allowedCodes.contains(capitalAssetSystemState.getCapitalAssetSystemStateCode())) {
            GlobalVariables.getMessageMap().putError("document.capitalAssetSystemStateCode", "error.capitalAsset.not.allowed.system.type", new String[]{capitalAssetSystemType.getCapitalAssetSystemTypeDescription(), capitalAssetSystemState.getCapitalAssetSystemStateDescription()});
            return false;
        }
        return true;
    }

    protected void saveDocumentNoValidationUsingClearErrorMap(PurchasingDocument document) {
        MessageMap errorHolder = GlobalVariables.getMessageMap();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        try {
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)document);
        }
        finally {
            GlobalVariables.setMessageMap((MessageMap)errorHolder);
        }
    }

    public ActionForward changeSystem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument document = (PurchasingDocument)purchasingForm.getDocument();
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        if (question == null) {
            String questionText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("purchasing.question.change.system");
            return this.performQuestionWithoutInput(mapping, form, request, response, "SystemSwitchingQuestion", questionText, "confirmationQuestion", "route", "0");
        }
        if ("0".equals(buttonClicked)) {
            if (document instanceof PurchaseOrderDocument && "Change in Process".equals(document.getApplicationDocumentStatus())) {
                String description;
                Integer poId = document.getPurapDocumentIdentifier();
                PurchaseOrderDocument currentPO = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(poId);
                String oldSystemTypeCode = "";
                if (currentPO != null) {
                    oldSystemTypeCode = currentPO.getCapitalAssetSystemTypeCode();
                }
                CapitalAssetSystemType oldSystemType = new CapitalAssetSystemType();
                oldSystemType.setCapitalAssetSystemTypeCode(oldSystemTypeCode);
                Map keys = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)oldSystemType);
                oldSystemType = (CapitalAssetSystemType)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(CapitalAssetSystemType.class, keys);
                String string = description = oldSystemType == null ? "(NONE)" : oldSystemType.getCapitalAssetSystemTypeDescription();
                if (document instanceof PurchaseOrderAmendmentDocument) {
                    String noteText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("purchaseOrder.amend.message.change.systemType");
                    noteText = StringUtils.replace((String)noteText, (String)"{0}", (String)description);
                    try {
                        Note systemTypeChangeNote = this.getDocumentService().createNoteFromDocument((Document)document, noteText);
                        purchasingForm.setNewNote(systemTypeChangeNote);
                        this.insertBONote(mapping, (ActionForm)purchasingForm, request, response);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (form instanceof RequisitionForm) {
                ((RequisitionForm)form).resetNewPurchasingCapitalAssetLocationLine();
            }
            if (document instanceof PurchaseOrderAmendmentDocument) {
                for (PurchasingCapitalAssetItem assetItem : document.getPurchasingCapitalAssetItems()) {
                    ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).delete((PersistableBusinessObject)assetItem);
                }
            }
            document.clearCapitalAssetFields();
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)document);
            KNSGlobalVariables.getMessageList().add("purchasing.message.system.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward updateCamsView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument document = (PurchasingDocument)purchasingForm.getDocument();
        ((PurchasingService)SpringContext.getBean(PurchasingService.class)).setupCapitalAssetItems(document);
        return mapping.findForward("basic");
    }

    public ActionForward setManufacturerFromVendorByDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument document = (PurchasingDocument)purchasingForm.getDocument();
        String vendorName = document.getVendorName();
        if (StringUtils.isEmpty((CharSequence)vendorName)) {
            GlobalVariables.getMessageMap().putError("document.purchasingCapitalAsset*,newPurchasingItemCapitalAssetLine*,newPurchasingCapitalAssetLocationLine*,document.capitalAssetSystemStateCode", "error.capitalAsset.no.vendor", (String[])null);
        } else {
            CapitalAssetSystem system = document.getPurchasingCapitalAssetSystems().get(this.getSelectedLine(request));
            if (system != null) {
                system.setCapitalAssetManufacturerName(vendorName);
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward setManufacturerFromVendorByItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument document = (PurchasingDocument)purchasingForm.getDocument();
        String vendorName = document.getVendorName();
        if (StringUtils.isEmpty((CharSequence)vendorName)) {
            GlobalVariables.getMessageMap().putError("document.purchasingCapitalAsset*,newPurchasingItemCapitalAssetLine*,newPurchasingCapitalAssetLocationLine*,document.capitalAssetSystemStateCode", "error.capitalAsset.no.vendor", (String[])null);
        } else {
            PurchasingCapitalAssetItem assetItem = document.getPurchasingCapitalAssetItems().get(this.getSelectedLine(request));
            CapitalAssetSystem system = assetItem.getPurchasingCapitalAssetSystem();
            if (system != null) {
                system.setCapitalAssetManufacturerName(vendorName);
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward selectNotCurrentYearByDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument document = (PurchasingDocument)purchasingForm.getDocument();
        CapitalAssetSystem system = document.getPurchasingCapitalAssetSystems().get(this.getSelectedLine(request));
        if (system != null) {
            system.setCapitalAssetNotReceivedCurrentFiscalYearIndicator(true);
            system.setCapitalAssetTypeCode(((PurchasingService)SpringContext.getBean(PurchasingService.class)).getDefaultAssetTypeCodeNotThisFiscalYear());
        }
        return mapping.findForward("basic");
    }

    public ActionForward selectNotCurrentYearByItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument document = (PurchasingDocument)purchasingForm.getDocument();
        PurchasingCapitalAssetItem assetItem = document.getPurchasingCapitalAssetItems().get(this.getSelectedLine(request));
        CapitalAssetSystem system = assetItem.getPurchasingCapitalAssetSystem();
        if (system != null) {
            system.setCapitalAssetNotReceivedCurrentFiscalYearIndicator(true);
            system.setCapitalAssetTypeCode(((PurchasingService)SpringContext.getBean(PurchasingService.class)).getDefaultAssetTypeCodeNotThisFiscalYear());
        }
        return mapping.findForward("basic");
    }

    public ActionForward clearNotCurrentYearByDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument document = (PurchasingDocument)purchasingForm.getDocument();
        CapitalAssetSystem system = document.getPurchasingCapitalAssetSystems().get(this.getSelectedLine(request));
        if (system != null) {
            system.setCapitalAssetNotReceivedCurrentFiscalYearIndicator(false);
            system.setCapitalAssetTypeCode("");
        }
        return mapping.findForward("basic");
    }

    public ActionForward clearNotCurrentYearByItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument document = (PurchasingDocument)purchasingForm.getDocument();
        PurchasingCapitalAssetItem assetItem = document.getPurchasingCapitalAssetItems().get(this.getSelectedLine(request));
        CapitalAssetSystem system = assetItem.getPurchasingCapitalAssetSystem();
        if (system != null) {
            system.setCapitalAssetNotReceivedCurrentFiscalYearIndicator(false);
            system.setCapitalAssetTypeCode("");
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward calculate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument purDoc = (PurchasingDocument)purchasingForm.getDocument();
        boolean defaultUseTaxIndicatorValue = ((PurchasingService)SpringContext.getBean(PurchasingService.class)).getDefaultUseTaxIndicatorValue(purDoc);
        ((PurapService)SpringContext.getBean(PurapService.class)).updateUseTaxIndicator(purDoc, defaultUseTaxIndicatorValue);
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax(purDoc);
        ((PurapService)SpringContext.getBean(PurapService.class)).prorateForTradeInAndFullOrderDiscount(purDoc);
        ((PurapAccountingService)SpringContext.getBean(PurapAccountingService.class)).updateAccountAmounts(purDoc);
        this.customCalculate(purDoc);
        PurchasingFormBase formBase = (PurchasingFormBase)form;
        formBase.setInitialZipCode(purDoc.getDeliveryPostalCode());
        formBase.setCalculated(true);
        purDoc.setCalculated(true);
        KNSGlobalVariables.getMessageList().clear();
        return super.calculate(mapping, form, request, response);
    }

    @Override
    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) {
        super.loadDocument(kualiDocumentFormBase);
        PurchasingFormBase formBase = (PurchasingFormBase)kualiDocumentFormBase;
        if (StringUtils.isEmpty((CharSequence)formBase.getInitialZipCode())) {
            formBase.setInitialZipCode(((PurchasingDocument)formBase.getDocument()).getDeliveryPostalCode());
        }
    }

    @Override
    public ActionForward clearAllTaxes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableFormBase purchasingForm = (PurchasingAccountsPayableFormBase)form;
        PurchasingDocument purDoc = (PurchasingDocument)purchasingForm.getDocument();
        ((PurapService)SpringContext.getBean(PurapService.class)).clearAllTaxes(purDoc);
        return super.clearAllTaxes(mapping, form, request, response);
    }

    protected String findBuildingCodeFromCapitalAssetBuildingLookup(HttpServletRequest request) {
        Enumeration anEnum = request.getParameterNames();
        while (anEnum.hasMoreElements()) {
            String paramName = (String)anEnum.nextElement();
            if (!StringUtils.containsIgnoreCase((CharSequence)paramName, (CharSequence)"purchasingcapitalasset") || !paramName.contains("buildingCode")) continue;
            return paramName;
        }
        return "";
    }

    protected List<String> findAllBuildingCodesFromCapitalAssetBuildingLookup(HttpServletRequest request) {
        ArrayList<String> buildingCodes = new ArrayList<String>();
        Enumeration anEnum = request.getParameterNames();
        while (anEnum.hasMoreElements()) {
            String paramName = (String)anEnum.nextElement();
            if (!StringUtils.containsIgnoreCase((CharSequence)paramName, (CharSequence)"purchasingcapitalasset") || !paramName.contains("buildingCode")) continue;
            buildingCodes.add(paramName);
        }
        return buildingCodes;
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurchasingDocument purDoc = (PurchasingDocument)purchasingForm.getDocument();
        if (this.requiresCalculate(purchasingForm)) {
            GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "errors.purchasing.calculationRequired", new String[0]);
            return mapping.findForward("basic");
        }
        ((PurapService)SpringContext.getBean(PurapService.class)).prorateForTradeInAndFullOrderDiscount(purDoc);
        return super.route(mapping, form, request, response);
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurchasingDocument purDoc = (PurchasingDocument)purchasingForm.getDocument();
        ((PurapService)SpringContext.getBean(PurapService.class)).prorateForTradeInAndFullOrderDiscount(purDoc);
        return super.approve(mapping, form, request, response);
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purchasingForm = (PurchasingFormBase)form;
        PurchasingDocument purDoc = (PurchasingDocument)purchasingForm.getDocument();
        ((PurapService)SpringContext.getBean(PurapService.class)).prorateForTradeInAndFullOrderDiscount(purDoc);
        return super.blanketApprove(mapping, form, request, response);
    }

    protected boolean requiresCalculate(PurchasingFormBase purForm) {
        return !purForm.isCalculated() && purForm.canUserCalculate();
    }

    public ActionForward populateBuilding(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purForm = (PurchasingFormBase)form;
        PurchasingDocumentBase document = (PurchasingDocumentBase)purForm.getDocument();
        this.updateAssetBuildingLocations(purForm, request, document);
        return mapping.findForward("basic");
    }

    public ActionForward populateDeliveryBuilding(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingFormBase purForm = (PurchasingFormBase)form;
        PurchasingDocumentBase document = (PurchasingDocumentBase)purForm.getDocument();
        this.updateDeliveryBuilding(request, document);
        return mapping.findForward("basic");
    }
}

