/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedCalculateAccountsPayableEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedContinuePurapEvent;
import org.kuali.kfs.module.purap.document.web.struts.AccountsPayableActionBase;
import org.kuali.kfs.module.purap.document.web.struts.VendorCreditMemoForm;
import org.kuali.kfs.module.purap.util.PurQuestionCallback;
import org.kuali.kfs.sys.context.SpringContext;

public class VendorCreditMemoAction
extends AccountsPayableActionBase {
    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) {
        super.createDocument(kualiDocumentFormBase);
        ((VendorCreditMemoDocument)kualiDocumentFormBase.getDocument()).initiateDocument();
    }

    public ActionForward continueCreditMemo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        PurchaseOrderDocument po;
        VendorCreditMemoForm cmForm = (VendorCreditMemoForm)form;
        VendorCreditMemoDocument creditMemoDocument = (VendorCreditMemoDocument)cmForm.getDocument();
        creditMemoDocument.setAccountDistributionMethod("P");
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedContinuePurapEvent((Document)creditMemoDocument));
        if (!rulePassed) {
            return mapping.findForward("basic");
        }
        if (creditMemoDocument.isSourceDocumentPaymentRequest()) {
            PaymentRequestDocument preq = ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).getPaymentRequestById(creditMemoDocument.getPaymentRequestIdentifier());
            if (ObjectUtils.isNotNull((Object)preq)) {
                creditMemoDocument.setAccountsPayablePurchasingDocumentLinkIdentifier(preq.getAccountsPayablePurchasingDocumentLinkIdentifier());
                if (!((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)creditMemoDocument).isAuthorizedByTemplate((BusinessObject)creditMemoDocument, "KFS-SYS", "Open Document", GlobalVariables.getUserSession().getPrincipalId())) {
                    throw this.buildAuthorizationException("initiate document", (Document)creditMemoDocument);
                }
            }
        } else if (creditMemoDocument.isSourceDocumentPurchaseOrder() && ObjectUtils.isNotNull((Object)(po = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(creditMemoDocument.getPurchaseOrderIdentifier())))) {
            creditMemoDocument.setAccountsPayablePurchasingDocumentLinkIdentifier(po.getAccountsPayablePurchasingDocumentLinkIdentifier());
            if (!((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)creditMemoDocument).isAuthorizedByTemplate((BusinessObject)creditMemoDocument, "KFS-SYS", "Open Document", GlobalVariables.getUserSession().getPrincipalId())) {
                throw this.buildAuthorizationException("initiate document", (Document)creditMemoDocument);
            }
        }
        if ((forward = this.performDuplicateCreditMemoCheck(mapping, form, request, response, creditMemoDocument)) != null) {
            return forward;
        }
        ((CreditMemoService)SpringContext.getBean(CreditMemoService.class)).populateAndSaveCreditMemo(creditMemoDocument);
        ((PurapService)SpringContext.getBean(PurapService.class)).sortBelowTheLine(creditMemoDocument);
        cmForm.updateItemCounts();
        PurchaseOrderDocument po2 = creditMemoDocument.getPurchaseOrderDocument();
        if ((creditMemoDocument.isSourceDocumentPaymentRequest() || creditMemoDocument.isSourceDocumentPurchaseOrder()) && "Closed".equals(po2.getApplicationDocumentStatus())) {
            this.initiateReopenPurchaseOrder(po2, cmForm.getAnnotation());
        }
        List items = creditMemoDocument.getItems();
        for (PurApItem item : items) {
            for (PurApAccountingLine accountLine : item.getSourceAccountingLines()) {
                accountLine.setAmount(KualiDecimal.ZERO);
            }
        }
        return mapping.findForward("basic");
    }

    protected String getDistributionMethodFromPReq(String preqId) {
        String distributionMethod = "";
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("purapDocumentIdentifier", preqId);
        List preqDocuments = (List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(PaymentRequestDocument.class, criteria);
        for (PaymentRequestDocument preqDoc : preqDocuments) {
            if (!ObjectUtils.isNotNull((Object)preqDoc.getAccountDistributionMethod())) continue;
            distributionMethod = preqDoc.getAccountDistributionMethod();
            return distributionMethod;
        }
        return distributionMethod;
    }

    protected String getDistributionMethodFromPO(String poId) {
        String distributionMethod = "";
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("purapDocumentIdentifier", poId);
        List poDocuments = (List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(PurchaseOrderDocument.class, criteria);
        for (PurchaseOrderDocument poDoc : poDocuments) {
            if (!ObjectUtils.isNotNull((Object)poDoc.getAccountDistributionMethod())) continue;
            distributionMethod = poDoc.getAccountDistributionMethod();
            return distributionMethod;
        }
        return distributionMethod;
    }

    public ActionForward clearInitFields(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VendorCreditMemoForm cmForm = (VendorCreditMemoForm)form;
        VendorCreditMemoDocument creditMemoDocument = (VendorCreditMemoDocument)cmForm.getDocument();
        creditMemoDocument.clearInitFields();
        return super.refresh(mapping, form, request, response);
    }

    protected ActionForward performDuplicateCreditMemoCheck(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, VendorCreditMemoDocument creditMemoDocument) throws Exception {
        ActionForward forward = null;
        String duplicateMessage = ((CreditMemoService)SpringContext.getBean(CreditMemoService.class)).creditMemoDuplicateMessages(creditMemoDocument);
        if (StringUtils.isNotBlank((CharSequence)duplicateMessage)) {
            String question = request.getParameter("questionIndex");
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "PREQDuplicateInvoice", duplicateMessage, "confirmationQuestion", "continueCreditMemo", "");
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if ("PREQDuplicateInvoice".equals(question) && "1".equals(buttonClicked)) {
                forward = mapping.findForward("basic");
            }
        }
        return forward;
    }

    @Override
    protected void customCalculate(PurchasingAccountsPayableDocument apDoc) {
        VendorCreditMemoDocument cmDocument = (VendorCreditMemoDocument)apDoc;
        ((CreditMemoService)SpringContext.getBean(CreditMemoService.class)).calculateCreditMemo(cmDocument);
        ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedCalculateAccountsPayableEvent((Document)cmDocument));
    }

    public ActionForward addHoldOnCreditMemo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = "Hold ";
        PurQuestionCallback callback = (document, noteText) -> ((CreditMemoService)SpringContext.getBean(CreditMemoService.class)).addHoldOnCreditMemo((VendorCreditMemoDocument)document, noteText);
        return this.askQuestionWithInput(mapping, form, request, response, "HoldCM", "Hold ", "Note entered while placing Credit Memo on hold: ", "creditMemo.question.hold.text", callback);
    }

    public ActionForward removeHoldFromCreditMemo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = "Remove Hold ";
        PurQuestionCallback callback = (document, noteText) -> ((CreditMemoService)SpringContext.getBean(CreditMemoService.class)).removeHoldOnCreditMemo((VendorCreditMemoDocument)document, noteText);
        return this.askQuestionWithInput(mapping, form, request, response, "RemoveCM", "Remove Hold ", "Note entered while removing hold on Credit Memo: ", "creditMemo.question.removeHold.text", callback);
    }

    @Override
    public String getActionName() {
        return "VendorCreditMemo";
    }

    protected void populateAdHocActionRequestCodes(KualiDocumentFormBase formBase) {
        Document document = formBase.getDocument();
        DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
        HashMap<String, String> adHocActionRequestCodes = new HashMap<String, String>();
        if (documentAuthorizer.canSendAdHocRequests(document, "F", GlobalVariables.getUserSession().getPerson())) {
            adHocActionRequestCodes.put("F", "FYI");
        }
        if ((document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved() || document.getDocumentHeader().getWorkflowDocument().isEnroute()) && documentAuthorizer.canSendAdHocRequests(document, "K", GlobalVariables.getUserSession().getPerson())) {
            adHocActionRequestCodes.put("K", "ACKNOWLEDGE");
        }
        formBase.setAdHocActionRequestCodes(adHocActionRequestCodes);
    }
}

