/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorStipulation;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderRetransmitDocument;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.kfs.module.purap.pdf.PurapPdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderParameters;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderTransmitParameters;
import org.kuali.kfs.module.purap.util.PurApDateFormatUtils;

public class PurchaseOrderPdf
extends PurapPdf {
    private static final Logger LOG = LogManager.getLogger();

    public void onOpenDocument(PdfWriter writer, Document document) {
        LOG.debug("onOpenDocument() started. isRetransmit is {}", (Object)this.isRetransmit);
        try {
            float[] headerWidths = new float[]{0.2f, 0.8f};
            this.headerTable = new PdfPTable(headerWidths);
            this.headerTable.setWidthPercentage(100.0f);
            this.headerTable.setHorizontalAlignment(1);
            this.headerTable.setSplitLate(false);
            this.headerTable.getDefaultCell().setBorderWidth(0.0f);
            this.headerTable.getDefaultCell().setHorizontalAlignment(1);
            this.headerTable.getDefaultCell().setVerticalAlignment(1);
            Image logo = null;
            if (StringUtils.isNotBlank((CharSequence)this.logoImage)) {
                try {
                    logo = Image.getInstance((String)this.logoImage);
                }
                catch (IOException e) {
                    LOG.info("The logo image [{}] is not available. Defaulting to the default image.", (Object)this.logoImage);
                }
            }
            if (logo == null) {
                this.headerTable.addCell(new Phrase(new Chunk("")));
            } else {
                logo.scalePercent(3.0f, 3.0f);
                this.headerTable.addCell(new Phrase(new Chunk(logo, 0.0f, 0.0f)));
            }
            float[] nestedHeaderWidths = new float[]{0.7f, 0.3f};
            this.nestedHeaderTable = new PdfPTable(nestedHeaderWidths);
            this.nestedHeaderTable.setSplitLate(false);
            PdfPCell cell = new PdfPCell((Phrase)new Paragraph(this.po.getBillingName(), this.ver_15_normal));
            cell.setHorizontalAlignment(1);
            cell.setBorderWidth(0.0f);
            this.nestedHeaderTable.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph(" ", this.ver_15_normal));
            cell.setBorderWidth(0.0f);
            this.nestedHeaderTable.addCell(cell);
            cell = this.isRetransmit ? new PdfPCell((Phrase)new Paragraph(this.po.getRetransmitHeader(), this.ver_15_normal)) : new PdfPCell((Phrase)new Paragraph("PURCHASE ORDER", this.ver_15_normal));
            cell.setHorizontalAlignment(1);
            cell.setBorderWidth(0.0f);
            this.nestedHeaderTable.addCell(cell);
            Paragraph p = new Paragraph();
            p.add((Element)new Chunk("PO Number: ", this.ver_11_normal));
            p.add((Element)new Chunk(this.po.getPurapDocumentIdentifier().toString(), this.cour_16_bold));
            cell = new PdfPCell((Phrase)p);
            cell.setHorizontalAlignment(2);
            cell.setBorderWidth(0.0f);
            this.nestedHeaderTable.addCell(cell);
            if (!this.po.getPurchaseOrderAutomaticIndicator()) {
                p = new Paragraph();
                p.add((Element)new Chunk("Contract Manager: ", this.ver_11_normal));
                p.add((Element)new Chunk(this.po.getContractManager().getContractManagerName(), this.cour_7_normal));
                cell = new PdfPCell((Phrase)p);
                cell.setColspan(2);
                cell.setHorizontalAlignment(2);
                cell.setBorderWidth(0.0f);
                this.nestedHeaderTable.addCell(cell);
            }
            cell = new PdfPCell(this.nestedHeaderTable);
            cell.setHorizontalAlignment(1);
            cell.setBorderWidth(0.0f);
            this.headerTable.addCell(cell);
            this.tpl = writer.getDirectContent().createTemplate(100.0f, 100.0f);
            this.helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    @Override
    public PurchaseOrderPdf getPageEvents() {
        LOG.debug("getPageEvents() started.");
        return new PurchaseOrderPdf();
    }

    public void generatePdf(PurchaseOrderDocument po, PurchaseOrderTransmitParameters pdfParameters, ByteArrayOutputStream byteArrayOutputStream, boolean isRetransmit, String environment, List<PurchaseOrderItem> retransmitItems) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = po::getPurapDocumentIdentifier;
        LOG.debug("generatePdf() started for po number {}", supplierArray);
        this.isRetransmit = isRetransmit;
        String statusInquiryUrl = pdfParameters.getStatusInquiryUrl();
        String campusName = pdfParameters.getCampusParameter().getCampus().getName();
        String contractLanguage = pdfParameters.getContractLanguage();
        String logoImage = pdfParameters.getLogoImage();
        String directorSignatureImage = pdfParameters.getDirectorSignatureImage();
        String directorName = pdfParameters.getCampusParameter().getCampusPurchasingDirectorName();
        String directorTitle = pdfParameters.getCampusParameter().getCampusPurchasingDirectorTitle();
        String contractManagerSignatureImage = pdfParameters.getContractManagerSignatureImage();
        try {
            Document doc = this.getDocument(9.0f, 9.0f, 70.0f, 36.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)byteArrayOutputStream);
            this.createPdf(po, doc, writer, statusInquiryUrl, campusName, contractLanguage, logoImage, directorSignatureImage, directorName, directorTitle, contractManagerSignatureImage, isRetransmit, environment, retransmitItems);
        }
        catch (DocumentException de) {
            Supplier[] supplierArray2 = new Supplier[2];
            supplierArray2[0] = de::getMessage;
            supplierArray2[1] = () -> de;
            LOG.error("generatePdf() DocumentException: {}", supplierArray2);
            throw new PurError("Document Exception when trying to save a Purchase Order PDF", de);
        }
        catch (IOException i) {
            Supplier[] supplierArray3 = new Supplier[2];
            supplierArray3[0] = i::getMessage;
            supplierArray3[1] = () -> i;
            LOG.error("generatePdf() IOException: {}", supplierArray3);
            throw new PurError("IO Exception when trying to save a Purchase Order PDF", i);
        }
        catch (Exception t) {
            Supplier[] supplierArray4 = new Supplier[2];
            supplierArray4[0] = t::getMessage;
            supplierArray4[1] = () -> t;
            LOG.error("generatePdf() EXCEPTION: {}", supplierArray4);
            throw new PurError("Exception when trying to save a Purchase Order PDF", t);
        }
    }

    public void savePdf(PurchaseOrderDocument po, PurchaseOrderParameters pdfParameters, boolean isRetransmit, String environment) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = po::getPurapDocumentIdentifier;
        LOG.debug("savePdf() started for po number {}", supplierArray);
        PurchaseOrderTransmitParameters pdfTransmitParameters = (PurchaseOrderTransmitParameters)pdfParameters;
        this.isRetransmit = isRetransmit;
        String statusInquiryUrl = pdfTransmitParameters.getStatusInquiryUrl();
        String campusName = pdfTransmitParameters.getCampusParameter().getCampus().getName();
        String contractLanguage = pdfTransmitParameters.getContractLanguage();
        String logoImage = pdfTransmitParameters.getLogoImage();
        String directorSignatureImage = pdfTransmitParameters.getDirectorSignatureImage();
        String directorName = pdfTransmitParameters.getCampusParameter().getCampusPurchasingDirectorName();
        String directorTitle = pdfTransmitParameters.getCampusParameter().getCampusPurchasingDirectorTitle();
        String contractManagerSignatureImage = pdfTransmitParameters.getContractManagerSignatureImage();
        String pdfFileLocation = pdfTransmitParameters.getPdfFileLocation();
        String pdfFileName = pdfTransmitParameters.getPdfFileName();
        try {
            Document doc = this.getDocument(9.0f, 9.0f, 70.0f, 36.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(pdfFileLocation + pdfFileName));
            this.createPdf(po, doc, writer, statusInquiryUrl, campusName, contractLanguage, logoImage, directorSignatureImage, directorName, directorTitle, contractManagerSignatureImage, isRetransmit, environment);
        }
        catch (DocumentException de) {
            Supplier[] supplierArray2 = new Supplier[2];
            supplierArray2[0] = de::getMessage;
            supplierArray2[1] = () -> de;
            LOG.error("savePdf() DocumentException: {}", supplierArray2);
            throw new PurError("Document Exception when trying to save a Purchase Order PDF", de);
        }
        catch (FileNotFoundException f) {
            Supplier[] supplierArray3 = new Supplier[2];
            supplierArray3[0] = f::getMessage;
            supplierArray3[1] = () -> f;
            LOG.error("savePdf() FileNotFoundException: {}", supplierArray3);
            throw new PurError("FileNotFound Exception when trying to save a Purchase Order PDF", f);
        }
        catch (IOException i) {
            Supplier[] supplierArray4 = new Supplier[2];
            supplierArray4[0] = i::getMessage;
            supplierArray4[1] = () -> i;
            LOG.error("savePdf() IOException: {}", supplierArray4);
            throw new PurError("IO Exception when trying to save a Purchase Order PDF", i);
        }
        catch (Exception t) {
            Supplier[] supplierArray5 = new Supplier[2];
            supplierArray5[0] = t::getMessage;
            supplierArray5[1] = () -> t;
            LOG.error("savePdf() EXCEPTION: {}", supplierArray5);
            throw new PurError("Exception when trying to save a Purchase Order PDF", t);
        }
    }

    private void createPdf(PurchaseOrderDocument po, Document document, PdfWriter writer, String statusInquiryUrl, String campusName, String contractLanguage, String logoImage, String directorSignatureImage, String directorName, String directorTitle, String contractManagerSignatureImage, boolean isRetransmit, String environment) throws DocumentException, IOException {
        this.createPdf(po, document, writer, statusInquiryUrl, campusName, contractLanguage, logoImage, directorSignatureImage, directorName, directorTitle, contractManagerSignatureImage, isRetransmit, environment, null);
    }

    private void createPdf(PurchaseOrderDocument po, Document document, PdfWriter writer, String statusInquiryUrl, String campusName, String contractLanguage, String logoImage, String directorSignatureImage, String directorName, String directorTitle, String contractManagerSignatureImage, boolean isRetransmit, String environment, List<PurchaseOrderItem> retransmitItems) throws DocumentException, IOException {
        KualiDecimal totalDollarAmount;
        List vendorStipulationsList;
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = po::getPurapDocumentIdentifier;
        LOG.debug("createPdf() started for po number {}", supplierArray);
        this.campusName = campusName;
        this.po = po;
        this.logoImage = logoImage;
        this.environment = environment;
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(Locale.US);
        SimpleDateFormat sdf = PurApDateFormatUtils.getSimpleDateFormat(PurapConstants.NamedDateFormats.KUALI_SIMPLE_DATE_FORMAT_2);
        PurchaseOrderPdf events = new PurchaseOrderPdf().getPageEvents();
        writer.setPageEvent((PdfPageEvent)this);
        document.open();
        LOG.debug("createPdf() info table started.");
        float[] infoWidths = new float[]{0.5f, 0.5f};
        PdfPTable infoTable = new PdfPTable(infoWidths);
        infoTable.setWidthPercentage(100.0f);
        infoTable.setHorizontalAlignment(1);
        infoTable.setSplitLate(false);
        StringBuffer vendorInfo = new StringBuffer();
        vendorInfo.append("\n");
        if (StringUtils.isNotBlank((CharSequence)po.getVendorName())) {
            vendorInfo.append("     ").append(po.getVendorName()).append("\n");
        }
        vendorInfo.append("     ATTN: ").append(po.getVendorAttentionName()).append("\n");
        if (StringUtils.isNotBlank((CharSequence)po.getVendorLine1Address())) {
            vendorInfo.append("     ").append(po.getVendorLine1Address()).append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)po.getVendorLine2Address())) {
            vendorInfo.append("     ").append(po.getVendorLine2Address()).append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)po.getVendorCityName())) {
            vendorInfo.append("     ").append(po.getVendorCityName());
        }
        if (StringUtils.isNotBlank((CharSequence)po.getVendorStateCode())) {
            vendorInfo.append(", ").append(po.getVendorStateCode());
        }
        if (StringUtils.isNotBlank((CharSequence)po.getVendorAddressInternationalProvinceName())) {
            vendorInfo.append(", ").append(po.getVendorAddressInternationalProvinceName());
        }
        if (StringUtils.isNotBlank((CharSequence)po.getVendorPostalCode())) {
            vendorInfo.append(" ").append(po.getVendorPostalCode()).append("\n");
        } else {
            vendorInfo.append("\n");
        }
        if (!"US".equalsIgnoreCase(po.getVendorCountryCode()) && po.getVendorCountry() != null) {
            vendorInfo.append("     ").append(po.getVendorCountry().getName()).append("\n\n");
        } else {
            vendorInfo.append("\n\n");
        }
        Paragraph p = new Paragraph();
        p.add((Element)new Chunk(" Vendor", this.ver_5_normal));
        p.add((Element)new Chunk(vendorInfo.toString(), this.cour_7_normal));
        PdfPCell cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        StringBuffer shipToInfo = new StringBuffer();
        shipToInfo.append("\n");
        if (po.getAddressToVendorIndicator()) {
            shipToInfo.append("     ").append(po.getReceivingName()).append("\n");
            shipToInfo.append("     ").append(po.getReceivingLine1Address()).append("\n");
            if (StringUtils.isNotBlank((CharSequence)po.getReceivingLine2Address())) {
                shipToInfo.append("     ").append(po.getReceivingLine2Address()).append("\n");
            }
            shipToInfo.append("     ").append(po.getReceivingCityName()).append(", ").append(po.getReceivingStateCode()).append(" ").append(po.getReceivingPostalCode()).append("\n");
            if (StringUtils.isNotBlank((CharSequence)po.getReceivingCountryCode()) && !"US".equalsIgnoreCase(po.getReceivingCountryCode())) {
                shipToInfo.append("     ").append(po.getReceivingCountryName()).append("\n");
            }
        } else {
            shipToInfo.append("     ").append(po.getDeliveryToName()).append("\n");
            Object deliveryBuildingName = po.getDeliveryBuildingName() + " ";
            if (po.isDeliveryBuildingOtherIndicator()) {
                deliveryBuildingName = "";
            }
            shipToInfo.append("     ").append((String)deliveryBuildingName).append("Room #").append(po.getDeliveryBuildingRoomNumber()).append("\n");
            shipToInfo.append("     ").append(po.getDeliveryBuildingLine1Address()).append("\n");
            if (StringUtils.isNotBlank((CharSequence)po.getDeliveryBuildingLine2Address())) {
                shipToInfo.append("     ").append(po.getDeliveryBuildingLine2Address()).append("\n");
            }
            shipToInfo.append("     ").append(po.getDeliveryCityName()).append(", ").append(po.getDeliveryStateCode()).append(" ").append(po.getDeliveryPostalCode()).append("\n");
            if (StringUtils.isNotBlank((CharSequence)po.getDeliveryCountryCode()) && !"US".equalsIgnoreCase(po.getDeliveryCountryCode())) {
                shipToInfo.append("     ").append(po.getDeliveryCountryName()).append("\n");
            }
        }
        shipToInfo.append("     ").append(po.getDeliveryToPhoneNumber());
        p = new Paragraph();
        p.add((Element)new Chunk("  Shipping Address", this.ver_5_normal));
        p.add((Element)new Chunk(shipToInfo.toString(), this.cour_7_normal));
        cell = new PdfPCell((Phrase)p);
        infoTable.addCell(cell);
        p = new Paragraph();
        p.add((Element)new Chunk("  Shipping Terms\n", this.ver_5_normal));
        if (po.getVendorShippingPaymentTerms() != null && po.getVendorShippingTitle() != null) {
            p.add((Element)new Chunk("     " + po.getVendorShippingPaymentTerms().getVendorShippingPaymentTermsDescription(), this.cour_7_normal));
            p.add((Element)new Chunk(" - " + po.getVendorShippingTitle().getVendorShippingTitleDescription(), this.cour_7_normal));
        } else if (po.getVendorShippingPaymentTerms() != null && po.getVendorShippingTitle() == null) {
            p.add((Element)new Chunk("     " + po.getVendorShippingPaymentTerms().getVendorShippingPaymentTermsDescription(), this.cour_7_normal));
        } else if (po.getVendorShippingTitle() != null && po.getVendorShippingPaymentTerms() == null) {
            p.add((Element)new Chunk("     " + po.getVendorShippingTitle().getVendorShippingTitleDescription(), this.cour_7_normal));
        }
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        p = new Paragraph();
        p.add((Element)new Chunk("  Payment Terms\n", this.ver_5_normal));
        if (po.getVendorPaymentTerms() != null) {
            p.add((Element)new Chunk("     " + po.getVendorPaymentTerms().getVendorPaymentTermsDescription(), this.cour_7_normal));
        }
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        p = new Paragraph();
        p.add((Element)new Chunk("  Delivery Required By\n", this.ver_5_normal));
        if (po.getDeliveryRequiredDate() != null && po.getDeliveryRequiredDateReason() != null) {
            p.add((Element)new Chunk("     " + sdf.format(po.getDeliveryRequiredDate()), this.cour_7_normal));
            p.add((Element)new Chunk(" - " + po.getDeliveryRequiredDateReason().getDeliveryRequiredDateReasonDescription(), this.cour_7_normal));
        } else if (po.getDeliveryRequiredDate() != null && po.getDeliveryRequiredDateReason() == null) {
            p.add((Element)new Chunk("     " + sdf.format(po.getDeliveryRequiredDate()), this.cour_7_normal));
        } else if (po.getDeliveryRequiredDate() == null && po.getDeliveryRequiredDateReason() != null) {
            p.add((Element)new Chunk("     " + po.getDeliveryRequiredDateReason().getDeliveryRequiredDateReasonDescription(), this.cour_7_normal));
        }
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        p = new Paragraph();
        p.add((Element)new Chunk("  ", this.ver_5_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        float[] nestedInfoWidths = new float[]{0.5f, 0.5f};
        PdfPTable nestedInfoTable = new PdfPTable(nestedInfoWidths);
        nestedInfoTable.setSplitLate(false);
        p = new Paragraph();
        p.add((Element)new Chunk("  Order Date\n", this.ver_5_normal));
        String orderDate = po.getPurchaseOrderInitialOpenTimestamp() != null ? sdf.format(po.getPurchaseOrderInitialOpenTimestamp()) : sdf.format(this.getDateTimeService().getCurrentSqlDate());
        p.add((Element)new Chunk("     " + orderDate, this.cour_7_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        nestedInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Element)new Chunk("  Customer #\n", this.ver_5_normal));
        if (po.getVendorCustomerNumber() != null) {
            p.add((Element)new Chunk("     " + po.getVendorCustomerNumber(), this.cour_7_normal));
        }
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        nestedInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Element)new Chunk("  Delivery Instructions\n", this.ver_5_normal));
        if (StringUtils.isNotBlank((CharSequence)po.getDeliveryInstructionText())) {
            p.add((Element)new Chunk("     " + po.getDeliveryInstructionText(), this.cour_7_normal));
        }
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        nestedInfoTable.addCell(cell);
        p = new Paragraph();
        p.add((Element)new Chunk("  Contract ID\n", this.ver_5_normal));
        if (po.getVendorContract() != null) {
            p.add((Element)new Chunk(po.getVendorContract().getVendorContractName(), this.cour_7_normal));
        }
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        nestedInfoTable.addCell(cell);
        cell = new PdfPCell(nestedInfoTable);
        cell.setHorizontalAlignment(1);
        infoTable.addCell(cell);
        StringBuffer billToInfo = new StringBuffer();
        billToInfo.append("\n");
        billToInfo.append("     ").append(po.getBillingName()).append("\n");
        billToInfo.append("     ").append(po.getBillingLine1Address()).append("\n");
        if (po.getBillingLine2Address() != null) {
            billToInfo.append("     ").append(po.getBillingLine2Address()).append("\n");
        }
        billToInfo.append("     ").append(po.getBillingCityName()).append(", ").append(po.getBillingStateCode()).append(" ").append(po.getBillingPostalCode()).append("\n");
        if (po.getBillingPhoneNumber() != null) {
            billToInfo.append("     ").append(po.getBillingPhoneNumber());
        }
        if (po.getBillingEmailAddress() != null) {
            billToInfo.append("\n     ").append(po.getBillingEmailAddress());
        }
        p = new Paragraph();
        p.add((Element)new Chunk("  Billing Address", this.ver_5_normal));
        p.add((Element)new Chunk("     " + billToInfo.toString(), this.cour_7_normal));
        p.add((Element)new Chunk("\n Invoice status inquiry: " + statusInquiryUrl, this.ver_6_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(0);
        infoTable.addCell(cell);
        document.add((Element)infoTable);
        PdfPTable notesStipulationsTable = new PdfPTable(1);
        notesStipulationsTable.setWidthPercentage(100.0f);
        notesStipulationsTable.setSplitLate(false);
        p = new Paragraph();
        p.add((Element)new Chunk("  Vendor Note(s)\n", this.ver_5_normal));
        if (po.getVendorNoteText() != null) {
            p.add((Element)new Chunk("     " + po.getVendorNoteText() + "\n", this.cour_7_normal));
        }
        PdfPCell tableCell = new PdfPCell((Phrase)p);
        tableCell.setHorizontalAlignment(0);
        tableCell.setVerticalAlignment(4);
        notesStipulationsTable.addCell(tableCell);
        p = new Paragraph();
        p.add((Element)new Chunk("  Vendor Stipulations and Information\n", this.ver_5_normal));
        if (po.getPurchaseOrderBeginDate() != null && po.getPurchaseOrderEndDate() != null) {
            p.add((Element)new Chunk("     Order in effect from " + sdf.format(po.getPurchaseOrderBeginDate()) + " to " + sdf.format(po.getPurchaseOrderEndDate()) + ".\n", this.cour_7_normal));
        }
        if ((vendorStipulationsList = po.getPurchaseOrderVendorStipulations()).size() > 0) {
            StringBuffer vendorStipulations = new StringBuffer();
            for (PurchaseOrderVendorStipulation povs : vendorStipulationsList) {
                vendorStipulations.append("     ").append(povs.getVendorStipulationDescription()).append("\n");
            }
            p.add((Element)new Chunk("     " + vendorStipulations.toString(), this.cour_7_normal));
        }
        tableCell = new PdfPCell((Phrase)p);
        tableCell.setHorizontalAlignment(0);
        tableCell.setVerticalAlignment(4);
        notesStipulationsTable.addCell(tableCell);
        document.add((Element)notesStipulationsTable);
        LOG.debug("createPdf() items table started.");
        float[] itemsWidths = new float[]{0.07f, 0.1f, 0.07f, 0.45f, 0.15f, 0.15f};
        if (!po.isUseTaxIndicator()) {
            itemsWidths = ArrayUtils.add((float[])itemsWidths, (float)0.14f);
            itemsWidths = ArrayUtils.add((float[])itemsWidths, (float)0.15f);
        }
        PdfPTable itemsTable = new PdfPTable(itemsWidths.length);
        itemsTable.setWidthPercentage(100.0f);
        itemsTable.setWidths(itemsWidths);
        itemsTable.setSplitLate(false);
        tableCell = new PdfPCell((Phrase)new Paragraph("Item\nNo.", this.ver_5_normal));
        tableCell.setHorizontalAlignment(1);
        itemsTable.addCell(tableCell);
        tableCell = new PdfPCell((Phrase)new Paragraph("Quantity", this.ver_5_normal));
        tableCell.setHorizontalAlignment(1);
        itemsTable.addCell(tableCell);
        tableCell = new PdfPCell((Phrase)new Paragraph("UOM", this.ver_5_normal));
        tableCell.setHorizontalAlignment(1);
        itemsTable.addCell(tableCell);
        tableCell = new PdfPCell((Phrase)new Paragraph("Description", this.ver_5_normal));
        tableCell.setHorizontalAlignment(1);
        itemsTable.addCell(tableCell);
        tableCell = new PdfPCell((Phrase)new Paragraph("Unit Cost", this.ver_5_normal));
        tableCell.setHorizontalAlignment(1);
        itemsTable.addCell(tableCell);
        tableCell = new PdfPCell((Phrase)new Paragraph("Extended Cost", this.ver_5_normal));
        tableCell.setHorizontalAlignment(1);
        itemsTable.addCell(tableCell);
        if (!po.isUseTaxIndicator()) {
            tableCell = new PdfPCell((Phrase)new Paragraph("Tax Amount", this.ver_5_normal));
            tableCell.setHorizontalAlignment(1);
            itemsTable.addCell(tableCell);
            tableCell = new PdfPCell((Phrase)new Paragraph("Total Amount", this.ver_5_normal));
            tableCell.setHorizontalAlignment(1);
            itemsTable.addCell(tableCell);
        }
        List itemsList = isRetransmit ? retransmitItems : po.getItems();
        for (PurchaseOrderItem poi : itemsList) {
            if (poi.getItemType() == null || !poi.getItemType().isLineItemIndicator() && !poi.getItemType().getItemTypeCode().equals("SPHD") && !poi.getItemType().getItemTypeCode().equals("FRHT") && !poi.getItemType().getItemTypeCode().equals("ORDS") && !poi.getItemType().getItemTypeCode().equals("TRDI") || !this.lineItemDisplaysOnPdf(poi)) continue;
            Object description = poi.getItemCatalogNumber() != null ? poi.getItemCatalogNumber().trim() + " - " : "";
            if (StringUtils.isNotBlank((CharSequence)(description = (String)description + (poi.getItemDescription() != null ? poi.getItemDescription().trim() : ""))) && (poi.getItemType().getItemTypeCode().equals("ORDS") || poi.getItemType().getItemTypeCode().equals("TRDI") || poi.getItemType().getItemTypeCode().equals("FRHT") || poi.getItemType().getItemTypeCode().equals("SPHD"))) {
                description = poi.getItemType().getItemTypeDescription() + " - " + (String)description;
            }
            tableCell = poi.getItemType().isLineItemIndicator() ? new PdfPCell((Phrase)new Paragraph(poi.getItemLineNumber().toString(), this.cour_7_normal)) : new PdfPCell((Phrase)new Paragraph(" ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(1);
            itemsTable.addCell(tableCell);
            String quantity = poi.getItemQuantity() != null ? poi.getItemQuantity().toString() : " ";
            tableCell = new PdfPCell((Phrase)new Paragraph(quantity, this.cour_7_normal));
            tableCell.setHorizontalAlignment(1);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
            tableCell = new PdfPCell((Phrase)new Paragraph(poi.getItemUnitOfMeasureCode(), this.cour_7_normal));
            tableCell.setHorizontalAlignment(1);
            itemsTable.addCell(tableCell);
            tableCell = new PdfPCell((Phrase)new Paragraph(" " + (String)description, this.cour_7_normal));
            tableCell.setHorizontalAlignment(0);
            itemsTable.addCell(tableCell);
            String unitPrice = poi.getItemUnitPrice().setScale(4, RoundingMode.HALF_UP).toString();
            tableCell = new PdfPCell((Phrase)new Paragraph(unitPrice + " ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(2);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
            tableCell = new PdfPCell((Phrase)new Paragraph(numberFormat.format(poi.getExtendedPrice()) + " ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(2);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
            if (po.isUseTaxIndicator()) continue;
            KualiDecimal taxAmount = poi.getItemTaxAmount();
            taxAmount = taxAmount == null ? KualiDecimal.ZERO : taxAmount;
            tableCell = new PdfPCell((Phrase)new Paragraph(numberFormat.format(taxAmount) + " ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(2);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
            tableCell = new PdfPCell((Phrase)new Paragraph(numberFormat.format(poi.getTotalAmount()) + " ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(2);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
        }
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        if (!po.isUseTaxIndicator()) {
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
        }
        if (!po.isUseTaxIndicator()) {
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            tableCell = new PdfPCell((Phrase)new Paragraph("Total Prior to Tax: ", this.ver_10_normal));
            tableCell.setHorizontalAlignment(2);
            itemsTable.addCell(tableCell);
            itemsTable.addCell(" ");
            totalDollarAmount = po instanceof PurchaseOrderRetransmitDocument ? ((PurchaseOrderRetransmitDocument)po).getTotalPreTaxDollarAmountForRetransmit() : po.getTotalPreTaxDollarAmount();
            tableCell = new PdfPCell((Phrase)new Paragraph(numberFormat.format(totalDollarAmount) + " ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(2);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
            tableCell = new PdfPCell((Phrase)new Paragraph("Total Tax: ", this.ver_10_normal));
            tableCell.setHorizontalAlignment(2);
            itemsTable.addCell(tableCell);
            itemsTable.addCell(" ");
            totalDollarAmount = po instanceof PurchaseOrderRetransmitDocument ? ((PurchaseOrderRetransmitDocument)po).getTotalTaxDollarAmountForRetransmit() : po.getTotalTaxAmount();
            tableCell = new PdfPCell((Phrase)new Paragraph(numberFormat.format(totalDollarAmount) + " ", this.cour_7_normal));
            tableCell.setHorizontalAlignment(2);
            tableCell.setNoWrap(true);
            itemsTable.addCell(tableCell);
        }
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        if (!po.isUseTaxIndicator()) {
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
        }
        tableCell = new PdfPCell((Phrase)new Paragraph("Total order amount: ", this.ver_10_normal));
        tableCell.setHorizontalAlignment(2);
        itemsTable.addCell(tableCell);
        itemsTable.addCell(" ");
        totalDollarAmount = po instanceof PurchaseOrderRetransmitDocument ? ((PurchaseOrderRetransmitDocument)po).getTotalDollarAmountForRetransmit() : po.getTotalDollarAmount();
        tableCell = new PdfPCell((Phrase)new Paragraph(numberFormat.format(totalDollarAmount) + " ", this.cour_7_normal));
        tableCell.setHorizontalAlignment(2);
        tableCell.setNoWrap(true);
        itemsTable.addCell(tableCell);
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        itemsTable.addCell(" ");
        if (!po.isUseTaxIndicator()) {
            itemsTable.addCell(" ");
            itemsTable.addCell(" ");
        }
        document.add((Element)itemsTable);
        LOG.debug("createPdf() contract language started.");
        document.add((Element)new Paragraph(contractLanguage, this.ver_6_normal));
        document.add((Element)new Paragraph("\n", this.ver_6_normal));
        LOG.debug("createPdf() signatures table started.");
        float[] signaturesWidths = new float[]{0.3f, 0.7f};
        PdfPTable signaturesTable = new PdfPTable(signaturesWidths);
        signaturesTable.setWidthPercentage(100.0f);
        signaturesTable.setHorizontalAlignment(1);
        signaturesTable.setSplitLate(false);
        if (po.getPurchaseOrderAutomaticIndicator()) {
            cell = new PdfPCell((Phrase)new Paragraph(" ", this.cour_7_normal));
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
            p = StringUtils.isBlank((CharSequence)po.getInstitutionContactName()) || StringUtils.isBlank((CharSequence)po.getInstitutionContactPhoneNumber()) || StringUtils.isBlank((CharSequence)po.getInstitutionContactEmailAddress()) ? new Paragraph("For more information contact: " + po.getRequestorPersonName() + "  " + po.getRequestorPersonPhoneNumber() + "  " + po.getRequestorPersonEmailAddress(), this.cour_7_normal) : new Paragraph("For more information contact: " + po.getInstitutionContactName() + "  " + po.getInstitutionContactPhoneNumber() + "  " + po.getInstitutionContactEmailAddress(), this.cour_7_normal);
            cell = new PdfPCell((Phrase)p);
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(1);
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
            Image directorSignature = null;
            if (StringUtils.isNotBlank((CharSequence)directorSignatureImage)) {
                try {
                    directorSignature = Image.getInstance((String)directorSignatureImage);
                }
                catch (FileNotFoundException e) {
                    LOG.info("The director signature image [{}] is not available.  Defaulting to the default image.", (Object)directorSignatureImage);
                }
            }
            if (directorSignature == null) {
                cell = new PdfPCell();
            } else {
                directorSignature.scalePercent(30.0f, 30.0f);
                cell = new PdfPCell(directorSignature, false);
            }
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(6);
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph(" ", this.cour_7_normal));
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
        }
        p = new Paragraph();
        LOG.debug("createPdf() directorName parameter: {}", (Object)directorName);
        if (po.getPurchaseOrderAutomaticIndicator()) {
            p.add((Element)new Chunk(directorName, this.ver_6_normal));
        } else {
            p.add((Element)new Chunk(directorName, this.ver_10_normal));
        }
        p.add((Element)new Chunk("\n" + directorTitle, this.ver_4_normal));
        cell = new PdfPCell((Phrase)p);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(4);
        cell.setBorderWidth(0.0f);
        signaturesTable.addCell(cell);
        if (!po.getPurchaseOrderAutomaticIndicator()) {
            Image contractManagerSignature = null;
            if (StringUtils.isNotBlank((CharSequence)contractManagerSignatureImage)) {
                try {
                    contractManagerSignature = Image.getInstance((String)contractManagerSignatureImage);
                }
                catch (IOException e) {
                    LOG.info("The contract manager image [{}] is not available.  Defaulting to the default image.", (Object)contractManagerSignatureImage);
                }
            }
            if (contractManagerSignature == null) {
                cell = new PdfPCell();
            } else {
                contractManagerSignature.scalePercent(15.0f, 15.0f);
                cell = new PdfPCell(contractManagerSignature, false);
            }
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(6);
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph(" ", this.ver_10_normal));
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph(po.getContractManager().getContractManagerName() + "  " + po.getContractManager().getContractManagerPhoneNumber(), this.cour_7_normal));
            cell.setHorizontalAlignment(2);
            cell.setVerticalAlignment(4);
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
        } else {
            cell = new PdfPCell((Phrase)new Paragraph(" ", this.ver_10_normal));
            cell.setBorderWidth(0.0f);
            signaturesTable.addCell(cell);
        }
        document.add((Element)signaturesTable);
        document.close();
        LOG.debug("createPdf()pdf document closed.");
    }

    private boolean lineItemDisplaysOnPdf(PurchaseOrderItem poi) {
        LOG.debug("lineItemDisplaysOnPdf() started");
        if (poi.getItemType() != null && (poi.getItemType().getItemTypeCode().equals("SPHD") || poi.getItemType().getItemTypeCode().equals("FRHT") || poi.getItemType().getItemTypeCode().equals("ORDS") || poi.getItemType().getItemTypeCode().equals("TRDI"))) {
            if (poi.getItemUnitPrice() != null && (poi.getItemUnitPrice().compareTo(zero.bigDecimalValue()) == 1 || poi.getItemType().getItemTypeCode().equals("ORDS") || poi.getItemType().getItemTypeCode().equals("TRDI"))) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> poi.getItemType().getItemTypeCode();
                supplierArray[1] = poi::getItemUnitPrice;
                LOG.debug("lineItemDisplaysOnPdf() Item type is {}. Unit price is {}. Display on pdf.", supplierArray);
                return true;
            }
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> poi.getItemType().getItemTypeCode();
            supplierArray[1] = poi::getItemUnitPrice;
            LOG.debug("lineItemDisplaysOnPdf() Item type is {}. Unit price is {}. Don't display on pdf.", supplierArray);
            return false;
        }
        if (poi.getItemType() != null && poi.getItemType().isLineItemIndicator()) {
            if (poi.getItemQuantity() == null && poi.getItemUnitPrice() == null) {
                LOG.debug("lineItemDisplaysOnPdf() Item type is {} OrderQuantity and unit price are both null. Display on pdf.", new Supplier[]{() -> poi.getItemType().getItemTypeCode()});
                return true;
            }
            if (poi.getItemType().isAmountBasedGeneralLedgerIndicator() && poi.getItemUnitPrice() != null && poi.getItemUnitPrice().compareTo(zero.bigDecimalValue()) >= 0 || poi.getItemType().isQuantityBasedGeneralLedgerIndicator() && poi.getItemQuantity().isGreaterThan((AbstractKualiDecimal)zero) && poi.getItemUnitPrice() != null) {
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = () -> poi.getItemType().getItemTypeCode();
                supplierArray[1] = poi::getItemQuantity;
                supplierArray[2] = poi::getItemUnitPrice;
                LOG.debug("lineItemDisplaysOnPdf() Item type is {} OrderQuantity is {}. Unit price is {}. Display on pdf.", supplierArray);
                return true;
            }
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> poi.getItemType().getItemTypeCode();
            supplierArray[1] = poi::getItemQuantity;
            supplierArray[2] = poi::getItemUnitPrice;
            LOG.debug("lineItemDisplaysOnPdf() Item type is {} and item order quantity is {} and item unit price is {}. Don't display on pdf.", supplierArray);
        }
        return false;
    }
}

