/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.datadictionary.FieldDefinition;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileArranger;
import org.kuali.kfs.module.tem.businessobject.TemProfileFromCustomer;
import org.kuali.kfs.module.tem.businessobject.TemProfileFromKimPerson;
import org.kuali.kfs.module.tem.businessobject.datadictionary.TravelDetailLookupMappedFieldProxy;
import org.kuali.kfs.module.tem.document.authorization.TemProfileAuthorizer;
import org.kuali.kfs.module.tem.document.service.TravelArrangerDocumentService;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TemRoleService;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.framework.persistence.ojb.conversion.OjbCharBooleanConversion;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.IdentityManagementService;
import org.kuali.rice.krad.bo.BusinessObject;

public class TemProfileLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    public static Logger LOG = Logger.getLogger(TemProfileLookupableHelperServiceImpl.class);
    private TemRoleService temRoleService;
    private TravelerService travelerService;
    private PersonService personService;
    private TemProfileService temProfileService;
    private IdentityManagementService identityManagementService;
    private TravelArrangerDocumentService travelArrangerDocumentService;
    private static final String[] addressLookupFields = new String[]{"temProfileAddress.streetAddressLine1", "temProfileAddress.streetAddressLine2", "temProfileAddress.cityName", "temProfileAddress.stateCode", "temProfileAddress.zipCode", "temProfileAddress.countryCode"};

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        boolean arrangeesOnly = false;
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        if (fieldValues != null) {
            String arrangeesOnlyValue;
            String[] primaryDepartmentCode;
            String homeDepartment = fieldValues.get("homeDepartment");
            if (homeDepartment != null && (primaryDepartmentCode = homeDepartment.split("-")) != null) {
                if (primaryDepartmentCode.length == 2) {
                    fieldValues.put("homeDeptOrgCode", primaryDepartmentCode[1]);
                }
                fieldValues.put("homeDeptChartOfAccountsCode", primaryDepartmentCode[0]);
                fieldValues.remove("homeDepartment");
            }
            if (fieldValues.containsKey("onlyArrangeesInLookup") && !StringUtils.isBlank((String)(arrangeesOnlyValue = fieldValues.remove("onlyArrangeesInLookup")))) {
                OjbCharBooleanConversion booleanConverter = new OjbCharBooleanConversion();
                Boolean arrangeesOnlyBool = (Boolean)booleanConverter.sqlToJava((Object)arrangeesOnlyValue);
                arrangeesOnly = arrangeesOnlyBool;
            }
        }
        List searchResults = super.getSearchResults(fieldValues);
        ArrayList<TemProfile> profiles = new ArrayList<TemProfile>();
        for (TemProfile profile : searchResults) {
            if (!StringUtils.isBlank((String)profile.getPrincipalId())) {
                this.getTravelerService().populateTemProfile(profile);
            }
            if (arrangeesOnly && !this.isArranger(currentUser, profile)) continue;
            profiles.add(profile);
        }
        Map<String, String> kimLookupFields = this.convertFieldValues(Person.class, fieldValues, "", TemProfile.class.getName());
        if (this.kimLookupNeeded(fieldValues)) {
            List people = this.getPersonService().findPeople(kimLookupFields);
            block1: for (Person person : people) {
                TemProfile profileFromKim = this.getTemProfileService().findTemProfileByPrincipalId(person.getPrincipalId());
                if (!ObjectUtils.isNotNull((Object)((Object)profileFromKim))) continue;
                this.getTravelerService().populateTemProfile(profileFromKim);
                Boolean isFound = false;
                for (TemProfile profile : profiles) {
                    if (profile.getProfileId() != profileFromKim.getProfileId()) continue;
                    isFound = true;
                    continue block1;
                }
            }
        }
        return profiles;
    }

    protected boolean isArranger(Person possibleArranger, TemProfile possibleArrangee) {
        if (possibleArranger == null) {
            return false;
        }
        if (possibleArrangee == null) {
            return false;
        }
        TemProfileArranger temProfileArranger = this.getTravelArrangerDocumentService().findTemProfileArranger(possibleArranger.getPrincipalId(), possibleArrangee.getProfileId());
        boolean isOrganizationalApprover = this.getTravelerService().isArrangeeByOrganization(possibleArranger.getPrincipalId(), possibleArrangee);
        return temProfileArranger != null || isOrganizationalApprover;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (this.allowsMaintenanceEditAction(businessObject)) {
            htmlDataList.add((HtmlData)this.getUrlData(businessObject, "edit", pkNames));
        }
        if (this.allowsMaintenanceDeleteAction(businessObject)) {
            htmlDataList.add((HtmlData)this.getUrlData(businessObject, "delete", pkNames));
        }
        return htmlDataList;
    }

    private boolean kimLookupNeeded(Map<String, String> fieldValues) {
        for (String key : addressLookupFields) {
            if (fieldValues.get(key) == null) continue;
            return true;
        }
        return false;
    }

    protected String getReturnHref(Properties parameters, LookupForm lookupForm, List returnKeys) {
        String url = super.getReturnHref(parameters, lookupForm, returnKeys);
        url = url.replaceAll("profileId", "document.profileId");
        return url;
    }

    public String getSupplementalMenuBar() {
        if (this.parameters.containsKey("docNum")) {
            return "";
        }
        UserSession user = GlobalVariables.getUserSession();
        TemProfileAuthorizer authorizer = (TemProfileAuthorizer)((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer("TTP");
        TemProfile dummyProfile = new TemProfile();
        ChartOrgHolder chartOrg = ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPrimaryOrganization(user.getPerson(), "KFS-TEM");
        dummyProfile.setHomeDeptChartOfAccountsCode(chartOrg.getChartOfAccountsCode());
        dummyProfile.setHomeDeptOrgCode(chartOrg.getOrganizationCode());
        boolean canCreateNewProfile = authorizer.canCreateAnyProfile((BusinessObject)dummyProfile, user.getPerson());
        boolean canCreateMyProfile = false;
        HashMap<String, String> criteria = new HashMap<String, String>(2);
        criteria.put("principalId", user.getPrincipalId());
        if (this.getTemProfileService().findTemProfile(criteria) == null) {
            canCreateMyProfile = authorizer.canEditOwnProfile((BusinessObject)dummyProfile, user.getPerson());
        }
        String url = "<div class=\"createnew\" title=\"Create TEM Profile\">";
        String imageBaseUrl = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("externalizable.images.url");
        Properties myProfileParameters = new Properties();
        myProfileParameters.put("methodToCall", "start");
        myProfileParameters.put("businessObjectClassName", TemProfile.class.getName());
        myProfileParameters.put("overrideKeys", "principalId");
        myProfileParameters.put("refreshCaller", "principalId::" + user.getPrincipalId());
        myProfileParameters.put("principalId", user.getPrincipalId());
        String createMineUrl = UrlFactory.parameterizeUrl((String)"maintenance.do", (Properties)myProfileParameters);
        if (canCreateMyProfile) {
            url = url + "<a title=\"Create My Profile\" href=\"" + createMineUrl + "\"><span class=\"create-new btn btn-primary\"><span class=\"glyphicon glyphicon-plus\"></span>Create My Profile</span></a>";
        }
        if (canCreateNewProfile) {
            Properties parameters = new Properties();
            parameters.put("businessObjectClassName", TemProfileFromKimPerson.class.getName());
            parameters.put("docFormKey", "88888888");
            parameters.put("methodToCall", "start");
            String personUrl = UrlFactory.parameterizeUrl((String)"lookup.do", (Properties)parameters);
            url = url + "<a title=\"Create New From KIM\" href=\"" + personUrl + "\"><span class=\"create-new btn btn-primary\"><span class=\"glyphicon glyphicon-plus\"></span>Create New From KIM</span></a>";
            Properties custParameters = new Properties();
            custParameters.put("businessObjectClassName", TemProfileFromCustomer.class.getName());
            custParameters.put("docFormKey", "88888888");
            custParameters.put("methodToCall", "start");
            String custUrl = UrlFactory.parameterizeUrl((String)"lookup.do", (Properties)custParameters);
            url = url + "&nbsp;<a title=\"Create New From Customer\" href=\"" + custUrl + "\"><span class=\"create-new btn btn-primary\"><span class=\"glyphicon glyphicon-plus\"></span>Create New From Customer</span></a>";
        }
        url = url + "</div>";
        return url;
    }

    private Map<String, String> convertFieldValues(Class<? extends BusinessObject> boClass, Map<String, String> fieldValues, String prefix, String lookupClassName) {
        HashMap<String, String> retval = new HashMap<String, String>();
        LOG.debug((Object)("Converting field values " + fieldValues));
        for (FieldDefinition lookupField : this.getLookupFieldsFor(lookupClassName)) {
            String attrName = lookupField.getAttributeName();
            if (lookupField instanceof TravelDetailLookupMappedFieldProxy) {
                TravelDetailLookupMappedFieldProxy mappedField = (TravelDetailLookupMappedFieldProxy)lookupField;
                String key = mappedField.getAttributeMap().get(boClass.getSimpleName());
                String value = fieldValues.get(attrName);
                if (retval.containsKey(key)) {
                    value = (String)retval.get(key) + value;
                }
                if (key != null) {
                    retval.put(prefix + key, value);
                    continue;
                }
                LOG.warn((Object)("Got a null key for attribute name " + attrName));
                continue;
            }
            if (!this.containsAttribute(boClass, attrName)) continue;
            retval.put(prefix + attrName, fieldValues.get(attrName));
        }
        return retval;
    }

    protected boolean containsAttribute(Class boClass, String attributeName) {
        return this.getDataDictionaryService().isAttributeDefined(boClass, attributeName);
    }

    private Collection<FieldDefinition> getLookupFieldsFor(String className) {
        BusinessObjectEntry businessObjectEntry = (BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(className);
        return businessObjectEntry.getLookupDefinition().getLookupFields();
    }

    public TemRoleService getTemRoleService() {
        return this.temRoleService;
    }

    public void setTemRoleService(TemRoleService temRoleService) {
        this.temRoleService = temRoleService;
    }

    public TravelerService getTravelerService() {
        return this.travelerService;
    }

    public void setTravelerService(TravelerService travelerService) {
        this.travelerService = travelerService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public TemProfileService getTemProfileService() {
        return this.temProfileService;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }

    public IdentityManagementService getIdentityManagementService() {
        return this.identityManagementService;
    }

    public void setIdentityManagementService(IdentityManagementService identityManagementService) {
        this.identityManagementService = identityManagementService;
    }

    public TravelArrangerDocumentService getTravelArrangerDocumentService() {
        return this.travelArrangerDocumentService;
    }

    public void setTravelArrangerDocumentService(TravelArrangerDocumentService travelArrangerDocumentService) {
        this.travelArrangerDocumentService = travelArrangerDocumentService;
    }
}

