/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.identity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;

public class TemProfileDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected BusinessObjectService businessObjectService;

    protected List<String> getRequiredAttributes() {
        ArrayList<String> attrs = new ArrayList<String>(super.getRequiredAttributes());
        attrs.add("profilePrincipalId");
        return Collections.unmodifiableList(attrs);
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        String principalId;
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>(1);
        if (qualification != null && !qualification.isEmpty() && StringUtils.isNotBlank((String)(principalId = qualification.get("profilePrincipalId"))) && (this.hasProfile(principalId) || this.isCreatingProfile(qualification))) {
            members.add(RoleMembership.Builder.create((String)"", (String)"", (String)principalId, (MemberType)MemberType.PRINCIPAL, null).build());
        }
        return members;
    }

    protected boolean hasProfile(String profilePrincipalId) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("principalId", profilePrincipalId);
        fieldValues.put("active", Boolean.TRUE);
        int profileCount = this.getBusinessObjectService().countMatching(TemProfile.class, fieldValues);
        return profileCount > 0;
    }

    protected boolean isCreatingProfile(Map<String, String> qualification) {
        if (qualification.containsKey("documentTypeName") && qualification.containsKey("maintenanceAction")) {
            String documentTypeName = qualification.get("documentTypeName");
            String maintenanceAction = qualification.get("maintenanceAction");
            return StringUtils.equals((String)documentTypeName, (String)"TTP") && StringUtils.equals((String)maintenanceAction, (String)"New");
        }
        return false;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

