/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.tem.businessobject.TravelPayment;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelEntertainmentDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.service.TravelEntertainmentDocumentService;
import org.kuali.kfs.module.tem.pdf.Coversheet;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.AccountingDocumentSaveWithNoLedgerEntryGenerationEvent;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class TravelEntertainmentServiceTest
extends KualiTestBase {
    private static final int EXPENSE_AMOUNT = 100;
    private TravelEntertainmentDocument ent = null;
    private TravelerDetail traveler = null;
    private TravelEntertainmentDocumentService entservice;
    private TravelDocumentService service;
    private DocumentService documentService;
    private static final Logger LOG = Logger.getLogger(TravelEntertainmentServiceTest.class);

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.entservice = (TravelEntertainmentDocumentService)SpringContext.getBean(TravelEntertainmentDocumentService.class);
        this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        this.ent = (TravelEntertainmentDocument)DocumentTestUtils.createDocument((DocumentService)this.documentService, TravelEntertainmentDocument.class);
        this.documentService.prepareWorkflowDocument((Document)this.ent);
        this.traveler = new TravelerDetail(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        this.traveler.setTravelerTypeCode("EMP");
        this.traveler.setCustomer((AccountsReceivableCustomer)new Customer());
        this.ent.setTraveler(this.traveler);
        this.ent.setHostAsPayee(Boolean.valueOf(true));
        this.ent.setTravelPayment(new TravelPayment());
        this.ent.getTravelPayment().setDocumentationLocationCode("N");
    }

    @After
    public void tearDown() throws Exception {
        this.entservice = null;
        super.tearDown();
    }

    @Test
    public void testFindByTravelDocumentIdentifier() throws WorkflowException {
        this.documentService.saveDocument((Document)this.ent, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        List result = (List)this.entservice.findByTravelId("-1");
        TravelEntertainmentServiceTest.assertNotNull((Object)result);
        TravelEntertainmentServiceTest.assertTrue((boolean)result.isEmpty());
        result = (List)this.entservice.findByTravelId(this.ent.getTravelDocumentIdentifier());
        TravelEntertainmentServiceTest.assertNotNull((Object)result);
        TravelEntertainmentServiceTest.assertFalse((boolean)result.isEmpty());
    }

    @Test
    public void testFindByDocumentNumber() throws WorkflowException {
        TravelEntertainmentServiceTest.assertNull((Object)this.entservice.find(this.ent.getDocumentHeader().getDocumentNumber()));
        this.documentService.saveDocument((Document)this.ent, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        TravelEntertainmentServiceTest.assertNotNull((Object)this.entservice.find(this.ent.getDocumentHeader().getDocumentNumber()));
    }

    @Test
    public void testAddListenersTo() {
        boolean success = false;
        try {
            this.entservice.addListenersTo(this.ent);
            success = true;
        }
        catch (NullPointerException e) {
            success = false;
            LOG.warn((Object)"NPE.", (Throwable)e);
        }
        TravelEntertainmentServiceTest.assertTrue((boolean)success);
    }

    @Test
    public void testGenerateCoversheetFor() throws Exception {
        Coversheet cover = null;
        try {
            cover = this.entservice.generateCoversheetFor(new TravelEntertainmentDocument());
        }
        catch (RuntimeException e) {
            LOG.warn((Object)"Workflow doc is null.", (Throwable)e);
        }
        TravelEntertainmentServiceTest.assertNull((Object)cover);
        this.ent.setTripBegin(new Timestamp(new Date().getTime()));
        this.ent.setTripEnd(new Timestamp(new Date().getTime()));
        cover = this.entservice.generateCoversheetFor(this.ent);
        TravelEntertainmentServiceTest.assertNotNull((Object)cover);
    }
}

