/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.module.tem.batch.service.DataReportService;
import org.kuali.kfs.module.tem.util.MessageUtils;
import org.kuali.kfs.sys.MessageBuilder;
import org.kuali.kfs.sys.report.BusinessObjectReportHelper;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.BusinessObject;

public class DataReportServiceImpl
implements DataReportService {
    public static Logger LOG = Logger.getLogger(DataReportServiceImpl.class);
    public static final String REPORT_FILE_NAME_PATTERN = "{0}/{1}_{2}{3}";
    private DateTimeService dateTimeService;

    @Override
    public <T extends BusinessObject> void writeToReport(PrintStream reportDataStream, T tableData, List<ErrorMessage> errors, BusinessObjectReportHelper reportHelper) {
        String reportEntry = this.formatMessage(tableData, this.getMessageAsString(errors), reportHelper);
        reportDataStream.println(reportEntry);
    }

    private <T extends BusinessObject> String formatMessage(T tableData, String errors, BusinessObjectReportHelper reportHelper) {
        StringBuilder body = new StringBuilder();
        Map tableDefinition = new LinkedHashMap();
        List propertyList = new ArrayList();
        tableDefinition = reportHelper.getTableDefinition();
        propertyList = reportHelper.getTableCellValues(tableData, false);
        String tableCellFormat = (String)tableDefinition.get("tableCellFormat");
        String fieldLine = String.format(tableCellFormat, propertyList.toArray());
        body.append(fieldLine);
        body.append("\n");
        if (StringUtils.isNotEmpty((String)errors)) {
            body.append("**** ERROR(S): **** ").append("\n").append(errors).append("\n");
        }
        return body.toString();
    }

    @Override
    public void writeReportHeader(PrintStream reportDataStream, String fileName, String reportHeader, BusinessObjectReportHelper reportHelper) {
        StringBuilder header = new StringBuilder();
        header.append(MessageBuilder.buildMessageWithPlaceHolder((String)reportHeader, (Object[])new Object[]{"\n", fileName}));
        header.append("\n");
        header.append("\n");
        header.append("\n");
        Map tableDefinition = reportHelper.getTableDefinition();
        String tableHeaderFormat = (String)tableDefinition.get("tableHeaderLine");
        header.append(tableHeaderFormat);
        reportDataStream.print(header);
    }

    @Override
    public PrintStream getReportPrintStream(String directory, String filePrefix) {
        String dateTime = this.dateTimeService.toDateTimeStringForFilename((Date)this.dateTimeService.getCurrentSqlDate());
        String reportFileName = MessageFormat.format(REPORT_FILE_NAME_PATTERN, directory, filePrefix, dateTime, ".txt");
        File outputfile = new File(reportFileName);
        try {
            return new PrintStream(outputfile);
        }
        catch (FileNotFoundException e) {
            String errorMessage = "Cannot find the output file: " + reportFileName;
            LOG.error((Object)errorMessage);
            throw new RuntimeException(errorMessage, e);
        }
    }

    @Override
    public String getMessageAsString(List<ErrorMessage> errorMessages) {
        ArrayList<String> messageList = new ArrayList<String>();
        for (ErrorMessage error : errorMessages) {
            messageList.add(MessageUtils.getErrorMessage(error));
        }
        StrBuilder builder = new StrBuilder();
        builder.appendWithSeparators(messageList, "\n");
        return builder.toString();
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

