/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.util.LinkedHashMap;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.AbstractExpense;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeAware;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.sys.context.SpringContext;

@Entity
@Table(name="TEM_TRVL_EXP_T")
public class ImportedExpense
extends AbstractExpense
implements TemExpense,
ExpenseTypeAware {
    private String cardType = "";
    private Boolean receiptRequired = Boolean.FALSE;
    private String temExpenseTypeCode = "I";
    private Long historicalTravelExpenseId;
    private Boolean enableNonReimbursable = Boolean.TRUE;
    private String expenseLineTypeCode = "I";
    private HistoricalTravelExpense historicalTravelExpense;

    @Override
    public String getExpenseLineTypeCode() {
        return this.expenseLineTypeCode;
    }

    public Long getHistoricalTravelExpenseId() {
        return this.historicalTravelExpenseId;
    }

    public void setHistoricalTravelExpenseId(Long historicalTravelExpenseId) {
        this.historicalTravelExpenseId = historicalTravelExpenseId;
    }

    public String getCardType() {
        return this.cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public Boolean getReceiptRequired() {
        return this.receiptRequired;
    }

    public void setReceiptRequired(Boolean receiptRequired) {
        this.receiptRequired = receiptRequired;
    }

    public Boolean getEnableNonReimbursable() {
        String cardTypes = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "ALWAYS_REIMBURSABLE_CARD_TYPE");
        if (cardTypes != null) {
            String[] cards;
            for (String cardStr : cards = cardTypes.split(",")) {
                if (this.getCardType() == null || !this.getCardType().equalsIgnoreCase(cardStr)) continue;
                this.enableNonReimbursable = false;
            }
        }
        return this.enableNonReimbursable;
    }

    public void setEnableNonReimbursable(Boolean enableNonReimbursable) {
        this.enableNonReimbursable = enableNonReimbursable;
    }

    @Override
    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        return null;
    }

    @Override
    public void setExpenseLineTypeCode(String expenseLineTypeCode) {
        this.expenseLineTypeCode = expenseLineTypeCode;
    }

    @Override
    public String getClassOfServiceCode() {
        return null;
    }

    @Override
    public boolean isRentalCar() {
        return false;
    }

    @Override
    public Boolean getRentalCarInsurance() {
        return false;
    }

    public HistoricalTravelExpense getHistoricalTravelExpense() {
        return this.historicalTravelExpense;
    }

    public void setHistoricalTravelExpense(HistoricalTravelExpense historicalTravelExpense) {
        this.historicalTravelExpense = historicalTravelExpense;
    }
}

