/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.sql.Date;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coa.businessobject.ProjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.BaseTemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileAccount;
import org.kuali.kfs.module.tem.businessobject.TemProfileAddress;
import org.kuali.kfs.module.tem.businessobject.TemProfileArranger;
import org.kuali.kfs.module.tem.businessobject.TemProfileEmergencyContact;
import org.kuali.kfs.module.tem.businessobject.TravelerType;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

@Entity
@Table(name="TEM_PROFILE_T")
public class TemProfile
extends BaseTemProfile {
    private Integer profileId;
    private String updatedBy;
    private Date lastUpdate;
    private List<TemProfileArranger> arrangers;
    private List<TemProfileAccount> accounts;
    private TemProfileAddress temProfileAddress;
    private String employeeId;
    private String homeDepartment;
    private String homeDeptOrgCode;
    private String homeDeptChartOfAccountsCode;
    private Organization homeDeptOrg;
    private String defaultChartCode;
    private String defaultAccount;
    private String defaultSubAccount;
    private String defaultProjectCode;
    private Chart chart;
    private Account account;
    private SubAccount subAccount;
    private ProjectCode project;
    private Person principal;
    private org.kuali.rice.kim.api.identity.entity.Entity kimEntityInfo;
    private String achSignUp;
    private String achTransactionType;
    private boolean onlyArrangeesInLookup;
    private List<TemProfileEmergencyContact> emergencyContacts = new ArrayList<TemProfileEmergencyContact>();
    private List<Note> boNotes;

    public TemProfile() {
        this.arrangers = new ArrayList<TemProfileArranger>();
        this.accounts = new ArrayList<TemProfileAccount>();
        this.temProfileAddress = new TemProfileAddress();
    }

    @Id
    @GeneratedValue(generator="TEM_PROFILE_ID_SEQ")
    @SequenceGenerator(name="TEM_PROFILE_ID_SEQ", sequenceName="TEM_PROFILE_ID_SEQ", allocationSize=5)
    @Column(name="profile_id", nullable=false, length=19)
    public Integer getProfileId() {
        return this.profileId;
    }

    public void setProfileId(Integer profileId) {
        this.profileId = profileId;
    }

    @Column(name="updated_by", length=40, nullable=true)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Column(name="last_update")
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="traveler_typ_cd")
    public TravelerType getTravelerType() {
        return this.travelerType;
    }

    @Override
    public void setTravelerType(TravelerType travelerType) {
        this.travelerType = travelerType;
    }

    @OneToMany
    @JoinColumn(name="arranger_id")
    public List<TemProfileArranger> getArrangers() {
        return this.arrangers;
    }

    public void setArrangers(List<TemProfileArranger> arrangers) {
        this.arrangers = arrangers;
    }

    public List<TemProfileAccount> getAccounts() {
        return this.accounts;
    }

    @Override
    @Column(length=1, nullable=true)
    public boolean isMotorVehicleRecordCheck() {
        return this.motorVehicleRecordCheck;
    }

    @Override
    public void setMotorVehicleRecordCheck(boolean motorVehicleRecordCheck) {
        this.motorVehicleRecordCheck = motorVehicleRecordCheck;
    }

    @Column(length=40, nullable=true)
    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    @Column(name="home_dept", length=40, nullable=false)
    public String getHomeDepartment() {
        if (this.getHomeDeptChartOfAccountsCode() != null && this.getHomeDeptOrgCode() != null) {
            return this.getHomeDeptChartOfAccountsCode() + "-" + this.getHomeDeptOrgCode();
        }
        return "";
    }

    public String getHomeDeptOrgCode() {
        return this.homeDeptOrgCode;
    }

    public void setHomeDeptOrgCode(String homeDeptOrgCode) {
        this.homeDeptOrgCode = homeDeptOrgCode;
    }

    public String getHomeDeptChartOfAccountsCode() {
        return this.homeDeptChartOfAccountsCode;
    }

    public void setHomeDeptChartOfAccountsCode(String homeDeptChartOfAccountsCode) {
        this.homeDeptChartOfAccountsCode = homeDeptChartOfAccountsCode;
    }

    public Organization getHomeDeptOrg() {
        return this.homeDeptOrg;
    }

    public void setHomeDeptOrg(Organization homeDeptOrg) {
        this.homeDeptOrg = homeDeptOrg;
    }

    @Column(length=2, nullable=true)
    public String getDefaultChartCode() {
        if (this.defaultChartCode == null && this.homeDeptChartOfAccountsCode != null) {
            this.defaultChartCode = this.homeDeptChartOfAccountsCode;
        }
        return this.defaultChartCode;
    }

    public void setDefaultChartCode(String defaultChartCode) {
        this.defaultChartCode = defaultChartCode;
    }

    @Column(length=7, nullable=true)
    public String getDefaultAccount() {
        return this.defaultAccount;
    }

    public void setDefaultAccount(String defaultAccount) {
        this.defaultAccount = defaultAccount;
    }

    @Column(length=5, nullable=true)
    public String getDefaultSubAccount() {
        return this.defaultSubAccount;
    }

    public void setDefaultSubAccount(String defaultSubAccount) {
        this.defaultSubAccount = defaultSubAccount;
    }

    @Column(length=10, nullable=false)
    public String getDefaultProjectCode() {
        return this.defaultProjectCode;
    }

    public void setDefaultProjectCode(String defaultProjectCode) {
        this.defaultProjectCode = defaultProjectCode;
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public SubAccount getSubAccount() {
        return this.subAccount;
    }

    public void setSubAccount(SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    public ProjectCode getProject() {
        return this.project;
    }

    public void setProject(ProjectCode project) {
        this.project = project;
    }

    public String getAchSignUp() {
        return this.achSignUp;
    }

    public void setAchSignUp(String achSignUp) {
        this.achSignUp = achSignUp;
    }

    public String getAchTransactionType() {
        return this.achTransactionType;
    }

    public void setAchTransactionType(String achTransactionType) {
        this.achTransactionType = achTransactionType;
    }

    public Person getPrincipal() {
        this.principal = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.principalId, this.principal);
        return this.principal;
    }

    public void setPrincipal(Person principal) {
        this.principal = principal;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @Override
    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        return null;
    }

    public org.kuali.rice.kim.api.identity.entity.Entity getKimEntityInfo() {
        return this.kimEntityInfo;
    }

    public void setKimEntityInfo(org.kuali.rice.kim.api.identity.entity.Entity kimEntityInfo) {
        this.kimEntityInfo = kimEntityInfo;
    }

    public TemProfileAddress getTemProfileAddress() {
        TemProfileService profileService = (TemProfileService)SpringContext.getBean(TemProfileService.class);
        if (ObjectUtils.isNull((Object)((Object)this.temProfileAddress))) {
            this.temProfileAddress = new TemProfileAddress();
        }
        return profileService.getAddressFromProfile(this, this.temProfileAddress);
    }

    public void setTemProfileAddress(TemProfileAddress temProfileAddress) {
        this.temProfileAddress = temProfileAddress;
    }

    public void setHomeDepartment(String homeDepartment) {
        this.homeDepartment = homeDepartment;
    }

    public boolean isOnlyArrangeesInLookup() {
        return this.onlyArrangeesInLookup;
    }

    public void setOnlyArrangeesInLookup(boolean onlyArrangeesInLookup) {
        this.onlyArrangeesInLookup = onlyArrangeesInLookup;
    }

    public void setAccounts(List<TemProfileAccount> accounts) {
        this.accounts = accounts;
    }

    public List<TemProfileEmergencyContact> getEmergencyContacts() {
        return this.emergencyContacts;
    }

    public void setEmergencyContacts(List<TemProfileEmergencyContact> emergencyContacts) {
        this.emergencyContacts = emergencyContacts;
    }

    public void setBoNotes(List<Note> notes) {
        this.boNotes = notes;
    }

    public List<Note> getBoNotes() {
        if (ObjectUtils.isNull(this.boNotes)) {
            List noteList;
            this.boNotes = noteList = KRADServiceLocator.getNoteService().getByRemoteObjectId(this.getObjectId());
        }
        return this.boNotes;
    }
}

