/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject.options;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.KeyValue;

public class MileageRateValuesFinder
extends KeyValuesBase {
    protected static Logger LOG = Logger.getLogger(MileageRateValuesFinder.class);
    private String queryDate;

    public List<KeyValue> getKeyValues() {
        java.sql.Date searchDate = this.getSearchDateFromDocument();
        if (searchDate == null) {
            searchDate = this.getSearchDateFromQueryDate();
        }
        return this.getTravelDocumentService().getMileageRateKeyValues(searchDate);
    }

    protected java.sql.Date getSearchDateFromDocument() {
        KualiForm currentForm = KNSGlobalVariables.getKualiForm();
        if (currentForm instanceof KualiDocumentFormBase && ((KualiDocumentFormBase)currentForm).getDocument() instanceof TravelDocument) {
            TravelDocument travelDoc = (TravelDocument)((KualiDocumentFormBase)currentForm).getDocument();
            return travelDoc.getEffectiveDateForMileageRate(new ActualExpense());
        }
        return null;
    }

    protected java.sql.Date getSearchDateFromQueryDate() {
        Date javaDate = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (!StringUtils.isBlank((String)this.queryDate)) {
            try {
                javaDate = df.parse(this.queryDate);
            }
            catch (ParseException ex) {
                LOG.error((Object)("unable to parse date: " + this.queryDate));
            }
        }
        java.sql.Date searchDate = null;
        try {
            searchDate = this.getDateTimeService().convertToSqlDate(df.format(javaDate));
        }
        catch (ParseException ex) {
            LOG.error((Object)("unable to convert date: " + this.queryDate));
        }
        return searchDate;
    }

    public String getQueryDate() {
        return this.queryDate;
    }

    public void setQueryDate(String queryDate) {
        this.queryDate = queryDate;
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected DateTimeService getDateTimeService() {
        return (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }
}

