/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.authorization.AccountingLineAuthorizerBase;
import org.kuali.rice.kew.api.WorkflowDocument;

public class TemAccountingLineAuthorizer
extends AccountingLineAuthorizerBase {
    private static Log LOG = LogFactory.getLog(TemAccountingLineAuthorizer.class);

    private DocumentHelperService getDocumentHelperService() {
        return (DocumentHelperService)SpringContext.getBean(DocumentHelperService.class);
    }

    protected String getAddMethod(AccountingLine accountingLine, String accountingLineProperty) {
        String infix = this.getActionInfixForNewAccountingLine(accountingLine, accountingLineProperty);
        if (accountingLineProperty.equals("accountDistributionnewSourceLine")) {
            infix = "Distribution";
        }
        return "insert" + infix + "Line.anchoraccounting" + infix + "Anchor";
    }

    protected String getDeleteLineMethod(AccountingLine accountingLine, String accountingLineProperty, Integer accountingLineIndex) {
        String infix = this.getActionInfixForExtantAccountingLine(accountingLine, accountingLineProperty);
        if (accountingLineProperty.contains("Distribution")) {
            infix = "Distribution";
        }
        return "delete" + infix + "Line.line" + accountingLineIndex + ".anchoraccounting" + infix + "Anchor";
    }

    protected String getBalanceInquiryMethod(AccountingLine accountingLine, String accountingLineProperty, Integer accountingLineIndex) {
        String infix = this.getActionInfixForExtantAccountingLine(accountingLine, accountingLineProperty);
        if (accountingLineProperty.contains("Distribution")) {
            infix = "Distribution";
        }
        return "performBalanceInquiryFor" + infix + "Line.line" + accountingLineIndex + ".anchoraccounting" + infix + "existingLineLineAnchor" + accountingLineIndex;
    }

    public boolean isAtNode(WorkflowDocument workflowDocument, String nodeName) {
        Set nodeNames = workflowDocument.getNodeNames();
        for (String nodeNamesNode : nodeNames) {
            if (!nodeName.equals(nodeNamesNode)) continue;
            return true;
        }
        return false;
    }
}

