/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kfs.krad.workflow.authorizer.CfDocumentTypeAuthorizer;
import org.kuali.rice.kew.api.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;

public class TravelWorkflowDocumentAuthorizer
extends CfDocumentTypeAuthorizer {
    public boolean canInitiate(String principalId, DocumentType documentType) {
        this.validatePrincipalId(principalId);
        this.validateDocumentType(documentType);
        Map permissionDetails = this.buildDocumentTypePermissionDetails(documentType, null, null, null);
        Map<String, String> qualificationDetails = this.getRoleQualifiers(principalId);
        if (this.useKimPermission("KR-SYS", "Initiate Document", permissionDetails, true)) {
            return this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-SYS", "Initiate Document", permissionDetails, qualificationDetails);
        }
        return true;
    }

    public boolean canRoute(String principalId, DocumentRouteHeaderValue document) {
        this.validatePrincipalId(principalId);
        this.validateDocument(document);
        String documentId = document.getDocumentId();
        DocumentType documentType = document.getDocumentType();
        String documentStatus = document.getDocRouteStatus();
        String initiatorPrincipalId = document.getInitiatorWorkflowId();
        this.validateDocumentType(documentType);
        this.validateDocumentStatus(documentStatus);
        this.validatePrincipalId(initiatorPrincipalId);
        if (!documentType.isPolicyDefined(DocumentTypePolicy.INITIATOR_MUST_ROUTE)) {
            Map permissionDetails = this.buildDocumentTypePermissionDetails(documentType, documentStatus, null, null);
            Map roleQualifiers = this.buildDocumentRoleQualifiers(document, (String)permissionDetails.get("routeNodeName"));
            roleQualifiers.put("profilePrincipalId", principalId);
            if (this.useKimPermission("KR-WKFLW", "Route Document", permissionDetails, true)) {
                return this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-WKFLW", "Route Document", permissionDetails, roleQualifiers);
            }
        }
        if (documentType.getInitiatorMustRoutePolicy().getPolicyValue().booleanValue()) {
            return super.canRoute(principalId, document);
        }
        return true;
    }

    protected Map<String, String> getRoleQualifiers(String principalId) {
        HashMap<String, String> qualificationDetails = new HashMap<String, String>();
        qualificationDetails.put("profilePrincipalId", principalId);
        return qualificationDetails;
    }
}

