/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.module.tem.businessobject.PerDiem;

public class PerDiemRule
extends MaintenanceDocumentRuleBase {
    static Pattern seasonBeginMonthDayPattern = Pattern.compile("^(\\d{1,2})/(\\d{1,2})$");

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        super.processCustomSaveDocumentBusinessRules(document);
        PerDiem perDiem = (PerDiem)document.getNewMaintainableObject().getBusinessObject();
        this.checkSeasonBeginMonthDayBeginParsability(perDiem);
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomRouteDocumentBusinessRules(document);
        PerDiem perDiem = (PerDiem)document.getNewMaintainableObject().getBusinessObject();
        return result &= this.checkSeasonBeginMonthDayBeginParsability(perDiem);
    }

    protected boolean checkSeasonBeginMonthDayBeginParsability(PerDiem perDiem) {
        boolean valid = true;
        if (!StringUtils.isBlank((String)perDiem.getSeasonBeginMonthAndDay())) {
            Matcher seasonBeginMonthDayMatcher = seasonBeginMonthDayPattern.matcher(perDiem.getSeasonBeginMonthAndDay());
            if (seasonBeginMonthDayMatcher.matches()) {
                Integer month = new Integer(seasonBeginMonthDayMatcher.group(1));
                Integer day = new Integer(seasonBeginMonthDayMatcher.group(2));
                if (month > 12 || month < 1 || day < 1 || day > 31) {
                    valid = false;
                    this.putFieldError("seasonBeginMonthAndDay", "error.perdiem.invalid.date.seasonBeginMonthDay", new String[]{perDiem.getSeasonBeginMonthAndDay()});
                }
            } else {
                valid = false;
                this.putFieldError("seasonBeginMonthAndDay", "error.perdiem.invalid.date.seasonBeginMonthDay", new String[]{perDiem.getSeasonBeginMonthAndDay()});
            }
        }
        return valid;
    }
}

