/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class TripTypeRule
extends MaintenanceDocumentRuleBase {
    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        super.processCustomSaveDocumentBusinessRules(document);
        TripType tripType = (TripType)document.getNewMaintainableObject().getBusinessObject();
        this.checkBalanceType(tripType);
        this.checkObjectCode(tripType);
        this.checkAutoTravelReimbursementLimit(tripType);
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomRouteDocumentBusinessRules(document);
        TripType tripType = (TripType)document.getNewMaintainableObject().getBusinessObject();
        result &= this.checkBalanceType(tripType);
        result &= this.checkObjectCode(tripType);
        return result &= this.checkAutoTravelReimbursementLimit(tripType);
    }

    protected boolean checkBalanceType(TripType tripType) {
        if (tripType.isGenerateEncumbrance() && StringUtils.isEmpty((String)tripType.getEncumbranceBalanceType())) {
            this.putFieldError("encumbranceBalanceType", "error.triptype.encumbrance.balanceType");
            return false;
        }
        return true;
    }

    protected boolean checkObjectCode(TripType tripType) {
        if (tripType.isGenerateEncumbrance() && StringUtils.isEmpty((String)tripType.getEncumbranceBalanceType())) {
            this.putFieldError("encumbranceObjCode", "error.triptype.encumbrance.objectCode");
            return false;
        }
        return true;
    }

    protected boolean checkAutoTravelReimbursementLimit(TripType tripType) {
        if (ObjectUtils.isNull((Object)tripType.getAutoTravelReimbursementLimit())) {
            tripType.setAutoTravelReimbursementLimit(KualiDecimal.ZERO);
        } else if (tripType.getAutoTravelReimbursementLimit().isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            this.putFieldError("autoTravelReimbursementLimit", "error.triptype.autoTravelReimbursementLimit");
            return false;
        }
        return true;
    }
}

