/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.form.BlankFormFile;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.document.Copyable;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TravelerDetailEmergencyContact;
import org.kuali.kfs.module.tem.document.TravelAuthorizationAmendmentDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.authorization.TravelAuthorizationAuthorizer;
import org.kuali.kfs.module.tem.document.validation.event.AddEmergencyContactLineEvent;
import org.kuali.kfs.module.tem.document.web.bean.TravelAuthorizationMvcWrapperBean;
import org.kuali.kfs.module.tem.document.web.struts.Inquisitive;
import org.kuali.kfs.module.tem.document.web.struts.QuestionHandler;
import org.kuali.kfs.module.tem.document.web.struts.StrutsInquisitor;
import org.kuali.kfs.module.tem.document.web.struts.TravelActionBase;
import org.kuali.kfs.module.tem.document.web.struts.TravelAuthorizationForm;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.AccountingDocumentSaveWithNoLedgerEntryGenerationEvent;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.document.validation.event.DeleteAccountingLineEvent;
import org.kuali.kfs.sys.web.struts.KualiAccountingDocumentFormBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class TravelAuthorizationAction
extends TravelActionBase {
    public static Logger LOG = Logger.getLogger(TravelAuthorizationAction.class);
    public static final String DOCUMENT_ERROR_PREFIX = "document.";
    public static final String NEW_SOURCE_LINE_OBJECT_CODE = String.format("%s.%s", "newSourceLine", "financialObjectCode");
    private DocumentDao documentDao;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelAuthorizationForm authForm = (TravelAuthorizationForm)form;
        String[] transpoModes = request.getParameterValues("selectedTransportationModes");
        ActionForward retval = super.execute(mapping, form, request, response);
        TravelAuthorizationDocument travelAuthDocument = (TravelAuthorizationDocument)authForm.getDocument();
        if (transpoModes != null) {
            authForm.setSelectedTransportationModes(Arrays.asList(transpoModes));
        } else {
            authForm.setSelectedTransportationModes(authForm.getTravelAuthorizationDocument().getTransportationModeCodes());
        }
        this.refreshTransportationModesAfterButtonAction(travelAuthDocument, authForm);
        if (!StringUtils.isBlank((String)travelAuthDocument.getTripTypeCode())) {
            if (ObjectUtils.isNull((Object)((Object)travelAuthDocument.getTripType())) || !StringUtils.equals((String)travelAuthDocument.getTripType().getCode(), (String)travelAuthDocument.getTripTypeCode())) {
                travelAuthDocument.refreshReferenceObject("tripType");
            }
        } else {
            travelAuthDocument.setTripType(null);
        }
        if (travelAuthDocument.getTraveler() != null && travelAuthDocument.getTraveler().getPrincipalId() != null) {
            travelAuthDocument.getTraveler().setPrincipalName(this.getPersonService().getPerson(travelAuthDocument.getTraveler().getPrincipalId()).getPrincipalName());
        }
        this.setButtonPermissions(authForm);
        String perDiemPercentage = this.getParameterService().getParameterValueAsString(TravelAuthorizationDocument.class, "FIRST_AND_LAST_DAY_PER_DIEM_PERCENTAGE");
        String travelIdentifier = travelAuthDocument.getTravelDocumentIdentifier();
        authForm.setPerDiemPercentage(perDiemPercentage);
        this.disablePerDiemExpenes(travelAuthDocument);
        if (ObjectUtils.isNotNull(travelAuthDocument.getActualExpenses())) {
            travelAuthDocument.enableExpenseTypeSpecificFields(travelAuthDocument.getActualExpenses());
        }
        LOG.debug((Object)("Got " + authForm.getRelatedDocuments().size() + " related documents"));
        if (!this.isReturnFromObjectCodeLookup(authForm, request)) {
            this.getTravelEncumbranceService().updateEncumbranceObjectCode(travelAuthDocument, authForm.getNewSourceLine());
        }
        this.getMessages(authForm);
        this.refreshRelatedDocuments(authForm);
        if (((TravelFormBase)form).getMethodToCall().equalsIgnoreCase("docHandler") && travelAuthDocument.getPrimaryDestinationId() != null && travelAuthDocument.getPrimaryDestinationId() == Integer.MAX_VALUE) {
            travelAuthDocument.getPrimaryDestination().setPrimaryDestinationName(travelAuthDocument.getPrimaryDestinationName());
            travelAuthDocument.getPrimaryDestination().setCounty(travelAuthDocument.getPrimaryDestinationCounty());
            travelAuthDocument.getPrimaryDestination().getRegion().setRegionName(travelAuthDocument.getPrimaryDestinationCountryState());
        }
        request.setAttribute("certificationStatement", (Object)this.getCertificationStatement(travelAuthDocument));
        request.setAttribute("isEmployee", (Object)this.isEmployee(travelAuthDocument.getTraveler()));
        if (!this.getCalculateIgnoreList().contains(authForm.getMethodToCall())) {
            this.recalculateTripDetailTotalOnly(mapping, form, request, response);
        }
        this.setupTravelAdvances(authForm);
        travelAuthDocument.propagateAdvanceInformationIfNeeded();
        this.populateAnyMissingAdvanceAccountingLineObjectCodes(authForm);
        if (travelAuthDocument.getTravelAdvances() != null && !travelAuthDocument.getTravelAdvances().isEmpty()) {
            authForm.setShowTravelAdvancesForTrip(true);
        }
        this.setTabStateForEmergencyContacts(authForm);
        return retval;
    }

    private void setupTravelAdvances(TravelAuthorizationForm form) {
        TravelAuthorizationDocument document = form.getTravelAuthorizationDocument();
        boolean waitingOnTraveler = document.getAppDocStatus().equals("Awaiting Traveler Review");
        String initiator = document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        String travelerID = "";
        boolean showPolicy = false;
        if (document.getTraveler() != null) {
            travelerID = document.getTraveler().getPrincipalId();
            showPolicy = travelerID != null ? initiator.equals(travelerID) || GlobalVariables.getUserSession().getPrincipalId().equals(travelerID) : true;
        }
        form.setWaitingOnTraveler(waitingOnTraveler);
        form.setShowPolicy(showPolicy);
    }

    protected void processAccountingLineOverrides(KualiAccountingDocumentFormBase transForm) {
        TravelAuthorizationDocument authorizationDocument;
        super.processAccountingLineOverrides(transForm);
        this.processAccountingLineOverrides((AccountingLine)((TravelAuthorizationForm)transForm).getNewAdvanceAccountingLine());
        if (transForm.hasDocumentId() && !ObjectUtils.isNull((authorizationDocument = (TravelAuthorizationDocument)transForm.getDocument()).getAdvanceAccountingLines()) && !authorizationDocument.getAdvanceAccountingLines().isEmpty()) {
            this.processAccountingLineOverrides(authorizationDocument, authorizationDocument.getAdvanceAccountingLines());
        }
    }

    protected void populateAnyMissingAdvanceAccountingLineObjectCodes(TravelAuthorizationForm form) {
        TravelAuthorizationDocument authorizationDocument;
        String advanceAccountingLineObjectCode = this.getParameterService().getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_OBJECT_CODE", "");
        if (!StringUtils.isBlank((String)advanceAccountingLineObjectCode) && (authorizationDocument = form.getTravelAuthorizationDocument()).getAdvanceAccountingLines() != null && !authorizationDocument.getAdvanceAccountingLines().isEmpty()) {
            for (TemSourceAccountingLine accountingLine : authorizationDocument.getAdvanceAccountingLines()) {
                if (!StringUtils.isBlank((String)accountingLine.getFinancialObjectCode())) continue;
                accountingLine.setFinancialObjectCode(advanceAccountingLineObjectCode);
            }
        }
    }

    public ActionForward insertAdvanceAccountingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelAuthorizationForm authorizationDocumentForm = (TravelAuthorizationForm)form;
        TemSourceAccountingLine line = authorizationDocumentForm.getNewAdvanceAccountingLine();
        boolean rulePassed = true;
        if (rulePassed &= ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AddAccountingLineEvent("newAdvanceAccountingLine", authorizationDocumentForm.getDocument(), (AccountingLine)line))) {
            ((PersistenceService)SpringContext.getBean(PersistenceService.class)).refreshAllNonUpdatingReferences((PersistableBusinessObject)line);
            authorizationDocumentForm.setAnchor("sourceAnchor");
            authorizationDocumentForm.getTravelAuthorizationDocument().addAdvanceAccountingLine(line);
            authorizationDocumentForm.setNewAdvanceAccountingLine(null);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteAdvanceAccountingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelAuthorizationForm authorizationDocumentForm = (TravelAuthorizationForm)form;
        int deleteIndex = this.getLineToDelete(request);
        String errorPath = "document.advanceAccountingLines[" + deleteIndex + "]";
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new DeleteAccountingLineEvent(errorPath, authorizationDocumentForm.getDocument(), (AccountingLine)authorizationDocumentForm.getTravelAuthorizationDocument().getAdvanceAccountingLine(deleteIndex), false));
        if (rulePassed) {
            authorizationDocumentForm.setAnchor("sourceAnchor");
            authorizationDocumentForm.getTravelAuthorizationDocument().getAdvanceAccountingLines().remove(deleteIndex);
        } else {
            String[] errorParams = new String[]{"source", Integer.toString(deleteIndex + 1)};
            GlobalVariables.getMessageMap().putError(errorPath, "error.accountingLine.deleteRule.invalidAccount", errorParams);
        }
        return mapping.findForward("basic");
    }

    public ActionForward performBalanceInquiryForAdvanceAccountingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TemSourceAccountingLine line = this.getAdvanceAccountingLine(form, request);
        return this.performBalanceInquiryForAccountingLine(mapping, form, request, (AccountingLine)line);
    }

    protected TemSourceAccountingLine getAdvanceAccountingLine(ActionForm form, HttpServletRequest request) {
        int lineIndex = this.getSelectedLine(request);
        TemSourceAccountingLine line = (TemSourceAccountingLine)((Object)ObjectUtils.deepCopy((Serializable)((Object)((TravelAuthorizationForm)form).getTravelAuthorizationDocument().getAdvanceAccountingLine(lineIndex))));
        return line;
    }

    protected boolean isReturnFromObjectCodeLookup(TravelAuthorizationForm form, HttpServletRequest request) {
        return form.getRefreshCaller() != null && request.getParameter(NEW_SOURCE_LINE_OBJECT_CODE) != null;
    }

    private void getMessages(TravelAuthorizationForm authForm) {
        TravelAuthorizationDocument document = authForm.getTravelAuthorizationDocument();
        if (!StringUtils.isBlank((String)document.getAppDocStatus())) {
            if (document.getAppDocStatus().equals("Reimbursement On Hold")) {
                KNSGlobalVariables.getMessageList().add("travelAuthorization.message.hold.text", new String[]{document.getHoldRequestorPersonName()});
            } else if (document.getAppDocStatus().equals("Retired Version")) {
                KNSGlobalVariables.getMessageList().add("travelAuthorization.message.retired.text", new String[0]);
            } else if (document.getAppDocStatus().equals("Pending Amendment")) {
                KNSGlobalVariables.getMessageList().add("travelAuthorization.message.amend.text", new String[0]);
            }
        }
    }

    protected void setButtonPermissions(TravelAuthorizationForm authForm) {
        this.canSave(authForm);
        this.setCanCalculate(authForm);
        this.setCanReturnToFisicalOfficer(authForm);
        this.hideButtons(authForm);
    }

    protected void hideButtons(TravelAuthorizationForm authForm) {
        boolean can = false;
        TravelAuthorizationAuthorizer documentAuthorizer = (TravelAuthorizationAuthorizer)this.getDocumentAuthorizer((KualiDocumentFormBase)authForm);
        can = documentAuthorizer.hideButtons(authForm.getTravelAuthorizationDocument(), GlobalVariables.getUserSession().getPerson());
        if (can) {
            authForm.getDocumentActions().remove("canSave");
            authForm.getDocumentActions().remove("canClose");
            authForm.getDocumentActions().remove("canSendAdHocRequests");
            authForm.getDocumentActions().remove("canCopy");
            authForm.getDocumentActions().remove("canReload");
        }
    }

    protected void canSave(TravelAuthorizationForm authForm) {
        boolean can;
        boolean bl = can = !this.isFinal(authForm) && !this.isProcessed(authForm);
        if (can) {
            TravelAuthorizationAuthorizer documentAuthorizer = (TravelAuthorizationAuthorizer)this.getDocumentAuthorizer((KualiDocumentFormBase)authForm);
            can = documentAuthorizer.canSave((Document)authForm.getTravelAuthorizationDocument(), GlobalVariables.getUserSession().getPerson());
        }
        if (!can) {
            boolean isDelinquent;
            boolean isTravelManager = this.getTravelDocumentService().isTravelManager(GlobalVariables.getUserSession().getPerson());
            boolean bl2 = isDelinquent = authForm.getTravelAuthorizationDocument().getDelinquentAction() != null;
            if (isTravelManager && isDelinquent) {
                can = true;
            }
        }
        if (can) {
            authForm.getDocumentActions().put("canSave", true);
        } else {
            authForm.getDocumentActions().remove("canSave");
        }
    }

    @Override
    public ActionForward performLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelAuthorizationForm authForm = (TravelAuthorizationForm)form;
        List<String> selectedTransportationModes = authForm.getTempSelectedTransporationModes();
        if (selectedTransportationModes != null) {
            authForm.getTravelAuthorizationDocument().setTransportationModeCodes(selectedTransportationModes);
        } else {
            authForm.getTravelAuthorizationDocument().setTransportationModeCodes(new ArrayList<String>());
        }
        return super.performLookup(mapping, form, request, response);
    }

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionAfterPrimaryDestinationLookup;
        TravelAuthorizationForm authForm = (TravelAuthorizationForm)form;
        authForm.setSelectedTransportationModes(authForm.getTravelAuthorizationDocument().getTransportationModeCodes());
        String refreshCaller = authForm.getRefreshCaller();
        LOG.debug((Object)("refresh call is: " + refreshCaller));
        String groupTravelerId = request.getParameter("newGroupTravelerLine.groupTravelerEmpId");
        if (refreshCaller == null) {
            authForm.setTravelerId(authForm.getTempTravelerId());
        }
        if ((actionAfterPrimaryDestinationLookup = this.refreshAfterPrimaryDestinationLookup(mapping, authForm, request)) != null) {
            return actionAfterPrimaryDestinationLookup;
        }
        return super.refresh(mapping, form, request, response);
    }

    protected void refreshTransportationModesAfterButtonAction(TravelAuthorizationDocument travelReqDoc, TravelAuthorizationForm authForm) {
        List<String> selectedTransportationModes = authForm.getTempSelectedTransporationModes();
        if (selectedTransportationModes != null) {
            LOG.debug((Object)("selected transportation modes are: " + selectedTransportationModes.toString()));
            travelReqDoc.setTransportationModeCodes(selectedTransportationModes);
        } else {
            LOG.debug((Object)"setting selected transportation modes to empty list");
            travelReqDoc.setTransportationModeCodes(new ArrayList<String>());
        }
    }

    @Override
    protected void performRequesterRefresh(TravelDocument document, TravelFormBase travelForm, HttpServletRequest request) {
        LOG.debug((Object)("Looking up customer with number " + document.getTraveler().getCustomerNumber()));
        document.getTraveler().refreshReferenceObject("customer");
        document.getTraveler().refreshReferenceObject("travelerType");
        LOG.debug((Object)("Got " + document.getTraveler().getCustomer()));
        if (document.getTraveler().getPrincipalId() != null) {
            String principalName = this.getPersonService().getPerson(document.getTraveler().getPrincipalId()).getPrincipalName();
            document.getTraveler().setPrincipalName(principalName);
        }
        ((TravelAuthorizationDocument)document).updatePayeeTypeForAuthorization();
        this.updateAccountsWithNewProfile(travelForm, document.getTemProfile());
    }

    public ActionForward addEmergencyContactLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelAuthorizationForm travelauthForm = (TravelAuthorizationForm)form;
        TravelAuthorizationDocument travelReqDoc = (TravelAuthorizationDocument)travelauthForm.getDocument();
        TravelerDetailEmergencyContact newEmergencyContactLine = travelauthForm.getNewEmergencyContactLine();
        boolean rulePassed = true;
        if (rulePassed &= ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AddEmergencyContactLineEvent("newEmergencyContactLine", travelauthForm.getDocument(), newEmergencyContactLine))) {
            travelReqDoc.addEmergencyContactLine(newEmergencyContactLine);
            travelauthForm.setNewEmergencyContactLine(new TravelerDetailEmergencyContact());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteEmergencyContactLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelAuthorizationForm travelauthForm = (TravelAuthorizationForm)form;
        TravelAuthorizationDocument travelReqDoc = (TravelAuthorizationDocument)travelauthForm.getDocument();
        int deleteIndex = this.getLineToDelete(request);
        travelReqDoc.getTraveler().getEmergencyContacts().remove(deleteIndex);
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward updatePerDiemExpenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelAuthorizationForm taForm = (TravelAuthorizationForm)form;
        TravelAuthorizationDocument document = taForm.getTravelAuthorizationDocument();
        ActionForward forward = super.updatePerDiemExpenses(mapping, form, request, response);
        taForm.getNewSourceLine().setAmount(this.getAccountingLineAmountToFillIn(taForm));
        this.getTravelEncumbranceService().updateEncumbranceObjectCode(document, taForm.getNewSourceLine());
        return forward;
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelAuthorizationForm authForm = (TravelAuthorizationForm)form;
        TravelAuthorizationDocument travelReqDoc = authForm.getTravelAuthorizationDocument();
        String tripTypeCode = travelReqDoc.getTripTypeCode();
        LOG.debug((Object)("Got special circumstances " + authForm.getTravelAuthorizationDocument().getSpecialCircumstances()));
        LOG.debug((Object)("Save Called on " + ((Object)((Object)this)).getClass().getSimpleName() + " for " + authForm.getDocument().getClass().getSimpleName()));
        LOG.debug((Object)("Saving document traveler detail " + travelReqDoc.getTravelerDetailId()));
        return super.save(mapping, form, request, response);
    }

    public ActionForward recalculate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.recalculateTripDetailTotal(mapping, form, request, response);
    }

    @Override
    protected ActionForward askQuestionsAndPerformDocumentAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionType, String confirmType, String documentType, String notePrefix, String messageType, String operation) throws Exception {
        LOG.debug((Object)"askQuestionsAndPerformDocumentAction started.");
        TravelAuthorizationForm taForm = (TravelAuthorizationForm)form;
        TravelAuthorizationDocument taDoc = taForm.getTravelAuthorizationDocument();
        String question = request.getParameter("questionIndex");
        String reason = request.getParameter("reason");
        String noteText = "";
        ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        if (ObjectUtils.isNull((Object)question)) {
            String message = "";
            String key = kualiConfiguration.getPropertyValueAsString("travelAuthorization.question.text");
            message = StringUtils.replace((String)key, (String)"{0}", (String)operation);
            return this.performQuestionWithInput(mapping, form, request, response, questionType, message, "confirmationQuestion", questionType, "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if (question.equals(questionType) && buttonClicked.equals("1")) {
            return this.returnToPreviousPage(mapping, (KualiDocumentFormBase)taForm);
        }
        if (question.equals(confirmType) && buttonClicked.equals("0")) {
            return mapping.findForward("portal");
        }
        String introNoteMessage = notePrefix + " ";
        noteText = introNoteMessage + reason;
        int noteTextLength = noteText.length();
        int noteTextMaxLength = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(Note.class, "noteText");
        if (StringUtils.isBlank((String)reason) || noteTextLength > noteTextMaxLength) {
            int reasonLimit = noteTextMaxLength - noteTextLength;
            if (ObjectUtils.isNull((Object)reason)) {
                reason = "";
            }
            return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, questionType, kualiConfiguration.getPropertyValueAsString("travelAuthorization.question.text"), "confirmationQuestion", questionType, "", reason, "error.travelAuthorization.reasonRequired", "reason", new Integer(reasonLimit).toString());
        }
        ActionForward returnActionForward = null;
        String newStatus = null;
        if (documentType.equals("TAA")) {
            newStatus = "Pending Amendment";
            returnActionForward = mapping.findForward("basic");
            noteText = noteText + " (Previous Document Id is " + taForm.getDocId() + ")";
        } else if (questionType.equals("HoldTa")) {
            newStatus = "Reimbursement On Hold";
        } else if (questionType.equals("RemoveHoldTa")) {
            newStatus = "Open For Reimbursement";
        }
        Note newNote = this.getDocumentService().createNoteFromDocument((Document)taDoc, noteText);
        taForm.setNewNote(newNote);
        taForm.setAttachmentFile((FormFile)new BlankFormFile());
        this.insertBONote(mapping, (ActionForm)taForm, request, response);
        taDoc.updateAndSaveAppDocStatus(newStatus);
        if (questionType.equals("RemoveHoldTa") || questionType.equals("HoldTa")) {
            this.getTravelDocumentService().addAdHocFYIRecipient((Document)taDoc, taDoc.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        }
        ((DocumentService)SpringContext.getBean(DocumentService.class)).saveDocument((Document)taDoc);
        if (ObjectUtils.isNotNull((Object)returnActionForward)) {
            return returnActionForward;
        }
        return this.performQuestionWithoutInput(mapping, form, request, response, confirmType, kualiConfiguration.getPropertyValueAsString(messageType), "temSingleConfirmationQuestion", questionType, "");
    }

    public ActionForward amendTa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"Amend TA started");
        Inquisitive<TravelAuthorizationDocument, ActionForward> inq = this.getInquisitive(mapping, form, request, response);
        if (inq.wasQuestionAsked() && request.getParameterMap().containsKey("reason")) {
            this.getDocumentService().saveDocument(((TravelAuthorizationForm)form).getDocument(), AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        }
        ActionForward forward = this.askQuestionsAndPerformDocumentAction(inq, "AmendmentTa");
        return forward;
    }

    public ActionForward holdTa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"Hold TA started");
        Inquisitive<TravelAuthorizationDocument, ActionForward> inq = this.getInquisitive(mapping, form, request, response);
        return this.askQuestionsAndPerformDocumentAction(inq, "HoldTa");
    }

    public ActionForward removeHoldTa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"Remove Hold TA started");
        Inquisitive<TravelAuthorizationDocument, ActionForward> inq = this.getInquisitive(mapping, form, request, response);
        return this.askQuestionsAndPerformDocumentAction(inq, "RemoveHoldTa");
    }

    public ActionForward cancelTa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"Cancel TA started");
        Inquisitive<TravelAuthorizationDocument, ActionForward> inq = this.getInquisitive(mapping, form, request, response);
        return this.askQuestionsAndPerformDocumentAction(inq, "CancelTa");
    }

    public ActionForward closeTa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"Close TA started");
        String operation = "Close ";
        Inquisitive<TravelAuthorizationDocument, ActionForward> inq = this.getInquisitive(mapping, form, request, response);
        return this.askQuestionsAndPerformDocumentAction(inq, "CloseTa");
    }

    public ActionForward newReimbursement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelAuthorizationDocument travelAuth = ((TravelAuthorizationForm)form).getTravelAuthorizationDocument();
        return new ActionForward(this.buildNewReimbursementUrl(travelAuth), true);
    }

    protected Inquisitive<TravelAuthorizationDocument, ActionForward> getInquisitive(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        StrutsInquisitor inq = new StrutsInquisitor(mapping, (TravelAuthorizationForm)form, this, request, response);
        return inq;
    }

    protected ActionForward askQuestionsAndPerformDocumentAction(Inquisitive<TravelAuthorizationDocument, ActionForward> inq, String questionId) throws Exception {
        QuestionHandler questionHandler = (QuestionHandler)this.getQuestionHandler(questionId);
        if (inq.wasQuestionAsked()) {
            return (ActionForward)questionHandler.handleResponse(inq);
        }
        return (ActionForward)questionHandler.askQuestion(inq);
    }

    protected ActionForward returnToPreviousPage(ActionMapping mapping, KualiDocumentFormBase kualiDocumentFormBase) {
        return mapping.findForward("basic");
    }

    @Override
    protected KualiDecimal getAccountingLineAmountToFillIn(TravelFormBase travelFormBase) {
        TravelAuthorizationForm travelAuthForm = (TravelAuthorizationForm)travelFormBase;
        KualiDecimal amount = new KualiDecimal(0);
        KualiDecimal encTotal = travelAuthForm.getTravelAuthorizationDocument().getEncumbranceTotal();
        KualiDecimal expenseTotal = travelAuthForm.getTravelAuthorizationDocument().getExpenseLimit();
        List accountingLines = travelAuthForm.getTravelAuthorizationDocument().getSourceAccountingLines();
        KualiDecimal accountingTotal = new KualiDecimal(0);
        for (SourceAccountingLine accountingLine : accountingLines) {
            accountingTotal = (KualiDecimal)accountingTotal.add((AbstractKualiDecimal)accountingLine.getAmount());
        }
        amount = ObjectUtils.isNull((Object)expenseTotal) ? (KualiDecimal)encTotal.subtract((AbstractKualiDecimal)accountingTotal) : (expenseTotal.isLessThan((AbstractKualiDecimal)encTotal) ? (KualiDecimal)expenseTotal.subtract((AbstractKualiDecimal)accountingTotal) : (KualiDecimal)encTotal.subtract((AbstractKualiDecimal)accountingTotal));
        return amount;
    }

    public ActionForward insertSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelAuthorizationForm travelauthForm = (TravelAuthorizationForm)form;
        TemSourceAccountingLine accountingLine = (TemSourceAccountingLine)((TravelAuthorizationForm)form).getNewSourceLine();
        accountingLine.setCardType("ENCUMBRANCE");
        super.insertSourceLine(mapping, form, request, response);
        travelauthForm.getNewSourceLine().setAmount(this.getAccountingLineAmountToFillIn(travelauthForm));
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward deleteSourceLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.deleteSourceLine(mapping, form, request, response);
        TravelAuthorizationForm travelauthForm = (TravelAuthorizationForm)form;
        travelauthForm.getNewSourceLine().setAmount(this.getAccountingLineAmountToFillIn(travelauthForm));
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String buttonClicked = request.getParameter("buttonClicked");
        if ("0".equals(buttonClicked)) {
            this.reverseAmendment((TravelAuthorizationForm)form);
        }
        return super.cancel(mapping, form, request, response);
    }

    @Override
    public ActionForward disapprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String buttonClicked = request.getParameter("buttonClicked");
        if ("0".equals(buttonClicked)) {
            this.reverseAmendment((TravelAuthorizationForm)form);
        }
        return super.disapprove(mapping, form, request, response);
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String buttonClicked = request.getParameter("buttonClicked");
        return super.close(mapping, form, request, response);
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.recalculateTripDetailTotalOnly(mapping, form, request, response);
        TravelAuthorizationForm authForm = (TravelAuthorizationForm)form;
        TravelAuthorizationDocument document = authForm.getTravelAuthorizationDocument();
        document.propagateAdvanceInformationIfNeeded();
        return super.route(mapping, form, request, response);
    }

    @Override
    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (((TravelAuthorizationForm)form).getTravelAuthorizationDocument().shouldProcessAdvanceForDocument()) {
            ((TravelAuthorizationForm)form).getTravelAuthorizationDocument().propagateAdvanceInformationIfNeeded();
            ((TravelAuthorizationForm)form).getTravelAuthorizationDocument().getTravelAdvance().setTravelAdvancePolicy(true);
        }
        return super.blanketApprove(mapping, form, request, response);
    }

    @Override
    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isAtApprovalPropagateAdvanceInfoNode(((TravelAuthorizationForm)form).getTravelAuthorizationDocument().getDocumentHeader().getWorkflowDocument().getCurrentNodeNames()) && ((TravelAuthorizationForm)form).getTravelAuthorizationDocument().shouldProcessAdvanceForDocument()) {
            ((TravelAuthorizationForm)form).getTravelAuthorizationDocument().propagateAdvanceInformationIfNeeded();
        }
        return super.approve(mapping, form, request, response);
    }

    protected boolean isAtApprovalPropagateAdvanceInfoNode(Set<String> nodeNames) {
        if (nodeNames != null && !nodeNames.isEmpty()) {
            return nodeNames.contains("PaymentMethod") || nodeNames.contains("Travel");
        }
        return false;
    }

    public ActionForward clearAdvance(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (((TravelAuthorizationForm)form).getTravelAuthorizationDocument().shouldProcessAdvanceForDocument()) {
            TravelAuthorizationDocument doc = ((TravelAuthorizationForm)form).getTravelAuthorizationDocument();
            doc.getTravelAdvance().clear();
            if (!ObjectUtils.isNull((Object)((Object)doc.getAdvanceTravelPayment()))) {
                doc.getAdvanceTravelPayment().setDueDate(null);
                doc.getAdvanceTravelPayment().setCheckTotalAmount(null);
                doc.getAdvanceTravelPayment().setPaymentMethodCode(KFSConstants.PaymentMethod.ACH_CHECK.getCode());
            }
            if (doc.allParametersForAdvanceAccountingLinesSet()) {
                doc.getAdvanceAccountingLine(0).setAmount(KualiDecimal.ZERO);
            } else {
                doc.setAdvanceAccountingLines(new ArrayList<TemSourceAccountingLine>());
            }
        }
        return mapping.findForward("basic");
    }

    protected void reverseAmendment(TravelAuthorizationForm form) {
        if (form.getTravelAuthorizationDocument() instanceof TravelAuthorizationAmendmentDocument) {
            TravelAuthorizationDocument travelDocument = form.getTravelAuthorizationDocument();
            this.getTravelDocumentService().revertOriginalDocument(travelDocument, "Open For Reimbursement");
        }
    }

    @Override
    protected void showAccountDistribution(HttpServletRequest request, Document document) {
        if (document instanceof TravelAuthorizationDocument) {
            boolean showAccountDistribution = this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "DISPLAY_ACCOUNTING_DISTRIBUTION_TAB_IND");
            request.setAttribute("accountDistribution", (Object)showAccountDistribution);
        } else {
            super.showAccountDistribution(request, document);
        }
    }

    public ActionForward copy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelAuthorizationForm travelAuthForm = (TravelAuthorizationForm)form;
        TravelAuthorizationDocument doc = travelAuthForm.getTravelAuthorizationDocument();
        if (!travelAuthForm.getDocumentActions().containsKey("canCopy")) {
            throw this.buildAuthorizationException("copy", (Document)doc);
        }
        if (doc.shouldRevertToOriginalAuthorizationOnCopy()) {
            TravelAuthorizationDocument newTaDoc = doc.toCopyTA();
            travelAuthForm.setDocument((Document)newTaDoc);
            travelAuthForm.setDocTypeName("TA");
        } else {
            ((Copyable)travelAuthForm.getTransactionalDocument()).toCopy();
        }
        return mapping.findForward("basic");
    }

    protected void setTabStateForEmergencyContacts(TravelAuthorizationForm form) {
        TravelAuthorizationDocument travelAuthDocument = (TravelAuthorizationDocument)form.getDocument();
        boolean openTab = false;
        Collection internationalTrips = this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "INTERNATIONAL_TRIP_TYPES");
        if (travelAuthDocument.getTripTypeCode() != null) {
            if (internationalTrips.contains(travelAuthDocument.getTripTypeCode())) {
                openTab = true;
            }
            if (openTab) {
                String tabKey = WebUtils.generateTabKey((String)"Emergency Contact Information");
                form.getTabStates().put(tabKey, KualiForm.TabState.OPEN.name());
            }
        }
    }

    protected Class getMvcWrapperInterface() {
        return TravelAuthorizationMvcWrapperBean.class;
    }
}

