/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.kns.web.ui.ExtraButton;
import org.kuali.kfs.module.tem.businessobject.Attendee;
import org.kuali.kfs.module.tem.document.TravelEntertainmentDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.bean.TravelEntertainmentMvcWrapperBean;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.sys.context.SpringContext;

public class TravelEntertainmentForm
extends TravelFormBase
implements TravelEntertainmentMvcWrapperBean {
    public static Logger LOG = Logger.getLogger(TravelEntertainmentForm.class);
    private Date startDate;
    private Date endDate;
    private boolean canPrintHostCertification;
    private boolean canUnmask = false;
    private Attendee newAttendeeLine;
    private List<Attendee> newAttendeeLines;
    private FormFile attendeesImportFile;
    private String attendesTagGroupLabelName = "Attendees";
    private String travelDocumentIdentifier;
    private String fromDocumentNumber;

    public TravelEntertainmentForm() {
        this.setNewAttendeeLine(new Attendee());
        ArrayList<Attendee> attendee = new ArrayList<Attendee>();
        attendee.add(new Attendee());
        this.setNewAttendeeLines(attendee);
    }

    @Override
    public void populate(HttpServletRequest request) {
        super.populate(request);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public TravelEntertainmentDocument getEntertainmentDocument() {
        return (TravelEntertainmentDocument)this.getDocument();
    }

    @Override
    protected String getDocumentIdentifierFieldName() {
        return "travelDocumentIdentifier";
    }

    protected String getDefaultDocumentTypeName() {
        return "ENT";
    }

    public String getAttendesTagGroupLabelName() {
        return this.attendesTagGroupLabelName;
    }

    public void setAttendesTagGroupLabelName(String attendesTagGroupLabelName) {
        this.attendesTagGroupLabelName = attendesTagGroupLabelName;
    }

    protected Map<String, ExtraButton> createButtonsMap() {
        HashMap<String, ExtraButton> result = new HashMap<String, ExtraButton>();
        ExtraButton newEntertainmentButton = new ExtraButton();
        newEntertainmentButton.setExtraButtonProperty("methodToCall.newEntertainment");
        newEntertainmentButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_newentertainment.png");
        newEntertainmentButton.setExtraButtonAltText("New Entertainment");
        result.put(newEntertainmentButton.getExtraButtonProperty(), newEntertainmentButton);
        result.putAll(this.createPaymentExtraButtonMap());
        return result;
    }

    @Override
    public boolean isDefaultOpenPaymentInfoTab() {
        if ("Awaiting Entertainment Manager Review".equals(this.getDocument().getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus())) {
            return true;
        }
        return super.isDefaultOpenPaymentInfoTab();
    }

    @Override
    public List<ExtraButton> getExtraButtons() {
        super.getExtraButtons();
        Map<String, ExtraButton> buttonsMap = this.createButtonsMap();
        LOG.debug((Object)"Creating button map");
        if (!((TravelDocumentService)SpringContext.getBean(TravelDocumentService.class)).isUnsuccessful(this.getTravelDocument()) && this.getEntertainmentDocument().canPayDVToVendor()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.payDVToVendor"));
        }
        if (this.getDocumentActions().keySet().contains("canNewEntertainment")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.newEntertainment"));
        }
        return this.extraButtons;
    }

    public boolean isCanUnmask() {
        return this.canUnmask;
    }

    public void setCanUnmask(boolean canUnmask) {
        this.canUnmask = canUnmask;
    }

    @Override
    public Attendee getNewAttendeeLine() {
        return this.newAttendeeLine;
    }

    @Override
    public void setNewAttendeeLine(Attendee newAttendeeLine) {
        this.newAttendeeLine = newAttendeeLine;
    }

    @Override
    public List<Attendee> getNewAttendeeLines() {
        return this.newAttendeeLines;
    }

    @Override
    public void setNewAttendeeLines(List<Attendee> newAttendeeLines) {
        this.newAttendeeLines = newAttendeeLines;
    }

    public FormFile getAttendeesImportFile() {
        return this.attendeesImportFile;
    }

    public void setAttendeesImportFile(FormFile attendeesImportFile) {
        this.attendeesImportFile = attendeesImportFile;
    }

    public boolean isCanPrintHostCertification() {
        return this.getEntertainmentDocument().canShowHostCertification();
    }

    public void setCanPrintHostCertification(boolean canPrintHostCertification) {
        this.canPrintHostCertification = canPrintHostCertification;
    }

    public boolean isEventHostandEventNameReadonly() {
        return !StringUtils.isBlank((String)this.getTravelDocumentIdentifier()) && !StringUtils.isBlank((String)this.getFromDocumentNumber());
    }

    @Override
    public String getTravelPaymentFormAction() {
        return "temTravelEntertainment";
    }

    public String getTravelDocumentIdentifier() {
        return this.travelDocumentIdentifier;
    }

    public void setTravelDocumentIdentifier(String travelDocumentIdentifier) {
        this.travelDocumentIdentifier = travelDocumentIdentifier;
    }

    public String getFromDocumentNumber() {
        return this.fromDocumentNumber;
    }

    public void setFromDocumentNumber(String fromDocumentNumber) {
        this.fromDocumentNumber = fromDocumentNumber;
    }
}

