/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.report;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import net.sf.jasperreports.engine.JRDataSource;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.tem.report.DetailedReport;
import org.kuali.kfs.module.tem.report.annotations.DetailSection;
import org.kuali.kfs.module.tem.report.annotations.Group;
import org.kuali.kfs.module.tem.report.annotations.JasperReport;
import org.kuali.kfs.module.tem.report.annotations.ReportStyle;
import org.kuali.kfs.module.tem.report.annotations.SubReport;
import org.kuali.kfs.module.tem.report.annotations.Summary;
import org.kuali.kfs.module.tem.report.annotations.TitleStyle;
import org.kuali.kfs.sys.report.ReportInfoHolder;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.ui.jasperreports.JasperReportsUtils;

@JasperReport
@ReportStyle(value="standard")
@TitleStyle(value="standard")
public class ExpenseSummaryReport
extends ReportInfoHolder
implements DetailedReport {
    public static Logger LOG = Logger.getLogger(ExpenseSummaryReport.class);
    private String traveler;
    private String initiator;
    private String authorizationInitiator;
    private Date beginDate;
    private Date endDate;
    private String locations;
    private String purpose;
    private String institution;
    @Group(value="expenseType")
    @DetailSection
    private JRDataSource data;
    @SubReport
    @Summary
    private JRDataSource summary;
    private String tripId;

    public ExpenseSummaryReport() {
        this.setReportTemplateClassPath("org/kuali/kfs/module/tem/report/");
        this.setReportFileName("ExpenseSummary.pdf");
        this.setReportTitle("Overview Summary of Expenses");
    }

    public String getTraveler() {
        return this.traveler;
    }

    public void setTraveler(String argTraveler) {
        this.traveler = argTraveler;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String argInitiator) {
        this.initiator = argInitiator;
    }

    public String getAuthorizationInitiator() {
        return this.authorizationInitiator;
    }

    public void setAuthorizationInitiator(String argAuthorizationInitiator) {
        this.authorizationInitiator = argAuthorizationInitiator;
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String argInstitution) {
        this.institution = argInstitution;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date argBeginDate) {
        this.beginDate = argBeginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date argEndDate) {
        this.endDate = argEndDate;
    }

    public String getLocations() {
        return this.locations;
    }

    public void setLocations(String argLocations) {
        this.locations = argLocations;
    }

    public String getTripId() {
        return this.tripId;
    }

    public void setTripId(String argTripId) {
        this.tripId = argTripId;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String argPurpose) {
        this.purpose = argPurpose;
    }

    @Override
    public JRDataSource getData() {
        return this.data;
    }

    public void setData(Collection<Detail> argData) {
        LOG.debug((Object)("Report created with data " + argData.size()));
        this.data = JasperReportsUtils.convertReportData(argData);
    }

    public JRDataSource getSummary() {
        return this.summary;
    }

    public void setSummary(Collection<Detail> argSummary) {
        this.summary = JasperReportsUtils.convertReportData(argSummary);
    }

    public static class Detail {
        private String name = "";
        private String expenseType = "";
        private String date = "";
        private BigDecimal amount = new BigDecimal(0);

        public Detail(String name, String expenseType, KualiDecimal amount, Date date) {
            this.name = name;
            this.amount = amount != null ? amount.bigDecimalValue() : KualiDecimal.ZERO.bigDecimalValue();
            if (date != null) {
                String expenseDate;
                this.date = expenseDate = new SimpleDateFormat("MM/dd").format(date);
            }
            this.expenseType = expenseType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String argName) {
            this.name = argName;
        }

        public String getExpenseType() {
            return this.expenseType;
        }

        public void setExpenseType(String argExpenseType) {
            this.expenseType = argExpenseType;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal argAmount) {
            this.amount = argAmount;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String argDate) {
            this.date = argDate;
        }
    }
}

