/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.LinkedHashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.AbstractExpense;
import org.kuali.kfs.module.tem.businessobject.ClassOfService;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeAware;
import org.kuali.kfs.module.tem.businessobject.MileageRate;
import org.kuali.kfs.module.tem.businessobject.OtherExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.MileageRateService;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@Entity
@Table(name="TEM_TRVL_EXP_T")
public class ActualExpense
extends AbstractExpense
implements OtherExpense,
ExpenseTypeAware {
    public static Logger LOG = Logger.getLogger(AbstractExpense.class);
    @GeneratedValue(generator="tem_trvl_exp_id_seq")
    @SequenceGenerator(name="tem_trvl_exp_id_seq", sequenceName="tem_trvl_exp_id_seq", allocationSize=5)
    private String airfareSourceCode;
    private String classOfServiceCode;
    private Integer miles;
    private BigDecimal mileageOtherRate = BigDecimal.ZERO;
    private Boolean rentalCarInsurance = Boolean.FALSE;
    private Boolean airfareIndicator = Boolean.FALSE;
    private Boolean mileageIndicator = Boolean.FALSE;
    private Boolean rentalCarIndicator = Boolean.FALSE;
    private Boolean lodgingIndicator = Boolean.FALSE;
    private Boolean lodgingAllowanceIndicator = Boolean.FALSE;
    private String expenseLineTypeCode = "A";
    private ClassOfService classOfService;

    public boolean getDefaultTabOpen() {
        return !this.getExpenseDetails().isEmpty() || this.getMileageIndicator() != false || this.getAirfareIndicator() != false || this.getRentalCarIndicator() != false || this.getExpenseTypeObjectCode() != null && this.getExpenseTypeObjectCode().getExpenseType().isExpenseDetailRequired();
    }

    @Override
    public void setAirfareSourceCode(String airfareSourceCode) {
        this.airfareSourceCode = airfareSourceCode;
    }

    @Override
    @Column(name="AIRFARE_SRC_CD", nullable=true)
    public String getAirfareSourceCode() {
        return this.airfareSourceCode;
    }

    @Override
    public void setClassOfServiceCode(String classOfServiceCode) {
        this.classOfServiceCode = classOfServiceCode;
    }

    @Override
    @Column(name="CLASS_SVC_CODE", nullable=true)
    public String getClassOfServiceCode() {
        return this.classOfServiceCode;
    }

    public MileageRate getMileageRate(Date effectiveDate) {
        return ((MileageRateService)SpringContext.getBean(MileageRateService.class)).findMileageRateByExpenseTypeCodeAndDate(this.getExpenseTypeCode(), effectiveDate);
    }

    @Deprecated
    public MileageRate getContextlessMileageRate() {
        TravelFormBase travelForm = (TravelFormBase)KNSGlobalVariables.getKualiForm();
        if (travelForm == null) {
            return null;
        }
        TravelDocument travelDocument = travelForm.getTravelDocument();
        if (travelDocument == null) {
            return null;
        }
        Date effectiveDate = travelDocument.getEffectiveDateForMileageRate(this);
        return this.getMileageRate(effectiveDate);
    }

    @Override
    @Column(name="MILES", length=19, nullable=true)
    public Integer getMiles() {
        return this.miles;
    }

    @Override
    public void setMiles(Integer miles) {
        this.miles = miles;
    }

    @Override
    public void setMileageOtherRate(BigDecimal mileageOtherRate) {
        this.mileageOtherRate = mileageOtherRate;
    }

    @Override
    @Column(name="MILEAGE_OTHR_RT", precision=19, scale=2, nullable=true)
    public BigDecimal getMileageOtherRate() {
        return this.mileageOtherRate;
    }

    @Override
    public void setRentalCarInsurance(Boolean rentalCarInsurance) {
        this.rentalCarInsurance = rentalCarInsurance;
    }

    @Override
    @Column(name="RENTAL_CAR_INSURANCE", nullable=true, length=1)
    public Boolean getRentalCarInsurance() {
        return this.rentalCarInsurance;
    }

    public void setAirfareIndicator(Boolean airfareIndicator) {
        this.airfareIndicator = airfareIndicator;
    }

    public Boolean getAirfareIndicator() {
        return this.airfareIndicator;
    }

    public void setMileageIndicator(Boolean mileageIndicator) {
        this.mileageIndicator = mileageIndicator;
    }

    public Boolean getMileageIndicator() {
        return this.mileageIndicator;
    }

    public void setRentalCarIndicator(Boolean rentalCarIndicator) {
        this.rentalCarIndicator = rentalCarIndicator;
    }

    public Boolean getRentalCarIndicator() {
        return this.rentalCarIndicator;
    }

    public void setLodgingIndicator(Boolean lodgingIndicator) {
        this.lodgingIndicator = lodgingIndicator;
    }

    public Boolean getLodgingIndicator() {
        return this.lodgingIndicator;
    }

    public void setLodgingAllowanceIndicator(Boolean lodgingAllowanceIndicator) {
        this.lodgingAllowanceIndicator = lodgingAllowanceIndicator;
    }

    public Boolean getLodgingAllowanceIndicator() {
        return this.lodgingAllowanceIndicator;
    }

    public void enableExpenseTypeSpecificFields() {
        this.setAirfareIndicator(this.isAirfare());
        this.setMileageIndicator(this.isMileage());
        this.setRentalCarIndicator(this.isRentalCar());
        this.setLodgingIndicator(this.isLodging());
        this.setLodgingAllowanceIndicator(this.isLodgingAllowance());
    }

    public boolean isHostedBreakfast() {
        return this.isHostedMeal() && this.isBreakfast();
    }

    public boolean isHostedLunch() {
        return this.isHostedMeal() && this.isLunch();
    }

    public boolean isHostedDinner() {
        return this.isHostedMeal() && this.isDinner();
    }

    public boolean isBreakfast() {
        return this.isInMetaCategory(TemConstants.ExpenseTypeMetaCategory.BREAKFAST);
    }

    public boolean isLunch() {
        return this.isInMetaCategory(TemConstants.ExpenseTypeMetaCategory.LUNCH);
    }

    public boolean isDinner() {
        return this.isInMetaCategory(TemConstants.ExpenseTypeMetaCategory.DINNER);
    }

    public boolean isAirfare() {
        return this.isInMetaCategory(TemConstants.ExpenseTypeMetaCategory.AIRFARE);
    }

    public boolean isMileage() {
        return this.isInMetaCategory(TemConstants.ExpenseTypeMetaCategory.MILEAGE);
    }

    @Override
    public boolean isRentalCar() {
        return this.isInMetaCategory(TemConstants.ExpenseTypeMetaCategory.RENTAL_CAR);
    }

    public boolean isLodging() {
        return this.isInMetaCategory(TemConstants.ExpenseTypeMetaCategory.LODGING);
    }

    public boolean isLodgingAllowance() {
        return this.isInMetaCategory(TemConstants.ExpenseTypeMetaCategory.LODGING_ALLOWANCE);
    }

    public boolean isIncidental() {
        return this.isInMetaCategory(TemConstants.ExpenseTypeMetaCategory.INCIDENTALS);
    }

    protected boolean isInMetaCategory(TemConstants.ExpenseTypeMetaCategory category) {
        if (ObjectUtils.isNull((Object)((Object)this.getExpenseType())) && !StringUtils.isBlank((String)this.getExpenseTypeCode())) {
            this.refreshReferenceObject("expenseType");
        }
        return !ObjectUtils.isNull((Object)((Object)this.getExpenseType())) && category.getCode().equals(this.getExpenseType().getExpenseTypeMetaCategoryCode());
    }

    public boolean isHostedMeal() {
        if (ObjectUtils.isNull((Object)((Object)this.getExpenseType())) && !StringUtils.isBlank((String)this.getExpenseTypeCode())) {
            this.refreshReferenceObject("expenseType");
        }
        return !ObjectUtils.isNull((Object)((Object)this.getExpenseType())) && this.getExpenseType().isHosted();
    }

    @Transient
    public KualiDecimal getMileageTotal() {
        KualiDecimal total;
        block7: {
            total = KualiDecimal.ZERO;
            if (ObjectUtils.isNotNull((Object)this.miles) && this.miles != 0) {
                if (ObjectUtils.isNotNull((Object)this.mileageOtherRate) && this.mileageOtherRate != BigDecimal.ZERO) {
                    total = new KualiDecimal(new BigDecimal(this.miles).multiply(this.mileageOtherRate));
                } else {
                    try {
                        TravelFormBase travelForm = (TravelFormBase)KNSGlobalVariables.getKualiForm();
                        if (travelForm == null) {
                            return KualiDecimal.ZERO;
                        }
                        TravelDocument travelDocument = travelForm.getTravelDocument();
                        if (travelDocument == null) {
                            return KualiDecimal.ZERO;
                        }
                        Date effectiveDate = travelDocument.getEffectiveDateForMileageRate(this);
                        MileageRate mileageRate = this.getMileageRate(effectiveDate);
                        total = new KualiDecimal(new BigDecimal(this.miles).multiply(mileageRate.getRate()));
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Mileage Rate not found." + this.getClass()));
                        LOG.error((Object)ex.getMessage());
                        if (!LOG.isDebugEnabled()) break block7;
                        ex.printStackTrace();
                    }
                }
            }
        }
        return total;
    }

    protected ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    @Override
    public KualiDecimal getExpenseAmount() {
        return super.getExpenseAmount();
    }

    @Override
    public KualiDecimal getConvertedAmount() {
        return super.getConvertedAmount();
    }

    @Override
    public String getSequenceName() {
        String retval;
        block7: {
            Class<?> boClass = this.getClass();
            retval = "";
            try {
                boolean rethrow = true;
                Exception e = null;
                while (rethrow) {
                    LOG.debug((Object)("Looking for id in " + boClass.getName()));
                    try {
                        Field idField = boClass.getDeclaredField("id");
                        SequenceGenerator sequenceInfo = idField.getAnnotation(SequenceGenerator.class);
                        return sequenceInfo.sequenceName();
                    }
                    catch (Exception ee) {
                        LOG.debug((Object)("Could not find id in " + boClass.getName()));
                        if (Object.class.equals(boClass)) {
                            rethrow = false;
                        }
                        boClass = boClass.getSuperclass();
                        e = ee;
                    }
                }
                if (e != null) {
                    throw e;
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Could not get the sequence name for business object " + this.getClass().getSimpleName()));
                LOG.error((Object)e.getMessage());
                if (!LOG.isDebugEnabled()) break block7;
                e.printStackTrace();
            }
        }
        return retval;
    }

    @Override
    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", this.getId());
        map.put("documentNumber", this.getDocumentNumber());
        map.put("expenseDate", this.getExpenseDate());
        map.put("expenseAmount", this.getExpenseAmount());
        return map;
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        return (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
    }

    @Override
    public String getExpenseLineTypeCode() {
        return this.expenseLineTypeCode;
    }

    @Override
    public void setExpenseLineTypeCode(String expenseLineTypeCode) {
        this.expenseLineTypeCode = expenseLineTypeCode;
    }

    public ClassOfService getClassOfService() {
        return this.classOfService;
    }

    public void setClassOfService(ClassOfService classOfService) {
        this.classOfService = classOfService;
    }
}

