/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class AgencyStagingDataLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List agencyData = new ArrayList();
        if (fieldValues != null) {
            String searchAccount = fieldValues.get("searchAccountNumber").trim();
            String searchSubAccount = fieldValues.get("searchSubAccountNumber").trim();
            fieldValues.remove("searchAccountNumber");
            fieldValues.remove("searchSubAccountNumber");
            fieldValues.remove("searchChartOfAccountsCode");
            agencyData = super.getSearchResults(fieldValues);
            if (StringUtils.isNotBlank((String)searchAccount) || StringUtils.isNotBlank((String)searchSubAccount)) {
                ArrayList<AgencyStagingData> temp = new ArrayList<AgencyStagingData>();
                for (AgencyStagingData agency : agencyData) {
                    for (TripAccountingInformation acctgInfo : agency.getTripAccountingInformation()) {
                        String acct = acctgInfo.getTripAccountNumber();
                        String subAcct = acctgInfo.getTripSubAccountNumber();
                        if (StringUtils.isNotBlank((String)searchAccount) && StringUtils.isNotBlank((String)acct) && acct.equals(searchAccount)) {
                            if (StringUtils.isNotBlank((String)searchSubAccount) && StringUtils.isNotBlank((String)subAcct) && subAcct.equals(searchSubAccount)) {
                                temp.add(agency);
                                continue;
                            }
                            if (searchSubAccount != null) continue;
                            temp.add(agency);
                            continue;
                        }
                        if (!StringUtils.isNotBlank((String)searchSubAccount) || !StringUtils.isNotBlank((String)subAcct) || !subAcct.equals(searchSubAccount)) continue;
                        temp.add(agency);
                    }
                }
                agencyData = temp;
            }
        } else {
            agencyData = super.getSearchResults(fieldValues);
        }
        return agencyData;
    }

    public boolean allowsMaintenanceNewOrCopyAction() {
        return super.allowsMaintenanceNewOrCopyAction();
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject bo, List pkNames) {
        List anchorHtmlDataList = super.getCustomActionUrls(bo, pkNames);
        AgencyStagingData agencyStagingData = (AgencyStagingData)bo;
        boolean isTravelManager = this.isUserTravelManager();
        if (agencyStagingData.getMoveToHistoryIndicator() || !isTravelManager) {
            anchorHtmlDataList.clear();
        }
        if (isTravelManager) {
            anchorHtmlDataList.add(this.getViewUrl(agencyStagingData));
        }
        return anchorHtmlDataList;
    }

    private boolean isUserTravelManager() {
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        boolean isTravelManager = ((TravelDocumentService)SpringContext.getBean(TravelDocumentService.class)).isTravelManager(currentUser);
        return isTravelManager;
    }

    private HtmlData getViewUrl(AgencyStagingData agencyStagingData) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        parameters.put("id", agencyStagingData.getId().toString());
        parameters.put("businessObjectClassName", AgencyStagingData.class.getName());
        String href = UrlFactory.parameterizeUrl((String)"inquiry.do", (Properties)parameters);
        HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(href, "start", "view");
        anchorHtmlData.setTarget("blank");
        return anchorHtmlData;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        if (this.isUserTravelManager()) {
            lookupForm.setSuppressActions(false);
        } else {
            lookupForm.setSuppressActions(true);
        }
        return super.performLookup(lookupForm, resultTable, bounded);
    }
}

