/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.web.bean.AccountingLineDistributionKey;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class TemAccountingLineTotalsValidation
extends GenericValidation {
    protected AccountingDistributionService accountingDistributionService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean rulePassed = true;
        TravelDocument travelDocument = (TravelDocument)event.getDocument();
        List<AccountingDistribution> distributions = this.getAccountingDistributionService().buildDistributionFrom(travelDocument);
        KualiDecimal totalRemaining = KualiDecimal.ZERO;
        HashMap<AccountingLineDistributionKey, KualiDecimal> amounts = new HashMap<AccountingLineDistributionKey, KualiDecimal>();
        HashMap<AccountingLineDistributionKey, KualiDecimal> finalAmounts = new HashMap<AccountingLineDistributionKey, KualiDecimal>();
        HashMap<AccountingLineDistributionKey, Integer> lineIndexes = new HashMap<AccountingLineDistributionKey, Integer>();
        KualiDecimal distributionsTotal = KualiDecimal.ZERO;
        for (AccountingDistribution dist : distributions) {
            distributionsTotal = (KualiDecimal)distributionsTotal.add((AbstractKualiDecimal)dist.getSubTotal());
            AccountingLineDistributionKey key = new AccountingLineDistributionKey(dist.getObjectCode(), dist.getCardType());
            if (amounts.containsKey(key)) {
                KualiDecimal tempAmount = (KualiDecimal)dist.getSubTotal().add((AbstractKualiDecimal)amounts.get(key));
                amounts.put(key, tempAmount);
                finalAmounts.put(key, tempAmount);
                continue;
            }
            amounts.put(key, dist.getSubTotal());
            finalAmounts.put(key, dist.getSubTotal());
        }
        if (travelDocument.getSourceAccountingLines() != null && !travelDocument.getSourceAccountingLines().isEmpty()) {
            List errorPath = GlobalVariables.getMessageMap().getErrorPath();
            GlobalVariables.getMessageMap().clearErrorPath();
            KualiDecimal accountingLineTotal = KualiDecimal.ZERO;
            for (TemSourceAccountingLine line : travelDocument.getSourceAccountingLines()) {
                accountingLineTotal = (KualiDecimal)accountingLineTotal.add((AbstractKualiDecimal)line.getAmount());
                AccountingLineDistributionKey key = new AccountingLineDistributionKey(line.getFinancialObjectCode(), line.getCardType());
                if (amounts.containsKey(key)) {
                    if (((KualiDecimal)amounts.get(key)).isGreaterEqual((AbstractKualiDecimal)line.getAmount())) {
                        KualiDecimal tempAmount = (KualiDecimal)((KualiDecimal)amounts.get(key)).subtract((AbstractKualiDecimal)line.getAmount());
                        amounts.put(key, tempAmount);
                        lineIndexes.put(key, line.getSequenceNumber());
                        continue;
                    }
                    GlobalVariables.getMessageMap().putError("document.sourceAccountingLine[" + (line.getSequenceNumber() - 1) + "]." + "financialObjectCode", "error.tem.accountingline.objectcode.total", new String[]{key.getFinancialObjectCode(), key.getCardType(), ((KualiDecimal)finalAmounts.get(key)).toString()});
                    rulePassed = false;
                    continue;
                }
                if (event.getDocument() instanceof TravelAuthorizationDocument) continue;
                GlobalVariables.getMessageMap().putError("document.sourceAccountingLine[" + (line.getSequenceNumber() - 1) + "]." + "financialObjectCode", "error.tem.accountingline.objectcode", new String[]{line.getFinancialObjectCode(), line.getCardType()});
                rulePassed = false;
            }
            if (rulePassed) {
                if (travelDocument.getExpenseLimit() == null || travelDocument.getExpenseLimit().equals((Object)KualiDecimal.ZERO) || distributionsTotal.isLessThan((AbstractKualiDecimal)travelDocument.getExpenseLimit())) {
                    for (AccountingLineDistributionKey key : amounts.keySet()) {
                        KualiDecimal tempAmount = (KualiDecimal)amounts.get(key);
                        if (tempAmount.isZero()) continue;
                        String errorKey = lineIndexes.containsKey(key) ? "document.sourceAccountingLine[" + ((Integer)lineIndexes.get(key) - 1) + "]." + "financialObjectCode" : "newSourceLine.financialObjectCode";
                        GlobalVariables.getMessageMap().putError(errorKey, "error.tem.accountingline.objectcode.total", new String[]{key.getFinancialObjectCode(), key.getCardType(), ((KualiDecimal)finalAmounts.get(key)).toString()});
                        rulePassed = false;
                    }
                } else if (accountingLineTotal.isLessThan((AbstractKualiDecimal)travelDocument.getExpenseLimit())) {
                    GlobalVariables.getMessageMap().putError("newSourceLine.amount", "error.tem.accountingline.objectcode.total.expenseLimit", new String[]{distributionsTotal.toString(), travelDocument.getExpenseLimit().toString(), accountingLineTotal.toString()});
                    rulePassed = false;
                } else if (accountingLineTotal.isGreaterThan((AbstractKualiDecimal)travelDocument.getExpenseLimit())) {
                    GlobalVariables.getMessageMap().putError("newSourceLine.amount", "error.tem.accountingline.expenseLimit.exceeded", new String[]{accountingLineTotal.toString(), travelDocument.getExpenseLimit().toString()});
                    rulePassed = false;
                }
            }
            GlobalVariables.getMessageMap().getErrorPath().addAll(errorPath);
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        return rulePassed;
    }

    public AccountingDistributionService getAccountingDistributionService() {
        return this.accountingDistributionService;
    }

    public void setAccountingDistributionService(AccountingDistributionService accountingDistributionService) {
        this.accountingDistributionService = accountingDistributionService;
    }
}

