/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.Observable;
import java.util.Observer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.validation.event.AddActualExpenseDetailLineEvent;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.module.tem.util.ExpenseUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AddActualExpenseDetailEvent
implements Observer {
    public static Logger LOG = Logger.getLogger(AddActualExpenseDetailEvent.class);
    protected volatile TravelExpenseService travelExpenseService;
    private static final int WRAPPER_ARG_IDX = 0;
    private static final int SELECTED_LINE_ARG_IDX = 1;

    @Override
    public void update(Observable arg0, Object arg1) {
        if (!(arg1 instanceof Object[])) {
            return;
        }
        Object[] args = (Object[])arg1;
        LOG.debug(args[0]);
        if (!(args[0] instanceof TravelMvcWrapperBean)) {
            return;
        }
        TravelMvcWrapperBean wrapper = (TravelMvcWrapperBean)args[0];
        TravelDocument document = wrapper.getTravelDocument();
        Integer index = (Integer)args[1];
        ActualExpense newActualExpenseLine = wrapper.getNewActualExpenseLines().get(index);
        ActualExpense line = document.getActualExpenses().get(index);
        if (newActualExpenseLine != null) {
            if (StringUtils.isBlank((String)newActualExpenseLine.getExpenseTypeCode())) {
                newActualExpenseLine.setExpenseTypeCode(line.getExpenseTypeCode());
            }
            newActualExpenseLine.refreshReferenceObject("expenseTypeObjectCode");
            if (ObjectUtils.isNull((Object)((Object)newActualExpenseLine.getExpenseTypeObjectCode()))) {
                if (StringUtils.isBlank((String)newActualExpenseLine.getExpenseTypeCode())) {
                    newActualExpenseLine.setExpenseTypeCode(line.getExpenseTypeCode());
                }
                if (!(StringUtils.isBlank((String)document.getTripTypeCode()) || ObjectUtils.isNull((Object)((Object)document.getTraveler())) || StringUtils.isBlank((String)document.getTraveler().getTravelerTypeCode()))) {
                    ExpenseTypeObjectCode expenseTypeObjectCode = ((TravelExpenseService)SpringContext.getBean(TravelExpenseService.class)).getExpenseType(newActualExpenseLine.getExpenseTypeCode(), document.getDocumentTypeName(), document.getTripTypeCode(), document.getTraveler().getTravelerTypeCode());
                    newActualExpenseLine.setExpenseTypeObjectCode(expenseTypeObjectCode);
                    newActualExpenseLine.setExpenseTypeObjectCodeId(expenseTypeObjectCode.getExpenseTypeObjectCodeId());
                }
            }
        }
        boolean rulePassed = true;
        if (rulePassed &= this.getRuleService().applyRules(new AddActualExpenseDetailLineEvent<ActualExpense>("newActualExpenseLines[" + index + "]", (Document)document, line, newActualExpenseLine))) {
            if (newActualExpenseLine != null && line != null) {
                newActualExpenseLine.setExpenseLineTypeCode(null);
                if (newActualExpenseLine.getExpenseTypeObjectCodeId() == null || newActualExpenseLine.getExpenseTypeObjectCodeId().equals(new Long(0L))) {
                    newActualExpenseLine.setExpenseTypeObjectCode(null);
                }
                document.addExpenseDetail(newActualExpenseLine, index);
                newActualExpenseLine.setExpenseDetails(null);
            }
            KualiDecimal detailTotal = line.getTotalDetailExpenseAmount();
            ActualExpense newExpense = this.getTravelExpenseService().createNewDetailForActualExpense(line);
            if (detailTotal.isLessEqual((AbstractKualiDecimal)line.getExpenseAmount())) {
                KualiDecimal remainderExpense = (KualiDecimal)line.getExpenseAmount().subtract((AbstractKualiDecimal)detailTotal);
                KualiDecimal remainderConverted = (KualiDecimal)line.getConvertedAmount().subtract((AbstractKualiDecimal)new KualiDecimal(detailTotal.bigDecimalValue().multiply(line.getCurrencyRate())));
                newExpense.setExpenseAmount(remainderExpense);
                newExpense.setConvertedAmount(remainderConverted);
            } else {
                newExpense.setExpenseAmount(KualiDecimal.ZERO);
            }
            wrapper.getNewActualExpenseLines().add(index, newExpense);
            wrapper.getNewActualExpenseLines().remove(index + 1);
            ExpenseUtils.calculateMileage(document, document.getActualExpenses());
            wrapper.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(document));
        }
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected KualiRuleService getRuleService() {
        return (KualiRuleService)SpringContext.getBean(KualiRuleService.class);
    }

    protected AccountingDistributionService getAccountingDistributionService() {
        return (AccountingDistributionService)SpringContext.getBean(AccountingDistributionService.class);
    }

    protected TravelExpenseService getTravelExpenseService() {
        if (this.travelExpenseService == null) {
            this.travelExpenseService = (TravelExpenseService)SpringContext.getBean(TravelExpenseService.class);
        }
        return this.travelExpenseService;
    }
}

