/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.util.List;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.tem.TravelEntertainmentMovingModuleService;
import org.kuali.kfs.integration.tem.TravelEntertainmentMovingTravelDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.AccountingDocumentRelationshipService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.rice.kim.api.identity.Person;

public class TravelEntertainmentMovingModuleServiceImpl
implements TravelEntertainmentMovingModuleService {
    private ParameterService parameterService;
    private TravelDocumentService travelDocumentService;
    private TravelerService travelerService;
    private AccountingDocumentRelationshipService accountingDocumentRelationshipService;

    public boolean isTEMDocument(String docId) {
        boolean isTEMDoc = false;
        Document doc = this.find(docId);
        isTEMDoc = doc.getClass().getPackage().getName().contains("org.kuali.kfs.module.tem");
        return isTEMDoc;
    }

    public TravelEntertainmentMovingTravelDocument getTEMDocument(String temDocId) {
        TravelEntertainmentMovingTravelDocument doc = null;
        doc = (TravelEntertainmentMovingTravelDocument)this.find(temDocId);
        return doc;
    }

    private Document find(String temDocId) {
        TravelReimbursementDocument doc = null;
        List<TravelReimbursementDocument> results = this.travelDocumentService.findReimbursementDocuments(temDocId);
        if (results != null && !results.isEmpty()) {
            doc = results.get(0);
        }
        return doc;
    }

    public boolean isTemProfileEmployee(TravelEntertainmentMovingTravelDocument document) {
        return this.travelerService.isEmployee(((TravelDocument)document).getTraveler());
    }

    public boolean isTravelManager(Person user) {
        return this.travelDocumentService.isTravelManager(user);
    }

    public void createAccountingDocumentRelationship(String documentNumber, String relDocumentNumber, String relationDescription) {
        this.accountingDocumentRelationshipService.save(new AccountingDocumentRelationship(documentNumber, relDocumentNumber, relationDescription));
    }

    public boolean isTravelReimbursementDocument(TravelEntertainmentMovingTravelDocument document) {
        return document instanceof TravelReimbursementDocument;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelerService(TravelerService travelerService) {
        this.travelerService = travelerService;
    }

    public TravelerService getTravelerService() {
        return this.travelerService;
    }

    public AccountingDocumentRelationshipService getAccountingDocumentRelationshipService() {
        return this.accountingDocumentRelationshipService;
    }

    public void setAccountingDocumentRelationshipService(AccountingDocumentRelationshipService accountingDocumentRelationshipService) {
        this.accountingDocumentRelationshipService = accountingDocumentRelationshipService;
    }
}

