/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.sql.Date;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.batch.PerDiemLoadStep;
import org.kuali.kfs.module.tem.batch.businessobject.PerDiemForLoad;
import org.kuali.kfs.module.tem.batch.service.PerDiemLoadService;
import org.kuali.kfs.module.tem.batch.service.PerDiemLoadValidationService;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.kfs.module.tem.businessobject.PrimaryDestination;
import org.kuali.kfs.module.tem.businessobject.TemRegion;
import org.kuali.kfs.module.tem.service.PerDiemService;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.MessageBuilder;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.service.BatchInputFileService;
import org.kuali.kfs.sys.report.BusinessObjectReportHelper;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.springframework.transaction.annotation.Transactional;

public class PerDiemLoadServiceImpl
implements PerDiemLoadService {
    public static Logger LOG = Logger.getLogger(PerDiemLoadServiceImpl.class);
    public static final String REPORT_FILE_NAME_PATTERN = "{0}/{1}_{2}{3}";
    private PerDiemService perDiemService;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private DateTimeService dateTimeService;
    private PerDiemLoadValidationService perDiemLoadValidationService;
    private BusinessObjectReportHelper perDiemUploadReportHelper;
    private BatchInputFileService batchInputFileService;
    private List<BatchInputFileType> perDiemInputFileTypes;
    private String perDiemFileErrorDirectory;
    private String perDiemReportDirectory;
    private String perDiemReportFilePrefix;
    private java.util.Date futureDate;
    Collection<TemRegion> persistedRegions;
    Collection<PrimaryDestination> persistedPrimaryDestinations;

    @Override
    public boolean loadPerDiem() {
        boolean success = true;
        String dateValue = this.parameterService.getParameterValueAsString(PerDiemLoadStep.class, "DEFAULT_EFFECTIVE_TO_DATE");
        try {
            this.futureDate = this.dateTimeService.convertToDate(dateValue);
        }
        catch (ParseException pe) {
            LOG.error((Object)"Unable to parse the parameter value to a Date for DEFAULT_EFFECTIVE_TO_DATE");
            throw new RuntimeException(pe);
        }
        for (BatchInputFileType inputFileType : this.perDiemInputFileTypes) {
            List inputFileNames = this.batchInputFileService.listInputFileNamesWithDoneFile(inputFileType);
            for (String dataFileName : inputFileNames) {
                success &= this.loadPerDiem(dataFileName, inputFileType);
            }
        }
        return success;
    }

    @Override
    @Transactional
    public boolean loadPerDiem(String dataFileName, BatchInputFileType inputFileType) {
        String fileExtension = "." + inputFileType.getFileExtension();
        String doneFileName = this.getCompanionFileName(dataFileName, fileExtension, ".done");
        File doneFile = this.getFileByAbsolutePath(doneFileName);
        try {
            FileInputStream fileContents = new FileInputStream(dataFileName);
            LOG.info((Object)("Processing Per Diem file [" + dataFileName + "]"));
            byte[] fileByteContent = IOUtils.toByteArray((InputStream)fileContents);
            List perDiemList = (List)this.batchInputFileService.parse(inputFileType, fileByteContent);
            IOUtils.closeQuietly((InputStream)fileContents);
            List<PerDiemForLoad> perDiemLoadList = this.validatePerDiem(perDiemList, dataFileName);
            this.persistedRegions = this.businessObjectService.findAll(TemRegion.class);
            Map<String, TemRegion> newRegions = this.extractTemCountries(perDiemLoadList, true);
            for (TemRegion temRegion : newRegions.values()) {
                this.businessObjectService.save((PersistableBusinessObject)temRegion);
            }
            this.persistedPrimaryDestinations = this.businessObjectService.findAll(PrimaryDestination.class);
            Map<String, PrimaryDestination> newPrimaryDestinations = this.extractPrimaryDestinations(perDiemLoadList, true);
            for (PrimaryDestination primaryDestination : newPrimaryDestinations.values()) {
                this.businessObjectService.save((PersistableBusinessObject)primaryDestination);
            }
            this.persistedPrimaryDestinations = this.businessObjectService.findAll(PrimaryDestination.class);
            HashMap<String, PrimaryDestination> hashMap = new HashMap<String, PrimaryDestination>();
            for (PrimaryDestination primaryDestination : this.persistedPrimaryDestinations) {
                hashMap.put(primaryDestination.getRegionCode() + ":" + primaryDestination.getCounty() + ":" + primaryDestination.getPrimaryDestinationName(), primaryDestination);
            }
            for (PerDiem perDiem : perDiemLoadList) {
                if (perDiem.getPrimaryDestination().getId() == null) {
                    StringBuilder keyBuilder = new StringBuilder();
                    keyBuilder.append(perDiem.getPrimaryDestination().getRegionCode());
                    keyBuilder.append(":");
                    keyBuilder.append(perDiem.getPrimaryDestination().getCounty());
                    keyBuilder.append(":");
                    keyBuilder.append(perDiem.getPrimaryDestination().getPrimaryDestinationName());
                    PrimaryDestination pd = (PrimaryDestination)hashMap.get(keyBuilder.toString());
                    if (pd == null) continue;
                    if (pd.equals(perDiem.getPrimaryDestination())) {
                        perDiem.setPrimaryDestinationId(pd.getId());
                    }
                } else {
                    perDiem.setPrimaryDestinationId(perDiem.getPrimaryDestination().getId());
                }
                List<PerDiem> oldPerDiems = this.perDiemService.retrievePreviousPerDiem(perDiem);
                for (PerDiem oldPerDiem : oldPerDiems) {
                    if (!KfsDateUtils.isSameDay((java.util.Date)oldPerDiem.getEffectiveToDate(), (java.util.Date)this.futureDate)) continue;
                    oldPerDiem.setEffectiveToDate(new Date(DateUtils.addDays((java.util.Date)perDiem.getEffectiveFromDate(), (int)0).getTime()));
                    this.businessObjectService.save((PersistableBusinessObject)oldPerDiem);
                }
            }
            this.businessObjectService.save(perDiemLoadList);
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to process the file : " + dataFileName), (Throwable)ex);
            this.moveErrorFile(dataFileName, this.getPerDiemFileErrorDirectory());
            throw new RuntimeException("Failed to process the file : " + dataFileName, ex);
        }
        finally {
            boolean bl = doneFile.delete();
        }
        return true;
    }

    protected Map<String, PrimaryDestination> extractPrimaryDestinations(List<PerDiemForLoad> validPerDiemList, boolean newOnly) {
        HashMap<String, PrimaryDestination> primaryDests = new HashMap<String, PrimaryDestination>();
        for (PerDiem perDiem : validPerDiemList) {
            PrimaryDestination primaryDest = perDiem.getPrimaryDestination();
            primaryDest.setRegionCode(primaryDest.getRegion().getRegionCode());
            if (!this.persistedPrimaryDestinations.contains(primaryDest) && newOnly) {
                primaryDests.put(primaryDest.getRegionCode() + ":" + primaryDest.getCounty() + ":" + primaryDest.getPrimaryDestinationName(), primaryDest);
                continue;
            }
            if (newOnly) continue;
            primaryDests.put(primaryDest.getRegionCode() + ":" + primaryDest.getCounty() + ":" + primaryDest.getPrimaryDestinationName(), primaryDest);
        }
        return primaryDests;
    }

    protected Map<String, TemRegion> extractTemCountries(List<PerDiemForLoad> validPerDiemList, boolean newOnly) {
        HashMap<String, TemRegion> regions = new HashMap<String, TemRegion>();
        for (PerDiem perDiem : validPerDiemList) {
            TemRegion region = perDiem.getPrimaryDestination().getRegion();
            if (!this.persistedRegions.contains(region) && newOnly) {
                regions.put(region.getRegionCode(), region);
                continue;
            }
            if (newOnly) continue;
            regions.put(region.getRegionCode(), region);
        }
        return regions;
    }

    protected boolean isRejectAllWhenError() {
        return this.getParameterService().getParameterValueAsBoolean(PerDiemLoadStep.class, "REJECT_FILE_IND");
    }

    @Override
    public List<PerDiemForLoad> updatePerDiem(List<PerDiemForLoad> perDiemList) {
        ArrayList<PerDiemForLoad> filteredPerDiemList = new ArrayList<PerDiemForLoad>();
        int lineNumber = 0;
        for (PerDiemForLoad perDiemForLoad : perDiemList) {
            if (!this.shouldProcess(perDiemForLoad)) continue;
            this.updatePerDiem(perDiemForLoad);
            perDiemForLoad.setLineNumber(++lineNumber);
            filteredPerDiemList.add(perDiemForLoad);
        }
        return filteredPerDiemList;
    }

    @Override
    public void updatePerDiem(PerDiemForLoad perDiem) {
        Date effectiveDate = this.getEffectiveDateFromString(perDiem);
        perDiem.setEffectiveFromDate(effectiveDate);
        Date effectiveToDate = this.getExpirationDateFromString(perDiem);
        perDiem.setEffectiveToDate(effectiveToDate);
        Date loadDate = this.getDateTimeService().getCurrentSqlDate();
        perDiem.setLoadDate(loadDate);
        this.getPerDiemService().updateTripType(perDiem);
        this.getPerDiemService().breakDownMealsIncidental(perDiem);
        String seasonBeginMonthAndDay = perDiem.getSeasonBeginDateAsString();
        perDiem.setSeasonBeginMonthAndDay(seasonBeginMonthAndDay);
    }

    protected Date getSessionBeginDateFromString(PerDiemForLoad perDiem) {
        String seasonBeginDateAsString = perDiem.getSeasonBeginDateAsString();
        return this.buildDate(perDiem, seasonBeginDateAsString);
    }

    protected Date getSessionEndDateFromString(PerDiemForLoad perDiem) {
        String seasonEndDateAsString = perDiem.getSeasonEndDateAsString();
        return this.buildDate(perDiem, seasonEndDateAsString);
    }

    protected Date buildDate(PerDiemForLoad perDiem, String seasonDateAsString) {
        int effectiveYear = this.getEffectiveYear(perDiem);
        Date effectiveDate = perDiem.getEffectiveFromDate();
        Date seasonDate = this.getDateFromString(seasonDateAsString, effectiveYear);
        int difference = this.getDateTimeService().dateDiff((java.util.Date)effectiveDate, (java.util.Date)seasonDate, true);
        if (difference <= 0) {
            DateUtils.addYears((java.util.Date)seasonDate, (int)1);
        }
        return seasonDate;
    }

    protected Date getEffectiveDateFromString(PerDiemForLoad perDiem) {
        int effectiveYear = this.getDateTimeService().getCurrentCalendar().get(1);
        return this.getDateFromString(perDiem.getEffectiveDateAsString(), effectiveYear);
    }

    protected Date getExpirationDateFromString(PerDiemForLoad perDiem) {
        int effectiveYear = this.getDateTimeService().getCurrentCalendar().get(1);
        return this.getDateFromString(perDiem.getExpirationDateAsString(), effectiveYear);
    }

    protected Date getDateFromString(String dateAsString, int effectiveYear) {
        String localDateAsString = this.completeDateString(dateAsString, effectiveYear);
        return this.convertDateFrom(localDateAsString);
    }

    protected String completeDateString(String dateString, int effectiveYear) {
        if (StringUtils.isNotEmpty((String)dateString) && StringUtils.countMatches((String)dateString, (String)"/") >= 2) {
            return dateString;
        }
        return dateString + "/" + effectiveYear;
    }

    protected Date convertDateFrom(String dateString) {
        try {
            java.util.Date localDate = TemConstants.SIMPLE_DATE_FORMAT.parse(dateString);
            return KfsDateUtils.convertToSqlDate((java.util.Date)localDate);
        }
        catch (ParseException ex) {
            throw new RuntimeException("The date " + dateString + " must be formatted as " + "MM/dd/yyyy", ex);
        }
    }

    protected int getEffectiveYear(PerDiemForLoad perDiem) {
        Date effectiveDate = perDiem.getEffectiveFromDate();
        return this.getDateTimeService().getCurrentCalendar().get(1);
    }

    protected void moveErrorFile(String fileName, String directory) {
        File dataFile = this.getFileByAbsolutePath(fileName);
        if (dataFile != null && dataFile.exists()) {
            File errorDirectory = this.getFileByAbsolutePath(directory);
            try {
                FileUtils.moveToDirectory((File)dataFile, (File)errorDirectory, (boolean)true);
            }
            catch (IOException ex) {
                LOG.error((Object)("Cannot move the file:" + fileName + " to the directory: " + this.perDiemFileErrorDirectory), (Throwable)ex);
            }
        }
    }

    protected File getFileByAbsolutePath(String absolutePath) {
        File dataFile = new File(absolutePath);
        if (!dataFile.exists() || !dataFile.canRead()) {
            LOG.error((Object)("Cannot find/read data file " + absolutePath));
            return null;
        }
        return dataFile;
    }

    protected String getCompanionFileName(String fileAbsPath, String fileExtension, String companionFileExtension) {
        return StringUtils.removeEnd((String)fileAbsPath, (String)fileExtension).concat(companionFileExtension);
    }

    protected <T extends PerDiem> List<T> validatePerDiem(List<T> perDiemList, String fileName) {
        ArrayList<PerDiem> validPerDiems = new ArrayList<PerDiem>();
        PrintStream reportDataStream = this.getReportPrintStream();
        this.writeReportHeader(reportDataStream, fileName);
        for (PerDiem perDiem : perDiemList) {
            List<Message> errorMessage = this.getPerDiemLoadValidationService().validate(perDiem);
            if (ObjectUtils.isNotNull(errorMessage) && !errorMessage.isEmpty()) {
                this.writeErrorToReport(reportDataStream, perDiem, errorMessage);
                continue;
            }
            validPerDiems.add(perDiem);
        }
        if (reportDataStream != null) {
            reportDataStream.flush();
            reportDataStream.close();
        }
        return validPerDiems;
    }

    protected void writeReportHeader(PrintStream reportDataStream, String fileName) {
        StringBuilder header = new StringBuilder();
        header.append(MessageBuilder.buildMessageWithPlaceHolder((String)"message.batch.tem.perDiemReportHeader", (Object[])new Object[]{"\n", fileName}));
        header.append("\n");
        header.append("\n");
        header.append("\n");
        Map tableDefinition = this.getPerDiemUploadReportHelper().getTableDefinition();
        String tableHeaderFormat = (String)tableDefinition.get("tableHeaderLine");
        header.append(tableHeaderFormat);
        reportDataStream.print(header);
    }

    protected <T extends PerDiem> void writeErrorToReport(PrintStream reportDataStream, T perDiem, List<Message> errorMessage) {
        String reportEntry = this.formatMessage(perDiem, errorMessage);
        reportDataStream.println(reportEntry);
    }

    protected <T extends PerDiem> String formatMessage(T perDiem, List<Message> messageList) {
        StringBuilder body = new StringBuilder();
        Map tableDefinition = this.getPerDiemUploadReportHelper().getTableDefinition();
        String tableCellFormat = (String)tableDefinition.get("tableCellFormat");
        List propertyList = this.getPerDiemUploadReportHelper().getTableCellValues(perDiem, false);
        String fieldLine = String.format(tableCellFormat, propertyList.toArray());
        body.append(fieldLine);
        for (Message message : messageList) {
            body.append("\t**  ").append(message).append("\n");
        }
        return body.toString();
    }

    protected PrintStream getReportPrintStream() {
        String dateTime = this.dateTimeService.toDateTimeStringForFilename((java.util.Date)this.dateTimeService.getCurrentSqlDate());
        String reportFileName = MessageFormat.format(REPORT_FILE_NAME_PATTERN, this.getPerDiemReportDirectory(), this.getPerDiemReportFilePrefix(), dateTime, ".txt");
        File outputfile = new File(reportFileName);
        try {
            return new PrintStream(outputfile);
        }
        catch (FileNotFoundException e) {
            String errorMessage = "Cannot find the output file: " + reportFileName;
            LOG.error((Object)errorMessage);
            throw new RuntimeException(errorMessage, e);
        }
    }

    protected <T extends PerDiem> boolean shouldProcess(T perDiem) {
        Collection bypassStateCountryCodes = this.getParameterService().getParameterValuesAsString(PerDiemLoadStep.class, "BYPASS_STATE_OR_COUNTRY_CODES");
        return bypassStateCountryCodes == null || bypassStateCountryCodes.isEmpty() || !bypassStateCountryCodes.contains(perDiem.getPrimaryDestination().getRegion().getRegionCode());
    }

    public PerDiemService getPerDiemService() {
        return this.perDiemService;
    }

    public void setPerDiemService(PerDiemService perDiemService) {
        this.perDiemService = perDiemService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public String getPerDiemFileErrorDirectory() {
        return this.perDiemFileErrorDirectory;
    }

    public void setPerDiemFileErrorDirectory(String perDiemFileErrorDirectory) {
        this.perDiemFileErrorDirectory = perDiemFileErrorDirectory;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public PerDiemLoadValidationService getPerDiemLoadValidationService() {
        return this.perDiemLoadValidationService;
    }

    public void setPerDiemLoadValidationService(PerDiemLoadValidationService perDiemLoadValidationService) {
        this.perDiemLoadValidationService = perDiemLoadValidationService;
    }

    public String getPerDiemReportDirectory() {
        return this.perDiemReportDirectory;
    }

    public void setPerDiemReportDirectory(String perDiemReportDirectory) {
        this.perDiemReportDirectory = perDiemReportDirectory;
    }

    public String getPerDiemReportFilePrefix() {
        return this.perDiemReportFilePrefix;
    }

    public void setPerDiemReportFilePrefix(String perDiemReportFilePrefix) {
        this.perDiemReportFilePrefix = perDiemReportFilePrefix;
    }

    public BusinessObjectReportHelper getPerDiemUploadReportHelper() {
        return this.perDiemUploadReportHelper;
    }

    public void setPerDiemUploadReportHelper(BusinessObjectReportHelper perDiemUploadReportHelper) {
        this.perDiemUploadReportHelper = perDiemUploadReportHelper;
    }

    public BatchInputFileService getBatchInputFileService() {
        return this.batchInputFileService;
    }

    public void setBatchInputFileService(BatchInputFileService batchInputFileService) {
        this.batchInputFileService = batchInputFileService;
    }

    public List<BatchInputFileType> getPerDiemInputFileTypes() {
        return this.perDiemInputFileTypes;
    }

    public void setPerDiemInputFileTypes(List<BatchInputFileType> perDiemInputFileTypes) {
        this.perDiemInputFileTypes = perDiemInputFileTypes;
    }
}

