/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.service.SessionDocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TravelerProfileForLookup;
import org.kuali.kfs.module.tem.businessobject.lookup.TemProfileLookupableHelperServiceImpl;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.bo.BusinessObject;

public class TravelerProfileDocLookupableHelperServiceImpl
extends TemProfileLookupableHelperServiceImpl {
    protected PermissionService permissionService;

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        Map<String, String> viewRecordPermissionDetails = this.getPermissionDetailsForViewRecordsCheck();
        String currentUserPrincipalId = GlobalVariables.getUserSession().getPrincipalId();
        String documentTypeName = this.updateAuthorizationDocumentType(this.getCurrentDocumentTypeName());
        List<? extends BusinessObject> allProfiles = super.getSearchResults(fieldValues);
        ArrayList<TemProfile> qualifyingProfiles = new ArrayList<TemProfile>();
        for (TemProfile temProfile : allProfiles) {
            Map<String, String> roleQualifier = this.getRoleQualifierForViewRecordsCheck(temProfile, documentTypeName);
            if (!this.getPermissionService().isAuthorizedByTemplate(currentUserPrincipalId, KFSConstants.PermissionTemplate.VIEW_RECORD.namespace, KFSConstants.PermissionTemplate.VIEW_RECORD.name, viewRecordPermissionDetails, roleQualifier)) continue;
            qualifyingProfiles.add(temProfile);
        }
        return qualifyingProfiles;
    }

    protected Map<String, String> getPermissionDetailsForViewRecordsCheck() {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("componentName", TravelerProfileForLookup.class.getSimpleName());
        return permissionDetails;
    }

    protected Map<String, String> getRoleQualifierForViewRecordsCheck(TemProfile profile, String documentTypeName) {
        HashMap<String, String> roleQualifier = new HashMap<String, String>();
        roleQualifier.put("chartOfAccountsCode", profile.getHomeDeptChartOfAccountsCode());
        roleQualifier.put("organizationCode", profile.getHomeDeptOrgCode());
        roleQualifier.put("profilePrincipalId", profile.getPrincipalId());
        roleQualifier.put("customerProfileId", profile.getCustomerNumber());
        roleQualifier.put("profileId", profile.getProfileId().toString());
        if (!StringUtils.isBlank((String)documentTypeName)) {
            roleQualifier.put("documentTypeName", documentTypeName);
        }
        return roleQualifier;
    }

    protected String getCurrentDocumentTypeName() {
        KualiForm form = KNSGlobalVariables.getKualiForm();
        if (form != null) {
            String docNum;
            if (form instanceof KualiDocumentFormBase) {
                return ((KualiDocumentFormBase)KNSGlobalVariables.getKualiForm()).getDocTypeName();
            }
            if (form instanceof LookupForm && !StringUtils.isBlank((String)(docNum = ((LookupForm)KNSGlobalVariables.getKualiForm()).getDocNum()))) {
                WorkflowDocument workflowDocument = ((SessionDocumentService)SpringContext.getBean(SessionDocumentService.class)).getDocumentFromSession(GlobalVariables.getUserSession(), docNum);
                return workflowDocument.getDocumentTypeName();
            }
        }
        return null;
    }

    protected String updateAuthorizationDocumentType(String documentType) {
        if (!StringUtils.isBlank((String)documentType) && ("TAC".equals(documentType) || "TAA".equals(documentType))) {
            return "TA";
        }
        return documentType;
    }

    public Class getBusinessObjectClass() {
        return TemProfile.class;
    }

    @Override
    public String getSupplementalMenuBar() {
        return "";
    }

    protected void setRows() {
        List lookupFieldAttributeList = null;
        Class<TravelerProfileForLookup> businessObjectClazz = TravelerProfileForLookup.class;
        if (this.getBusinessObjectMetaDataService().isLookupable(businessObjectClazz)) {
            lookupFieldAttributeList = this.getBusinessObjectMetaDataService().getLookupableFieldNames(businessObjectClazz);
        }
        if (lookupFieldAttributeList == null) {
            throw new RuntimeException("Lookup not defined for business object " + this.getBusinessObjectClass());
        }
        List fields = new ArrayList();
        try {
            fields = FieldUtils.createAndPopulateFieldsForLookup((List)lookupFieldAttributeList, (List)this.getReadOnlyFieldsList(), businessObjectClazz);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create instance of business object class" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to create instance of business object class" + e.getMessage());
        }
        int numCols = this.getBusinessObjectDictionaryService().getLookupNumberOfColumns(businessObjectClazz);
        this.rows = FieldUtils.wrapFields(fields, (int)numCols);
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

