/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.fp.document.DisbursementVoucherDocument;
import org.kuali.kfs.gl.businessobject.Encumbrance;
import org.kuali.kfs.gl.service.EncumbranceService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.kfs.module.tem.document.TEMReimbursementDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;

@Entity
@Table(name="TEM_TRVL_REIMB_DOC_T")
public class TravelReimbursementDocument
extends TEMReimbursementDocument
implements AmountTotaling {
    public static Logger LOG = Logger.getLogger(TravelReimbursementDocument.class);
    private static volatile IdentityService identityService;
    @Column(name="final_reimb_ind", nullable=false, length=1)
    private Boolean finalReimbursement = Boolean.FALSE;
    private Boolean employeeCertification = Boolean.FALSE;
    private String contactName;
    private String contactPhoneNum;
    private String contactEmailAddress;
    private String contactCampusCode;
    private KualiDecimal perDiemAdjustment;
    private KualiDecimal travelAdvanceAmount = KualiDecimal.ZERO;
    @Transient
    private KualiDecimal reimbursableAmount = KualiDecimal.ZERO;
    @Transient
    private List<TravelAdvance> travelAdvances;

    public Boolean getFinalReimbursement() {
        return this.finalReimbursement;
    }

    public void setFinalReimbursement(Boolean finalReimbursement) {
        this.finalReimbursement = finalReimbursement;
    }

    @Column(name="emp_cert_ind", nullable=false, length=1)
    public Boolean getEmployeeCertification() {
        return this.employeeCertification;
    }

    public void setEmployeeCertification(Boolean employeeCertification) {
        this.employeeCertification = employeeCertification;
    }

    public Boolean getNonEmployeeCertification() {
        return this.employeeCertification == false;
    }

    public void setNonEmployeeCertification(Boolean employeeCertification) {
        this.employeeCertification = employeeCertification == false;
    }

    @Column(name="con_nm", length=40, nullable=false)
    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    @Column(name="con_phone_nbr", length=20, nullable=false)
    public String getContactPhoneNum() {
        return this.contactPhoneNum;
    }

    public void setContactPhoneNum(String contactPhoneNum) {
        this.contactPhoneNum = contactPhoneNum;
    }

    @Column(name="con_email_addr", length=40, nullable=true)
    public String getContactEmailAddress() {
        return this.contactEmailAddress;
    }

    public void setContactEmailAddress(String contactEmailAddress) {
        this.contactEmailAddress = contactEmailAddress;
    }

    @Column(name="con_campus_cd", length=2, nullable=true)
    public String getContactCampusCode() {
        return this.contactCampusCode;
    }

    public void setContactCampusCode(String contactCampusCode) {
        this.contactCampusCode = contactCampusCode;
    }

    @Override
    public void setPerDiemAdjustment(KualiDecimal perDiemAdjustment) {
        this.perDiemAdjustment = perDiemAdjustment;
    }

    @Override
    public KualiDecimal getPerDiemAdjustment() {
        return this.perDiemAdjustment;
    }

    public KualiDecimal getTravelAdvanceAmount() {
        return this.travelAdvanceAmount;
    }

    public void setTravelAdvanceAmount(KualiDecimal travelAdvanceAmount) {
        this.travelAdvanceAmount = travelAdvanceAmount;
    }

    public KualiDecimal getReimbursableAmount() {
        return this.reimbursableAmount;
    }

    public void setReimbursableAmount(KualiDecimal reimbursableAmount) {
        this.reimbursableAmount = reimbursableAmount;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        LOG.debug((Object)"Handling route status change");
        if (DocumentStatus.PROCESSED.getCode().equals(statusChangeEvent.getNewRouteStatus())) {
            try {
                this.updateAndSaveAppDocStatus("Department Approved");
                this.getTravelReimbursementService().processCustomerReimbursement(this);
            }
            catch (Exception e) {
                LOG.error((Object)("Could not spawn CRM or DV on FINAL for travel id " + this.getTravelDocumentIdentifier()));
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                final TravelAuthorizationDocument openAuthorization = this.getTravelReimbursementService().getRelatedOpenTravelAuthorizationDocument(this);
                List<Document> authorizations = this.getTravelDocumentService().getDocumentsRelatedTo(this, "TA");
                if (openAuthorization != null) {
                    List<Document> relatedCloseDocuments = this.getTravelDocumentService().getDocumentsRelatedTo(openAuthorization, "TAC");
                    if (relatedCloseDocuments.isEmpty() && this.getFinalReimbursement().booleanValue()) {
                        this.getBusinessObjectService().save(this.getGeneralLedgerPendingEntries());
                        String initiatorId = this.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
                        final Principal initiator = this.getIdentityService().getPrincipal(initiatorId);
                        GlobalVariables.doInNewGlobalVariables((UserSession)new UserSession(initiator.getPrincipalName()), (Callable)new Callable<Object>(){

                            @Override
                            public Object call() {
                                TravelReimbursementDocument.this.getTravelAuthorizationService().closeAuthorization(openAuthorization, TravelReimbursementDocument.this.getTripDescription(), initiator.getPrincipalName(), TravelReimbursementDocument.this.getDocumentNumber());
                                return null;
                            }
                        });
                    }
                } else if (!authorizations.isEmpty()) {
                    Note newNote = this.getDocumentService().createNoteFromDocument((Document)this, "TA is no longer Open; skip Dis-encumberance process.");
                    this.addNote(newNote);
                    this.getDocumentDao().save((Document)this);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Could Add notes for annotation to TR doc #" + this.getDocumentNumber()));
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void toCopy() throws WorkflowException {
        super.toCopy();
        this.getNotes().clear();
        this.addContactInformation();
        this.employeeCertification = Boolean.FALSE;
    }

    public void addContactInformation() {
        String initiatorName = GlobalVariables.getUserSession().getPrincipalName();
        Person initiator = this.getPersonService().getPersonByPrincipalName(initiatorName);
        this.setContactName(initiator.getName());
        this.setContactPhoneNum(initiator.getPhoneNumber());
        this.setContactEmailAddress(initiator.getEmailAddress());
        this.setContactCampusCode(initiator.getCampusCode());
    }

    @Override
    public void initiateDocument() {
        super.initiateDocument();
        this.setApplicationDocumentStatus("In Process");
        this.getTravelPayment().setDocumentationLocationCode(this.getParameterService().getParameterValueAsString(TravelReimbursementDocument.class, "DOCUMENTATION_LOCATION_CODE", this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "DOCUMENTATION_LOCATION_CODE")));
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("TravelRequiresDivisionApproval")) {
            return this.requiresDivisionApprovalRouting() && this.isNotAutomaticReimbursement();
        }
        if (nodeName.equals("TravelHasSpecialRequest")) {
            return (this.requiresSpecialRequestReviewRouting() || this.isDelinquent() && !this.hasDelinquencyException()) && this.isNotAutomaticReimbursement();
        }
        if (nodeName.equals("TravelIsInternational")) {
            return this.requiresInternationalTravelReviewRouting() && this.isNotAutomaticReimbursement();
        }
        if (nodeName.equals("TaxManagerApproval")) {
            return this.requiresTaxManagerApprovalRouting() && this.isNotAutomaticReimbursement();
        }
        if (StringUtils.equals((String)"RequiresBudgetReview", (String)nodeName)) {
            return this.isBudgetReviewRequired();
        }
        if (nodeName.equals("RequiresSeparationOfDuties")) {
            return this.requiresSeparationOfDutiesRouting() && this.isNotAutomaticReimbursement();
        }
        if (nodeName.equals("TravelRequiresTravelerApproval")) {
            return this.requiresTravelerApprovalRouting();
        }
        if (nodeName.equals("RequiresAward") || nodeName.equals("RequiresSubFund")) {
            return this.isNotAutomaticReimbursement();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    /*
     * WARNING - void declaration
     */
    private boolean isNotAutomaticReimbursement() {
        void var3_7;
        List<Document> authorizations;
        boolean enabled = this.getParameterService().getParameterValueAsBoolean(TravelReimbursementDocument.class, "AUTOMATIC_APPROVALS_IND");
        if (!enabled) {
            return true;
        }
        if (!ObjectUtils.isNull((Object)((Object)this.getTraveler())) && !StringUtils.equals((String)this.getTraveler().getTravelerTypeCode(), (String)"EMP")) {
            return true;
        }
        if (this.getActualExpenses() != null && this.getActualExpenses().size() > 0) {
            for (ActualExpense actualExpense : this.getActualExpenses()) {
                if (actualExpense.getExpenseTypeObjectCode() == null || !actualExpense.getExpenseTypeObjectCode().isReceiptRequired() || !this.getTravelExpenseService().isTravelExpenseExceedReceiptRequirementThreshold(actualExpense)) continue;
                return true;
            }
        }
        if ((authorizations = this.getTravelDocumentService().getDocumentsRelatedTo(this, "TA", "TAA")) != null && !authorizations.isEmpty()) {
            for (Document doc : authorizations) {
                TravelAuthorizationDocument auth = (TravelAuthorizationDocument)doc;
                if (ObjectUtils.isNull((Object)((Object)auth.getTravelAdvance())) || !auth.shouldProcessAdvanceForDocument() || !"W".equals(auth.getAdvanceTravelPayment().getPaymentMethodCode()) && !"F".equals(auth.getAdvanceTravelPayment().getPaymentMethodCode())) continue;
                return true;
            }
        }
        KualiDecimal kualiDecimal = KualiDecimal.ZERO;
        List lines = this.getSourceAccountingLines();
        for (AccountingLine line : lines) {
            KualiDecimal kualiDecimal2 = (KualiDecimal)var3_7.add((AbstractKualiDecimal)line.getAmount());
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("code", this.getTripTypeCode());
        TripType tripType = (TripType)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(TripType.class, fieldValues);
        KualiDecimal threshold = tripType.getAutoTravelReimbursementLimit();
        return var3_7.isGreaterEqual((AbstractKualiDecimal)threshold);
    }

    protected boolean isDelinquent() {
        return !StringUtils.isBlank((String)this.getDelinquentAction());
    }

    protected boolean hasDelinquencyException() {
        if (this.getDelinquentTRException() != null && this.getDelinquentTRException().booleanValue()) {
            return true;
        }
        TravelAuthorizationDocument travelAuth = this.getTravelDocumentService().findCurrentTravelAuthorization(this);
        if (travelAuth != null && travelAuth.getDelinquentTRException() != null) {
            return travelAuth.getDelinquentTRException();
        }
        return false;
    }

    @Override
    protected boolean requiresInternationalTravelReviewRouting() {
        return super.requiresInternationalTravelReviewRouting() && this.requiresDivisionApprovalRouting();
    }

    @Override
    protected boolean requiresDivisionApprovalRouting() {
        KualiDecimal divApprovalMax;
        boolean reqDivApproval = false;
        KualiDecimal trTotal = this.getTravelDocumentService().getTotalCumulativeReimbursements(this);
        return trTotal.isGreaterThan((AbstractKualiDecimal)(divApprovalMax = new KualiDecimal(this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "CUMULATIVE_REIMBURSABLE_AMOUNT_WITHOUT_DIVISION_APPROVAL")))) && this.requiresAccountingReviewRouting();
    }

    public KualiDecimal getTotalAuthorizedEncumbrance() {
        KualiDecimal taTotal = this.getTravelDocumentService().getTotalAuthorizedEncumbrance(this);
        return taTotal;
    }

    public KualiDecimal getTotalCumulativeReimbursements() {
        KualiDecimal trTotal = this.getTravelDocumentService().getTotalCumulativeReimbursements(this);
        return trTotal;
    }

    private boolean requiresAccountingReviewRouting() {
        String percent = this.getParameterService().getParameterValueAsString(TravelReimbursementDocument.class, "REIMBURSEMENT_PERCENT_OVER_ENCUMBRANCE_AMOUNT");
        KualiDecimal taTotal = this.getTravelDocumentService().getTotalAuthorizedEncumbrance(this);
        if (taTotal.isLessEqual((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            return false;
        }
        KualiDecimal trTotal = this.getTravelDocumentService().getTotalCumulativeReimbursements(this);
        if (trTotal.isLessEqual((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            return false;
        }
        if (trTotal.isGreaterThan((AbstractKualiDecimal)taTotal)) {
            KualiDecimal subAmount = (KualiDecimal)trTotal.subtract((AbstractKualiDecimal)taTotal);
            KualiDecimal percentOver = (KualiDecimal)((KualiDecimal)subAmount.divide((AbstractKualiDecimal)taTotal)).multiply((AbstractKualiDecimal)new KualiDecimal(100));
            return percentOver.isGreaterThan((AbstractKualiDecimal)new KualiDecimal(percent));
        }
        return false;
    }

    public DocumentDao getDocumentDao() {
        return (DocumentDao)SpringContext.getBean(DocumentDao.class);
    }

    @Override
    public KualiDecimal getPaymentAmount() {
        KualiDecimal paymentAmountBeforeAdvances = super.getPaymentAmount();
        KualiDecimal paymentAmountAfterAdvances = (KualiDecimal)paymentAmountBeforeAdvances.subtract((AbstractKualiDecimal)this.getAdvancesTotal());
        if (paymentAmountAfterAdvances.isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            return KualiDecimal.ZERO;
        }
        return paymentAmountAfterAdvances;
    }

    public List<TravelAdvance> getTravelAdvances() {
        if (this.travelAdvances == null) {
            this.travelAdvances = this.getTravelDocumentService().getTravelAdvancesForTrip(this.getTravelDocumentIdentifier());
        }
        return this.travelAdvances;
    }

    public KualiDecimal getAdvancesTotal() {
        KualiDecimal retval = KualiDecimal.ZERO;
        retval = this.getTravelAdvanceAmount().isZero() ? this.getTravelReimbursementService().getInvoiceAmount(this) : this.getTravelAdvanceAmount();
        return retval;
    }

    @Override
    public KualiDecimal getReimbursableGrandTotal() {
        KualiDecimal grandTotal = this.getReimbursableTotal();
        KualiDecimal advancesTotal = this.getAdvancesTotal();
        if (advancesTotal.isGreaterThan((AbstractKualiDecimal)grandTotal)) {
            return KualiDecimal.ZERO;
        }
        KualiDecimal reimbursableGrandTotal = (KualiDecimal)grandTotal.subtract((AbstractKualiDecimal)this.getAdvancesTotal());
        KualiDecimal reimbursableGrandTotalAfterExpenseLimit = this.applyExpenseLimit(reimbursableGrandTotal);
        return reimbursableGrandTotalAfterExpenseLimit;
    }

    @Override
    public String getReportPurpose() {
        return this.getTripDescription();
    }

    @Override
    public void populateVendorPayment(DisbursementVoucherDocument disbursementVoucherDocument) {
        super.populateVendorPayment(disbursementVoucherDocument);
        String locationCode = this.getParameterService().getParameterValueAsString(TravelReimbursementDocument.class, "DOCUMENTATION_LOCATION_CODE", this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "DOCUMENTATION_LOCATION_CODE"));
        String startDate = new SimpleDateFormat("MM/dd/yyyy").format(this.getTripBegin());
        String endDate = new SimpleDateFormat("MM/dd/yyyy").format(this.getTripEnd());
        String checkStubText = this.getTravelDocumentIdentifier() + ", " + this.getPrimaryDestinationName() + ", " + startDate + " - " + endDate;
        disbursementVoucherDocument.setDisbursementVoucherDocumentationLocationCode(locationCode);
        disbursementVoucherDocument.setDisbVchrCheckStubText(checkStubText);
    }

    @Override
    @Transient
    public KualiDecimal getEncumbranceTotal() {
        KualiDecimal encTotal = KualiDecimal.ZERO;
        List<Encumbrance> encumbrances = this.getTravelEncumbranceService().getEncumbrancesForTrip(this.getTravelDocumentIdentifier(), this.getDocumentNumber());
        for (Encumbrance enc : encumbrances) {
            encTotal = (KualiDecimal)encTotal.add((AbstractKualiDecimal)enc.getAccountLineEncumbranceAmount());
        }
        return encTotal;
    }

    @Override
    public String getAchCheckDocumentType() {
        return "TRCA";
    }

    @Override
    public String getWireTransferOrForeignDraftDocumentType() {
        return "TRWF";
    }

    @Override
    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        boolean result = super.generateDocumentGeneralLedgerPendingEntries(sequenceHelper);
        if (this.isTripGenerateEncumbrance()) {
            this.getTravelEncumbranceService().disencumberTravelReimbursementFunds(this, sequenceHelper);
        }
        this.getTravelReimbursementService().generateEntriesForAdvances(this, sequenceHelper);
        return result;
    }

    @Override
    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        super.customizeExplicitGeneralLedgerPendingEntry(postable, explicitEntry);
        if (postable instanceof AccountingLine) {
            AccountingLine accountingLine = (AccountingLine)postable;
            if ("B".equals(accountingLine.getFinancialDocumentLineTypeCode())) {
                explicitEntry.setTransactionDebitCreditCode("D");
                explicitEntry.setFinancialDocumentTypeCode("TRTA");
            } else if ("C".equals(accountingLine.getFinancialDocumentLineTypeCode())) {
                explicitEntry.setTransactionDebitCreditCode("C");
                explicitEntry.setFinancialDocumentTypeCode("TRTA");
            }
        }
    }

    @Override
    public KualiDecimal getApprovedAmount() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (TemConstants.ExpenseType expense : EnumSet.allOf(TemConstants.ExpenseType.class)) {
            KualiDecimal expenseAmount = this.getTravelExpenseService().getExpenseServiceByType(expense).getAllExpenseTotal(this, false);
            if (expenseAmount == null) {
                expenseAmount = KualiDecimal.ZERO;
            }
            total = (KualiDecimal)expenseAmount.add((AbstractKualiDecimal)total);
            if (!expense.equals((Object)TemConstants.ExpenseType.perDiem) || this.getPerDiemAdjustment() == null || !this.getPerDiemAdjustment().isPositive() || !expenseAmount.isPositive()) continue;
            total = (KualiDecimal)total.subtract((AbstractKualiDecimal)this.getPerDiemAdjustment());
        }
        return total;
    }

    protected PersonService getPersonService() {
        return (PersonService)SpringContext.getBean(PersonService.class);
    }

    protected DocumentService getDocumentService() {
        return (DocumentService)SpringContext.getBean(DocumentService.class);
    }

    protected TravelAuthorizationService getTravelAuthorizationService() {
        return (TravelAuthorizationService)SpringContext.getBean(TravelAuthorizationService.class);
    }

    protected EncumbranceService getEncumbranceService() {
        return (EncumbranceService)SpringContext.getBean(EncumbranceService.class);
    }

    protected GeneralLedgerPendingEntryService getGeneralLedgerPendingEntryService() {
        return (GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class);
    }

    protected IdentityService getIdentityService() {
        if (identityService == null) {
            identityService = (IdentityService)SpringContext.getBean(IdentityService.class);
        }
        return identityService;
    }

    @Override
    public Map<String, String> getDisapprovedAppDocStatusMap() {
        return TemConstants.TravelReimbursementStatusCodeKeys.getDisapprovedAppDocStatusMap();
    }

    @Override
    protected String generateDescription() {
        DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        String description = super.generateDescription();
        if (this.getTripEnd() != null && this.getTripBegin() != null) {
            boolean preTripReimbursement = false;
            try {
                Date tripEnd = dateTimeService.convertToSqlDate(this.getTripEnd());
                Date tripBegin = dateTimeService.convertToSqlDate(this.getTripBegin());
                Date currentDate = dateTimeService.getCurrentSqlDate();
                preTripReimbursement = tripBegin.compareTo(currentDate) >= 0 && tripEnd.compareTo(currentDate) >= 0;
            }
            catch (ParseException pe) {
                LOG.error((Object)"Error while parsing dates ", (Throwable)pe);
            }
            boolean preTrip = this.getParameterService().getParameterValueAsBoolean(TravelReimbursementDocument.class, "PRETRIP_REIMBURSEMENT_IND", Boolean.valueOf(false));
            if (preTrip && preTripReimbursement) {
                return this.postpendPreTripToDescription(description);
            }
        }
        return description;
    }

    protected String postpendPreTripToDescription(String description) {
        String postPendedDescription = "PT:" + description;
        int maxLength = TravelReimbursementDocument.getDataDictionaryService().getAttributeMaxLength(this.getDocumentHeader().getClass(), "documentDescription");
        String fittedDescription = postPendedDescription.length() > maxLength ? postPendedDescription.substring(0, maxLength) : postPendedDescription;
        return fittedDescription;
    }

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        super.prepareForSave(event);
        this.getTravelPayment().setCheckStubText(this.getTravelDocumentIdentifier() + " " + StringUtils.defaultString((String)this.getTripDescription()) + " " + this.getTripBegin());
    }
}

