/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.sql.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ProjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileAccount;
import org.kuali.kfs.module.tem.businessobject.TemProfileArranger;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class TemProfileRule
extends MaintenanceDocumentRuleBase {
    protected static final String TRAVEL_ARRANGERS_SECTION_ID = "TemProfileArrangers";
    protected static volatile TemProfileService temProfileService;
    protected static volatile DataDictionaryService dataDictionaryService;

    protected boolean dataDictionaryValidate(MaintenanceDocument document) {
        List subAccountList;
        String errorMessage;
        BusinessObjectService businessObjectService = this.getBusinessObjectService();
        TemProfile profile = (TemProfile)document.getNewMaintainableObject().getBusinessObject();
        TravelService travelService = (TravelService)SpringContext.getBean(TravelService.class);
        boolean success = true;
        List paths = GlobalVariables.getMessageMap().getErrorPath();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        paths.add("document");
        paths.add("newMaintainableObject");
        if (!StringUtils.isEmpty((String)profile.getPhoneNumber()) && !StringUtils.isBlank((String)(errorMessage = travelService.validatePhoneNumber(profile.getCountryCode(), profile.getPhoneNumber(), "error.document.tem.phoneNumber")))) {
            GlobalVariables.getMessageMap().putError("phoneNumber", errorMessage, new String[]{"Phone Number"});
            success = false;
        }
        if (!StringUtils.isEmpty((String)profile.getDefaultChartCode())) {
            fieldValues.put("chartOfAccountsCode", profile.getDefaultChartCode());
            List chartList = (List)businessObjectService.findMatching(Chart.class, fieldValues);
            if (chartList.size() == 0) {
                GlobalVariables.getMessageMap().putError("defaultChartCode", "error.tem.profile.chartMustExist", new String[]{profile.getDefaultChartCode()});
                success = false;
            }
        } else {
            profile.setChart(null);
        }
        if (success && !StringUtils.isEmpty((String)profile.getDefaultAccount())) {
            fieldValues.put("accountNumber", profile.getDefaultAccount());
            List accountList = (List)businessObjectService.findMatching(Account.class, fieldValues);
            if (accountList.size() == 0) {
                GlobalVariables.getMessageMap().putError("defaultAccount", "error.tem.profile.accountNumberMustExist", new String[]{profile.getDefaultAccount()});
                success = false;
            }
        } else {
            profile.setAccount(null);
        }
        if (success && !StringUtils.isEmpty((String)profile.getDefaultSubAccount())) {
            fieldValues.put("subAccountNumber", profile.getDefaultSubAccount());
            subAccountList = (List)businessObjectService.findMatching(SubAccount.class, fieldValues);
            if (subAccountList.size() == 0) {
                GlobalVariables.getMessageMap().putError("defaultSubAccount", "error.tem.profile.subAccountNumberMustExist", new String[]{profile.getDefaultSubAccount()});
                success = false;
            }
        } else {
            profile.setSubAccount(null);
        }
        if (!StringUtils.isEmpty((String)profile.getDefaultProjectCode())) {
            fieldValues.clear();
            fieldValues.put("code", profile.getDefaultProjectCode());
            subAccountList = (List)businessObjectService.findMatching(ProjectCode.class, fieldValues);
            if (subAccountList.size() == 0) {
                GlobalVariables.getMessageMap().putError("defaultProjectCode", "error.tem.profile.projectCodeMustExist", new String[]{profile.getDefaultProjectCode()});
                success = false;
            }
        } else {
            profile.setProject(null);
        }
        for (int i = 0; i < profile.getAccounts().size(); ++i) {
            paths.add("accounts[" + i + "]");
            TemProfileAccount account = profile.getAccounts().get(i);
            paths.remove(paths.size() - 1);
        }
        if (profile.getArrangers() != null) {
            int arrangerPrimaryCount = 0;
            HashSet<String> arrangerId = new HashSet<String>();
            for (TemProfileArranger arranger : profile.getArrangers()) {
                if (arranger.getPrimary()) {
                    ++arrangerPrimaryCount;
                }
                arrangerId.add(arranger.getPrincipalName());
                paths.add("arrangers");
                paths.remove(paths.size() - 1);
            }
            if (arrangerPrimaryCount > 1) {
                GlobalVariables.getMessageMap().putError("arrangers", "error.tem.profile.arranger.primary", new String[0]);
                success = false;
            }
            if (profile.getArrangers().size() != arrangerId.size()) {
                GlobalVariables.getMessageMap().putError("arrangers", "error.tem.profile.arranger.duplicate", new String[0]);
                success = false;
            }
        }
        paths.clear();
        boolean bl = success = success && super.dataDictionaryValidate(document);
        if (success) {
            Person user = GlobalVariables.getUserSession().getPerson();
            profile.setUpdatedBy(user.getPrincipalName());
            java.util.Date current = new java.util.Date();
            profile.setLastUpdate(new Date(current.getTime()));
        }
        return success;
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        TemProfile profile = (TemProfile)document.getNewMaintainableObject().getBusinessObject();
        if (line instanceof TemProfileArranger) {
            TemProfileArranger arranger = (TemProfileArranger)line;
            if ("NON".equals(profile.getTravelerTypeCode())) {
                TravelService travelService = (TravelService)SpringContext.getBean(TravelService.class);
                String initiatorId = document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
                Person person = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(initiatorId);
            }
            if (arranger.getPrimary()) {
                for (TemProfileArranger tempArranger : ((TemProfile)document.getNewMaintainableObject().getBusinessObject()).getArrangers()) {
                    tempArranger.setPrimary(false);
                }
                if ("NON".equals(profile.getTravelerTypeCode())) {
                    String profileChart = profile.getHomeDeptChartOfAccountsCode();
                    String profileOrg = profile.getHomeDeptOrgCode();
                    Person arrangerPerson = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(arranger.getPrincipalId());
                    String[] primaryDeptCode = arrangerPerson.getPrimaryDepartmentCode().split("-");
                    if (primaryDeptCode != null && primaryDeptCode.length == 2) {
                        profile.setHomeDeptChartOfAccountsCode(primaryDeptCode[0]);
                        profile.setHomeDeptOrgCode(primaryDeptCode[1]);
                    }
                }
            }
        } else if (line instanceof TemProfileAccount) {
            TemProfileAccount account = (TemProfileAccount)line;
            return this.checkNewTemProfileAccount(profile, account);
        }
        return super.processCustomAddCollectionLineBusinessRules(document, collectionName, line);
    }

    protected boolean checkNewTemProfileAccount(TemProfile temProfile, TemProfileAccount account) {
        boolean success = true;
        if (!StringUtils.isBlank((String)account.getAccountNumber())) {
            Integer minLength = this.getDataDictionaryService().getAttributeMaxLength(TemProfile.class, "accountNumber");
            if (minLength != null && account.getAccountNumber().length() < minLength) {
                String label = this.getDataDictionaryService().getAttributeLabel(TemProfile.class, "accountNumber");
                String[] errorMessage = null;
                errorMessage = new String[]{label, minLength.toString()};
                GlobalVariables.getMessageMap().putError("accountNumber", "error.minLength", errorMessage);
                success = false;
            }
            if (this.doesProfileAccountMatchExisting(temProfile, account)) {
                if (account.getCreditCardOrAgencyCode() != null) {
                    account.refreshReferenceObject("creditCardAgency");
                }
                GlobalVariables.getMessageMap().putError("accountNumber", "error.tem.profile.accountId.duplicate", new String[]{account.getCreditCardAgency().getCreditCardOrAgencyName(), account.getAccountNumber()});
                success = false;
            }
        }
        return success;
    }

    protected boolean doesProfileAccountMatchExisting(TemProfile profile, TemProfileAccount newAccount) {
        if (profile.getAccounts() == null || profile.getAccounts().isEmpty()) {
            return this.getTemProfileService().doesProfileAccountExist(newAccount, profile);
        }
        for (TemProfileAccount existingAccount : profile.getAccounts()) {
            if (!StringUtils.equals((String)existingAccount.getAccountNumber(), (String)newAccount.getAccountNumber()) || !StringUtils.equals((String)existingAccount.getCreditCardOrAgencyCode(), (String)newAccount.getCreditCardOrAgencyCode())) continue;
            return true;
        }
        return this.getTemProfileService().doesProfileAccountExist(newAccount, profile);
    }

    protected boolean checkActiveArrangersForNonEmployees(TemProfile profile) {
        boolean success = true;
        if (profile != null && this.getTemProfileService().isProfileNonEmploye(profile) && !this.getTemProfileService().hasActiveArrangers(profile)) {
            GlobalVariables.getMessageMap().putErrorForSectionId(TRAVEL_ARRANGERS_SECTION_ID, "error.tem.profile.nonEmployee.mustHaveActiveArranger", new String[0]);
            success = false;
        }
        return success;
    }

    protected boolean checkEmailAddressForNonEmployees(TemProfile profile) {
        boolean success = true;
        if (profile != null && this.getTemProfileService().isProfileNonEmploye(profile) && StringUtils.isBlank((String)profile.getEmailAddress())) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.emailAddress", "error.tem.profile.nonEmployee.mustHaveEmail", new String[0]);
            success = false;
        }
        return success;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = true;
        TemProfile profile = (TemProfile)document.getNewMaintainableObject().getBusinessObject();
        if (ObjectUtils.isNotNull((Object)profile.getHomeDeptOrg()) && !profile.getHomeDeptOrg().isActive()) {
            this.putFieldError("homeDepartment", "error.tem.profile.organization.inactive", profile.getHomeDeptChartOfAccountsCode() + "-" + profile.getHomeDeptOrgCode());
            success = false;
        }
        success &= this.checkActiveArrangersForNonEmployees(profile);
        return success &= this.checkEmailAddressForNonEmployees(profile);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    protected TemProfileService getTemProfileService() {
        if (temProfileService == null) {
            temProfileService = (TemProfileService)SpringContext.getBean(TemProfileService.class);
        }
        return temProfileService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
        }
        return dataDictionaryService;
    }
}

