/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.module.tem.util.ExpenseUtils;
import org.kuali.kfs.sys.context.SpringContext;

public class RemoveImportedExpenseEvent
implements Observer {
    public static Logger LOG = Logger.getLogger(RemoveImportedExpenseEvent.class);
    private static final int WRAPPER_ARG_IDX = 0;
    private static final int SELECTED_LINE_ARG_IDX = 1;

    @Override
    public void update(Observable arg0, Object arg1) {
        if (!(arg1 instanceof Object[])) {
            return;
        }
        Object[] args = (Object[])arg1;
        LOG.debug(args[0]);
        if (!(args[0] instanceof TravelMvcWrapperBean)) {
            return;
        }
        TravelMvcWrapperBean wrapper = (TravelMvcWrapperBean)args[0];
        TravelDocument document = wrapper.getTravelDocument();
        Integer deleteIndex = (Integer)args[1];
        ImportedExpense line = document.getImportedExpenses().get(deleteIndex);
        document.removeExpense(line, deleteIndex);
        ExpenseUtils.assignExpense(line.getHistoricalTravelExpenseId(), null, null, null, false);
        List<ImportedExpense> importedExpenses = wrapper.getNewImportedExpenseLines();
        if (wrapper.getNewImportedExpenseLines().size() > deleteIndex) {
            wrapper.getNewImportedExpenseLines().remove(deleteIndex);
        }
        wrapper.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(document));
    }

    private int getNextDetailIndex(List<ImportedExpense> importedExpenses, Long id) {
        int index = 0;
        for (ImportedExpense detailLine : importedExpenses) {
            if (ObjectUtils.isNotNull((Object)detailLine.getExpenseParentId()) && detailLine.getExpenseParentId().equals(id)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected KualiRuleService getRuleService() {
        return (KualiRuleService)SpringContext.getBean(KualiRuleService.class);
    }

    protected AccountingDistributionService getAccountingDistributionService() {
        return (AccountingDistributionService)SpringContext.getBean(AccountingDistributionService.class);
    }
}

