/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service;

import java.util.List;
import org.junit.Test;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.module.tem.batch.service.ExpenseImportByTripService;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.businessobject.defaultvalue.NextAgencyStagingDataIdFinder;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.khuntley)
public class ExpenseImportByTripServiceTest
extends KualiTestBase {
    private ExpenseImportByTripService expenseImportByTripService;
    private DateTimeService dateTimeService;
    private BusinessObjectService businessObjectService;
    private SequenceAccessorService sas;
    private ParameterService parameterService;
    private DocumentService documentService;
    private static final String TRIP_ID = "12345678";

    protected void setUp() throws Exception {
        super.setUp();
        this.expenseImportByTripService = (ExpenseImportByTripService)SpringContext.getBean(ExpenseImportByTripService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.sas = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
        this.parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
    }

    @Test
    @ConfigureContext(shouldCommitTransactions=false, session=UserNameFixture.khuntley)
    public void testValidateAccountingInfo() {
        AgencyStagingData agency = this.createAgencyStagingData();
        TravelAuthorizationDocument travelAuth = this.createTA();
        this.expenseImportByTripService.validateAccountingInfo(agency);
        ExpenseImportByTripServiceTest.assertTrue((boolean)agency.getErrorCode().equals("OK"));
        TripAccountingInformation accountingInfo = (TripAccountingInformation)agency.getTripAccountingInformation().get(0);
        accountingInfo.setTripAccountNumber("");
        this.expenseImportByTripService.validateAccountingInfo(agency);
        ExpenseImportByTripServiceTest.assertTrue((boolean)agency.getErrorCode().equals("ACT"));
        accountingInfo.setTripAccountNumber("1031400");
        accountingInfo.setTripSubAccountNumber("ZZ");
        agency.setErrorCode("OK");
        this.expenseImportByTripService.validateAccountingInfo(agency);
        ExpenseImportByTripServiceTest.assertTrue((boolean)agency.getErrorCode().equals("SACT"));
        accountingInfo.setTripSubAccountNumber("");
        accountingInfo.setProjectCode("COOL");
        agency.setErrorCode("OK");
        this.expenseImportByTripService.validateAccountingInfo(agency);
        ExpenseImportByTripServiceTest.assertTrue((boolean)agency.getErrorCode().equals("PROJ"));
    }

    @Test
    @ConfigureContext(shouldCommitTransactions=false)
    public void testValidateTripId() throws Exception {
        AgencyStagingData agency = this.createAgencyStagingData();
        this.expenseImportByTripService.validateTripId(agency);
        ExpenseImportByTripServiceTest.assertTrue((boolean)agency.getErrorCode().equals("TRIP"));
    }

    @Test
    @ConfigureContext(shouldCommitTransactions=false)
    public void testIsDuplicate() {
        AgencyStagingData dbData = this.createAgencyStagingData();
        this.businessObjectService.save((PersistableBusinessObject)dbData);
        AgencyStagingData importData = this.createAgencyStagingData();
        List errorMessages = this.expenseImportByTripService.validateDuplicateData(importData);
        ExpenseImportByTripServiceTest.assertTrue((!errorMessages.isEmpty() ? 1 : 0) != 0);
        importData.setTripId("987654321");
        errorMessages = this.expenseImportByTripService.validateDuplicateData(importData);
        ExpenseImportByTripServiceTest.assertTrue((boolean)errorMessages.isEmpty());
    }

    @Test
    @ConfigureContext(shouldCommitTransactions=false)
    public void testAreMandatoryFieldsPresent() {
        AgencyStagingData agency = this.createAgencyStagingData();
        List errorMessages = this.expenseImportByTripService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTripServiceTest.assertTrue((boolean)errorMessages.isEmpty());
        agency.setAirTicketNumber("");
        errorMessages = this.expenseImportByTripService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTripServiceTest.assertFalse((boolean)errorMessages.isEmpty());
        agency.setTripInvoiceNumber("");
        errorMessages = this.expenseImportByTripService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTripServiceTest.assertFalse((boolean)errorMessages.isEmpty());
        agency.setTripExpenseAmount("");
        errorMessages = this.expenseImportByTripService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTripServiceTest.assertFalse((boolean)errorMessages.isEmpty());
        ((TripAccountingInformation)agency.getTripAccountingInformation().get(0)).setTripAccountNumber("");
        errorMessages = this.expenseImportByTripService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTripServiceTest.assertFalse((boolean)errorMessages.isEmpty());
        agency.setTransactionPostingDate(null);
        errorMessages = this.expenseImportByTripService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTripServiceTest.assertFalse((boolean)errorMessages.isEmpty());
        agency.setAlternateTripId(null);
        errorMessages = this.expenseImportByTripService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTripServiceTest.assertFalse((boolean)errorMessages.isEmpty());
        agency.setTripId("");
        errorMessages = this.expenseImportByTripService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTripServiceTest.assertFalse((boolean)errorMessages.isEmpty());
        agency.setCreditCardOrAgencyCode("");
        errorMessages = this.expenseImportByTripService.validateMandatoryFieldsPresent(agency);
        ExpenseImportByTripServiceTest.assertFalse((boolean)errorMessages.isEmpty());
    }

    protected TemProfile createTemProfile() {
        TemProfile profile = new TemProfile();
        Integer newProfileId = this.sas.getNextAvailableSequenceNumber("TEM_PROFILE_ID_SEQ").intValue();
        profile.setProfileId(newProfileId);
        profile.getTemProfileAddress().setProfileId(newProfileId);
        profile.setDefaultChartCode("BL");
        profile.setDefaultAccount("1031400");
        profile.setDefaultSubAccount("ADV");
        profile.setDefaultProjectCode("KUL");
        profile.setDateOfBirth(this.dateTimeService.getCurrentSqlDate());
        profile.setGender("M");
        profile.setHomeDeptOrgCode("BL");
        profile.setHomeDeptChartOfAccountsCode("BL");
        return profile;
    }

    protected AgencyStagingData createAgencyStagingData() {
        AgencyStagingData agency = new AgencyStagingData();
        NextAgencyStagingDataIdFinder idFinder = new NextAgencyStagingDataIdFinder();
        agency.setId(Integer.valueOf(idFinder.getValue()));
        agency.setImportBy("TRP");
        agency.setTravelerName("Traveler Bob");
        agency.setCreditCardOrAgencyCode("1234");
        agency.setTripId(TRIP_ID);
        agency.setAlternateTripId(TRIP_ID);
        agency.setTransactionPostingDate(this.dateTimeService.getCurrentSqlDate());
        agency.setTripExpenseAmount(new KualiDecimal(123.45));
        agency.setTripInvoiceNumber("invoice12345");
        agency.setAirTicketNumber(TRIP_ID);
        TripAccountingInformation account = new TripAccountingInformation();
        account.setTripChartCode("BL");
        account.setTripAccountNumber("1031400");
        agency.addTripAccountingInformation(account);
        agency.setErrorCode("OK");
        return agency;
    }

    protected TravelAuthorizationDocument createTA() {
        TravelAuthorizationDocument ta = null;
        try {
            ta = (TravelAuthorizationDocument)this.documentService.getNewDocument(TravelAuthorizationDocument.class);
            ta.getDocumentHeader().setDocumentDescription("testing");
            ta.setTravelDocumentIdentifier(TRIP_ID);
            ta.setTripTypeCode("IN");
            ta.setApplicationDocumentStatus("In Process");
            TemSourceAccountingLine line = new TemSourceAccountingLine();
            line.setAccountNumber("1031400");
            line.setSubAccountNumber("ADV");
            line.setFinancialObjectCode("6000");
            line.setChartOfAccountsCode("BL");
            line.setCardType("ADVANCE");
            line.setAmount(new KualiDecimal(50));
            ta.addSourceAccountingLine((SourceAccountingLine)line);
            TemProfile temProfile = new TemProfile();
            temProfile.setPrincipalName("abeal");
            temProfile.setProfileId(Integer.valueOf(8));
            temProfile.setTravelerTypeCode("EMP");
            ta.setTemProfile(temProfile);
            this.documentService.saveDocument((Document)ta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ta;
    }
}

