/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.validation.impl.TemAccountingLineTotalsValidation;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.khuntley)
public class ReimbursementAccountingTotalsValidationTest
extends KualiTestBase {
    private static final String DEFAULT_CHART_CODE = "BL";
    private static final int EXPENSE_AMOUNT = 100;
    private static final int ACCOUNTING_LINE_AMOUNT = 100;
    private TemAccountingLineTotalsValidation validation;
    private static final String AIRLINE_EXPENSE_TYPE_CODE = "A";
    private static final String FINANCIAL_OBJECT_CODE = "5070";
    private BusinessObjectService businessObjectService;
    private ObjectCodeService objectCodeService;
    private static final Logger LOG = Logger.getLogger(ReimbursementAccountingTotalsValidationTest.class);
    private AttributedDocumentEventBase event = null;
    private TravelReimbursementDocument tr = null;
    private List<ActualExpense> oteList = null;
    private ObjectCode perDiemObjCode = null;
    private ActualExpense actualExpense = null;
    private List sourceLines = null;

    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.validation = new TemAccountingLineTotalsValidation();
        this.validation.setAccountingDistributionService((AccountingDistributionService)SpringContext.getBean(AccountingDistributionService.class));
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.objectCodeService = (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
        this.tr = new TravelReimbursementDocument();
        TravelerDetail traveler = new TravelerDetail();
        traveler.setId(Integer.valueOf(1));
        this.tr.setTemProfileId(Integer.valueOf(1));
        TripType tripType = new TripType();
        HashMap<String, String> outOfState = new HashMap<String, String>();
        outOfState.put("code", "OUT");
        List results = (List)this.businessObjectService.findMatching(TripType.class, outOfState);
        TripType tt = !results.isEmpty() ? (TripType)results.get(0) : null;
        this.tr.setTripType(tt);
        traveler.setTravelerTypeCode("EMP");
        this.tr.setTraveler(traveler);
        this.oteList = new ArrayList<ActualExpense>();
        this.tr.setActualExpenses(this.oteList);
        this.tr.setPerDiemExpenses(new ArrayList());
        this.event = new AttributedDocumentEventBase("description", "errorPathPrefix", (Document)this.tr);
        this.perDiemObjCode = this.objectCodeService.getByPrimaryIdForCurrentYear(DEFAULT_CHART_CODE, FINANCIAL_OBJECT_CODE);
        this.actualExpense = new ActualExpense(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        this.actualExpense.setExpenseTypeCode("O");
        this.actualExpense.setExpenseAmount(new KualiDecimal(100));
        ExpenseTypeObjectCode travelExpenseTypeCode = new ExpenseTypeObjectCode();
        travelExpenseTypeCode.setExpenseTypeCode(AIRLINE_EXPENSE_TYPE_CODE);
        travelExpenseTypeCode.setFinancialObjectCode(FINANCIAL_OBJECT_CODE);
        ExpenseType expenseType = new ExpenseType();
        expenseType.setCode(AIRLINE_EXPENSE_TYPE_CODE);
        expenseType.setPrepaidExpense(false);
        travelExpenseTypeCode.setExpenseType(expenseType);
        this.actualExpense.setTravelExpenseTypeCode(travelExpenseTypeCode);
        this.sourceLines = new ArrayList();
        TemSourceAccountingLine sal = new TemSourceAccountingLine();
        sal.setAmount(new KualiDecimal(100));
        sal.setFinancialObjectCode(this.perDiemObjCode.getFinancialObjectCode());
        sal.setCardType("OUT OF POCKET");
        sal.setSequenceNumber(Integer.valueOf(1));
        this.sourceLines.add(sal);
    }

    @After
    protected void tearDown() throws Exception {
        this.validation = null;
        super.tearDown();
    }

    @Test
    public void testValidation_emptyTest() {
        ReimbursementAccountingTotalsValidationTest.assertTrue((boolean)this.validation.validate((AttributedDocumentEvent)this.event));
    }

    @Test
    public void testValidation_noAccountingLine() {
        if (this.perDiemObjCode != null) {
            this.oteList.add(this.actualExpense);
            ReimbursementAccountingTotalsValidationTest.assertTrue((boolean)this.validation.validate((AttributedDocumentEvent)this.event));
        } else {
            LOG.error((Object)"PerDiemObjCode is null. Financial object code need to exists in the current fiscal year.");
        }
    }

    @Test
    public void testValidation_withAccountingLine() {
        if (this.perDiemObjCode != null) {
            this.oteList.add(this.actualExpense);
            this.tr.setSourceAccountingLines(this.sourceLines);
            ReimbursementAccountingTotalsValidationTest.assertTrue((boolean)this.validation.validate((AttributedDocumentEvent)this.event));
        } else {
            LOG.error((Object)"PerDiemObjCode is null. Financial object code need to exists in the current fiscal year.");
        }
    }
}

