/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.module.tem.businessobject.CreditCardImportData;
import org.kuali.kfs.sys.batch.XmlBatchInputFileTypeBase;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class CreditCardDataXmlInputFileType
extends XmlBatchInputFileTypeBase {
    private DateTimeService dateTimeService;
    private String fileNamePrefix;

    public String getFileTypeIdentifer() {
        return "creditCardDataXmlInputFileType";
    }

    public String getFileName(String principalName, Object parsedFileContents, String fileUserIdentifier) {
        StringBuilder fileName = new StringBuilder();
        fileUserIdentifier = StringUtils.deleteWhitespace((String)fileUserIdentifier);
        fileUserIdentifier = StringUtils.remove((String)fileUserIdentifier, (String)"_");
        fileName.append(this.getFileNamePrefix()).append("_");
        fileName.append(principalName).append("_");
        fileName.append(fileUserIdentifier).append("_");
        fileName.append(this.dateTimeService.toDateTimeStringForFilename(this.dateTimeService.getCurrentDate()));
        return fileName.toString();
    }

    public boolean validate(Object parsedFileContents) {
        return true;
    }

    public Object parse(byte[] fileByteContent) throws ParseException {
        CreditCardImportData creditCardData = (CreditCardImportData)super.parse(fileByteContent);
        return creditCardData;
    }

    public String getAuthorPrincipalName(File file) {
        return StringUtils.substringBetween((String)file.getName(), (String)this.getFileNamePrefix(), (String)"_");
    }

    public String getTitleKey() {
        return "message.batchUpload.title.credit.card.data.xml.file";
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    public void setFileNamePrefix(String fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
    }
}

