/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import java.beans.PropertyChangeEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.fp.document.DisbursementVoucherDocument;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.Attendee;
import org.kuali.kfs.module.tem.businessobject.EntertainmentPurpose;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.businessobject.TravelerType;
import org.kuali.kfs.module.tem.document.TEMReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

@Entity
@Table(name="TEM_ENT_DOC_T")
public class TravelEntertainmentDocument
extends TEMReimbursementDocument
implements AmountTotaling {
    protected static Logger LOG = Logger.getLogger(TravelEntertainmentDocument.class);
    private Integer hostProfileId;
    private String hostName;
    private String eventTitle;
    protected Boolean spouseIncluded;
    private String description;
    private String purposeCode;
    private EntertainmentPurpose purpose;
    private Boolean attendeeListAttached;
    private Integer numberOfAttendees;
    private TravelerDetail host;
    private TemProfile hostProfile;
    private TravelerDetail attendeeDetail;
    private Boolean hostAsPayee;
    private List<Attendee> attendee = new ArrayList<Attendee>();

    @Column(name="HOST_TEM_PROFILE_ID", length=50, nullable=true)
    public Integer getHostProfileId() {
        return this.hostProfileId;
    }

    public void setHostProfileId(Integer hostProfileId) {
        this.hostProfileId = hostProfileId;
        BusinessObjectService service = (BusinessObjectService)SpringContext.getService((String)"businessObjectService");
        HashMap<String, Integer> primaryKeys = new HashMap<String, Integer>();
        primaryKeys.put("profileId", hostProfileId);
        this.setHostProfile((TemProfile)service.findByPrimaryKey(TemProfile.class, primaryKeys));
    }

    @Column(name="TITLE", length=100, nullable=true)
    public String getEventTitle() {
        return this.eventTitle;
    }

    public void setEventTitle(String eventTitle) {
        this.eventTitle = eventTitle;
    }

    @Column(name="SPOUSE_INCLUDED", nullable=true, length=1)
    public Boolean getSpouseIncluded() {
        return this.spouseIncluded;
    }

    public Boolean getSpouseIncludedForSearching() {
        return this.spouseIncluded;
    }

    public Boolean isSpouseIncludedForSearching() {
        return this.spouseIncluded;
    }

    public void setSpouseIncluded(Boolean spouseIncluded) {
        this.spouseIncluded = spouseIncluded;
    }

    @Column(name="DESCRIPTION", nullable=true, length=255)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="PURPOSE_CODE", nullable=true, length=4)
    public String getPurposeCode() {
        return this.purposeCode;
    }

    public void setPurpose(String purposeCode) {
        this.purposeCode = purposeCode;
    }

    @JoinColumn(name="PURPOSE_CODE", nullable=true)
    public EntertainmentPurpose getPurpose() {
        return this.purpose;
    }

    public void setPurpose(EntertainmentPurpose purpose) {
        this.purpose = purpose;
    }

    public void setPurposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
    }

    @Override
    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    @Column(name="ATTENDEE_LIST_ATTACHED", nullable=true, length=1)
    public Boolean getAttendeeListAttached() {
        return this.attendeeListAttached;
    }

    public void setAttendeeListAttached(Boolean attendeeListAttached) {
        this.attendeeListAttached = attendeeListAttached;
    }

    @Column(name="NUMBER_ATTENDEES", nullable=true, length=50)
    public Integer getNumberOfAttendees() {
        return this.numberOfAttendees;
    }

    public void setNumberOfAttendees(Integer numberOfAttendees) {
        this.numberOfAttendees = numberOfAttendees;
    }

    public List<Attendee> getAttendee() {
        return this.attendee;
    }

    public void setAttendee(List<Attendee> attendee) {
        this.attendee = attendee;
    }

    @Column(name="HOST_NAME", nullable=true, length=40)
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public TravelerDetail getHost() {
        return this.host;
    }

    public void setHost(TravelerDetail host) {
        this.host = host;
    }

    public TravelerDetail getAttendeeDetail() {
        return this.attendeeDetail;
    }

    public void setAttendeeDetail(TravelerDetail attendeeDetail) {
        this.attendeeDetail = attendeeDetail;
    }

    public TemProfile getHostProfile() {
        return this.hostProfile;
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("TravelRequiresTravelerApproval")) {
            return this.requiresTravelerApprovalRouting();
        }
        if (nodeName.equals("TravelHasSpecialRequest")) {
            return this.requiresSpecialRequestReviewRouting();
        }
        if (nodeName.equals("TaxManager")) {
            return this.requiresTaxManagerApprovalRouting();
        }
        if (StringUtils.equals((String)"RequiresBudgetReview", (String)nodeName)) {
            return this.isBudgetReviewRequired();
        }
        if (nodeName.equals("RequiresSeparationOfDuties")) {
            return this.requiresSeparationOfDutiesRouting();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    private boolean requiresEntertainmentManagerRouting() {
        return true;
    }

    @Override
    protected boolean requiresSpecialRequestReviewRouting() {
        if (super.requiresSpecialRequestReviewRouting()) {
            return true;
        }
        if (this.getPurpose() != null) {
            String purposeCode = this.getPurpose().getPurposeCode();
            if (this.getPurpose().isReviewRequiredIndicator() != null && this.getPurpose().isReviewRequiredIndicator().booleanValue()) {
                return true;
            }
        }
        return ObjectUtils.isNotNull((Object)this.getSpouseIncluded()) && this.getSpouseIncluded() != false;
    }

    @Override
    protected boolean requiresTaxManagerApprovalRouting() {
        boolean requiresTaxManagerApprovalRouting = super.requiresTaxManagerApprovalRouting();
        return requiresTaxManagerApprovalRouting || this.getTraveler().getNonResidentAlien() != false;
    }

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        super.prepareForSave(event);
        this.getTravelPayment().setCheckStubText(this.getTravelDocumentIdentifier() + " " + StringUtils.defaultString((String)this.getEventTitle()) + " " + this.getTripBegin());
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (DocumentStatus.PROCESSED.getCode().equals(statusChangeEvent.getNewRouteStatus())) {
            LOG.debug((Object)("New route status is " + statusChangeEvent.getNewRouteStatus()));
            try {
                this.updateAndSaveAppDocStatus("Entertainment Manager Approved");
            }
            catch (WorkflowException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void initiateDocument() {
        super.initiateDocument();
        this.setTripBegin(null);
        this.setTripEnd(null);
        this.setApplicationDocumentStatus("In Process");
        this.getTravelPayment().setDocumentationLocationCode(this.getParameterService().getParameterValueAsString(TravelEntertainmentDocument.class, "DOCUMENTATION_LOCATION_CODE", this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "DOCUMENTATION_LOCATION_CODE")));
    }

    @Override
    public KualiDecimal getTotalFor(String financialObjectCode) {
        KualiDecimal retval = KualiDecimal.ZERO;
        LOG.debug((Object)("Getting total for " + financialObjectCode));
        for (AccountingLine line : this.getSourceAccountingLines()) {
            LOG.debug((Object)("Comparing " + financialObjectCode + " to " + line.getObjectCode().getCode()));
            if (!line.getObjectCode().getCode().equals(financialObjectCode)) continue;
            retval = (KualiDecimal)retval.add((AbstractKualiDecimal)line.getAmount());
        }
        return retval;
    }

    public boolean canShowHostCertification() {
        return this.getHostProfile() != null && this.getTemProfile() != null && !this.getHostProfile().getProfileId().equals(this.getTemProfile().getProfileId()) && !this.getDocumentHeader().getWorkflowDocument().isInitiated();
    }

    public boolean IsHostNonEmployee() {
        return this.getHostProfile() != null && this.getHostProfile().getTravelerTypeCode().equals("NON") || this.getTemProfile() != null && this.getTemProfile().getTravelerTypeCode().equals("NON");
    }

    @Override
    protected String generateDescription() {
        String tempStr;
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        PersonService ps = (PersonService)SpringContext.getBean(PersonService.class);
        Person person = ps.getPerson(this.getTraveler().getPrincipalId());
        this.getTraveler().refreshReferenceObject("customer");
        AccountsReceivableCustomer customer = this.getTraveler().getCustomer();
        if (person != null) {
            sb.append(person.getLastName() + ", " + person.getFirstName() + " " + person.getMiddleName() + " ");
        } else if (customer != null) {
            sb.append(customer.getCustomerName() + " ");
        } else {
            sb.append(this.getTraveler().getFirstName() + " " + this.getTraveler().getLastName() + " ");
        }
        if (this.getTripBegin() != null) {
            sb.append(format.format(this.getTripBegin()) + " ");
        }
        if (this.eventTitle != null) {
            sb.append(this.eventTitle);
        }
        if ((tempStr = sb.toString()).length() > 40) {
            tempStr = tempStr.substring(0, 39);
        }
        return tempStr;
    }

    @Transient
    public void addAttendee(Attendee line) {
        String sequenceName = line.getSequenceName();
        Long sequenceNumber = this.getSequenceAccessorService().getNextAvailableSequenceNumber(sequenceName, Attendee.class);
        line.setId(sequenceNumber.intValue());
        line.setDocumentNumber(this.documentNumber);
        this.notifyChangeListeners(new PropertyChangeEvent(this, "attendee", null, (Object)line));
        this.getAttendee().add(line);
    }

    @Transient
    public void removeAttendee(Integer index) {
        Attendee line = this.getAttendee().remove(index);
        this.notifyChangeListeners(new PropertyChangeEvent(this, "attendee", (Object)line, null));
    }

    public void setHostProfile(TemProfile hostProfile) {
        this.hostProfile = hostProfile;
        if (hostProfile != null) {
            TravelerService service = (TravelerService)SpringContext.getService((String)"travelerService");
            service.populateTemProfile(hostProfile);
            if (hostProfile.getTravelerType() == null) {
                BusinessObjectService boService = (BusinessObjectService)SpringContext.getService((String)"businessObjectService");
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("code", hostProfile.getTravelerTypeCode());
                List types = (List)boService.findMatching(TravelerType.class, fieldValues);
                hostProfile.setTravelerType((TravelerType)((Object)types.get(0)));
            }
        }
    }

    @Override
    public String getReportPurpose() {
        return this.purpose != null ? this.purpose.getPurposeName() : null;
    }

    @Override
    public void populateVendorPayment(DisbursementVoucherDocument disbursementVoucherDocument) {
        super.populateVendorPayment(disbursementVoucherDocument);
        String locationCode = this.getParameterService().getParameterValueAsString(TravelEntertainmentDocument.class, "DOCUMENTATION_LOCATION_CODE", this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "DOCUMENTATION_LOCATION_CODE"));
        String checkStubText = this.getTravelDocumentIdentifier() + ", " + this.getEventTitle();
        disbursementVoucherDocument.setDisbVchrPaymentMethodCode("P");
        disbursementVoucherDocument.setDisbursementVoucherDocumentationLocationCode(locationCode);
        disbursementVoucherDocument.setDisbVchrCheckStubText(checkStubText);
    }

    @Override
    public Map<String, String> getDisapprovedAppDocStatusMap() {
        return TemConstants.EntertainmentStatusCodeKeys.getDisapprovedAppDocStatusMap();
    }

    @Override
    public String getAchCheckDocumentType() {
        return "ENCA";
    }

    @Override
    public String getWireTransferOrForeignDraftDocumentType() {
        return "ENWF";
    }

    @Override
    protected String getTripIdPrefix() {
        return "E-";
    }

    @Override
    public String getTripTypeCode() {
        return "All";
    }

    public Boolean getHostAsPayee() {
        return this.hostAsPayee;
    }

    public void setHostAsPayee(Boolean hostAsPayee) {
        this.hostAsPayee = hostAsPayee;
    }
}

