/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddress;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerInvoice;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerInvoiceDetail;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerInvoiceRecurrenceDetails;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerType;
import org.kuali.kfs.integration.ar.AccountsReceivableDocumentHeader;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.integration.ar.AccountsReceivableOrganizationOptions;
import org.kuali.kfs.integration.ar.AccountsReceivableSystemInformation;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KeyValuesService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.dataaccess.TravelAuthorizationDao;
import org.kuali.kfs.module.tem.document.TravelAuthorizationAmendmentDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationCloseDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.AccountingDocumentRelationshipService;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.module.tem.util.MessageUtils;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;
import org.kuali.kfs.sys.document.validation.event.AddAccountingLineEvent;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.util.ObjectPopulationUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TravelAuthorizationServiceImpl
implements TravelAuthorizationService {
    protected static Logger LOG = Logger.getLogger(TravelAuthorizationServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected AccountsReceivableModuleService accountsReceivableModuleService;
    protected ParameterService parameterService;
    protected DocumentService documentService;
    protected DateTimeService dateTimeService;
    protected KualiRuleService kualiRuleService;
    protected WorkflowDocumentService workflowDocumentService;
    protected UniversityDateService universityDateService;
    protected AccountingDocumentRelationshipService accountingDocumentRelationshipService;
    protected TemProfileService temProfileService;
    protected TravelDocumentService travelDocumentService;
    protected DocumentDao documentDao;
    protected DataDictionaryService dataDictionaryService;
    protected IdentityService identityService;
    protected NoteService noteService;
    protected TravelAuthorizationDao travelAuthorizationDao;
    protected List<PropertyChangeListener> propertyChangeListeners;

    @Override
    public void createCustomerInvoice(TravelAuthorizationDocument travelAuthorizationDocument) {
        KualiDecimal amount;
        boolean enableInvoice = this.parameterService.getParameterValueAsBoolean(TravelAuthorizationDocument.class, "GENERATE_INVOICE_INV_FOR_TRAVL_ADVANCE_IND");
        if (enableInvoice && travelAuthorizationDocument.shouldProcessAdvanceForDocument() && KualiDecimal.ZERO.isLessThan((AbstractKualiDecimal)(amount = travelAuthorizationDocument.getTravelAdvance().getTravelAdvanceRequested()))) {
            AccountsReceivableCustomer customer;
            TemProfile profile = travelAuthorizationDocument.getTemProfile();
            if (profile == null) {
                profile = this.temProfileService.findTemProfileById(travelAuthorizationDocument.getTemProfileId());
            }
            if (ObjectUtils.isNull((Object)(customer = profile.getCustomer()))) {
                customer = this.createNewCustomer(profile);
                travelAuthorizationDocument.getTraveler().setCustomerNumber(customer.getCustomerNumber());
            }
            this.createCustomerInvoiceFromAdvance(travelAuthorizationDocument, travelAuthorizationDocument.getTravelAdvance(), amount);
        }
    }

    protected void createCustomerInvoiceFromAdvance(final TravelAuthorizationDocument travelAuthorizationDocument, final TravelAdvance advance, KualiDecimal amount) {
        final int numDaysDue = Integer.parseInt(this.parameterService.getParameterValueAsString(TravelAuthorizationDocument.class, "DUE_DATE_DAYS"));
        final String invoiceItemCode = this.parameterService.getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_INVOICE_ITEM_CODE");
        final String processingOrgCode = this.parameterService.getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_BILLING_ORGANIZATION");
        final String processingChartCode = this.parameterService.getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_BILLING_CHART");
        try {
            GlobalVariables.doInNewGlobalVariables((UserSession)new UserSession("kfs"), (Callable)new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() {
                    Calendar cal = Calendar.getInstance();
                    String customerNumber = travelAuthorizationDocument.getTemProfile().getCustomerNumber();
                    String orgInvoiceNumber = travelAuthorizationDocument.getTravelDocumentIdentifier();
                    java.util.Date billingDate = TravelAuthorizationServiceImpl.this.dateTimeService.getCurrentDate();
                    cal.setTime(travelAuthorizationDocument.getTripEnd());
                    cal.add(5, numDaysDue);
                    java.util.Date dueDate = cal.getTime();
                    AccountsReceivableCustomerInvoice customerInvoiceDocument = TravelAuthorizationServiceImpl.this.accountsReceivableModuleService.createCustomerInvoiceDocument();
                    LOG.info((Object)("Created customer invoice document " + customerInvoiceDocument.getDocumentNumber()));
                    TravelAuthorizationServiceImpl.this.setupDefaultValuesForNewCustomerInvoiceDocument(customerInvoiceDocument, processingChartCode, processingOrgCode);
                    customerInvoiceDocument.getDocumentHeader().setOrganizationDocumentNumber(travelAuthorizationDocument.getTravelDocumentIdentifier());
                    customerInvoiceDocument.getDocumentHeader().setDocumentDescription("Travel Advance - " + travelAuthorizationDocument.getTravelDocumentIdentifier() + " - " + travelAuthorizationDocument.getTraveler().getFirstName() + " " + travelAuthorizationDocument.getTraveler().getLastName());
                    int documentDescriptionMaxLength = TravelAuthorizationServiceImpl.this.getDataDictionaryService().getAttributeMaxLength(customerInvoiceDocument.getDocumentHeader().getClass(), "documentDescription");
                    if (customerInvoiceDocument.getDocumentHeader().getDocumentDescription().length() >= documentDescriptionMaxLength) {
                        String truncatedDocumentDescription = customerInvoiceDocument.getDocumentHeader().getDocumentDescription().substring(0, documentDescriptionMaxLength - 1);
                        customerInvoiceDocument.getDocumentHeader().setDocumentDescription(truncatedDocumentDescription);
                    }
                    customerInvoiceDocument.getAccountsReceivableDocumentHeader().setCustomerNumber(customerNumber);
                    customerInvoiceDocument.setBillingDate(new Date(billingDate.getTime()));
                    customerInvoiceDocument.setInvoiceDueDate(new Date(dueDate.getTime()));
                    customerInvoiceDocument.setOrganizationInvoiceNumber(orgInvoiceNumber.toString());
                    AccountsReceivableCustomerAddress customerBillToAddress = null;
                    TravelerDetail traveler = travelAuthorizationDocument.getTraveler();
                    TemProfile profile = travelAuthorizationDocument.getTemProfile();
                    if (profile == null) {
                        profile = TravelAuthorizationServiceImpl.this.temProfileService.findTemProfileById(travelAuthorizationDocument.getTemProfileId());
                    }
                    AccountsReceivableCustomer customer = profile.getCustomer();
                    for (AccountsReceivableCustomerAddress address : customer.getAccountsReceivableCustomerAddresses()) {
                        if (TravelAuthorizationServiceImpl.this.compareAddress(address, traveler)) continue;
                        customerBillToAddress = address;
                        break;
                    }
                    if (customerBillToAddress == null) {
                        customerBillToAddress = TravelAuthorizationServiceImpl.this.accountsReceivableModuleService.createCustomerAddress();
                        customerBillToAddress.setCustomerAddressTypeCodeAsAlternate();
                        String tempName = profile.getFirstName() + " " + (StringUtils.isEmpty((String)profile.getMiddleName()) ? "" : profile.getMiddleName() + " ") + profile.getLastName();
                        if (tempName.length() > 40) {
                            tempName = profile.getFirstName() + " " + profile.getLastName();
                            while (tempName.length() > 40) {
                                tempName = tempName.substring(0, tempName.length() - 1);
                            }
                        }
                        customerBillToAddress.setCustomerAddressName(tempName);
                        customer.setCustomerAddressChangeDate(TravelAuthorizationServiceImpl.this.dateTimeService.getCurrentSqlDate());
                        customerBillToAddress.setCustomerLine1StreetAddress(StringUtils.isNotEmpty((String)traveler.getStreetAddressLine1()) ? traveler.getStreetAddressLine1().toUpperCase() : "");
                        customerBillToAddress.setCustomerLine2StreetAddress(StringUtils.isNotEmpty((String)traveler.getStreetAddressLine2()) ? traveler.getStreetAddressLine2().toUpperCase() : "");
                        customerBillToAddress.setCustomerCityName(StringUtils.isNotEmpty((String)traveler.getCityName()) ? traveler.getCityName().toUpperCase() : "");
                        customerBillToAddress.setCustomerStateCode(StringUtils.isNotEmpty((String)traveler.getStateCode()) ? traveler.getStateCode().toUpperCase() : "");
                        customerBillToAddress.setCustomerZipCode(traveler.getZipCode());
                        customerBillToAddress.setCustomerCountryCode(StringUtils.isNotEmpty((String)traveler.getCountryCode()) ? traveler.getCountryCode().toUpperCase() : "");
                        customerBillToAddress.setCustomerEmailAddress(StringUtils.isNotEmpty((String)traveler.getEmailAddress()) ? traveler.getEmailAddress().toUpperCase() : "");
                        List customerAddresses = customer.getAccountsReceivableCustomerAddresses();
                        customerAddresses.add(customerBillToAddress);
                        customer.setAccountsReceivableCustomerAddresses(customerAddresses);
                        TravelAuthorizationServiceImpl.this.accountsReceivableModuleService.saveCustomer(customer);
                    }
                    customerBillToAddress.refresh();
                    customerInvoiceDocument.setCustomerBillToAddress(customerBillToAddress);
                    customerInvoiceDocument.setCustomerBillToAddressIdentifier(customerBillToAddress.getCustomerAddressIdentifier());
                    customerInvoiceDocument.setBillingAddressTypeCodeAsPrimary();
                    customerInvoiceDocument.setBillingAddressName(customer.getCustomerName());
                    customerInvoiceDocument.setBillingLine1StreetAddress(customerBillToAddress.getCustomerLine1StreetAddress());
                    customerInvoiceDocument.setBillingLine2StreetAddress(customerBillToAddress.getCustomerLine2StreetAddress());
                    customerInvoiceDocument.setBillingCityName(customerBillToAddress.getCustomerCityName());
                    customerInvoiceDocument.setBillingStateCode(customerBillToAddress.getCustomerStateCode());
                    customerInvoiceDocument.setBillingZipCode(customerBillToAddress.getCustomerZipCode());
                    customerInvoiceDocument.setBillingCountryCode(customerBillToAddress.getCustomerCountryCode());
                    customerInvoiceDocument.setBillingAddressInternationalProvinceName(customerBillToAddress.getCustomerAddressInternationalProvinceName());
                    customerInvoiceDocument.setBillingInternationalMailCode(customerBillToAddress.getCustomerInternationalMailCode());
                    customerInvoiceDocument.setBillingEmailAddress(customerBillToAddress.getCustomerEmailAddress());
                    try {
                        LOG.info((Object)("Saving customer invoice document " + customerInvoiceDocument.getDocumentNumber()));
                        if (StringUtils.isEmpty((String)advance.getArInvoiceDocNumber())) {
                            AccountsReceivableCustomerInvoiceDetail detail = TravelAuthorizationServiceImpl.this.createInvoiceDetailFromAdvance(advance, customerInvoiceDocument.getDocumentNumber(), invoiceItemCode, processingOrgCode, processingChartCode);
                            TravelAuthorizationServiceImpl.this.addInvoiceDetailToDocument(detail, customerInvoiceDocument);
                        }
                        LOG.info((Object)("Saving customer invoice document after adding acctg lines " + customerInvoiceDocument.getDocumentNumber()));
                        TravelAuthorizationServiceImpl.this.accountsReceivableModuleService.saveCustomerInvoiceDocument(customerInvoiceDocument);
                        String relationDescription = "TA - Customer Invoice";
                        TravelAuthorizationServiceImpl.this.accountingDocumentRelationshipService.save(new AccountingDocumentRelationship(travelAuthorizationDocument.getDocumentNumber(), customerInvoiceDocument.getDocumentNumber(), relationDescription));
                        if (StringUtils.isEmpty((String)advance.getArInvoiceDocNumber())) {
                            advance.setArInvoiceDocNumber(customerInvoiceDocument.getDocumentNumber());
                            advance.setArCustomerId(customerNumber);
                        }
                        WorkflowDocument originalWorkflowDocument = customerInvoiceDocument.getDocumentHeader().getWorkflowDocument();
                        try {
                            WorkflowDocument newWorkflowDocument = TravelAuthorizationServiceImpl.this.workflowDocumentService.loadWorkflowDocument(customerInvoiceDocument.getDocumentNumber(), GlobalVariables.getUserSession().getPerson());
                            newWorkflowDocument.setTitle(originalWorkflowDocument.getTitle());
                            customerInvoiceDocument.getDocumentHeader().setWorkflowDocument(newWorkflowDocument);
                            TravelAuthorizationServiceImpl.this.accountsReceivableModuleService.blanketApproveCustomerInvoiceDocument(customerInvoiceDocument);
                        }
                        finally {
                            customerInvoiceDocument.getDocumentHeader().setWorkflowDocument(originalWorkflowDocument);
                        }
                        LOG.info((Object)("Submitted customer invoice document " + customerInvoiceDocument.getDocumentNumber() + " for " + customerNumber + " - " + TravelAuthorizationServiceImpl.this.dateTimeService.toDateString(billingDate) + "\n\n"));
                    }
                    catch (WorkflowException e) {
                        throw new RuntimeException("Customer Invoice Document routing failed.");
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)e.toString());
        }
    }

    protected boolean compareAddress(AccountsReceivableCustomerAddress customerAddress, TravelerDetail traveler) {
        if (!StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerLine1StreetAddress(), (String)traveler.getStreetAddressLine1())) {
            return true;
        }
        if (!StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerLine2StreetAddress(), (String)traveler.getStreetAddressLine2())) {
            return true;
        }
        if (!StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerCityName(), (String)traveler.getCityName())) {
            return true;
        }
        if (!StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerStateCode(), (String)traveler.getStateCode())) {
            return true;
        }
        if (!StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerZipCode(), (String)traveler.getZipCode())) {
            return true;
        }
        return !StringUtils.equalsIgnoreCase((String)customerAddress.getCustomerCountryCode(), (String)traveler.getCountryCode());
    }

    protected void setupDefaultValuesForNewCustomerInvoiceDocument(AccountsReceivableCustomerInvoice document, String chartOfAccountsCode, String organizationCode) {
        AccountsReceivableOrganizationOptions orgOptions;
        document.setBillByChartOfAccountCode(chartOfAccountsCode);
        document.setBilledByOrganizationCode(organizationCode);
        document.setOpenInvoiceIndicator(true);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = this.accountsReceivableModuleService.createAccountsReceivableDocumentHeader();
        AccountsReceivableSystemInformation processingOrg = this.accountsReceivableModuleService.getSystemInformationByProcessingChartOrgAndFiscalYear(chartOfAccountsCode, organizationCode, this.universityDateService.getCurrentFiscalYear());
        if (processingOrg != null) {
            accountsReceivableDocumentHeader.setProcessingChartOfAccountCode(processingOrg.getProcessingChartOfAccountCode());
            accountsReceivableDocumentHeader.setProcessingOrganizationCode(processingOrg.getProcessingOrganizationCode());
        }
        if ((orgOptions = this.accountsReceivableModuleService.getOrgOptionsIfExists(chartOfAccountsCode, organizationCode)) != null) {
            accountsReceivableDocumentHeader.setProcessingChartOfAccountCode(orgOptions.getProcessingChartOfAccountCode());
            accountsReceivableDocumentHeader.setProcessingOrganizationCode(orgOptions.getProcessingOrganizationCode());
        }
        accountsReceivableDocumentHeader.setDocumentNumber(document.getDocumentNumber());
        document.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
        AccountsReceivableCustomerInvoiceRecurrenceDetails recurrenceDetails = this.accountsReceivableModuleService.createCustomerInvoiceRecurrenceDetails();
        recurrenceDetails.setInvoiceNumber(document.getDocumentNumber());
        document.setCustomerInvoiceRecurrenceDetails(recurrenceDetails);
        AccountsReceivableOrganizationOptions organizationOptions = this.accountsReceivableModuleService.getOrgOptionsIfExists(document.getBillByChartOfAccountCode(), document.getBilledByOrganizationCode());
        if (ObjectUtils.isNotNull((Object)organizationOptions)) {
            document.setPrintInvoiceIndicator(organizationOptions.getPrintInvoiceIndicator());
            document.setInvoiceTermsText(organizationOptions.getOrganizationPaymentTermsText());
        }
    }

    protected AccountsReceivableCustomerInvoiceDetail createInvoiceDetailFromAdvance(TravelAdvance advance, String documentNumber, String invoiceItemCode, String processingOrgCode, String processingChartCode) {
        AccountsReceivableCustomerInvoiceDetail customerInvoiceDetail = this.accountsReceivableModuleService.getCustomerInvoiceDetailFromCustomerInvoiceItemCode(invoiceItemCode, processingChartCode, processingOrgCode);
        customerInvoiceDetail.setDocumentNumber(documentNumber);
        customerInvoiceDetail.setInvoiceItemUnitPrice(advance.getTravelAdvanceRequested());
        customerInvoiceDetail.setInvoiceItemQuantity(new BigDecimal(1));
        customerInvoiceDetail.updateAmountBasedOnQuantityAndUnitPrice();
        String accountsReceivableObjectCode = this.accountsReceivableModuleService.getAccountsReceivableObjectCodeBasedOnReceivableParameter(customerInvoiceDetail);
        customerInvoiceDetail.setAccountsReceivableObjectCode(accountsReceivableObjectCode);
        return customerInvoiceDetail;
    }

    protected void addInvoiceDetailToDocument(AccountsReceivableCustomerInvoiceDetail detail, AccountsReceivableCustomerInvoice customerInvoiceDocument) {
        this.accountsReceivableModuleService.recalculateCustomerInvoiceDetail(customerInvoiceDocument, detail);
        boolean rulePassed = true;
        LOG.debug((Object)("running rules on new source line : " + (rulePassed &= this.kualiRuleService.applyRules((KualiDocumentEvent)new AddAccountingLineEvent("newSourceLine", (Document)customerInvoiceDocument, (AccountingLine)detail)))));
        detail.refreshNonUpdateableReferences();
        this.accountsReceivableModuleService.prepareCustomerInvoiceDetailForAdd(detail, customerInvoiceDocument);
        customerInvoiceDocument.addSourceAccountingLine((SourceAccountingLine)detail);
        if (customerInvoiceDocument instanceof AmountTotaling) {
            ((FinancialSystemDocumentHeader)customerInvoiceDocument.getDocumentHeader()).setFinancialDocumentTotalAmount(((AmountTotaling)customerInvoiceDocument).getTotalDollarAmount());
        }
    }

    @Override
    public Collection<TravelAuthorizationDocument> find(String travelDocumentIdentifier) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("travelDocumentIdentifier", travelDocumentIdentifier);
        return this.businessObjectService.findMatching(TravelAuthorizationDocument.class, criteria);
    }

    public void addListenersTo(TravelAuthorizationDocument authorization) {
        authorization.setPropertyChangeListeners(this.propertyChangeListeners);
    }

    @Override
    public Collection<TravelAuthorizationAmendmentDocument> findAmendment(Integer travelDocumentIdentifier) {
        HashMap<String, Integer> criteria = new HashMap<String, Integer>();
        criteria.put("travelDocumentIdentifier", travelDocumentIdentifier);
        return this.businessObjectService.findMatching(TravelAuthorizationAmendmentDocument.class, criteria);
    }

    protected TravelAuthorizationDocument createTravelAuthorizationDocumentFromSourceDocument(TravelDocument sourceDocument, String docType) throws WorkflowException {
        if (ObjectUtils.isNull((Object)sourceDocument)) {
            String errorMsg = "Attempting to create new Travel Authorization of type '" + docType + "' from source TA doc that is null";
            LOG.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        TravelAuthorizationDocument newTravelAuthChangeDocument = (TravelAuthorizationDocument)this.documentService.getNewDocument(docType);
        HashSet<Class<FinancialSystemTransactionalDocumentBase>> classesToExclude = new HashSet<Class<FinancialSystemTransactionalDocumentBase>>();
        Class sourceObjectClass = FinancialSystemTransactionalDocumentBase.class;
        classesToExclude.add(sourceObjectClass);
        while (sourceObjectClass.getSuperclass() != null) {
            sourceObjectClass = sourceObjectClass.getSuperclass();
            classesToExclude.add(sourceObjectClass);
        }
        ObjectPopulationUtils.populateFromBaseWithSuper((BusinessObject)sourceDocument, (BusinessObject)newTravelAuthChangeDocument, TemConstants.uncopyableFieldsForTravelAuthorization(), classesToExclude);
        newTravelAuthChangeDocument.getDocumentHeader().setDocumentDescription(sourceDocument.getDocumentHeader().getDocumentDescription());
        newTravelAuthChangeDocument.getDocumentHeader().setOrganizationDocumentNumber(sourceDocument.getDocumentHeader().getOrganizationDocumentNumber());
        newTravelAuthChangeDocument.getDocumentHeader().setExplanation(sourceDocument.getDocumentHeader().getExplanation());
        newTravelAuthChangeDocument.refreshNonUpdateableReferences();
        return newTravelAuthChangeDocument;
    }

    @Override
    public TravelAuthorizationDocument getTravelAuthorizationBy(String documentNumber) {
        if (ObjectUtils.isNotNull((Object)documentNumber)) {
            try {
                TravelAuthorizationDocument doc = (TravelAuthorizationDocument)this.documentService.getByDocumentHeaderId(documentNumber);
                if (ObjectUtils.isNotNull((Object)doc)) {
                    WorkflowDocument workflowDocument = doc.getDocumentHeader().getWorkflowDocument();
                    doc.refreshReferenceObject("documentHeader");
                    doc.getDocumentHeader().setWorkflowDocument(workflowDocument);
                }
                return doc;
            }
            catch (WorkflowException e) {
                String errorMessage = "Error getting travel authorization document from document service";
                LOG.error((Object)("getTravelAuthorizationByDocumentNumber() " + errorMessage), (Throwable)e);
                throw new RuntimeException(errorMessage, e);
            }
        }
        return null;
    }

    @Override
    public TravelAuthorizationCloseDocument closeAuthorization(TravelAuthorizationDocument authorization, String annotation, String initiatorPrincipalName, String reimbursementDocNum) {
        TravelAuthorizationCloseDocument authorizationClose = null;
        try {
            String user = GlobalVariables.getUserSession().getPerson().getLastName() + ", " + GlobalVariables.getUserSession().getPerson().getFirstName();
            String note = MessageUtils.getMessage("travelAuthorization.message.close.text", user);
            Principal kfsSystemUser = this.getIdentityService().getPrincipalByPrincipalName("kfs");
            authorization.updateAndSaveAppDocStatus("Retired Version");
            this.documentDao.save((Document)authorization);
            GlobalVariables.setUserSession((UserSession)new UserSession(initiatorPrincipalName));
            authorizationClose = authorization.toCopyTAC();
            Note newNoteTAC = this.documentService.createNoteFromDocument((Document)authorizationClose, note);
            newNoteTAC.setAuthorUniversalIdentifier(kfsSystemUser.getPrincipalId());
            authorizationClose.addNote(newNoteTAC);
            authorizationClose.setTravelReimbursementDocumentNumber(reimbursementDocNum);
            String relationDescription = authorization.getDocumentTypeName() + " - " + authorizationClose.getDocumentTypeName();
            this.accountingDocumentRelationshipService.save(new AccountingDocumentRelationship(authorization.getDocumentNumber(), authorizationClose.getDocumentNumber(), relationDescription));
            GlobalVariables.setUserSession((UserSession)new UserSession("kr"));
            authorizationClose.setApplicationDocumentStatus("Closed");
            this.documentService.routeDocument((Document)authorizationClose, annotation, null);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not create TAC or route it with travel id " + authorization.getTravelDocumentIdentifier()));
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return authorizationClose;
    }

    protected AccountsReceivableCustomer createNewCustomer(TemProfile profile) {
        profile.setCustomer(this.accountsReceivableModuleService.createCustomer());
        profile.getCustomer().setCustomerName(profile.getName());
        String newCustNumber = this.accountsReceivableModuleService.getNextCustomerNumber(profile.getCustomer());
        newCustNumber = newCustNumber.toUpperCase();
        profile.setCustomerNumber(newCustNumber);
        profile.getCustomer().setCustomerNumber(newCustNumber);
        this.businessObjectService.save((PersistableBusinessObject)profile);
        String customerTypeCode = "";
        List customerTypes = this.accountsReceivableModuleService.findByCustomerTypeDescription("Traveler");
        Iterator iterator = customerTypes.iterator();
        if (iterator.hasNext()) {
            AccountsReceivableCustomerType customerType = (AccountsReceivableCustomerType)iterator.next();
            customerTypeCode = customerType.getCustomerTypeCode();
        }
        profile.getCustomer().setCustomerTypeCode(customerTypeCode);
        profile.getCustomer().setActive(true);
        ((TravelerService)SpringContext.getBean(TravelerService.class)).copyTemProfileToCustomer(profile, profile.getCustomer());
        this.accountsReceivableModuleService.saveCustomer(profile.getCustomer());
        return profile.getCustomer();
    }

    @Override
    public TravelReimbursementDocument findEnrouteOrProcessedTravelReimbursement(TravelAuthorizationDocument authorization) {
        TravelReimbursementDocument reimbursement = null;
        List<TravelReimbursementDocument> reimbursementDocumentList = this.travelDocumentService.findReimbursementDocuments(authorization.getTravelDocumentIdentifier());
        for (TravelReimbursementDocument document : reimbursementDocumentList) {
            WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
            if (!workflowDocument.isEnroute() && !workflowDocument.isFinal() && !workflowDocument.isProcessed()) continue;
            reimbursement = document;
        }
        return reimbursement;
    }

    public boolean checkNonReimbursable(String travelExpenseTypeCodeId) {
        boolean nonReimbursable = false;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("travelExpenseTypeCodeId", travelExpenseTypeCodeId);
        Collection keyValueList = ((KeyValuesService)SpringContext.getBean(KeyValuesService.class)).findMatching(ExpenseTypeObjectCode.class, fieldValues);
        for (ExpenseTypeObjectCode typeCode : keyValueList) {
            nonReimbursable = typeCode.getExpenseType().isPrepaidExpense();
        }
        return nonReimbursable;
    }

    @Override
    public List<String> findMatchingTrips(TravelAuthorizationDocument authorization) {
        Date tripEndBufferDate;
        ArrayList<String> duplicateTrips = new ArrayList<String>();
        Date tripBeginBufferDate = authorization.getTripBegin() == null ? null : this.getTripBeginDate(authorization.getTripBegin());
        Date date = tripEndBufferDate = authorization.getTripEnd() == null ? null : this.getTripEndDate(authorization.getTripEnd());
        if (tripBeginBufferDate == null || tripEndBufferDate == null) {
            return duplicateTrips;
        }
        List<TravelAuthorizationDocument> authorizationDocuments = this.travelAuthorizationDao.findTravelAuthorizationByTraveler(authorization.getTemProfileId());
        for (TravelAuthorizationDocument authorizationDocument : authorizationDocuments) {
            List<TravelReimbursementDocument> travelReimbursementDocuments = this.travelDocumentService.findReimbursementDocuments(authorizationDocument.getTravelDocumentIdentifier());
            if (!ObjectUtils.isNull(travelReimbursementDocuments) && !travelReimbursementDocuments.isEmpty()) {
                boolean matchFound = this.matchReimbursements(travelReimbursementDocuments, tripBeginBufferDate, tripEndBufferDate);
                if (!matchFound) continue;
                duplicateTrips.add(authorizationDocument.getDocumentNumber());
                continue;
            }
            Date tripBeginDate = this.convertToSqlDate(authorizationDocument.getTripBegin());
            Date tripEndDate = this.convertToSqlDate(authorizationDocument.getTripEnd());
            if (authorization.getDocumentNumber().equals(authorizationDocument.getDocumentNumber()) || !this.doesDatesOverlap(tripBeginBufferDate, tripEndBufferDate, tripBeginDate, tripEndDate)) continue;
            duplicateTrips.add(authorizationDocument.getDocumentNumber());
        }
        return duplicateTrips;
    }

    private Date convertToSqlDate(Timestamp date) {
        Date convertedDate = null;
        try {
            convertedDate = this.dateTimeService.convertToSqlDate(date);
        }
        catch (ParseException ex) {
            LOG.error((Object)("Parse exception " + ex));
        }
        return convertedDate;
    }

    public boolean doesDatesOverlap(Date tripBeginBufferDate, Date tripEndBufferDate, Date tripBeginDate, Date tripEndDate) {
        return tripBeginDate.compareTo(tripBeginBufferDate) >= 0 && tripBeginDate.compareTo(tripEndBufferDate) <= 0 || tripEndDate.compareTo(tripBeginBufferDate) >= 0 && tripEndDate.compareTo(tripEndBufferDate) <= 0;
    }

    private boolean matchReimbursements(List<TravelReimbursementDocument> travelReimbursementDocuments, Date tripBeginBufferDate, Date tripEndBufferDate) {
        Timestamp earliestTripBeginDate = null;
        Timestamp greatestTripEndDate = null;
        for (TravelReimbursementDocument document : travelReimbursementDocuments) {
            Timestamp tripBegin = document.getTripBegin();
            Timestamp tripEnd = document.getTripEnd();
            if (ObjectUtils.isNull(earliestTripBeginDate) && ObjectUtils.isNull(greatestTripEndDate)) {
                earliestTripBeginDate = tripBegin;
                greatestTripEndDate = tripEnd;
                continue;
            }
            earliestTripBeginDate = tripBegin.before(earliestTripBeginDate) ? tripBegin : earliestTripBeginDate;
            greatestTripEndDate = tripEnd.after(greatestTripEndDate) ? tripEnd : greatestTripEndDate;
        }
        return this.doesDatesOverlap(tripBeginBufferDate, tripEndBufferDate, this.convertToSqlDate(earliestTripBeginDate), this.convertToSqlDate(greatestTripEndDate));
    }

    private Integer getDuplicateTripDateRangeDays() {
        String tripDateRangeDays = this.parameterService.getParameterValueAsString(TravelAuthorizationDocument.class, "DUPLICATE_TRIP_DATE_RANGE_DAYS");
        Integer days = null;
        if (!StringUtils.isNumeric((String)tripDateRangeDays)) {
            days = TemConstants.DEFAULT_DUPLICATE_TRIP_DATE_RANGE_DAYS;
        }
        days = Integer.parseInt(tripDateRangeDays);
        return days;
    }

    private Date getTripBeginDate(Timestamp tripBeginDate) {
        Date tripBegin = null;
        Integer days = this.getDuplicateTripDateRangeDays();
        try {
            tripBegin = this.dateTimeService.convertToSqlDate(this.dateTimeService.toDateString(DateUtils.addDays((java.util.Date)tripBeginDate, (int)(days * -1))));
        }
        catch (ParseException pe) {
            LOG.error((Object)("Exception while parsing trip begin date" + pe));
        }
        return tripBegin;
    }

    private Date getTripEndDate(Timestamp tripEndDate) {
        Date tripEnd = null;
        Integer days = this.getDuplicateTripDateRangeDays();
        try {
            tripEnd = this.dateTimeService.convertToSqlDate(this.dateTimeService.toDateString(DateUtils.addDays((java.util.Date)tripEndDate, (int)days)));
        }
        catch (ParseException pe) {
            LOG.error((Object)("Exception while parsing trip end date" + pe));
        }
        return tripEnd;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setAccountsReceivableModuleService(AccountsReceivableModuleService accountsReceivableModuleService) {
        this.accountsReceivableModuleService = accountsReceivableModuleService;
    }

    public void setPropertyChangeListeners(List<PropertyChangeListener> propertyChangeListeners) {
        this.propertyChangeListeners = propertyChangeListeners;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public void setRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public void setAccountingDocumentRelationshipService(AccountingDocumentRelationshipService accountingDocumentRelationshipService) {
        this.accountingDocumentRelationshipService = accountingDocumentRelationshipService;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }

    public void setDocumentDao(DocumentDao documentDao) {
        this.documentDao = documentDao;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setTravelAuthorizationDao(TravelAuthorizationDao travelAuthorizationDao) {
        this.travelAuthorizationDao = travelAuthorizationDao;
    }
}

