/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileArranger;
import org.kuali.kfs.module.tem.document.TravelArrangerDocument;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class TravelArrangerResignsValidation
extends GenericValidation {
    protected TemProfileService temProfileService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean success = true;
        TravelArrangerDocument document = (TravelArrangerDocument)event.getDocument();
        if (document.getResign().booleanValue()) {
            if (document.getTaInd().booleanValue() || document.getTrInd().booleanValue() || document.getPrimaryInd().booleanValue()) {
                GlobalVariables.getMessageMap().putError("resign", "error.tta.resignNoOtherFields", new String[0]);
                success = false;
            }
            if (this.getTemProfileService().isProfileNonEmploye(document.getProfile()) && !this.isAnyActiveArrangersBesidesResigner(document.getProfile(), document.getArrangerId())) {
                GlobalVariables.getMessageMap().putError("document.resign", "error.tem.profile.nonEmployee.mustHaveActiveArranger", new String[0]);
                success = false;
            }
        }
        return success;
    }

    protected boolean isAnyActiveArrangersBesidesResigner(TemProfile profile, String arrangerId) {
        for (TemProfileArranger arranger : profile.getArrangers()) {
            if (!arranger.isActive() || arranger.getPrincipalId().equals(arrangerId)) continue;
            return true;
        }
        return false;
    }

    public TemProfileService getTemProfileService() {
        return this.temProfileService;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }
}

