/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.report;

import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import org.kuali.kfs.module.tem.report.NonEmployeeCertificationReport;
import org.kuali.kfs.module.tem.report.annotations.ColumnHeader;
import org.kuali.kfs.module.tem.report.annotations.Crosstab;
import org.kuali.kfs.module.tem.report.annotations.DetailSection;
import org.kuali.kfs.module.tem.report.annotations.JasperReport;
import org.kuali.kfs.module.tem.report.annotations.Measure;
import org.kuali.kfs.module.tem.report.annotations.ReportStyle;
import org.kuali.kfs.module.tem.report.annotations.RowHeader;
import org.kuali.kfs.module.tem.report.annotations.SubReport;
import org.kuali.kfs.module.tem.report.annotations.TitleStyle;
import org.kuali.kfs.sys.report.ReportInfoHolder;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.ui.jasperreports.JasperReportsUtils;

@JasperReport
@ReportStyle(value="standard")
@TitleStyle(value="standard")
public class EntertainmentHostCertificationReport
extends ReportInfoHolder {
    private String documentId;
    private String eventId;
    private String eventTitle;
    private String businessPurpose;
    private String entertainmentHostName;
    private Date beginDate;
    private Date endDate;
    private KualiDecimal totalExpense;
    private String employeeName;
    private String purpose;
    private String tripId;
    private String institution;
    private String temFaxNumber;
    private String certificationDescription;
    private String approvingDepartment;
    List<NonEmployeeCertificationReport.Detail> expenseDetails;
    private BufferedImage barcodeImage;
    @Crosstab
    @DetailSection
    @SubReport
    private JRDataSource actualExpenses;

    public EntertainmentHostCertificationReport() {
        this.setReportTemplateClassPath("org/kuali/kfs/module/tem/report/");
        this.setReportFileName("EntertainmentHostCertification.pdf");
        this.setReportTemplateName("EntertainmentHostCertification.jrxml");
    }

    public void setDocumentId(String argDocumentId) {
        this.documentId = argDocumentId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setEventId(String argEventId) {
        this.eventId = argEventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEndDate(Date argEndDate) {
        this.endDate = argEndDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setTotalExpense(KualiDecimal argTotalExpense) {
        this.totalExpense = argTotalExpense;
    }

    public KualiDecimal getTotalExpense() {
        return this.totalExpense;
    }

    public String getTripId() {
        return this.tripId;
    }

    public void setTripId(String argTripId) {
        this.tripId = argTripId;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String argPurpose) {
        this.purpose = argPurpose;
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String argInstitution) {
        this.institution = argInstitution;
    }

    public JRDataSource getActualExpenses() {
        return this.actualExpenses;
    }

    public void setActualExpenses(Collection<Detail> argOther) {
        this.actualExpenses = JasperReportsUtils.convertReportData(argOther);
    }

    public String getEventTitle() {
        return this.eventTitle;
    }

    public void setEventTitle(String eventTitle) {
        this.eventTitle = eventTitle;
    }

    public String getBusinessPurpose() {
        return this.businessPurpose;
    }

    public void setBusinessPurpose(String businessPurpose) {
        this.businessPurpose = businessPurpose;
    }

    public String getEntertainmentHostName() {
        return this.entertainmentHostName;
    }

    public void setEntertainmentHostName(String entertainmentHostName) {
        this.entertainmentHostName = entertainmentHostName;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setActualExpenses(JRDataSource actualExpenses) {
        this.actualExpenses = actualExpenses;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public String getTemFaxNumber() {
        return this.temFaxNumber;
    }

    public void setTemFaxNumber(String temFaxNumber) {
        this.temFaxNumber = temFaxNumber;
    }

    public String getCertificationDescription() {
        return this.certificationDescription;
    }

    public void setCertificationDescription(String certificationDescription) {
        this.certificationDescription = certificationDescription;
    }

    public String getApprovingDepartment() {
        return this.approvingDepartment;
    }

    public void setApprovingDepartment(String approvingDepartment) {
        this.approvingDepartment = approvingDepartment;
    }

    public List<NonEmployeeCertificationReport.Detail> getExpenseDetails() {
        return this.expenseDetails;
    }

    public void setExpenseDetails(List<NonEmployeeCertificationReport.Detail> expenseDetails) {
        this.expenseDetails = expenseDetails;
    }

    public BufferedImage getBarcodeImage() {
        return this.barcodeImage;
    }

    public void setBarcodeImage(BufferedImage barcodeImage) {
        this.barcodeImage = barcodeImage;
    }

    public static class Detail {
        @ColumnHeader
        private String name;
        @RowHeader
        private String date;
        @Measure
        private BigDecimal amount;

        public Detail(String name, KualiDecimal amount, String date) {
            this.name = name;
            this.amount = amount != null ? amount.bigDecimalValue() : KualiDecimal.ZERO.bigDecimalValue();
            this.date = date;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String argName) {
            this.name = argName;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal argAmount) {
            this.amount = argAmount;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String argDate) {
            this.date = argDate;
        }
    }
}

