/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.report;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import org.kuali.kfs.module.tem.report.annotations.ColumnHeader;
import org.kuali.kfs.module.tem.report.annotations.Crosstab;
import org.kuali.kfs.module.tem.report.annotations.JasperReport;
import org.kuali.kfs.module.tem.report.annotations.Measure;
import org.kuali.kfs.module.tem.report.annotations.ReportStyle;
import org.kuali.kfs.module.tem.report.annotations.RowHeader;
import org.kuali.kfs.module.tem.report.annotations.SubReport;
import org.kuali.kfs.module.tem.report.annotations.Summary;
import org.kuali.kfs.module.tem.report.annotations.TitleStyle;
import org.kuali.kfs.sys.report.ReportInfoHolder;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.ui.jasperreports.JasperReportsUtils;

@JasperReport
@ReportStyle(value="standard")
@TitleStyle(value="standard")
public class SummaryByDayReport
extends ReportInfoHolder {
    private Date beginDate;
    private Date endDate;
    private String purpose;
    private String tripId;
    private String institution;
    @Crosstab
    @Summary
    private JRDataSource summary;
    @Crosstab
    @SubReport
    private JRDataSource transportation;
    @Crosstab
    @SubReport
    private JRDataSource lodging;
    @Crosstab
    @SubReport
    private JRDataSource meals;
    @Crosstab
    @SubReport
    private JRDataSource otherExpenses;
    @Crosstab
    @SubReport
    private JRDataSource weeklyTotal;

    public SummaryByDayReport() {
        this.setReportTemplateClassPath("org/kuali/kfs/module/tem/report/");
        this.setReportFileName("ExpenseSummary.pdf");
        this.setSubReports(new HashMap());
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date argBeginDate) {
        this.beginDate = argBeginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date argEndDate) {
        this.endDate = argEndDate;
    }

    public String getTripId() {
        return this.tripId;
    }

    public void setTripId(String argTripId) {
        this.tripId = argTripId;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String argPurpose) {
        this.purpose = argPurpose;
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String argInstitution) {
        this.institution = argInstitution;
    }

    public JRDataSource getSummary() {
        return this.summary;
    }

    public void setSummary(Collection<Detail> argSummary) {
        this.summary = JasperReportsUtils.convertReportData(argSummary);
    }

    public JRDataSource getLodging() {
        return this.lodging;
    }

    public void setLodging(Collection<Detail> argLodging) {
        this.lodging = JasperReportsUtils.convertReportData(argLodging);
    }

    public JRDataSource getTransportation() {
        return this.transportation;
    }

    public void setTransportation(Collection<Detail> argTransportation) {
        this.transportation = JasperReportsUtils.convertReportData(argTransportation);
    }

    public JRDataSource getMeals() {
        return this.meals;
    }

    public void setMeals(Collection<Detail> argMeals) {
        this.meals = JasperReportsUtils.convertReportData(argMeals);
    }

    public JRDataSource getOtherExpenses() {
        return this.otherExpenses;
    }

    public void setOtherExpenses(Collection<Detail> argOther) {
        this.otherExpenses = JasperReportsUtils.convertReportData(argOther);
    }

    public JRDataSource getWeeklyTotal() {
        return this.weeklyTotal;
    }

    public void setWeeklyTotal(Collection<Detail> argWeeklyTotal) {
        this.weeklyTotal = JasperReportsUtils.convertReportData(argWeeklyTotal);
    }

    public static class Detail {
        @ColumnHeader
        private String name;
        @RowHeader
        private String date;
        @Measure
        private BigDecimal amount;

        public Detail(String name, KualiDecimal amount, String date) {
            this.name = name;
            this.amount = amount != null ? amount.bigDecimalValue() : KualiDecimal.ZERO.bigDecimalValue();
            this.date = date;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String argName) {
            this.name = argName;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal argAmount) {
            this.amount = argAmount;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String argDate) {
            this.date = argDate;
        }
    }
}

