/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileAccount;
import org.kuali.kfs.module.tem.businessobject.TemProfileAddress;
import org.kuali.kfs.module.tem.businessobject.TemProfileArranger;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.pdp.businessobject.PayeeACHAccount;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class TemProfileServiceImpl
implements TemProfileService {
    private BusinessObjectService businessObjectService;
    private PersonService personService;

    @Override
    public TemProfile findTemProfileByPrincipalId(String principalId) {
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("principalId", principalId);
        return this.findTemProfile(criteria);
    }

    @Override
    public TemProfile findTemProfileById(Integer profileId) {
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("profileId", String.valueOf(profileId));
        return this.findTemProfile(criteria);
    }

    @Override
    public TemProfile findTemProfile(Map<String, String> criteria) {
        Collection profiles = this.getBusinessObjectService().findMatching(TemProfile.class, criteria);
        if (ObjectUtils.isNotNull((Object)profiles) && profiles.size() > 0) {
            return (TemProfile)((Object)profiles.iterator().next());
        }
        return null;
    }

    @Override
    public TemProfileAddress getAddressFromProfile(TemProfile profile, TemProfileAddress defaultAddress) {
        if (ObjectUtils.isNull((Object)((Object)defaultAddress))) {
            defaultAddress = new TemProfileAddress();
        }
        if (!StringUtils.isEmpty((String)profile.getPrincipalId())) {
            Person person = this.getPersonService().getPerson(profile.getPrincipalId());
            TemProfileAddress kimAddress = this.createTemProfileAddressFromPerson(person, profile.getProfileId(), defaultAddress);
            return kimAddress;
        }
        return defaultAddress;
    }

    @Override
    public TemProfileAddress createTemProfileAddressFromPerson(Person person, Integer profileId, TemProfileAddress defaultAddress) {
        defaultAddress.setProfileId(profileId);
        defaultAddress.setStreetAddressLine1(StringUtils.upperCase((String)person.getAddressLine1()));
        defaultAddress.setStreetAddressLine2(StringUtils.upperCase((String)person.getAddressLine2()));
        defaultAddress.setCityName(StringUtils.upperCase((String)person.getAddressCity()));
        defaultAddress.setStateCode(StringUtils.upperCase((String)person.getAddressStateProvinceCode()));
        defaultAddress.setZipCode(person.getAddressPostalCode());
        defaultAddress.setCountryCode(StringUtils.upperCase((String)person.getAddressCountryCode()));
        return defaultAddress;
    }

    @Override
    public List<TemProfile> getAllActiveTemProfile() {
        HashMap<String, Boolean> criteria = new HashMap<String, Boolean>(3);
        criteria.put("active", true);
        List profiles = (List)this.getBusinessObjectService().findMatching(TemProfile.class, criteria);
        return profiles;
    }

    @Override
    public void updateACHAccountInfo(TemProfile profile) {
        profile.setAchSignUp("No");
        profile.setAchTransactionType("None");
        if ("EMP".equals(profile.getTravelerTypeCode()) && profile.getEmployeeId() != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("payeeIdNumber", profile.getEmployeeId());
            List accounts = (List)this.getBusinessObjectService().findMatching(PayeeACHAccount.class, fieldValues);
            if (!accounts.isEmpty()) {
                profile.setAchSignUp("Yes");
                profile.setAchTransactionType(((PayeeACHAccount)accounts.get(0)).getAchTransactionType());
            }
        }
    }

    @Override
    public boolean isProfileNonEmploye(TemProfile profile) {
        return !StringUtils.isBlank((String)profile.getTravelerTypeCode()) && profile.getTravelerTypeCode().equals("NON");
    }

    @Override
    public boolean hasActiveArrangers(TemProfile profile) {
        for (TemProfileArranger arranger : profile.getArrangers()) {
            if (!arranger.isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public TemProfile findTemProfileByEmployeeId(String employeeId) {
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("employeeId", employeeId);
        return this.findTemProfile(criteria);
    }

    @Override
    public TemProfile findTemProfileByCustomerNumber(String customerNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>(1);
        criteria.put("customerNumber", customerNumber);
        return this.findTemProfile(criteria);
    }

    @Override
    public List<KeyValue> getGenderKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("M", "Male"));
        keyValues.add((KeyValue)new ConcreteKeyValue("F", "Female"));
        return keyValues;
    }

    @Override
    public boolean doesProfileAccountExist(TemProfileAccount account, TemProfile skipProfile) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("accountNumber", account.getAccountNumber());
        fieldValues.put("creditCardOrAgencyCode", account.getCreditCardOrAgencyCode());
        fieldValues.put("active", Boolean.TRUE);
        Collection profileAccounts = this.getBusinessObjectService().findMatching(TemProfileAccount.class, fieldValues);
        if (skipProfile != null && skipProfile.getId() != null) {
            ArrayList<TemProfileAccount> otherFolksAccounts = new ArrayList<TemProfileAccount>();
            for (TemProfileAccount profileAccount : profileAccounts) {
                if (!profileAccount.getProfileId().equals(skipProfile.getId())) continue;
                otherFolksAccounts.add(profileAccount);
            }
            return otherFolksAccounts.size() > 0;
        }
        return profileAccounts.size() > 0;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

