/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.batch.TaxableRamificationNotificationStep;
import org.kuali.kfs.module.tem.batch.service.TaxableRamificationNotificationService;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TaxableRamificationDocument;
import org.kuali.kfs.module.tem.document.service.TaxableRamificationDocumentService;
import org.kuali.kfs.sys.service.KfsNotificationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.mail.MailMessage;
import org.springframework.transaction.annotation.Transactional;

public class TaxableRamificationNotificationServiceImpl
implements TaxableRamificationNotificationService {
    private static Logger LOG = Logger.getLogger(TaxableRamificationNotificationServiceImpl.class);
    private String notificationTemplate;
    private BusinessObjectService businessObjectService;
    private TaxableRamificationDocumentService taxableRamificationDocumentService;
    private KfsNotificationService kfsNotificationService;
    private ParameterService parameterService;
    private DateTimeService dateTimeService;

    @Override
    public void sendTaxableRamificationReport() {
        Date taxableRamificationNotificationDate = this.getDateTimeService().getCurrentSqlDate();
        List<TravelAdvance> travelAdvances = this.getTaxableRamificationDocumentService().getAllQualifiedOutstandingTravelAdvance();
        for (TravelAdvance advance : travelAdvances) {
            try {
                TaxableRamificationDocument taxableRamificationDocument = this.createTaxableRamificationDocument(advance, taxableRamificationNotificationDate);
                this.sendTaxableRamificationReport(taxableRamificationDocument);
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to send taxable ramification document for the travel advance: " + (Object)((Object)advance)), (Throwable)ex);
            }
        }
        LOG.info((Object)("The total outstanding travel advance being processed is " + travelAdvances.size()));
    }

    @Override
    public void sendTaxableRamificationReport(TaxableRamificationDocument taxableRamificationDocument) {
        if (ObjectUtils.isNotNull((Object)((Object)taxableRamificationDocument))) {
            MailMessage mailMessage = this.buildTaxRamificationReportMailMessage(taxableRamificationDocument);
            this.getKfsNotificationService().sendNotificationByMail(mailMessage);
        }
    }

    @Override
    @Transactional
    public TaxableRamificationDocument createTaxableRamificationDocument(TravelAdvance travelAdvance, Date taxableRamificationNotificationDate) {
        if (ObjectUtils.isNull((Object)((Object)travelAdvance))) {
            throw new RuntimeException("The given travel advance cannot be null.");
        }
        TaxableRamificationDocument taxRamificationDocument = this.getTaxableRamificationDocumentService().createAndBlanketApproveRamificationDocument(travelAdvance);
        if (ObjectUtils.isNotNull((Object)((Object)taxRamificationDocument))) {
            travelAdvance.setTaxRamificationNotificationDate(taxableRamificationNotificationDate);
            this.getBusinessObjectService().save((PersistableBusinessObject)travelAdvance);
        }
        return taxRamificationDocument;
    }

    protected MailMessage buildTaxRamificationReportMailMessage(TaxableRamificationDocument taxableRamificationDocument) {
        MailMessage mailMessage = new MailMessage();
        String senderEmailAddress = this.getNotificationSender();
        mailMessage.setFromAddress(senderEmailAddress);
        TravelerDetail travelerDetail = taxableRamificationDocument.getTravelerDetail();
        String travelerEmailAddress = travelerDetail.getEmailAddress();
        mailMessage.addToAddress(travelerEmailAddress);
        String travelerName = travelerDetail.getLastName() + ", " + travelerDetail.getFirstName();
        String notificationSubject = this.getNotificationSubject() + "[" + travelerName + "]";
        mailMessage.setSubject(notificationSubject);
        String notificationBody = this.buildNotificationBody(taxableRamificationDocument);
        mailMessage.setMessage(notificationBody);
        return mailMessage;
    }

    protected String buildNotificationBody(TaxableRamificationDocument taxRamificationDocument) {
        HashMap<String, Object> taxRamificationInformationHolder = new HashMap<String, Object>();
        taxRamificationInformationHolder.put("document", (Object)taxRamificationDocument);
        String campusTravelEmailAddress = this.getCampusTravelEmailAddress();
        taxRamificationInformationHolder.put("campusTravelEmailAddress", campusTravelEmailAddress);
        return this.getKfsNotificationService().generateNotificationContent(this.getNotificationTemplate(), taxRamificationInformationHolder);
    }

    protected String getNotificationSender() {
        return this.getParameterService().getParameterValueAsString(TaxableRamificationNotificationStep.class, "FROM_EMAIL_ADDRESS");
    }

    protected String getNotificationText() {
        return this.getParameterService().getParameterValueAsString(TaxableRamificationNotificationStep.class, "NOTIFICATION_TEXT");
    }

    protected String getNotificationSubject() {
        return this.getParameterService().getParameterValueAsString(TaxableRamificationNotificationStep.class, "NOTIFICATION_SUBJECT");
    }

    protected String getCampusTravelEmailAddress() {
        return this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "TRAVEL_EMAIL_ADDRESS");
    }

    public KfsNotificationService getKfsNotificationService() {
        return this.kfsNotificationService;
    }

    public void setKfsNotificationService(KfsNotificationService kfsNotificationService) {
        this.kfsNotificationService = kfsNotificationService;
    }

    public String getNotificationTemplate() {
        return this.notificationTemplate;
    }

    public void setNotificationTemplate(String notificationTemplate) {
        this.notificationTemplate = notificationTemplate;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public TaxableRamificationDocumentService getTaxableRamificationDocumentService() {
        return this.taxableRamificationDocumentService;
    }

    public void setTaxableRamificationDocumentService(TaxableRamificationDocumentService taxableRamificationDocumentService) {
        this.taxableRamificationDocumentService = taxableRamificationDocumentService;
    }
}

