/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.AgencyCorrectionChangeGroup;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class TemCorrectionProcessDocument
extends FinancialSystemTransactionalDocumentBase
implements AmountTotaling {
    protected static Logger LOG = Logger.getLogger(TemCorrectionProcessDocument.class);
    protected String correctionTypeCode;
    protected boolean correctionSelection;
    protected boolean correctionFileDelete;
    protected Integer correctionRowCount;
    protected String correctionInputFileName;
    protected String correctionOutputFileName;
    protected String correctionScriptText;
    protected Integer correctionChangeGroupNextLineNumber;
    protected List<AgencyCorrectionChangeGroup> correctionChangeGroup;
    protected KualiDecimal correctionTripTotalAmount = KualiDecimal.ZERO;

    public TemCorrectionProcessDocument() {
        this.correctionChangeGroupNextLineNumber = new Integer(0);
        this.correctionChangeGroup = new ArrayList<AgencyCorrectionChangeGroup>();
    }

    public String getMethod() {
        if ("M".equals(this.correctionTypeCode)) {
            return "Manual Edit";
        }
        if ("C".equals(this.correctionTypeCode)) {
            return "Using Criteria";
        }
        if ("R".equals(this.correctionTypeCode)) {
            return "Remove Group from Processing";
        }
        return "N/A";
    }

    public String getSystem() {
        return "Database";
    }

    public void addCorrectionChangeGroup(AgencyCorrectionChangeGroup ccg) {
        ccg.setDocumentNumber(this.documentNumber);
        Integer n = this.correctionChangeGroupNextLineNumber;
        Integer n2 = this.correctionChangeGroupNextLineNumber = Integer.valueOf(this.correctionChangeGroupNextLineNumber + 1);
        ccg.setCorrectionChangeGroupLineNumber(n);
        this.correctionChangeGroup.add(ccg);
    }

    public void removeCorrectionChangeGroup(int changeNumber) {
        Iterator<AgencyCorrectionChangeGroup> iter = this.correctionChangeGroup.iterator();
        while (iter.hasNext()) {
            AgencyCorrectionChangeGroup element = iter.next();
            if (changeNumber != element.getCorrectionChangeGroupLineNumber()) continue;
            iter.remove();
        }
    }

    public AgencyCorrectionChangeGroup getCorrectionChangeGroupItem(int groupNumber) {
        for (AgencyCorrectionChangeGroup element : this.correctionChangeGroup) {
            if (groupNumber != element.getCorrectionChangeGroupLineNumber()) continue;
            return element;
        }
        AgencyCorrectionChangeGroup ccg = new AgencyCorrectionChangeGroup(this.documentNumber, groupNumber);
        this.correctionChangeGroup.add(ccg);
        return ccg;
    }

    public KualiDecimal getTotalDollarAmount() {
        return this.correctionTripTotalAmount;
    }

    public String getCorrectionTypeCode() {
        return this.correctionTypeCode;
    }

    public void setCorrectionTypeCode(String correctionTypeCode) {
        this.correctionTypeCode = correctionTypeCode;
    }

    public boolean isCorrectionSelection() {
        return this.correctionSelection;
    }

    public void setCorrectionSelection(boolean correctionSelection) {
        this.correctionSelection = correctionSelection;
    }

    public boolean isCorrectionFileDelete() {
        return this.correctionFileDelete;
    }

    public void setCorrectionFileDelete(boolean correctionFileDelete) {
        this.correctionFileDelete = correctionFileDelete;
    }

    public Integer getCorrectionRowCount() {
        return this.correctionRowCount;
    }

    public void setCorrectionRowCount(Integer correctionRowCount) {
        this.correctionRowCount = correctionRowCount;
    }

    public String getCorrectionInputFileName() {
        return this.correctionInputFileName;
    }

    public void setCorrectionInputFileName(String correctionInputFileName) {
        this.correctionInputFileName = correctionInputFileName;
    }

    public String getCorrectionOutputFileName() {
        return this.correctionOutputFileName;
    }

    public void setCorrectionOutputFileName(String correctionOutputFileName) {
        this.correctionOutputFileName = correctionOutputFileName;
    }

    public String getCorrectionScriptText() {
        return this.correctionScriptText;
    }

    public void setCorrectionScriptText(String correctionScriptText) {
        this.correctionScriptText = correctionScriptText;
    }

    public Integer getCorrectionChangeGroupNextLineNumber() {
        return this.correctionChangeGroupNextLineNumber;
    }

    public void setCorrectionChangeGroupNextLineNumber(Integer correctionChangeGroupNextLineNumber) {
        this.correctionChangeGroupNextLineNumber = correctionChangeGroupNextLineNumber;
    }

    public KualiDecimal getCorrectionTripTotalAmount() {
        return this.correctionTripTotalAmount;
    }

    public void setCorrectionTripTotalAmount(KualiDecimal correctionTripTotalAmount) {
        this.correctionTripTotalAmount = ObjectUtils.isNull((Object)correctionTripTotalAmount) ? KualiDecimal.ZERO : correctionTripTotalAmount;
    }

    public List<AgencyCorrectionChangeGroup> getCorrectionChangeGroup() {
        Collections.sort(this.correctionChangeGroup);
        return this.correctionChangeGroup;
    }

    public void setCorrectionChangeGroup(List<AgencyCorrectionChangeGroup> correctionChangeGroup) {
        this.correctionChangeGroup = correctionChangeGroup;
    }
}

