/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import java.util.Set;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelRelocationDocument;
import org.kuali.kfs.module.tem.document.authorization.TravelDocumentPresentationController;

public class TravelRelocationDocumentPresentationController
extends TravelDocumentPresentationController {
    @Override
    public Set<String> getEditModes(Document document) {
        Set<String> editModes = super.getEditModes(document);
        this.addFullEntryEditMode(document, editModes);
        editModes.remove("checkAmountEntry");
        Set nodeNames = document.getDocumentHeader().getWorkflowDocument().getNodeNames();
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved() || nodeNames != null && !nodeNames.isEmpty() && (nodeNames.contains("Tax") || nodeNames.contains("MovingAndRelocationManager"))) {
            editModes.add("expenseTaxableEntry");
        }
        if (this.isRootTravelDocument((TravelDocument)document)) {
            editModes.add("requesterLooupMode");
        }
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved() || nodeNames != null && !nodeNames.isEmpty() && nodeNames.contains("MovingAndRelocationManager")) {
            editModes.add("expenseLimitEntry");
        }
        return editModes;
    }

    public Set<String> getDocumentActions(Document document) {
        TravelRelocationDocument travelRelocationDocument = (TravelRelocationDocument)document;
        Set actions = super.getDocumentActions(document);
        if (this.canNewRelocation(travelRelocationDocument)) {
            actions.add("canNewRelocation");
        }
        return actions;
    }

    public boolean canNewRelocation(TravelRelocationDocument document) {
        return document.isTripProgenitor() && !document.getDocumentHeader().getWorkflowDocument().isInitiated();
    }

    @Override
    public String getDocumentManagerApprovalNode() {
        return "MovingAndRelocationManager";
    }
}

